"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VmConsoles = exports.RdpServiceNotConfigured = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = require("lodash");

var _reactConsole = require("@patternfly/react-console");

var _patternflyReact = require("patternfly-react");

var _VmStatus = require("../VmStatus");

var _SerialConsoleConnector = require("./SerialConsoleConnector");

var _utils = require("../../utils");

var _constants = require("../../constants");

var _DesktopViewerSelector = require("./DesktopViewerSelector");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const _AccessConsoles$const = _reactConsole.AccessConsoles.constants,
      VNC_CONSOLE_TYPE = _AccessConsoles$const.VNC_CONSOLE_TYPE,
      SERIAL_CONSOLE_TYPE = _AccessConsoles$const.SERIAL_CONSOLE_TYPE;

const VmIsDown = ({
  vm,
  onStartVm
}) => {
  const action = _react.default.createElement(_patternflyReact.Button, {
    bsStyle: "link",
    onClick: onStartVm
  }, "start");

  return _react.default.createElement("div", {
    className: "co-m-pane__body"
  }, _react.default.createElement("div", {
    className: "kubevirt-vm-consoles__loading"
  }, "This Virtual Machine is down. Please ", action, " it to access its console."));
};

VmIsDown.propTypes = {
  vm: _propTypes.default.object.isRequired,
  onStartVm: _propTypes.default.func.isRequired
};

const VmIsStarting = ({
  LoadingComponent
}) => _react.default.createElement("div", {
  className: "co-m-pane__body"
}, _react.default.createElement("div", {
  className: "kubevirt-vm-consoles__loading"
}, _react.default.createElement(LoadingComponent, null), "This Virtual Machine is still starting up. The console will be available soon."));

VmIsStarting.propTypes = {
  LoadingComponent: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func]).isRequired
};

const RdpServiceNotConfigured = ({
  vm
}) => _react.default.createElement("div", {
  className: "kubevirt-vm-consoles__rdp"
}, _react.default.createElement("span", null, "This is a Windows virtual machine but no Service for the RDP (Remote Desktop Protocol) can be found."), _react.default.createElement("br", null), _react.default.createElement("span", null, "For better experience accessing Windows console, it is recommended to use the RDP. To do so, create a service:", _react.default.createElement("ul", null, _react.default.createElement("li", null, "exposing the", ' ', _react.default.createElement("b", null, _constants.DEFAULT_RDP_PORT, "/tcp"), ' ', "port of the virtual machine"), _react.default.createElement("li", null, "using selector:", ' ', _react.default.createElement("b", null, _constants.TEMPLATE_VM_NAME_LABEL, ": ", vm.metadata.name)), _react.default.createElement("li", null, "Example: virtctl expose virtualmachine ", vm.metadata.name, " --name ", vm.metadata.name, "-rdp --port [UNIQUE_PORT] --target-port ", _constants.DEFAULT_RDP_PORT, " --type NodePort")), "Make sure, the VM object has ", _react.default.createElement("b", null, "spec.template.metadata.labels"), " set to", ' ', _react.default.createElement("b", null, _constants.TEMPLATE_VM_NAME_LABEL, ": ", vm.metadata.name)));

exports.RdpServiceNotConfigured = RdpServiceNotConfigured;
RdpServiceNotConfigured.propTypes = {
  vm: _propTypes.default.object.isRequired
};
/**
 * Actual component for consoles.
 */

const VmConsoles = ({
  vm,
  vmi,
  onStartVm,
  vnc,
  serial,
  rdp,
  WSFactory,
  LoadingComponent
}) => {
  if (!(0, _VmStatus.isVmiRunning)(vmi)) {
    return (0, _VmStatus.isVmStarting)(vm, vmi) ? _react.default.createElement(VmIsStarting, {
      LoadingComponent: LoadingComponent
    }) : _react.default.createElement(VmIsDown, {
      vm: vm,
      onStartVm: onStartVm
    });
  }

  const vncServiceManual = (0, _lodash.get)({
    vnc
  }, 'vnc.manual');
  const rdpServiceManual = (0, _lodash.get)({
    rdp
  }, 'rdp.manual');
  let desktopViewerSelector;

  if ((0, _utils.isWindows)(vm)) {
    desktopViewerSelector = _react.default.createElement(_DesktopViewerSelector.DesktopViewerSelector, {
      vncServiceManual: vncServiceManual,
      rdpServiceManual: rdpServiceManual,
      type: "DesktopViewer",
      vm: vm,
      vmi: vmi,
      guestAgent: (0, _utils.isGuestAgentConnected)(vmi)
    });
  }

  return _react.default.createElement("div", {
    className: "co-m-pane__body"
  }, _react.default.createElement(_reactConsole.AccessConsoles, {
    preselectedType: VNC_CONSOLE_TYPE,
    disconnectByChange: false
  }, _react.default.createElement(_SerialConsoleConnector.SerialConsoleConnector, _extends({
    type: SERIAL_CONSOLE_TYPE,
    WSFactory: WSFactory
  }, serial)), _react.default.createElement(_reactConsole.VncConsole, vnc), desktopViewerSelector));
};

exports.VmConsoles = VmConsoles;
VmConsoles.propTypes = {
  vm: _propTypes.default.object.isRequired,
  vmi: _propTypes.default.object,
  vnc: _propTypes.default.object,
  serial: _propTypes.default.object,
  rdp: _propTypes.default.object,
  onStartVm: _propTypes.default.func.isRequired,
  LoadingComponent: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.func]).isRequired,
  WSFactory: _propTypes.default.func.isRequired
};
VmConsoles.defaultProps = {
  vmi: undefined,
  vnc: undefined,
  serial: undefined,
  rdp: undefined
};