"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _lodash = require("lodash");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _utils = require("../../../../utils");

var _models = require("../../../../models");

var _Form = require("../../../Form");

var _strings = require("../strings");

var _constants = require("../constants");

var _selectors = require("../../../../k8s/selectors");

var _VCenterVmsWithPrefill = _interopRequireDefault(require("./VCenterVmsWithPrefill"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

const VCenterVms = (_ref) => {
  let onChange = _ref.onChange,
      onFormChange = _ref.onFormChange,
      id = _ref.id,
      value = _ref.value,
      extraProps = _ref.extraProps,
      extra = _objectWithoutProperties(_ref, ["onChange", "onFormChange", "id", "value", "extraProps"]);

  // the "value" is name of selected VMWare VM
  const WithResources = extraProps.WithResources,
        basicSettings = extraProps.basicSettings;
  const v2vvmwareName = (0, _selectors.getV2VVmwareName)(basicSettings);

  if (!v2vvmwareName) {
    return _react.default.createElement(_Form.Dropdown, {
      id: id,
      value: _strings.PROVIDER_SELECT_VM,
      disabled: true
    });
  }

  const resourceMap = {
    v2vvmware: {
      resource: (0, _utils.getResource)(_models.V2VVMwareModel, {
        name: v2vvmwareName,
        namespace: (0, _selectors.settingsValue)(basicSettings, _constants.NAMESPACE_KEY),
        isList: false
      })
    }
  };

  const resourceToProps = ({
    v2vvmware
  }) => {
    const vms = (0, _lodash.get)(v2vvmware, 'spec.vms');
    let choices = [];

    if (vms) {
      choices = vms.map(vm => vm.name);
    }

    return {
      choices,
      // value set by the controller
      disabled: !vms
    };
  };

  return _react.default.createElement(WithResources, {
    resourceMap: resourceMap,
    resourceToProps: resourceToProps
  }, _react.default.createElement(_VCenterVmsWithPrefill.default, {
    id: id,
    value: value,
    onChange: onChange,
    onFormChange: onFormChange,
    basicSettings: basicSettings
  }));
};

VCenterVms.defaultProps = {
  id: undefined,
  value: undefined
};
VCenterVms.propTypes = {
  onChange: _propTypes.default.func.isRequired,
  extraProps: _propTypes.default.object.isRequired,
  onFormChange: _propTypes.default.func.isRequired,
  id: _propTypes.default.string,
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object])
};
var _default = VCenterVms;
exports.default = _default;