"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isGuestAgentConnected = exports.getFlavorDescription = exports.getVmiIpAddresses = exports.getHostName = exports.getNodeName = exports.isWindows = exports.getAnnotationValue = exports.getLabelValue = exports.getLabelKeyValue = exports.getCloudInitUserData = exports.getCloudInitVolume = exports.getDescription = exports.getVmTemplate = exports.getFlavor = exports.getWorkloadProfile = exports.getOperatingSystemName = exports.getOperatingSystem = exports.getCpu = exports.getMemory = exports.getDataVolumeTemplates = exports.getVolumes = exports.getNetworks = exports.getInterfaces = exports.getDisks = exports.getDataVolumeSourceType = exports.getDataVolumeStorageClassName = exports.getPvcStorageClassName = exports.getDataVolumeAccessModes = exports.getPvcAccessModes = exports.getDataVolumeResources = exports.getPvcResources = exports.getDataVolumeStorageSize = exports.getPvcStorageSize = exports.getStorageSize = exports.getGibStorageSize = exports.getNamespace = exports.getName = exports.getId = void 0;

var _lodash = require("lodash");

var _constants = require("../constants");

var _constants2 = require("../components/Wizard/CreateVmWizard/constants");

const getId = value => `${getNamespace(value)}-${getName(value)}`;

exports.getId = getId;

const getName = value => (0, _lodash.get)(value, 'metadata.name');

exports.getName = getName;

const getNamespace = value => (0, _lodash.get)(value, 'metadata.namespace');

exports.getNamespace = getNamespace;

const getGibStorageSize = (units, resources) => {
  const size = (0, _lodash.get)(resources, 'requests.storage');
  return size ? units.dehumanize(size, 'binaryBytesWithoutB').value / 1073741824 : null; // 1024^3
};

exports.getGibStorageSize = getGibStorageSize;

const getStorageSize = resources => (0, _lodash.get)(resources, 'requests.storage');

exports.getStorageSize = getStorageSize;

const getPvcStorageSize = pvc => getStorageSize(getPvcResources(pvc));

exports.getPvcStorageSize = getPvcStorageSize;

const getDataVolumeStorageSize = dataVolume => getStorageSize(getDataVolumeResources(dataVolume));

exports.getDataVolumeStorageSize = getDataVolumeStorageSize;

const getPvcResources = pvc => (0, _lodash.get)(pvc, 'spec.resources');

exports.getPvcResources = getPvcResources;

const getDataVolumeResources = dataVolume => (0, _lodash.get)(dataVolume, 'spec.pvc.resources');

exports.getDataVolumeResources = getDataVolumeResources;

const getPvcAccessModes = pvc => (0, _lodash.get)(pvc, 'spec.accessModes');

exports.getPvcAccessModes = getPvcAccessModes;

const getDataVolumeAccessModes = dataVolume => (0, _lodash.get)(dataVolume, 'spec.pvc.accessModes');

exports.getDataVolumeAccessModes = getDataVolumeAccessModes;

const getPvcStorageClassName = pvc => (0, _lodash.get)(pvc, 'spec.storageClassName');

exports.getPvcStorageClassName = getPvcStorageClassName;

const getDataVolumeStorageClassName = dataVolume => (0, _lodash.get)(dataVolume, 'spec.pvc.storageClassName');

exports.getDataVolumeStorageClassName = getDataVolumeStorageClassName;

const getDataVolumeSourceType = dataVolume => {
  const source = (0, _lodash.get)(dataVolume, 'spec.source');

  if (source.http) {
    return {
      type: _constants2.DATA_VOLUME_SOURCE_URL,
      url: (0, _lodash.get)(dataVolume, 'spec.source.http.url')
    };
  }

  if (source.pvc) {
    return {
      type: _constants2.DATA_VOLUME_SOURCE_PVC,
      name: (0, _lodash.get)(dataVolume, 'spec.source.pvc.name'),
      namespace: (0, _lodash.get)(dataVolume, 'spec.source.pvc.namespace')
    };
  }

  if (source.blank) {
    return {
      type: _constants2.DATA_VOLUME_SOURCE_BLANK
    };
  }

  return null;
};

exports.getDataVolumeSourceType = getDataVolumeSourceType;

const getDisks = vm => (0, _lodash.get)(vm, 'spec.template.spec.domain.devices.disks', []);

exports.getDisks = getDisks;

const getInterfaces = vm => (0, _lodash.get)(vm, 'spec.template.spec.domain.devices.interfaces', []);

exports.getInterfaces = getInterfaces;

const getNetworks = vm => (0, _lodash.get)(vm, 'spec.template.spec.networks', []);

exports.getNetworks = getNetworks;

const getVolumes = vm => (0, _lodash.get)(vm, 'spec.template.spec.volumes', []);

exports.getVolumes = getVolumes;

const getDataVolumeTemplates = vm => (0, _lodash.get)(vm, 'spec.dataVolumeTemplates', []);

exports.getDataVolumeTemplates = getDataVolumeTemplates;

const getMemory = vm => (0, _lodash.get)(vm, 'spec.template.spec.domain.resources.requests.memory');

exports.getMemory = getMemory;

const getCpu = vm => (0, _lodash.get)(vm, 'spec.template.spec.domain.cpu.cores');

exports.getCpu = getCpu;

const getOperatingSystem = vm => getLabelKeyValue(vm, _constants.TEMPLATE_OS_LABEL);

exports.getOperatingSystem = getOperatingSystem;

const getOperatingSystemName = vm => getAnnotationValue(vm, `${_constants.TEMPLATE_OS_NAME_ANNOTATION}/${getOperatingSystem(vm)}`);

exports.getOperatingSystemName = getOperatingSystemName;

const getWorkloadProfile = vm => getLabelKeyValue(vm, _constants.TEMPLATE_WORKLOAD_LABEL);

exports.getWorkloadProfile = getWorkloadProfile;

const getFlavor = vm => getLabelKeyValue(vm, _constants.TEMPLATE_FLAVOR_LABEL);

exports.getFlavor = getFlavor;

const getVmTemplate = vm => {
  const vmTemplateName = getLabelValue(vm, _constants.LABEL_USED_TEMPLATE_NAME);
  const vmTemplateNamespace = getLabelValue(vm, _constants.LABEL_USED_TEMPLATE_NAMESPACE);

  if (vmTemplateName && vmTemplateNamespace) {
    return {
      name: vmTemplateName,
      namespace: vmTemplateNamespace
    };
  }

  return null;
};

exports.getVmTemplate = getVmTemplate;

const getDescription = vm => (0, _lodash.get)(vm, 'metadata.annotations.description');

exports.getDescription = getDescription;

const getCloudInitVolume = vm => {
  const volumes = getVolumes(vm);
  const cloudInitVolume = volumes.find(volume => volume.cloudInitNoCloud && volume.cloudInitNoCloud.userData);

  if (cloudInitVolume) {
    // make sure volume is used by disk
    const disks = getDisks(vm);

    if (disks.find(disk => disk.name === cloudInitVolume.name)) {
      return cloudInitVolume;
    }
  }

  return null;
};

exports.getCloudInitVolume = getCloudInitVolume;

const getCloudInitUserData = vm => {
  const volume = getCloudInitVolume(vm);
  return volume && volume.cloudInitNoCloud.userData;
};

exports.getCloudInitUserData = getCloudInitUserData;

const getLabelKeyValue = (vm, label) => {
  const labels = (0, _lodash.get)(vm, 'metadata.labels', {});
  return readValueFromObject(labels, label, true);
};

exports.getLabelKeyValue = getLabelKeyValue;

const getLabelValue = (vm, label) => (0, _lodash.get)(vm, ['metadata', 'labels', label]);

exports.getLabelValue = getLabelValue;

const getAnnotationValue = (vm, annotation) => {
  const annotations = (0, _lodash.get)(vm, 'metadata.annotations', {});
  return readValueFromObject(annotations, annotation, false);
};

exports.getAnnotationValue = getAnnotationValue;

const readValueFromObject = (objects, key, split) => {
  if (objects) {
    const objectKey = Object.keys(objects).find(objKey => objKey.startsWith(key));

    if (!objectKey) {
      return null;
    }

    if (split && objectKey.includes('/')) {
      const objectParts = objectKey.split('/');
      return objectParts[objectParts.length - 1];
    }

    return objects[objectKey];
  }

  return null;
};

const isWindows = vm => (getOperatingSystem(vm) || '').startsWith(_constants.OS_WINDOWS_PREFIX);

exports.isWindows = isWindows;

const getNodeName = pod => (0, _lodash.get)(pod, 'spec.nodeName');

exports.getNodeName = getNodeName;

const getHostName = pod => (0, _lodash.get)(pod, 'spec.hostname');

exports.getHostName = getHostName;

const getVmiIpAddresses = vmi => (0, _lodash.get)(vmi, 'status.interfaces', []) // get IPs only for named interfaces because Windows reports IPs for other devices like Loopback Pseudo-Interface 1 etc.
.filter(i => i.name).map(i => i.ipAddress).filter(ip => ip && ip.trim().length > 0);

exports.getVmiIpAddresses = getVmiIpAddresses;

const getFlavorDescription = vm => {
  const cpu = getCpu(vm);
  const memory = getMemory(vm);
  const cpuStr = cpu ? `${cpu} CPU` : '';
  const memoryStr = memory ? `${memory} Memory` : '';
  const resourceStr = cpuStr && memoryStr ? `${cpuStr}, ${memoryStr}` : `${cpuStr}${memoryStr}`;
  return resourceStr || undefined;
};

exports.getFlavorDescription = getFlavorDescription;

const isGuestAgentConnected = vmi => (0, _lodash.get)(vmi, 'status.conditions', []).some(condition => condition.type === 'AgentConnected' && condition.status === 'True');

exports.isGuestAgentConnected = isGuestAgentConnected;