# optical-properties [![unstable](https://img.shields.io/badge/stability-unstable-green.svg)](http://github.com/badges/stability-badges)

Get optical params of a character, canvas or image data. Useful to do kerning, normalize size or adjust vertical/horizontal alignment.

![optical-properties](https://github.com/dfcreative/optical-properties/blob/gh-pages/index.png?raw=true)

See [demo](https://dfcreative.github.io/optical-properties).

## Usage

[![npm install optical-properties](https://nodei.co/npm/optical-properties.png?mini=true)](https://npmjs.org/package/optical-properties/)

```js
const optics = require('optical-properties')

let w = canvas.width, h = canvas.height, ctx = canvas.getContext('2d')

//get optical params
let {bounds, center, radius} = optics('▲', {size: h, fontSize: h/2})

//make sure radius of char is at least half of canvas height
let scale = h*.5 / (radius*2)

//optical center shift from the real center
let diff = [w*.5 - center[0], h*.5 - center[1]]

//draw normalized character
ctx.font = size*cale + 'px sans-serif'
ctx.fillText('▲', w*.5 + diff[0]*scale, h*.5 + diff[1]*scale)

```

## API

### let props = optics(char|canvas|imageData, options?)

Measures optical properties of a character, canvas or imageData based on options. Canvas is expected to be rectangular.

Options:

* `size` − size of canvas to use, bigger is slower but more precise and vice-versa. Defaults to `200`.
* `fontFamily` − font family to use for the character, defaults to `sans-serif`.
* `fontSize` − size of glyph, defaults to `100`.

Returns object with properties:

* `center` − coordinates of optical center as `[cx, cy]`.
* `bounds` − character bounding box `[left, top, right, bottom]`.
* `radius` − distance from the optical center to the outmost point.


## Credits

© 2017 Dima Yv. MIT License
