'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _Button = require('patternfly-react/dist/js/components/Button/Button');

var _Button2 = _interopRequireDefault(_Button);

var _helpers = require('../../common/helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var FilterSidePanelCategory = function FilterSidePanelCategory(_ref) {
  var children = _ref.children,
      className = _ref.className,
      title = _ref.title,
      maxShowCount = _ref.maxShowCount,
      leeway = _ref.leeway,
      showAll = _ref.showAll,
      onShowAllToggle = _ref.onShowAllToggle,
      showText = _ref.showText,
      hideText = _ref.hideText,
      props = _objectWithoutProperties(_ref, ['children', 'className', 'title', 'maxShowCount', 'leeway', 'showAll', 'onShowAllToggle', 'showText', 'hideText']);

  var classes = (0, _classnames2.default)('filter-panel-pf-category', className);
  var childrenArray = _helpers.helpers.childrenToArray(children);
  var itemCount = childrenArray.length;
  var hiddenCount = itemCount - maxShowCount;
  var shownChildren = void 0;
  var showAllToggle = null;

  if (hiddenCount <= leeway || showAll) {
    shownChildren = children;
    if (hiddenCount > leeway) {
      showAllToggle = _react2.default.createElement(
        _Button2.default,
        { bsStyle: 'link', onClick: onShowAllToggle },
        hideText || 'Show less'
      );
    }
  } else {
    shownChildren = children.slice(0, maxShowCount);
    if (hiddenCount > leeway) {
      showAllToggle = _react2.default.createElement(
        _Button2.default,
        { bsStyle: 'link', onClick: onShowAllToggle },
        showText || 'Show ' + hiddenCount + ' more'
      );
    }
  }

  return _react2.default.createElement(
    'form',
    _extends({ className: classes }, props),
    _react2.default.createElement(
      'fieldset',
      { className: 'checkbox filter-panel-pf-category-items' },
      title && _react2.default.createElement(
        'legend',
        { className: 'filter-panel-pf-category-title' },
        title
      ),
      shownChildren,
      showAllToggle
    )
  );
};

FilterSidePanelCategory.propTypes = {
  /** Children nodes */
  children: _propTypes2.default.node,
  /** Additional css classes */
  className: _propTypes2.default.string,
  /** Title for the category */
  title: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.node]),
  /** Number of items (max) to show before adding Show More link button */
  maxShowCount: _propTypes2.default.number,
  /** Leeway to add to maxShowCount, minimum X for the 'Show X more' */
  leeway: _propTypes2.default.number,
  /** Flag to show all items (ie. set to true after Show X more link is clicked) */
  showAll: _propTypes2.default.bool,
  /** Callback function when the Show/Hide link button is clicked */
  onShowAllToggle: _propTypes2.default.func,
  /** Text for the link to show all items, default 'Show <x> more' */
  showText: _propTypes2.default.string,
  /** Text for the link to hide overflow items, default 'Show less' */
  hideText: _propTypes2.default.string
};

FilterSidePanelCategory.defaultProps = {
  children: null,
  className: '',
  title: null,
  maxShowCount: 5,
  leeway: 2,
  showAll: false,
  onShowAllToggle: _helpers.helpers.noop,
  showText: null,
  hideText: null
};

exports.default = FilterSidePanelCategory;