'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var filterByHiding = exports.filterByHiding = function filterByHiding(list, value) {
  var filterValue = value.toLowerCase();
  return list.map(function (item) {
    var itemLabel = item.label.toLowerCase();
    var included = itemLabel.includes(filterValue);
    // if the item label matches the filter value.
    item.hidden = !included;
    // if it is a parent and its label doesn't match the filter value.
    if (itemHasChildren(item)) {
      if (isItemHidden(item)) {
        var childrenIncludedAmount = 0;
        item.children.forEach(function (childItem) {
          var childLabel = childItem.label.toLowerCase();
          var childIncluded = childLabel.includes(filterValue);
          childItem.hidden = !childIncluded;
          childrenIncludedAmount += childIncluded ? 1 : 0;
        });
        item.hidden = childrenIncludedAmount === 0;
      } else {
        item.children = makeAllItemsVisible(item.children);
      }
    }
    return item;
  });
};

var makeAllItemsVisible = exports.makeAllItemsVisible = function makeAllItemsVisible(list) {
  return list.map(function (item) {
    item.hidden = false;
    if (itemHasChildren(item)) {
      item.children.forEach(function (childItem) {
        childItem.hidden = false;
      });
    }
    return item;
  });
};

var sortItems = exports.sortItems = function sortItems(items) {
  var sortFactor = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'label';
  return items.sort(function (a, b) {
    return a[sortFactor].toLowerCase() > b[sortFactor].toLowerCase() ? 1 : -1;
  });
};

var arrangeArray = exports.arrangeArray = function arrangeArray(_ref) {
  var items = _ref.items,
      sortBy = _ref.sortBy,
      _ref$isSortAsc = _ref.isSortAsc,
      isSortAsc = _ref$isSortAsc === undefined ? true : _ref$isSortAsc,
      _ref$isMainChecked = _ref.isMainChecked,
      isMainChecked = _ref$isMainChecked === undefined ? false : _ref$isMainChecked;

  // sort the items
  var itemsCopy = sortItems(items, sortBy).map(function (item, index) {
    // add position to the item and update if the main checkbox is initialy checked.
    var modifiedItem = _extends({}, item, {
      position: index,
      checked: item.checked || isMainChecked
    });
    if (itemHasChildren(item)) {
      // sort the children array and add a position, parentPosition and update check state.
      modifiedItem.children = sortItems(item.children, sortBy).map(function (child, childIndex) {
        return _extends({}, child, {
          position: childIndex,
          parentPosition: index,
          checked: child.checked || isMainChecked
        });
      });
    }
    return modifiedItem;
  });

  itemsCopy = isSortAsc ? itemsCopy : reverseAllItemsOrder(itemsCopy);

  return itemsCopy;
};

var getDefaultProps = exports.getDefaultProps = function getDefaultProps() {
  return {
    items: [],
    options: null,
    isSortAsc: true,
    sortBy: 'label',
    filterTerm: '',
    isMainChecked: false
  };
};

var getCheckedAmount = exports.getCheckedAmount = function getCheckedAmount(_ref2) {
  var items = _ref2.items;

  var checkedAmount = 0;
  items.forEach(function (item) {
    if (isItemSelected(item)) {
      checkedAmount += 1;
      if (itemHasChildren(item)) {
        checkedAmount += item.children.length;
      }
    } else if (itemHasChildren(item)) {
      item.children.forEach(function (child) {
        if (isItemSelected(child)) {
          checkedAmount += 1;
        }
      });
    }
  });
  return checkedAmount;
};
var getCounterMessage = exports.getCounterMessage = function getCounterMessage(selected, total) {
  return selected + ' of ' + total + ' items selected';
};

var adjustProps = function adjustProps(_ref3) {
  var left = _ref3.left,
      right = _ref3.right,
      props = _objectWithoutProperties(_ref3, ['left', 'right']);

  var defaultProps = getDefaultProps();
  var leftItems = arrangeArray(_extends({}, left));
  var rightItems = arrangeArray(_extends({}, right));
  return _extends({}, props, {
    left: _extends({}, defaultProps, left, {
      items: leftItems,
      selectCount: getCheckedAmount(_extends({}, left))
    }),
    right: _extends({}, defaultProps, right, {
      items: rightItems,
      selectCount: getCheckedAmount(_extends({}, right))
    })
  });
};

exports.adjustProps = adjustProps;
var isAllChildrenChecked = exports.isAllChildrenChecked = function isAllChildrenChecked(_ref4) {
  var children = _ref4.children;
  return children.filter(function (_ref5) {
    var checked = _ref5.checked;
    return checked;
  }).length === children.length;
};

var getItemsLength = exports.getItemsLength = function getItemsLength(items) {
  var length = items.length;

  if (length === 0) {
    return 0;
  }
  items.forEach(function (_ref6) {
    var children = _ref6.children;

    if (children) {
      // add the children amount and reduce the parent.
      length += children.length - 1;
    }
  });
  return length;
};

var reverseAllItemsOrder = exports.reverseAllItemsOrder = function reverseAllItemsOrder(items) {
  var reversedItems = [].concat(_toConsumableArray(items)).reverse();
  return reversedItems.map(function (item) {
    return item.children ? _extends({}, item, { children: item.children.reverse() }) : item;
  });
};

var getItem = exports.getItem = function getItem(_ref7) {
  var isSortAsc = _ref7.isSortAsc,
      items = _ref7.items,
      position = _ref7.position,
      parentPosition = _ref7.parentPosition;

  // if item is a child.
  if (parentPosition !== undefined) {
    var parent = items[getItemPosition(items, parentPosition, isSortAsc)];
    return parent.children[getItemPosition(parent.children, position, isSortAsc)];
  }
  return items[getItemPosition(items, position, isSortAsc)];
};

var getUpdatedSelectCount = exports.getUpdatedSelectCount = function getUpdatedSelectCount(_ref8) {
  var selectCount = _ref8.selectCount,
      checked = _ref8.checked,
      _ref8$amount = _ref8.amount,
      amount = _ref8$amount === undefined ? 1 : _ref8$amount;
  return selectCount + (checked ? amount : -1 * amount);
};

var itemHasParent = exports.itemHasParent = function itemHasParent(item) {
  return item.parentPosition !== undefined;
};

var itemHasChildren = exports.itemHasChildren = function itemHasChildren(item) {
  return item.children !== undefined;
};

var getItemPosition = exports.getItemPosition = function getItemPosition(array, position, isSortAsc) {
  return isSortAsc ? position : array.length - position - 1;
};

var toggleAllItems = exports.toggleAllItems = function toggleAllItems(list, checked) {
  var toggleCount = 0;
  list.forEach(function (item) {
    if (item.disabled) {
      return;
    }
    if (item.checked !== checked) {
      item.checked = checked;
      toggleCount += 1;
    }
    if (itemHasChildren(item)) {
      var childrenToggleCount = 0;
      item.children.forEach(function (childItem) {
        if (childItem.checked !== checked) {
          childItem.checked = checked;
          childrenToggleCount += 1;
        }
      });
      if (childrenToggleCount > 0) {
        toggleCount += childrenToggleCount - 1;
      }
    }
  });
  return toggleCount;
};

var isAllItemsChecked = exports.isAllItemsChecked = function isAllItemsChecked(items, selectCount) {
  return selectCount > 0 && selectCount === getItemsLength(items);
};

var isItemExistOnList = exports.isItemExistOnList = function isItemExistOnList(list, itemLabel) {
  var parentIndex = null;
  // find if the parent already exist on the list.
  list.forEach(function (listItem, index) {
    if (listItem.label === itemLabel) {
      parentIndex = index;
    }
  });
  return { isParentExist: parentIndex !== null, parentIndex: parentIndex };
};

var getFilterredItems = exports.getFilterredItems = function getFilterredItems(list) {
  var filteredItems = [];
  list.forEach(function (item) {
    if (!isItemHidden(item)) {
      filteredItems.push(item);
    } else if (itemHasChildren(item)) {
      var filteredChildren = [];
      item.children.forEach(function (childItem) {
        if (!isItemHidden(childItem)) {
          filteredChildren.push(childItem);
        }
      });
      if (filteredChildren.length > 0) {
        filteredItems.push(_extends({}, item, { children: filteredChildren }));
      }
    }
  });

  return filteredItems;
};

var getFilterredItemsLength = exports.getFilterredItemsLength = function getFilterredItemsLength(list) {
  return getItemsLength(getFilterredItems(list));
};

var getSelectedFilterredItemsLength = exports.getSelectedFilterredItemsLength = function getSelectedFilterredItemsLength(list) {
  var filteredItems = getFilterredItems(list);
  var selectedAmount = 0;
  filteredItems.forEach(function (item) {
    if (isItemSelected(item)) {
      selectedAmount += 1;
      if (itemHasChildren(item)) {
        var selectedChildrenAmount = 0;
        item.children.forEach(function (childItem) {
          if (isItemSelected(childItem)) {
            selectedChildrenAmount += 1;
          }
        });
        if (selectedChildrenAmount) {
          selectedAmount += selectedChildrenAmount - 1;
        }
      }
    }
  });
  return selectedAmount;
};

var isItemSelected = exports.isItemSelected = function isItemSelected(item) {
  return item.checked;
};

var isItemHidden = exports.isItemHidden = function isItemHidden(item) {
  return item.hidden;
};

var isItemDisabled = exports.isItemDisabled = function isItemDisabled(item) {
  return item.disabled;
};