"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var union = require('lodash/union');
var without = require('lodash/without');
var EnterLeaveCounter = /** @class */ (function () {
    function EnterLeaveCounter() {
        this.entered = [];
    }
    EnterLeaveCounter.prototype.enter = function (enteringNode) {
        var previousLength = this.entered.length;
        var isNodeEntered = function (node) {
            return document.documentElement.contains(node) &&
                (!node.contains || node.contains(enteringNode));
        };
        this.entered = union(this.entered.filter(isNodeEntered), [enteringNode]);
        return previousLength === 0 && this.entered.length > 0;
    };
    EnterLeaveCounter.prototype.leave = function (leavingNode) {
        var previousLength = this.entered.length;
        this.entered = without(this.entered.filter(function (node) { return document.documentElement.contains(node); }), leavingNode);
        return previousLength > 0 && this.entered.length === 0;
    };
    EnterLeaveCounter.prototype.reset = function () {
        this.entered = [];
    };
    return EnterLeaveCounter;
}());
exports.default = EnterLeaveCounter;
