%global rolename v2v-conversion-host
%global roleprefix oVirt.
%global ansible_roles_dir ansible/roles

%global goipath github.com/ovirt/v2v-conversion-host

#gometa -i

#%if ! 0%{?gobuild:1}
#%define gobuild(o:) go build -buildmode=pie -ldflags "${LDFLAGS:-} -B 0x$(head -c20 /dev/urandom|od -An -tx1|tr -d ' \\n')" -tags "$BUILDTAGS" -a -v -x %{?**};
#%endif


Name: v2v-conversion-host
Summary: Set of tools for configuring conversion hosts for ManageIQ
Version: 1.13.0
Release: 1%{?release_suffix}%{?dist}
Source0: https://github.com/oVirt/v2v-conversion-host/releases/download/v%{version}/%{name}-%{version}.tar.gz
License: ASL 2.0
Group: Virtualization/Management
Url: http://www.ovirt.org


%description
A set of tools to configure and use hosts (oVirt, OpenStack) for ManageIQ

Project contsists of:
- Ansible role to setup hosts as conversion host for ManageIQ
- daemonizing wrapper for virt-v2v

%package ansible
Summary: Ansible role to setup oVirt host as conversion host for ManageIQ
Requires: ansible >= 2.4
BuildArch: noarch
Provides: ovirt-ansible-v2v-conversion-host = %{version}-%{release}
Obsoletes: ovirt-ansible-v2v-conversion-host < 1.11.0-1

%description ansible
Ansible role to setup hosts as conversion host for ManageIQ

#%package provider
#Summary: Helper service for querying information from VMware
#%if 0%{?fedora}
#BuildRequires:  compiler(go-compiler)
#%else
#BuildRequires:  %{?go_compiler:compiler(go-compiler)}%{!?go_compiler:golang}
#%endif

#%description provider
#Helper service for querying information from VMware

%package wrapper
Summary: Daemonizing wrapper for virt-v2v
Requires: libcgroup-tools
Requires: python
BuildArch: noarch

%description wrapper
Daemonizing wrapper for virt-v2v.

%prep
%setup -c -q
# Remove backups caused by unclean patch application
find -name '*.orig' | xargs rm -fv

#%build
#
#%if ! 0%{?fedora}
#export GOPATH=$(pwd)/GOPATH
#d="GOPATH/src/github.com/ovirt"
#mkdir -p "$d"
#pushd "$d"
#    ln -s $(dirs +1 -l) %{name}
#popd
#cd "$d"/%{name}
#%gobuild -o kubevirt-provider/kubevirt-provider %{goipath}/kubevirt-provider
#%else
#%gobuildroot
#%gobuild -o kubevirt-provider/kubevirt-provider %{goipath}/kubevirt-provider
#%endif


%install
export DATA_DIR=%{buildroot}%{_datadir}
export BIN_DIR=%{buildroot}%{_bindir}
sh build.sh install
#install -p -m 755 kubevirt-provider/kubevirt-provider %{buildroot}%{_bindir}

# Create symlinks for backward compatibility with
# ovirt-ansible-v2v-conversion-host. Remove this later.
mkdir -p %{buildroot}%{_datadir}/ovirt-ansible-v2v-conversion-host/playbooks
ln -s %{_datadir}/%{name}-ansible/playbooks/conversion_host_check.yml %{buildroot}%{_datadir}/ovirt-ansible-v2v-conversion-host/playbooks/
ln -s %{_datadir}/%{name}-ansible/playbooks/conversion_host_disable.yml %{buildroot}%{_datadir}/ovirt-ansible-v2v-conversion-host/playbooks/
ln -s %{_datadir}/%{name}-ansible/playbooks/conversion_host_enable.yml %{buildroot}%{_datadir}/ovirt-ansible-v2v-conversion-host/playbooks/
# Create symlink for backward compatibility with CFME
ln -s %{_bindir}/virt-v2v-wrapper %{buildroot}/usr/bin/virt-v2v-wrapper.py

%files ansible
%{_datadir}/%{ansible_roles_dir}/
%{_datadir}/%{name}-ansible/
%{_datadir}/ovirt-ansible-v2v-conversion-host
%doc README.md
%doc docs/
%doc ansible/examples/
%license LICENSE

#%files provider
#%{_bindir}/kubevirt-provider
#%doc README.md
#%doc docs/
#%license LICENSE

%files wrapper
%{_bindir}/virt-v2v-wrapper*
%doc README.md
%doc docs/
%license LICENSE

%pre wrapper
# Previously wrapper was installed from role. Remove this rogue file
# if this is first time we install the RPM.
if [ $1 -eq 1 -a -f /usr/bin/virt-v2v-wrapper.py ] ; then
    set -e
    rm -fv /usr/bin/virt-v2v-wrapper.py
fi

%changelog
* Thu Apr 18 2019 Tomáš Golembiovský <tgolembi@redhat.com> 1.13.0-1
- Updated to upstream version 1.13.0
- Removed merged patches

* Tue Apr 16 2019 Tomáš Golembiovský <tgolembi@redhat.com> 1.12.1-5
- patch: drop XDG_RUNTIME_DIR from environment (RHBZ#1700461)

* Wed Apr 10 2019 Tomáš Golembiovský <tgolembi@redhat.com> 1.12.1-4
- patch: fix creation of .ssh directory
- replace post-install and post-uninstall scripts with pre-install script and
  real symbolic link

* Thu Apr  4 2019 Tomáš Golembiovský <tgolembi@redhat.com> 1.12.1-3
- fix error in post-install script

* Tue Apr  2 2019 Tomáš Golembiovský <tgolembi@redhat.com> 1.12.1-2
- patch: ansible: fix check to allow checking SSH transport method

* Mon Mar 25 2019 Tomáš Golembiovský <tgolembi@redhat.com> 1.12.1-1
- Updated to upstream version 1.12.1

* Sun Mar 24 2019 Tomáš Golembiovský <tgolembi@redhat.com> 1.12.0-1
- Updated to upstream version 1.12.0

* Wed Mar 13 2019 Tomáš Golembiovský <tgolembi@redhat.com> 1.11.0-1
- Updated to upstream version 1.11.0
