// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/spanner/v1/mutation.proto

package spanner

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/struct"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A modification to one or more Cloud Spanner rows.  Mutations can be
// applied to a Cloud Spanner database by sending them in a
// [Commit][google.spanner.v1.Spanner.Commit] call.
type Mutation struct {
	// Required. The operation to perform.
	//
	// Types that are valid to be assigned to Operation:
	//	*Mutation_Insert
	//	*Mutation_Update
	//	*Mutation_InsertOrUpdate
	//	*Mutation_Replace
	//	*Mutation_Delete_
	Operation isMutation_Operation `protobuf_oneof:"operation"`
}

func (m *Mutation) Reset()                    { *m = Mutation{} }
func (m *Mutation) String() string            { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()               {}
func (*Mutation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

type isMutation_Operation interface {
	isMutation_Operation()
}

type Mutation_Insert struct {
	Insert *Mutation_Write `protobuf:"bytes,1,opt,name=insert,oneof"`
}
type Mutation_Update struct {
	Update *Mutation_Write `protobuf:"bytes,2,opt,name=update,oneof"`
}
type Mutation_InsertOrUpdate struct {
	InsertOrUpdate *Mutation_Write `protobuf:"bytes,3,opt,name=insert_or_update,json=insertOrUpdate,oneof"`
}
type Mutation_Replace struct {
	Replace *Mutation_Write `protobuf:"bytes,4,opt,name=replace,oneof"`
}
type Mutation_Delete_ struct {
	Delete *Mutation_Delete `protobuf:"bytes,5,opt,name=delete,oneof"`
}

func (*Mutation_Insert) isMutation_Operation()         {}
func (*Mutation_Update) isMutation_Operation()         {}
func (*Mutation_InsertOrUpdate) isMutation_Operation() {}
func (*Mutation_Replace) isMutation_Operation()        {}
func (*Mutation_Delete_) isMutation_Operation()        {}

func (m *Mutation) GetOperation() isMutation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *Mutation) GetInsert() *Mutation_Write {
	if x, ok := m.GetOperation().(*Mutation_Insert); ok {
		return x.Insert
	}
	return nil
}

func (m *Mutation) GetUpdate() *Mutation_Write {
	if x, ok := m.GetOperation().(*Mutation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *Mutation) GetInsertOrUpdate() *Mutation_Write {
	if x, ok := m.GetOperation().(*Mutation_InsertOrUpdate); ok {
		return x.InsertOrUpdate
	}
	return nil
}

func (m *Mutation) GetReplace() *Mutation_Write {
	if x, ok := m.GetOperation().(*Mutation_Replace); ok {
		return x.Replace
	}
	return nil
}

func (m *Mutation) GetDelete() *Mutation_Delete {
	if x, ok := m.GetOperation().(*Mutation_Delete_); ok {
		return x.Delete
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Mutation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Mutation_OneofMarshaler, _Mutation_OneofUnmarshaler, _Mutation_OneofSizer, []interface{}{
		(*Mutation_Insert)(nil),
		(*Mutation_Update)(nil),
		(*Mutation_InsertOrUpdate)(nil),
		(*Mutation_Replace)(nil),
		(*Mutation_Delete_)(nil),
	}
}

func _Mutation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Mutation)
	// operation
	switch x := m.Operation.(type) {
	case *Mutation_Insert:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Insert); err != nil {
			return err
		}
	case *Mutation_Update:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *Mutation_InsertOrUpdate:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InsertOrUpdate); err != nil {
			return err
		}
	case *Mutation_Replace:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Replace); err != nil {
			return err
		}
	case *Mutation_Delete_:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Delete); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Mutation.Operation has unexpected type %T", x)
	}
	return nil
}

func _Mutation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Mutation)
	switch tag {
	case 1: // operation.insert
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_Write)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Insert{msg}
		return true, err
	case 2: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_Write)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Update{msg}
		return true, err
	case 3: // operation.insert_or_update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_Write)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_InsertOrUpdate{msg}
		return true, err
	case 4: // operation.replace
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_Write)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Replace{msg}
		return true, err
	case 5: // operation.delete
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_Delete)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Delete_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Mutation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Mutation)
	// operation
	switch x := m.Operation.(type) {
	case *Mutation_Insert:
		s := proto.Size(x.Insert)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Update:
		s := proto.Size(x.Update)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_InsertOrUpdate:
		s := proto.Size(x.InsertOrUpdate)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Replace:
		s := proto.Size(x.Replace)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Delete_:
		s := proto.Size(x.Delete)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Arguments to [insert][google.spanner.v1.Mutation.insert], [update][google.spanner.v1.Mutation.update], [insert_or_update][google.spanner.v1.Mutation.insert_or_update], and
// [replace][google.spanner.v1.Mutation.replace] operations.
type Mutation_Write struct {
	// Required. The table whose rows will be written.
	Table string `protobuf:"bytes,1,opt,name=table" json:"table,omitempty"`
	// The names of the columns in [table][google.spanner.v1.Mutation.Write.table] to be written.
	//
	// The list of columns must contain enough columns to allow
	// Cloud Spanner to derive values for all primary key columns in the
	// row(s) to be modified.
	Columns []string `protobuf:"bytes,2,rep,name=columns" json:"columns,omitempty"`
	// The values to be written. `values` can contain more than one
	// list of values. If it does, then multiple rows are written, one
	// for each entry in `values`. Each list in `values` must have
	// exactly as many entries as there are entries in [columns][google.spanner.v1.Mutation.Write.columns]
	// above. Sending multiple lists is equivalent to sending multiple
	// `Mutation`s, each containing one `values` entry and repeating
	// [table][google.spanner.v1.Mutation.Write.table] and [columns][google.spanner.v1.Mutation.Write.columns]. Individual values in each list are
	// encoded as described [here][google.spanner.v1.TypeCode].
	Values []*google_protobuf1.ListValue `protobuf:"bytes,3,rep,name=values" json:"values,omitempty"`
}

func (m *Mutation_Write) Reset()                    { *m = Mutation_Write{} }
func (m *Mutation_Write) String() string            { return proto.CompactTextString(m) }
func (*Mutation_Write) ProtoMessage()               {}
func (*Mutation_Write) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0, 0} }

func (m *Mutation_Write) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *Mutation_Write) GetColumns() []string {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *Mutation_Write) GetValues() []*google_protobuf1.ListValue {
	if m != nil {
		return m.Values
	}
	return nil
}

// Arguments to [delete][google.spanner.v1.Mutation.delete] operations.
type Mutation_Delete struct {
	// Required. The table whose rows will be deleted.
	Table string `protobuf:"bytes,1,opt,name=table" json:"table,omitempty"`
	// Required. The primary keys of the rows within [table][google.spanner.v1.Mutation.Delete.table] to delete.
	KeySet *KeySet `protobuf:"bytes,2,opt,name=key_set,json=keySet" json:"key_set,omitempty"`
}

func (m *Mutation_Delete) Reset()                    { *m = Mutation_Delete{} }
func (m *Mutation_Delete) String() string            { return proto.CompactTextString(m) }
func (*Mutation_Delete) ProtoMessage()               {}
func (*Mutation_Delete) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0, 1} }

func (m *Mutation_Delete) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *Mutation_Delete) GetKeySet() *KeySet {
	if m != nil {
		return m.KeySet
	}
	return nil
}

func init() {
	proto.RegisterType((*Mutation)(nil), "google.spanner.v1.Mutation")
	proto.RegisterType((*Mutation_Write)(nil), "google.spanner.v1.Mutation.Write")
	proto.RegisterType((*Mutation_Delete)(nil), "google.spanner.v1.Mutation.Delete")
}

func init() { proto.RegisterFile("google/spanner/v1/mutation.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 402 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x92, 0x41, 0x6b, 0xdb, 0x30,
	0x14, 0xc7, 0x97, 0x38, 0x71, 0x16, 0x85, 0x8d, 0xcd, 0x6c, 0xcc, 0x33, 0x3b, 0x78, 0x39, 0xe5,
	0x24, 0x13, 0xef, 0x32, 0xc8, 0x76, 0xc9, 0x06, 0x1b, 0x6c, 0xa1, 0xc1, 0xa1, 0x29, 0xf4, 0x12,
	0x14, 0xe7, 0xd5, 0x18, 0x2b, 0x92, 0x91, 0xe4, 0x40, 0xa0, 0x9f, 0xa5, 0x1f, 0xa0, 0x9f, 0xb2,
	0x58, 0x92, 0x4b, 0x68, 0xda, 0x92, 0x9e, 0xec, 0xc7, 0xfb, 0xff, 0xfe, 0xff, 0xf7, 0x24, 0xa1,
	0x30, 0xe3, 0x3c, 0xa3, 0x10, 0xc9, 0x92, 0x30, 0x06, 0x22, 0xda, 0x8d, 0xa3, 0x6d, 0xa5, 0x88,
	0xca, 0x39, 0xc3, 0xa5, 0xe0, 0x8a, 0x7b, 0xef, 0x8d, 0x02, 0x5b, 0x05, 0xde, 0x8d, 0x83, 0x2f,
	0x16, 0x22, 0x65, 0x1e, 0x11, 0xc6, 0xb8, 0xd1, 0x4b, 0x03, 0xdc, 0x77, 0x75, 0xb5, 0xae, 0xae,
	0x22, 0xa9, 0x44, 0x95, 0xaa, 0x07, 0xdd, 0x83, 0xc0, 0x02, 0xf6, 0x96, 0x1d, 0xde, 0x74, 0xd0,
	0xeb, 0x99, 0xcd, 0xf7, 0x26, 0xc8, 0xcd, 0x99, 0x04, 0xa1, 0xfc, 0x56, 0xd8, 0x1a, 0x0d, 0xe2,
	0xaf, 0xf8, 0x68, 0x14, 0xdc, 0x88, 0xf1, 0x85, 0xc8, 0x15, 0xfc, 0x7d, 0x95, 0x58, 0xa4, 0x86,
	0xab, 0x72, 0x43, 0x14, 0xf8, 0xed, 0x17, 0xc0, 0x06, 0xf1, 0x66, 0xe8, 0x9d, 0xb1, 0x59, 0x71,
	0xb1, 0xb2, 0x36, 0xce, 0xe9, 0x36, 0x6f, 0x0d, 0x7c, 0x26, 0xce, 0x8d, 0xdd, 0x4f, 0xd4, 0x13,
	0x50, 0x52, 0x92, 0x82, 0xdf, 0x39, 0xdd, 0xa5, 0x61, 0xbc, 0x1f, 0xc8, 0xdd, 0x00, 0x05, 0x05,
	0x7e, 0x57, 0xd3, 0xc3, 0xe7, 0xe8, 0xdf, 0x5a, 0x59, 0xef, 0x62, 0x98, 0xa0, 0x40, 0x5d, 0xed,
	0xe8, 0x7d, 0x40, 0x5d, 0x45, 0xd6, 0x14, 0xf4, 0x69, 0xf6, 0x13, 0x53, 0x78, 0x3e, 0xea, 0xa5,
	0x9c, 0x56, 0x5b, 0x26, 0xfd, 0x76, 0xe8, 0x8c, 0xfa, 0x49, 0x53, 0x7a, 0x31, 0x72, 0x77, 0x84,
	0x56, 0x20, 0x7d, 0x27, 0x74, 0x46, 0x83, 0x38, 0x68, 0x62, 0x9b, 0x8b, 0xc5, 0xff, 0x73, 0xa9,
	0x96, 0xb5, 0x24, 0xb1, 0xca, 0x20, 0x41, 0xae, 0x19, 0xe0, 0x89, 0xb4, 0x18, 0xf5, 0x0a, 0xd8,
	0xaf, 0x24, 0x28, 0x7b, 0x2d, 0x9f, 0x1f, 0xd9, 0xe5, 0x1f, 0xec, 0x17, 0xa0, 0x12, 0xb7, 0xd0,
	0xdf, 0xe9, 0x00, 0xf5, 0x79, 0x09, 0x42, 0xaf, 0x37, 0xbd, 0x46, 0x1f, 0x53, 0xbe, 0x3d, 0x86,
	0xa6, 0x6f, 0x9a, 0x13, 0x98, 0xd7, 0xd3, 0xcd, 0x5b, 0x97, 0xdf, 0xad, 0x26, 0xe3, 0x94, 0xb0,
	0x0c, 0x73, 0x91, 0x45, 0x19, 0x30, 0x3d, 0x7b, 0x64, 0x5a, 0xa4, 0xcc, 0xe5, 0xc1, 0x3b, 0x9c,
	0xd8, 0xdf, 0xdb, 0xf6, 0xa7, 0x3f, 0x06, 0xfd, 0x45, 0x79, 0xb5, 0xc1, 0x0b, 0x1b, 0xb2, 0x1c,
	0xaf, 0x5d, 0x8d, 0x7f, 0xbb, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x94, 0x52, 0x99, 0xf3, 0x36, 0x03,
	0x00, 0x00,
}
