/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "kubevirt.io/containerized-data-importer/pkg/apis/core/v1alpha1"
)

// CDILister helps list CDIs.
type CDILister interface {
	// List lists all CDIs in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.CDI, err error)
	// CDIs returns an object that can list and get CDIs.
	CDIs(namespace string) CDINamespaceLister
	CDIListerExpansion
}

// cDILister implements the CDILister interface.
type cDILister struct {
	indexer cache.Indexer
}

// NewCDILister returns a new CDILister.
func NewCDILister(indexer cache.Indexer) CDILister {
	return &cDILister{indexer: indexer}
}

// List lists all CDIs in the indexer.
func (s *cDILister) List(selector labels.Selector) (ret []*v1alpha1.CDI, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.CDI))
	})
	return ret, err
}

// CDIs returns an object that can list and get CDIs.
func (s *cDILister) CDIs(namespace string) CDINamespaceLister {
	return cDINamespaceLister{indexer: s.indexer, namespace: namespace}
}

// CDINamespaceLister helps list and get CDIs.
type CDINamespaceLister interface {
	// List lists all CDIs in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.CDI, err error)
	// Get retrieves the CDI from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.CDI, error)
	CDINamespaceListerExpansion
}

// cDINamespaceLister implements the CDINamespaceLister
// interface.
type cDINamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all CDIs in the indexer for a given namespace.
func (s cDINamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.CDI, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.CDI))
	})
	return ret, err
}

// Get retrieves the CDI from the indexer for a given namespace and name.
func (s cDINamespaceLister) Get(name string) (*v1alpha1.CDI, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("cdi"), name)
	}
	return obj.(*v1alpha1.CDI), nil
}
