# Ansible Automation Platform UI Operator

An operator for Kubernetes built with [Operator SDK](https://github.com/operator-framework/operator-sdk) and [Ansible](https://github.com/ansible/ansible).

## Purpose

This operator is meant to provide a welcome page on Ansible Automation Platform deployment made on Azure.

## Usage

### Deploy a Kubernetes/OpenShift cluster

This can be achieved either with [minikube](https://github.com/kubernetes/minikube) or [CodeReady Containers](https://github.com/code-ready/crc) (crc).

**Note:** For `minikube`, be sure to enable the ingress addon with `--addons ingress`

### Install the operator-sdk

The `operator-sdk` command is needed for deploying the operator.

See the [documentation](https://sdk.operatorframework.io/docs/installation/) for installing it.

### Connect to your cluster

First login to your k8s cluster.

```
$ oc login -u <user> <cluster-api-url>
```

You might also want to create a new project.

```
$ oc new-project azure
```

### Get the operator sources

```
$ git clone https://github.com/ansible/ansible-automation-platform-ui-operator
$ cd ansible-automation-platform-ui-operator
```

### Build the operator/bundle container images

First login to the registry with either `docker` or `podman`.

```
$ podman login quay.io
Username: <user>
Password: ******
Login Succeeded!
```

**Note:** `quay.io` registry is used as an example but any other registries can be used.

Then create two repositories on your namespace for the operator and bundle container images.
Once created, you can start to build and push those images.

**Note:** When using `podman` you also need to set the BUILDER environment variable (default value is docker).

```
$ export BUILDER="podman"
$ export IMG="quay.io/<user>/ansible-automation-platform-ui-operator:dev"
$ export BUNDLE_IMG="quay.io/<user>/ansible-automation-platform-ui-bundle:dev"
$ make container-build container-push
podman build -t quay.io/<user>/ansible-automation-platform-ui-operator:dev .
(...)
podman push quay.io/<user>/ansible-automation-platform-ui-operator:dev
(...)
$ make bundle bundle-build bundle-push
operator-sdk generate kustomize manifests -q
cd config/manager && /home/<user>/ansible-automation-platform-ui-operator/bin/kustomize edit set image controller=quay.io/<user>/ansible-automation-platform-ui-operator:dev
/home/<user>/ansible-automation-platform-ui-operator/bin/kustomize build config/manifests | operator-sdk generate bundle -q --overwrite --version 0.0.1
INFO[0000] Creating bundle/metadata/annotations.yaml
INFO[0000] Creating bundle.Dockerfile
INFO[0000] Bundle metadata generated suceessfully
operator-sdk bundle validate ./bundle
INFO[0000] All validation tests have completed successfully
podman build -f bundle.Dockerfile -t quay.io/<user>/ansible-automation-platform-ui-bundle:dev .
(...)
podman push quay.io/<user>/ansible-automation-platform-ui-bundle:dev
(...)
```

### Install the operator

If you want to deploy the operator via OLM:

```
$ operator-sdk run bundle ${BUNDLE_IMG}
INFO[0010] Successfully created registry pod: ansible-automation-platform-ui-operator-bundle-v0-0-1
INFO[0010] Created CatalogSource: aap-ui-operator-catalog
INFO[0010] OperatorGroup "operator-sdk-og" created
INFO[0010] Created Subscription: aap-ui-operator-v0-0-1-sub
INFO[0014] Approved InstallPlan install-w6m2f for the Subscription: aap-ui-operator-v0-0-1-sub
INFO[0014] Waiting for ClusterServiceVersion "azure/aap-ui-operator.v0.0.1" to reach 'Succeeded' phase
INFO[0014]   Waiting for ClusterServiceVersion "azure/aap-ui-operator.v0.0.1" to appear
INFO[0026]   Found ClusterServiceVersion "azure/aap-ui-operator.v0.0.1" phase: Pending
INFO[0028]   Found ClusterServiceVersion "azure/aap-ui-operator.v0.0.1" phase: Installing
INFO[0039]   Found ClusterServiceVersion "azure/aap-ui-operator.v0.0.1" phase: Succeeded
INFO[0039] OLM has successfully installed "aap-ui-operator.v0.0.1"
```

Otherwise you can do a direct deployment:

```
$ export NAMESPACE=azure
$ make deploy
cd config/manager && /home/<user>/ansible-automation-platform-ui-operator/bin/kustomize edit set image controller=quay.io/<user>/ansible-automation-platform-ui-operator:dev
/home/<user>/ansible-automation-platform-ui-operator/bin/kustomize build config/default | kubectl apply -f -
namespace/aap-ui-operator-system created
customresourcedefinition.apiextensions.k8s.io/automationplatforms.platform.ansible.com created
serviceaccount/aap-ui-operator-controller-manager created
role.rbac.authorization.k8s.io/aap-ui-operator-leader-election-role created
clusterrole.rbac.authorization.k8s.io/aap-ui-operator-manager-role created
clusterrole.rbac.authorization.k8s.io/aap-ui-operator-metrics-reader configured
clusterrole.rbac.authorization.k8s.io/aap-ui-operator-proxy-role created
rolebinding.rbac.authorization.k8s.io/aap-ui-operator-leader-election-rolebinding created
clusterrolebinding.rbac.authorization.k8s.io/aap-ui-operator-manager-rolebinding created
clusterrolebinding.rbac.authorization.k8s.io/aap-ui-operator-proxy-rolebinding created
configmap/aap-ui-operator-manager-config created
service/aap-ui-operator-controller-manager-metrics-service created
deployment.apps/aap-ui-operator-controller-manager created
```

### Create an AutomationPlatfrom CR

```yaml
---
apiVersion: platform.ansible.com/v1alpha1
kind: AutomationPlatform
metadata:
  name: ui-demo
  namespace: azure
```

Finally, use `oc` to create the UI instance in your cluster:


```
$ oc apply -f ui-demo.yml
automationplatform.platform.ansible.com/ui-demo created
```

You should be able to see the UI pod/service/ingress resources by running:

```
$ oc get pods -l app=aap-ui
NAME                            READY   STATUS    RESTARTS   AGE
ui-demo-aapui-bd6fd588c-5mtzh   1/1     Running   0          2m36s
$ oc get services -l app=aap-ui
NAME                TYPE           CLUSTER-IP    EXTERNAL-IP   PORT(S)        AGE
ui-demo-aapui-svc   LoadBalancer   x.x.x.x       <pending>     80:30295/TCP   12m
$ oc get ingress -l app=aap-ui
NAME                   CLASS   HOSTS   ADDRESS   PORTS   AGE
ui-demo-aapui-ingres   nginx   *                 80      13m
```

### Advanced Configuration

There are few variables that are customizable for the UI image application

| Name                      | Description                |
| --------------------------| -------------------------- |
| image                     | Path of the image to pull  |
| image_version             | Image version to pull      |

```yaml
---
spec:
  ...
  image: quay.io/foo/bar
  image_version: v1.6.42
```

### Remove the AutomationPlatfrom instance

To uninstall the AutomationPlatform instance, run the following command.

```
$ oc delete automationplatform ui-demo
automationplatform.platform.ansible.com "ui-demo" deleted
```

### Remove the operator

If the operator was installed via OLM:

```
$ operator-sdk cleanup aap-ui-operator
INFO[0000] subscription "aap-ui-operator-v0-0-1-sub" deleted
INFO[0000] customresourcedefinition "automationplatforms.platform.ansible.com" deleted
INFO[0000] clusterserviceversion "aap-ui-operator.v0.0.1" deleted
INFO[0000] catalogsource "aap-ui-operator-catalog" deleted
INFO[0000] operatorgroup "operator-sdk-og" deleted
INFO[0000] Operator "aap-ui-operator" uninstalled
```

Otherwise:

```
$ export NAMESPACE=azure
$ make undeploy
/home/<user>/ansible-automation-platform-ui-operator/bin/kustomize build config/default | kubectl delete -f -
namespace "aap-ui-operator-system" deleted
customresourcedefinition.apiextensions.k8s.io "automationplatforms.platform.ansible.com" deleted
serviceaccount "aap-ui-operator-controller-manager" deleted
role.rbac.authorization.k8s.io "aap-ui-operator-leader-election-role" deleted
clusterrole.rbac.authorization.k8s.io "aap-ui-operator-manager-role" deleted
clusterrole.rbac.authorization.k8s.io "aap-ui-operator-metrics-reader" deleted
clusterrole.rbac.authorization.k8s.io "aap-ui-operator-proxy-role" deleted
rolebinding.rbac.authorization.k8s.io "aap-ui-operator-leader-election-rolebinding" deleted
clusterrolebinding.rbac.authorization.k8s.io "aap-ui-operator-manager-rolebinding" deleted
clusterrolebinding.rbac.authorization.k8s.io "aap-ui-operator-proxy-rolebinding" deleted
configmap "aap-ui-operator-manager-config" deleted
service "aap-ui-operator-controller-manager-metrics-service" deleted
deployment.apps "aap-ui-operator-controller-manager" deleted
```