#!/usr/bin/env bash

# -- General replaces section

replacements=(

    RELATED_IMAGE_AWX:RELATED_IMAGE_CONTROLLER
    AWX:AutomationController
    AutomationController_:AWX_
    # "quay.io/ansible/automationcontroller":"quay.io/ansible/awx"
)

# Replace in roles files; settings configmap is intentionally left out to keep settings in tact
for row in "${replacements[@]}"; do
    upstream="$(echo $row | cut -d: -f1)";
    downstream="$(echo $row | cut -d: -f2)";
    find ./roles -type f -name '*' \
      -not -path '*.md' \
      -not -path roles/installer/templates/config.yaml.j2 \
	    -exec sed -i -e "s/${upstream}/${downstream}/g" {} \;
done

# Replace in watches.yaml
for row in "${replacements[@]}"; do
    upstream="$(echo $row | cut -d: -f1)";
    downstream="$(echo $row | cut -d: -f2)";
    sed -i -e "s/${upstream}/${downstream}/g" ./watches.yaml ;
done

# -- Replace deployment_type

for row in "${replacements[@]}"; do
    upstream="$(echo $row | cut -d: -f1)";
    downstream="$(echo $row | cut -d: -f2)";
    sed -i -e "s/deployment_type: awx/deployment_type: automationcontroller/g" roles/backup/vars/main.yml roles/installer/defaults/main.yml roles/restore/vars/main.yml ;

done


# -- Inject Downstream Settings Variables for Controller

# TODO: Fix Me
# sed -i -e "/^BROADCAST_WEBSOCKET_PROTOCOL.*/a '    # Downstream variables\
#     INSIGHTS_URL_BASE = \'https://cloud.redhat.com\'\
#     REDHAT_CANDLEPIN_HOST = \'https://subscription.rhsm.redhat.com\'\
#     REDHAT_CANDLEPIN_VERIFY = \'/etc/rhsm/ca/redhat-uep.pem\'\
#     REDHAT_CONTENT_URL = \'https://cdn.redhat.com\'\
#     AUTOMATION_ANALYTICS_URL = \'https://cloud.redhat.com/api/ingress/v1/upload\'\
#     INSIGHTS_AGENT_MIME = \'application/vnd.redhat.tower.analytics+tgz\''" roles/installer/templates/config.yaml.j2

# -- Swap out postgres data path

# cat /var/lib/postgresql/data/pgdata/PG_VERSION      < Upstream postgres path
# cat /var/lib/pgsql/data/userdata/PG_VERSION         < Downstream postgresql-12 path (and 13)

# Need to verify new path after this work lands for 2.2
# sed -i -e "s/\/var\/lib\/pgsql\/data/\/var\/lib\/postgresql\/data\/pgdata/g" ./roles/installer/defaults/main.yml


# -- Inject RELATED_IMAGES_ references

# TODO


# -- Project Persistence

# Manually commit this change until the logic can be the same upstream and downstream
#   See this commit for context: https://code.engineering.redhat.com/gerrit/gitweb?p=automationcontroller-operator.git;a=commit;h=b86895e8cb9be3cb1f98b93692aa2e4d9a7dc979


# -- Check __postgres_image reference and swap if needed

# TODO
