# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .virtual_machine_scale_set_vm_reimage_parameters import VirtualMachineScaleSetVMReimageParameters


class VirtualMachineScaleSetReimageParameters(VirtualMachineScaleSetVMReimageParameters):
    """Describes a Virtual Machine Scale Set VM Reimage Parameters.

    :param temp_disk: Specifies whether to reimage temp disk. Default value:
     false.
    :type temp_disk: bool
    :param instance_ids: The virtual machine scale set instance ids. Omitting
     the virtual machine scale set instance ids will result in the operation
     being performed on all virtual machines in the virtual machine scale set.
    :type instance_ids: list[str]
    """

    _attribute_map = {
        'temp_disk': {'key': 'tempDisk', 'type': 'bool'},
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineScaleSetReimageParameters, self).__init__(**kwargs)
        self.instance_ids = kwargs.get('instance_ids', None)
