# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClusterGetProperties(Model):
    """The properties of cluster.

    All required parameters must be populated in order to send to Azure.

    :param cluster_version: The version of the cluster.
    :type cluster_version: str
    :param os_type: The type of operating system. Possible values include:
     'Windows', 'Linux'
    :type os_type: str or ~azure.mgmt.hdinsight.models.OSType
    :param tier: The cluster tier. Possible values include: 'Standard',
     'Premium'
    :type tier: str or ~azure.mgmt.hdinsight.models.Tier
    :param cluster_definition: Required. The cluster definition.
    :type cluster_definition: ~azure.mgmt.hdinsight.models.ClusterDefinition
    :param security_profile: The security profile.
    :type security_profile: ~azure.mgmt.hdinsight.models.SecurityProfile
    :param compute_profile: The compute profile.
    :type compute_profile: ~azure.mgmt.hdinsight.models.ComputeProfile
    :param provisioning_state: The provisioning state, which only appears in
     the response. Possible values include: 'InProgress', 'Failed',
     'Succeeded', 'Canceled', 'Deleting'
    :type provisioning_state: str or
     ~azure.mgmt.hdinsight.models.HDInsightClusterProvisioningState
    :param created_date: The date on which the cluster was created.
    :type created_date: str
    :param cluster_state: The state of the cluster.
    :type cluster_state: str
    :param quota_info: The quota information.
    :type quota_info: ~azure.mgmt.hdinsight.models.QuotaInfo
    :param errors: The list of errors.
    :type errors: list[~azure.mgmt.hdinsight.models.Errors]
    :param connectivity_endpoints: The list of connectivity endpoints.
    :type connectivity_endpoints:
     list[~azure.mgmt.hdinsight.models.ConnectivityEndpoint]
    """

    _validation = {
        'cluster_definition': {'required': True},
    }

    _attribute_map = {
        'cluster_version': {'key': 'clusterVersion', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'OSType'},
        'tier': {'key': 'tier', 'type': 'Tier'},
        'cluster_definition': {'key': 'clusterDefinition', 'type': 'ClusterDefinition'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'compute_profile': {'key': 'computeProfile', 'type': 'ComputeProfile'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'HDInsightClusterProvisioningState'},
        'created_date': {'key': 'createdDate', 'type': 'str'},
        'cluster_state': {'key': 'clusterState', 'type': 'str'},
        'quota_info': {'key': 'quotaInfo', 'type': 'QuotaInfo'},
        'errors': {'key': 'errors', 'type': '[Errors]'},
        'connectivity_endpoints': {'key': 'connectivityEndpoints', 'type': '[ConnectivityEndpoint]'},
    }

    def __init__(self, **kwargs):
        super(ClusterGetProperties, self).__init__(**kwargs)
        self.cluster_version = kwargs.get('cluster_version', None)
        self.os_type = kwargs.get('os_type', None)
        self.tier = kwargs.get('tier', None)
        self.cluster_definition = kwargs.get('cluster_definition', None)
        self.security_profile = kwargs.get('security_profile', None)
        self.compute_profile = kwargs.get('compute_profile', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.created_date = kwargs.get('created_date', None)
        self.cluster_state = kwargs.get('cluster_state', None)
        self.quota_info = kwargs.get('quota_info', None)
        self.errors = kwargs.get('errors', None)
        self.connectivity_endpoints = kwargs.get('connectivity_endpoints', None)
