# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class BackupLongTermRetentionPolicy(ProxyResource):
    """A long term retention policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param weekly_retention: The weekly retention policy for an LTR backup in
     an ISO 8601 format.
    :type weekly_retention: str
    :param monthly_retention: The montly retention policy for an LTR backup in
     an ISO 8601 format.
    :type monthly_retention: str
    :param yearly_retention: The yearly retention policy for an LTR backup in
     an ISO 8601 format.
    :type yearly_retention: str
    :param week_of_year: The week of year to take the yearly backup in an ISO
     8601 format.
    :type week_of_year: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'weekly_retention': {'key': 'properties.weeklyRetention', 'type': 'str'},
        'monthly_retention': {'key': 'properties.monthlyRetention', 'type': 'str'},
        'yearly_retention': {'key': 'properties.yearlyRetention', 'type': 'str'},
        'week_of_year': {'key': 'properties.weekOfYear', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(BackupLongTermRetentionPolicy, self).__init__(**kwargs)
        self.weekly_retention = kwargs.get('weekly_retention', None)
        self.monthly_retention = kwargs.get('monthly_retention', None)
        self.yearly_retention = kwargs.get('yearly_retention', None)
        self.week_of_year = kwargs.get('week_of_year', None)
