---
title: XY Grid
description: A fully reworked new grid system in v6.4 which has all the variety inbuilt in the form of multiple grid types which includes margin grid, padding grid, frame grid, block grid and vertical grid.
video: tjjVKGeoi3A
sass: scss/xy-grid/*.scss
---

<div class="callout training-callout">
  <p>The XY Grid is a huge advancement in Grids. Stay up-to-date with all the new features in Foundation 6.4 with our online webinar training. You’ll come away knowing the ins and outs of the XY Grid to create complex layouts faster and with less code. Not to mention all the useful UI components and Foundation JavaScript you’ll learn. You’ll make your coworkers jealous.</p>
  <a href="http://zurb.com/university/foundation-intro" target="_blank">Don’t miss out on the upcoming Foundation trainings →</a>
</div>

## XY Grid Basics

The XY grid works very similarly to the standard float grid, but includes a number of useful features only possible with Flexbox, like horizontal and vertical alignment, automatic sizing and a full vertical grid.

---

## Browser support

The XY grid is supported in Chrome, Firefox, Safari 6+, IE10+, iOS 7+, and Android 4.4+. Flexbox is supported in Android 2, but not reliably enough for use with this grid. ([View Flexbox browser support.](http://caniuse.com/#feat=flexbox)) We recommend only using the XY grid on projects that can live with purely cutting-edge browser support.

---

## Importing

**XY grid is the default Foundation grid**. It is present by default in `foundation.css` of CDN link or package managers. In Sass, it will be generated by default by `@include foundation-everything` (unless `$flex` or `$xy-grid` are set to false).

If `$xy-grid` is set to false, the flex grid is used.  
If `$flex` is set to false, the float grid is used instead.

You can manually generate the XY Grid with:
```scss
@import 'foundation';

@include foundation-xy-grid-classes(
  /* options
  $base-grid: true,
  $margin-grid: true,
  $padding-grid: true,
  $block-grid: true,
  $collapse: true,
  $offset: true,
  $vertical-grid: true,
  $frame-grid: true
  */
);
```

---

## Basics

The structure of XY grid uses `.grid-x`, `.grid-y`, and `.cell` as its base. Without [defining a gutter type](#gutters) the cells will simply split up the space without any gutters.

<p>
  <a class="" data-open-video="3:47"><img src="{{root}}assets/img/icons/watch-video-icon.svg" class="video-icon" height="30" width="30" alt=""> Watch this part in video</a>
</p>

<div class="docs-codepen-container">
<a class="codepen-logo-link" href="https://codepen.io/ZURBFoundation/pen/gRYeMQ?editors=1000" target="_blank"><img src="{{root}}assets/img/logos/edit-in-browser.svg" class="" height="" width="" alt="edit on codepen button"></a>
</div>

```html_example
<div class="grid-x">
  <div class="cell">full width cell</div>
  <div class="cell">full width cell</div>
</div>
<div class="grid-x">
  <div class="cell small-6">6 cells</div>
  <div class="cell small-6">6 cells</div>
</div>
<div class="grid-x">
  <div class="cell medium-6 large-4">12/6/4 cells</div>
  <div class="cell medium-6 large-8">12/6/8 cells</div>
</div>
```

---

## Gutters

The defining feature of the XY grid is the ability to use margin AND padding grids in harmony.
To define a grid type, simply set `.grid-margin-x`/`.grid-margin-y` or `.grid-padding-x`/`.grid-padding-y` on the grid.

<p>
  <a class="" data-open-video="5:43"><img src="{{root}}assets/img/icons/watch-video-icon.svg" class="video-icon" height="30" width="30" alt=""> Watch this part in video</a>
</p>

<div class="docs-codepen-container">
<a class="codepen-logo-link" href="https://codepen.io/ZURBFoundation/pen/owvqYp?editors=1000" target="_blank"><img src="{{root}}assets/img/logos/edit-in-browser.svg" class="" height="" width="" alt="edit on codepen button"></a>
</div>

```html_example
<div class="grid-x grid-margin-x">
  <div class="cell medium-6 large-4">12/6/4 cells</div>
  <div class="cell medium-6 large-8">12/6/8 cells</div>
</div>
<div class="grid-x grid-padding-x">
  <div class="cell medium-6 large-4">12/6/4 cells</div>
  <div class="cell medium-6 large-8">12/6/8 cells</div>
</div>
```
---

## Grid Container

The grid defaults to the full width of the available space. To contain it horizontally use the `grid-container` class. The container will be centered and have a max-width equal to your `$grid-container` setting (1200px by default), along with padding on the left/right equal to half your `$grid-container-padding` setting.

```html
<div class="grid-container">
  <div class="grid-x grid-margin-x">
    <div class="cell small-4">cell</div>
    <div class="cell small-4">cell</div>
    <div class="cell small-4">cell</div>
  </div>
</div>
```
### Grid Container Fluid

To stretch the content to the full width of the available space, simply add the class `fluid` to your `grid-container`.

```html
<div class="grid-container fluid">
  <div class="grid-x grid-margin-x">
    <div class="cell small-4">cell</div>
    <div class="cell small-4">cell</div>
    <div class="cell small-4">cell</div>
  </div>
</div>
```

### Grid Container Full

To stretch the content to the full width of the available space and remove grid container padding, simply add the class `full` to your `grid-container`. Note that this variation is primarily for use for the `grid-margin-x` - it works with `grid-padding-x` too, but will work the same as `.grid-container.fluid`.

<div class="callout alert">
  <p>Please note that when you are using `grid-margin-x` on a `grid-container` with `full` class you will also need to hide the horizontal overflow in order for this to work correctly if your content is going to touch the sides of the viewport.</p>
  <p>The best way to do this is:&nbsp; `body {overflow-x: hidden;}`</p>
</div>

```html
<div class="grid-container full">
  <div class="grid-x grid-margin-x">
    <div class="cell small-4">cell</div>
    <div class="cell small-4">cell</div>
    <div class="cell small-4">cell</div>
  </div>
</div>
```
---

## Auto Sizing

If the class `.auto` or `.[size]-auto` is added to the cell, it will take up the remaining space.

```html_example
<div class="grid-x grid-margin-x">
  <div class="cell small-4">4 cells</div>
  <div class="cell auto">Whatever's left!</div>
</div>
```

---

Multiple expanding cells will share the leftover space equally.

```html_example
<div class="grid-x grid-margin-x">
  <div class="cell small-4">4 cells</div>
  <div class="cell auto">Whatever's left!</div>
  <div class="cell auto">Whatever's left!</div>
</div>
```

---

A cell can also be made to *shrink*, by adding the `.shrink` or `.[size]-shrink` class. This means it will only take up the space its contents need.

```html_example
<div class="grid-x grid-margin-x">
  <div class="cell shrink">Shrink!</div>
  <div class="cell auto">Expand!</div>
</div>
```

---

## Responsive Adjustments

To switch back to the auto behavior from a percentage or shrink behavior, use the classes `.[size]-auto` or `.[size]-shrink`. In the below example, the cells stack on small screens, and become even-width on large screens.

```html_example
<div class="grid-x">
  <div class="cell large-auto">One</div>
  <div class="cell large-auto">Two</div>
  <div class="cell large-auto">Three</div>
  <div class="cell large-auto">Four</div>
  <div class="cell large-auto">Five</div>
  <div class="cell large-auto">Six</div>
</div>
```

---

## Collapse Cells <span class="label secondary">X Grid only</span>

The `.[size]-[gutter-type]-collapse` class lets you remove cell gutters.

There are times when you won't want each media query to be collapsed. In this case, use the media query size you want and collapse and add that to your grid element. Example shows gutters at small and no gutters on medium and up.

```html_example
<div class="grid-x grid-margin-x medium-margin-collapse">
  <div class="cell small-6">
    Gutters at small no gutters at medium.
  </div>
  <div class="cell small-6">
    Gutters at small no gutters at medium.
  </div>
</div>
```

---

## Offsets <span class="label secondary">X Grid only</span>

Offsets work by applying `margin-left` to a grid.

```html_example
<div class="grid-x grid-margin-x">
  <div class="cell small-4 large-offset-2">Offset 2 on large</div>
  <div class="cell small-4">4 cells</div>
</div>
```

---

## Block Grids <span class="label secondary">X Grid only</span>

To define cell widths within a direction-level, instead of the individual cell level, add the class `.[size]-up-[n]` to a `grid-x`, where `[n]` is the number of cells to display per direction, and `[size]` is the breakpoint at which to apply the effect.

<div class="callout primary">This example uses padding grid but this can be used with margin grid too.</div>

<div class="docs-codepen-container">
<a class="codepen-logo-link" href="https://codepen.io/IamManchanda/pen/PjBLxE?editors=1000" target="_blank"><img src="{{root}}assets/img/logos/edit-in-browser.svg" class="" height="" width="" alt="edit on codepen button"></a>
</div>

```html_example
<div class="grid-x grid-padding-x small-up-2 medium-up-4 large-up-6">
  <div class="cell">cell</div>
  <div class="cell">cell</div>
  <div class="cell">cell</div>
  <div class="cell">cell</div>
  <div class="cell">cell</div>
  <div class="cell">cell</div>
</div>
```

Block Grids are not available for the vertical grids. Use the [basic layout](#vertical-grids) with a size applied on each cell of the grid instead.

---

## Looking for Push/Pull?

Push and pull are a bit of a hack solution and was only necessary for Float based grids. But for flexbox, this hack is not needed as [source ordering](flexbox-utilities.html#source-ordering) does this with ease.

---

## Vertical Grids

The XY grid also supports vertical grids. Simply apply `.grid-y` instead of `.grid-x`.
The internal cells will shift automatically to provide spacing vertically rather than horizontally.

You can also apply margin or padding with `.grid-margin-y` and `.grid-padding-y` to apply spacing to the top and bottom of cells.

<p>
  <a class="" data-open-video="10:31"><img src="{{root}}assets/img/icons/watch-video-icon.svg" class="video-icon" height="30" width="30" alt=""> Watch this part in video</a>
</p>

<div class="callout">
  <p>Please note for vertical grids to work, the grid needs a height. You can also use [grid frame](#grid-frame) to create a 100 vertical height grid (or 100% height if nested).</p>
</div>


<div class="docs-codepen-container">
<a class="codepen-logo-link" href="https://codepen.io/ZURBFoundation/pen/JJPLYJ?editors=1000" target="_blank"><img src="{{root}}assets/img/logos/edit-in-browser.svg" class="" height="" width="" alt="edit on codepen button"></a>
</div>

```html_example
<div class="grid-y" style="height: 500px;">
  <div class="cell small-6 medium-8 large-2">
    6/8/2
  </div>
  <div class="cell small-6 medium-4 large-10">
    6/4/10
  </div>
</div>
```

---

## Grid Frame

The XY grid incorporates the grid frame from Foundation for Apps plus many other useful features.
To start, add `.grid-frame` to the grid. This sets the grid to be 100vh (the full height of the browser window).

<div class="callout warning">
  Please note that to use `.grid-margin-x` or `.grid-margin-y` with `.grid-frame` you need to hide the overflow on the body like so: `body {overflow: hidden;}`. However, take care not to unintentionally hide overflow body content on small screens when using `.medium-grid-frame`.
</div>

Here's an example of what you can do:

<p>
  <a class="" data-open-video="12:09"><img src="{{root}}assets/img/icons/watch-video-icon.svg" class="video-icon" height="30" width="30" alt=""> Watch this part in video</a>
</p>

<div class="docs-codepen-container">
<a class="codepen-logo-link" href="https://codepen.io/ZURBFoundation/pen/MogrXG?editors=1000" target="_blank"><img src="{{root}}assets/img/logos/edit-in-browser.svg" class="" height="" width="" alt="edit on codepen button"></a>
</div>

```html_example
<div class="grid-y medium-grid-frame">
  <div class="cell shrink header medium-cell-block-container">
    <h1>Grid Frame Header</h1>
    <div class="grid-x grid-padding-x">
      <div class="cell medium-4">
        A medium 4 cell
      </div>
      <div class="cell medium-4 medium-cell-block">
        <p style="width:80vw;">A medium 4 cell block... on medium this content should overflow and let you horizontally scroll across... one might use this for an array of options</p>
      </div>
      <div class="cell medium-4">
        A medium 4 cell
      </div>
    </div>
  </div>
  <div class="cell medium-auto medium-cell-block-container">
    <div class="grid-x grid-padding-x">
      <div class="cell medium-4 medium-cell-block-y">
        <h2>Independent scrolling sidebar</h2>
        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer lacus odio, accumsan id ullamcorper eget, varius nec erat. Nulla facilisi. Donec dui felis, euismod nec finibus vitae, dapibus quis arcu. Maecenas tempor et ipsum quis venenatis. Ut posuere sed augue sit amet efficitur. Sed imperdiet, justo id tempus rhoncus, est est viverra turpis, non vulputate magna lectus et nisl. Pellentesque ultrices porttitor vehicula. Ut aliquet efficitur ligula, a consectetur felis. Proin tristique ut augue nec luctus. Curabitur a sapien pretium, auctor elit a, efficitur erat. Donec tincidunt dui vel velit bibendum euismod. Cras vitae nibh dui. Aliquam erat volutpat. Etiam sit amet arcu a erat efficitur facilisis. Ut viverra dapibus turpis, et ornare justo. Integer in dui cursus, dignissim tortor a, hendrerit risus.</p>

        <p>Suspendisse pulvinar, massa iaculis feugiat lobortis, dolor sapien vestibulum nulla, vel cursus tellus leo in lorem. Aliquam eu placerat urna. Suspendisse sed viverra orci, ut mattis neque. Fusce non ultrices nisi. In sagittis varius mollis. Quisque dolor quam, consectetur eu lacinia ac, ullamcorper vel arcu. Nullam mattis imperdiet nulla sed ornare. Praesent tristique, est id eleifend vestibulum, neque nibh condimentum ex, nec lobortis purus justo a libero. Phasellus id ex ac nunc hendrerit hendrerit. Nullam urna ipsum, rutrum at fringilla vel, venenatis non purus. Maecenas egestas ex vitae venenatis molestie. Ut et odio egestas, accumsan neque et, viverra nisl. Sed faucibus nec nulla sed imperdiet. Fusce quis sem ac urna semper tempor a id elit. Nulla fringilla vitae sapien a vehicula.</p>

      </div>
      <div class="cell medium-8 medium-cell-block-y">
        <h2>Independent scrolling body</h2>
        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer lacus odio, accumsan id ullamcorper eget, varius nec erat. Nulla facilisi. Donec dui felis, euismod nec finibus vitae, dapibus quis arcu. Maecenas tempor et ipsum quis venenatis. Ut posuere sed augue sit amet efficitur. Sed imperdiet, justo id tempus rhoncus, est est viverra turpis, non vulputate magna lectus et nisl. Pellentesque ultrices porttitor vehicula. Ut aliquet efficitur ligula, a consectetur felis. Proin tristique ut augue nec luctus. Curabitur a sapien pretium, auctor elit a, efficitur erat. Donec tincidunt dui vel velit bibendum euismod. Cras vitae nibh dui. Aliquam erat volutpat. Etiam sit amet arcu a erat efficitur facilisis. Ut viverra dapibus turpis, et ornare justo. Integer in dui cursus, dignissim tortor a, hendrerit risus.</p>
        <p>Suspendisse pulvinar, massa iaculis feugiat lobortis, dolor sapien vestibulum nulla, vel cursus tellus leo in lorem. Aliquam eu placerat urna. Suspendisse sed viverra orci, ut mattis neque. Fusce non ultrices nisi. In sagittis varius mollis. Quisque dolor quam, consectetur eu lacinia ac, ullamcorper vel arcu. Nullam mattis imperdiet nulla sed ornare. Praesent tristique, est id eleifend vestibulum, neque nibh condimentum ex, nec lobortis purus justo a libero. Phasellus id ex ac nunc hendrerit hendrerit. Nullam urna ipsum, rutrum at fringilla vel, venenatis non purus. Maecenas egestas ex vitae venenatis molestie. Ut et odio egestas, accumsan neque et, viverra nisl. Sed faucibus nec nulla sed imperdiet. Fusce quis sem ac urna semper tempor a id elit. Nulla fringilla vitae sapien a vehicula.</p>
        <p>Nullam vestibulum lorem nec lectus egestas, nec ullamcorper diam maximus. Maecenas condimentum, nibh at blandit semper, ex erat tempus magna, id maximus neque velit accumsan nibh. Aenean dignissim lorem eu nisl laoreet vestibulum. Vivamus efficitur et augue vitae tincidunt. Etiam et magna felis. Integer mattis, nisi aliquet scelerisque blandit, ex mi sodales ante, eget accumsan quam magna et ligula. Curabitur id tristique leo. Proin rutrum mi vitae enim rhoncus, at cursus neque eleifend. Integer ultrices volutpat tellus ac porta. Fusce sollicitudin venenatis lacinia. Fusce ante lorem, gravida semper varius non, pharetra non erat. Sed dapibus arcu turpis, ac sollicitudin nibh lacinia vel. Nullam at enim porta, luctus metus sit amet, rutrum odio. Cras tempor enim vel pellentesque sollicitudin. Maecenas ullamcorper, sem non accumsan volutpat, neque tortor pulvinar orci, ut ultrices ligula lorem ut risus.</p>
        <p>Aliquam facilisis, nibh eget posuere suscipit, arcu sapien iaculis odio, in molestie dolor lectus vitae sem. Cras id nunc mollis mi rutrum dapibus. Quisque rutrum a augue at scelerisque. Praesent faucibus ac enim vitae gravida. Sed et sodales elit. Duis magna lectus, interdum sit amet metus a, sagittis varius magna. Proin nibh lectus, egestas a luctus ut, dapibus et enim. Curabitur fringilla ipsum vitae nunc imperdiet consectetur eget non neque. Suspendisse ultricies odio quis lorem vulputate, ac vulputate turpis feugiat. Maecenas posuere rhoncus orci, in ornare velit suscipit tempor. Curabitur pretium nisl id lorem placerat consequat. In quis quam eros. Nam mattis elit eu quam sagittis, in varius erat tempor.</p>
        <p>Fusce felis magna, pellentesque eget mollis a, rutrum id eros. Curabitur auctor varius arcu a consequat. Phasellus quis pulvinar enim, eu ultricies justo. Pellentesque risus libero, dapibus at erat ultricies, gravida varius erat. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nulla tempus, justo ut laoreet mollis, nunc tellus convallis urna, vel pretium dui velit eget ligula. Aliquam semper sed nulla a molestie. Maecenas at egestas massa, vitae aliquam mi. Fusce nec sem egestas, pretium lacus non, tincidunt sapien. Sed tristique odio at ultricies vulputate. Integer et convallis augue, eu aliquam enim. Mauris ut faucibus diam. Donec vulputate nunc sed congue accumsan. Etiam lobortis nisi quis lacinia pharetra.</p>
      </div>
    </div>
  </div>
  <div class="cell shrink footer">
    <h3>Here's my footer</h3>
  </div>
</div>
```

---

## Building Semantically

XY grid CSS is generated with a powerful set of Sass mixins, which you can use in your own code to build a semantic grid.

### Grid Container

Use the `xy-grid-container()` mixin to create a grid container. This contains the grid to the width specified in `$grid-container`.

```scss
.container {
  @include xy-grid-container;
}
```
---

### Grids

Use the `xy-grid()` mixin to create a grid.

```scss
.my-grid {
  @include xy-grid;
}
```
---

### Gutters

Use the `xy-gutters()` mixin to add gutters to an item. The `xy-cell` mixin used this to output gutters, but you can use this to add responsive gutters to anything you like.
This is especially powerful as you can specify where you want the gutters, like so:

```scss
.gallery-item {
  @include xy-gutters($gutter-position: left right bottom);
}
```
---

### Cells

Use the `xy-cell()` mixin to create a cell. There are a number of ways to define the size of a cell.
`xy-cell` accepts a few different keywords as well as specific sizes: `full` (full width), `auto` (automatic width) and `shrink` (take up only the space it needs).

```scss
.main-content {
  // Use the full column count (100%)
  @include xy-cell();

  // Use a column count (33%);
  @include xy-cell(4);

  // Use a percentage (15%)
  @include xy-cell(15%);

  // Use a custom fraction (20%)
  @include xy-cell(1 of 5);
}
```

The cell size calculator can also be accessed as a function. This gives you the percentage value, without any of the grid cell CSS.

```scss
.main-content {
  width: xy-cell-size(1 of 7);
}
```

---

### Responsive Grids

Pair `xy-cell` with the `breakpoint()` mixin to make your grid responsive.
Refer to the Sass documentation below to learn how each mixin works and the available arguments.

```scss
.main-content {
  @include xy-cell();

  @include breakpoint(medium) {
    @include xy-cell(8);
  }
}
```

### Custom Block Grid

Use the `xy-grid-layout()` mixin to create your own block grid.
By default the mixin takes 2 parameters:
- number of columns
- child selector

Refer to the Sass documentation [below](#xy-grid-layout) for the full list of arguments.

Here's an example:

```scss
.gallery {
  @include xy-grid-layout(3, '.gallery-item');
}
```
That outputs this CSS:

```
.gallery > .gallery-item {
  width: calc(33.33333% - 1.25rem);
  margin-right: 0.625rem;
  margin-left: 0.625rem;
}
```
