# Development Report for Mar 10, 2017

## Runtime 

This week I (@crosbymichael) have been working on the OCI runtime specifications.  Since containerd is to be fully compliant with the OCI specs we need to make sure we reach a 1.0 and have a solid base to build on.  We are getting very close on the spec side and have a final rc out for review.  If you have time please check it out. 

I have also been working on the `runc` side of things, fixing terminal handling for `exec` and implementing the changes in our go bindings.

## Reaper

I have also worked on adding a global process monitor/reaper to containerd.  The issues before with having a `SIGCHLD` reaper is that the Go `exec.Cmd` and especially its `Wait` method did not play well together.  This would cause races between the reaper doing a `waitpid` and the `exec.Cmd` doing a `Wait`.  I think we solved this problem fully now as long as code is written against the `reaper` api.  It is a little more of a burden on developers of containerd but makes it much more robust when dealing with processes being reparented to `containerd` and its `shim`.

## Snapshot Dynamic Registration

We merged a PR making the snapshot registration dynamic.  This allows users to compile containerd with additional shapshotters than the ones we have builtin to the core.  Because of the current state of Go 1.8 plugins the best course of action for adding additional runtimes, snapshotters, and other extensions is to modify the `builtins.go` file for the `containerd` command and recompile.  Hopefully the short comings will be fixed in later Go releases.

```go
package main

// register containerd builtins here
import (
	_ "github.com/containerd/containerd/linux"
	_ "github.com/containerd/containerd/services/content"
	_ "github.com/containerd/containerd/services/execution"
	_ "github.com/containerd/containerd/snapshot/btrfs"
	_ "github.com/containerd/containerd/snapshot/overlay"
)
```

## Update on Dates

We are working towards being feature complete mid April, with a Q2 1.0.  The Beta milestone on github should reflect this goal and the dates associated with it.

After we hit a feature complete state we hope to finish the Docker, swarm, and kube CRI integrations to make sure that we provide the feature set that is required for each, before locking down the APIs.

## Containerd Summit

There is going to be another containerd summit at Dockecon this year.  I created a document in the repository so that everyone can add discussion points for the breakout sessions.  We should have a much larger crowd than the previous summit, therefore, having a few pre-defined discussion points will help.  We will still have ad-hoc discussions but it never hurts to be prepared.


## Next

We are still moving forward so that we can have the distribution, content, and snapshotters all working together over the API.  One of the challenges is to make sure things work well over GRPC.  We need to be able to support things like `docker build` and making sure that it performs as good or better than what you expect.
