<!--
This template was adapted from the Kubernetes KEP template:

https://github.com/kubernetes/enhancements/blob/master/keps/YYYYMMDD-kep-template.md
-->
# Title

This is the title of the spec.  Keep it simple and descriptive.  A good title
can help communicate what the spec is and should be considered as part of any
review.

The title should be lowercased and spaces/punctuation should be replaced with
`-`.

## Summary

The `Summary` section is incredibly important for producing high quality
user-focused documentation such as release notes or a development roadmap.  It
should be possible to collect this information before implementation begins in
order to avoid requiring implementors to split their attention between writing
release notes and implementing the feature itself.  Ensure that the tone and
content of the `Summary` section is useful for a wide audience.

A good summary is probably at least a paragraph in length.

## Goals

List the specific goals of the spec.  How will we know that this has succeeded?

## Non-Goals

What is out of scope for this spec?  Listing non-goals helps to focus
discussion and make progress.

## Proposal

This is where we get down to the nitty gritty of what the proposal actually is.

### User Stories [optional]

Detail the things that people will be able to do if this spec is implemented.
Include as much detail as possible so that people can understand the "how" of
the system.  The goal here is to make this feel real for users without getting
bogged down.

#### Story 1

#### Story 2

### Implementation Details/Notes/Constraints [optional]

What are the caveats to the implementation?  What are some important details
that didn't come across above.  Go in to as much detail as necessary here.
This might be a good place to talk about core concepts and how they releate.

### Risks and Mitigations

What are the risks of this proposal and how do we mitigate.  Think broadly.
For example, consider both security and how this will impact the larger
kubernetes ecosystem.

How will security be reviewed and by whom?  How will UX be reviewed and by
whom?

Consider including folks that also work outside the SIG or subproject.

## Design Details

### Upgrade / Downgrade / Migration Strategy

If applicable, how will the component be upgraded and downgraded? Does this
spec propose migrating users from one component or behaviour to another?

### Public API changes

Does the spec propose a public API-facing change? If so, describe the impact of
changes.

## Drawbacks [optional]

Why should this spec _not_ be implemented.

## Alternatives [optional]

Similar to the `Drawbacks` section the `Alternatives` section is used to
highlight and record other possible approaches to delivering the value proposed
by the spec.
