import * as React from 'react';
import CollapsePanel from './Panel';
import { CollapseProps } from './interface';
export interface CollapseState {
    activeKey: React.Key[];
}
declare class Collapse extends React.Component<CollapseProps, CollapseState> {
    static defaultProps: {
        prefixCls: string;
        onChange(): void;
        accordion: boolean;
        destroyInactivePanel: boolean;
    };
    static Panel: typeof CollapsePanel;
    constructor(props: CollapseProps);
    shouldComponentUpdate(nextProps: CollapseProps, nextState: CollapseState): boolean;
    onClickItem: (key: React.Key) => void;
    static getDerivedStateFromProps(nextProps: CollapseProps): Partial<CollapseState>;
    getNewChild: (child: React.ReactElement, index: number) => React.ReactElement<any, string | React.JSXElementConstructor<any>>;
    getItems: () => React.ReactElement<any, string | React.JSXElementConstructor<any>>[];
    setActiveKey: (activeKey: React.Key[]) => void;
    render(): JSX.Element;
}
export default Collapse;
