// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: server/settings/settings.proto

// Settings Service
//
// Settings Service API retrieves Argo CD settings

package settings

import (
	context "context"
	fmt "fmt"
	v1alpha1 "github.com/argoproj/argo-cd/pkg/apis/application/v1alpha1"
	oidc "github.com/argoproj/argo-cd/server/settings/oidc"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// SettingsQuery is a query for Argo CD settings
type SettingsQuery struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SettingsQuery) Reset()         { *m = SettingsQuery{} }
func (m *SettingsQuery) String() string { return proto.CompactTextString(m) }
func (*SettingsQuery) ProtoMessage()    {}
func (*SettingsQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_a480d494da040caa, []int{0}
}
func (m *SettingsQuery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SettingsQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SettingsQuery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SettingsQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SettingsQuery.Merge(m, src)
}
func (m *SettingsQuery) XXX_Size() int {
	return m.Size()
}
func (m *SettingsQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_SettingsQuery.DiscardUnknown(m)
}

var xxx_messageInfo_SettingsQuery proto.InternalMessageInfo

type Settings struct {
	URL                string                                `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	DexConfig          *DexConfig                            `protobuf:"bytes,2,opt,name=dexConfig,proto3" json:"dexConfig,omitempty"`
	OIDCConfig         *OIDCConfig                           `protobuf:"bytes,3,opt,name=oidcConfig,proto3" json:"oidcConfig,omitempty"`
	AppLabelKey        string                                `protobuf:"bytes,4,opt,name=appLabelKey,proto3" json:"appLabelKey,omitempty"`
	ResourceOverrides  map[string]*v1alpha1.ResourceOverride `protobuf:"bytes,5,rep,name=resourceOverrides,proto3" json:"resourceOverrides,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	StatusBadgeEnabled bool                                  `protobuf:"varint,6,opt,name=statusBadgeEnabled,proto3" json:"statusBadgeEnabled,omitempty"`
	GoogleAnalytics    *GoogleAnalyticsConfig                `protobuf:"bytes,7,opt,name=googleAnalytics,proto3" json:"googleAnalytics,omitempty"`
	KustomizeOptions   *v1alpha1.KustomizeOptions            `protobuf:"bytes,8,opt,name=kustomizeOptions,proto3" json:"kustomizeOptions,omitempty"`
	// Help settings
	Help                    *Help                              `protobuf:"bytes,9,opt,name=help,proto3" json:"help,omitempty"`
	Plugins                 []*Plugin                          `protobuf:"bytes,10,rep,name=plugins,proto3" json:"plugins,omitempty"`
	UserLoginsDisabled      bool                               `protobuf:"varint,11,opt,name=userLoginsDisabled,proto3" json:"userLoginsDisabled,omitempty"`
	ConfigManagementPlugins []*v1alpha1.ConfigManagementPlugin `protobuf:"bytes,12,rep,name=configManagementPlugins,proto3" json:"configManagementPlugins,omitempty"`
	KustomizeVersions       []string                           `protobuf:"bytes,13,rep,name=kustomizeVersions,proto3" json:"kustomizeVersions,omitempty"`
	UiCssURL                string                             `protobuf:"bytes,14,opt,name=uiCssURL,proto3" json:"uiCssURL,omitempty"`
	UiBannerContent         string                             `protobuf:"bytes,15,opt,name=uiBannerContent,proto3" json:"uiBannerContent,omitempty"`
	UiBannerURL             string                             `protobuf:"bytes,16,opt,name=uiBannerURL,proto3" json:"uiBannerURL,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                           `json:"-"`
	XXX_unrecognized        []byte                             `json:"-"`
	XXX_sizecache           int32                              `json:"-"`
}

func (m *Settings) Reset()         { *m = Settings{} }
func (m *Settings) String() string { return proto.CompactTextString(m) }
func (*Settings) ProtoMessage()    {}
func (*Settings) Descriptor() ([]byte, []int) {
	return fileDescriptor_a480d494da040caa, []int{1}
}
func (m *Settings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Settings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Settings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Settings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Settings.Merge(m, src)
}
func (m *Settings) XXX_Size() int {
	return m.Size()
}
func (m *Settings) XXX_DiscardUnknown() {
	xxx_messageInfo_Settings.DiscardUnknown(m)
}

var xxx_messageInfo_Settings proto.InternalMessageInfo

func (m *Settings) GetURL() string {
	if m != nil {
		return m.URL
	}
	return ""
}

func (m *Settings) GetDexConfig() *DexConfig {
	if m != nil {
		return m.DexConfig
	}
	return nil
}

func (m *Settings) GetOIDCConfig() *OIDCConfig {
	if m != nil {
		return m.OIDCConfig
	}
	return nil
}

func (m *Settings) GetAppLabelKey() string {
	if m != nil {
		return m.AppLabelKey
	}
	return ""
}

func (m *Settings) GetResourceOverrides() map[string]*v1alpha1.ResourceOverride {
	if m != nil {
		return m.ResourceOverrides
	}
	return nil
}

func (m *Settings) GetStatusBadgeEnabled() bool {
	if m != nil {
		return m.StatusBadgeEnabled
	}
	return false
}

func (m *Settings) GetGoogleAnalytics() *GoogleAnalyticsConfig {
	if m != nil {
		return m.GoogleAnalytics
	}
	return nil
}

func (m *Settings) GetKustomizeOptions() *v1alpha1.KustomizeOptions {
	if m != nil {
		return m.KustomizeOptions
	}
	return nil
}

func (m *Settings) GetHelp() *Help {
	if m != nil {
		return m.Help
	}
	return nil
}

func (m *Settings) GetPlugins() []*Plugin {
	if m != nil {
		return m.Plugins
	}
	return nil
}

func (m *Settings) GetUserLoginsDisabled() bool {
	if m != nil {
		return m.UserLoginsDisabled
	}
	return false
}

func (m *Settings) GetConfigManagementPlugins() []*v1alpha1.ConfigManagementPlugin {
	if m != nil {
		return m.ConfigManagementPlugins
	}
	return nil
}

func (m *Settings) GetKustomizeVersions() []string {
	if m != nil {
		return m.KustomizeVersions
	}
	return nil
}

func (m *Settings) GetUiCssURL() string {
	if m != nil {
		return m.UiCssURL
	}
	return ""
}

func (m *Settings) GetUiBannerContent() string {
	if m != nil {
		return m.UiBannerContent
	}
	return ""
}

func (m *Settings) GetUiBannerURL() string {
	if m != nil {
		return m.UiBannerURL
	}
	return ""
}

type GoogleAnalyticsConfig struct {
	TrackingID           string   `protobuf:"bytes,1,opt,name=trackingID,proto3" json:"trackingID,omitempty"`
	AnonymizeUsers       bool     `protobuf:"varint,2,opt,name=anonymizeUsers,proto3" json:"anonymizeUsers,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GoogleAnalyticsConfig) Reset()         { *m = GoogleAnalyticsConfig{} }
func (m *GoogleAnalyticsConfig) String() string { return proto.CompactTextString(m) }
func (*GoogleAnalyticsConfig) ProtoMessage()    {}
func (*GoogleAnalyticsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_a480d494da040caa, []int{2}
}
func (m *GoogleAnalyticsConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GoogleAnalyticsConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GoogleAnalyticsConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GoogleAnalyticsConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GoogleAnalyticsConfig.Merge(m, src)
}
func (m *GoogleAnalyticsConfig) XXX_Size() int {
	return m.Size()
}
func (m *GoogleAnalyticsConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_GoogleAnalyticsConfig.DiscardUnknown(m)
}

var xxx_messageInfo_GoogleAnalyticsConfig proto.InternalMessageInfo

func (m *GoogleAnalyticsConfig) GetTrackingID() string {
	if m != nil {
		return m.TrackingID
	}
	return ""
}

func (m *GoogleAnalyticsConfig) GetAnonymizeUsers() bool {
	if m != nil {
		return m.AnonymizeUsers
	}
	return false
}

// Help settings
type Help struct {
	// the URL for getting chat help, this will typically be your Slack channel for support
	ChatUrl string `protobuf:"bytes,1,opt,name=chatUrl,proto3" json:"chatUrl,omitempty"`
	// the text for getting chat help, defaults to "Chat now!"
	ChatText             string   `protobuf:"bytes,2,opt,name=chatText,proto3" json:"chatText,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Help) Reset()         { *m = Help{} }
func (m *Help) String() string { return proto.CompactTextString(m) }
func (*Help) ProtoMessage()    {}
func (*Help) Descriptor() ([]byte, []int) {
	return fileDescriptor_a480d494da040caa, []int{3}
}
func (m *Help) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Help) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Help.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Help) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Help.Merge(m, src)
}
func (m *Help) XXX_Size() int {
	return m.Size()
}
func (m *Help) XXX_DiscardUnknown() {
	xxx_messageInfo_Help.DiscardUnknown(m)
}

var xxx_messageInfo_Help proto.InternalMessageInfo

func (m *Help) GetChatUrl() string {
	if m != nil {
		return m.ChatUrl
	}
	return ""
}

func (m *Help) GetChatText() string {
	if m != nil {
		return m.ChatText
	}
	return ""
}

// Plugin settings
type Plugin struct {
	// the name of the plugin, e.g. "kasane"
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Plugin) Reset()         { *m = Plugin{} }
func (m *Plugin) String() string { return proto.CompactTextString(m) }
func (*Plugin) ProtoMessage()    {}
func (*Plugin) Descriptor() ([]byte, []int) {
	return fileDescriptor_a480d494da040caa, []int{4}
}
func (m *Plugin) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Plugin) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Plugin.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Plugin) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Plugin.Merge(m, src)
}
func (m *Plugin) XXX_Size() int {
	return m.Size()
}
func (m *Plugin) XXX_DiscardUnknown() {
	xxx_messageInfo_Plugin.DiscardUnknown(m)
}

var xxx_messageInfo_Plugin proto.InternalMessageInfo

func (m *Plugin) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type DexConfig struct {
	Connectors           []*Connector `protobuf:"bytes,1,rep,name=connectors,proto3" json:"connectors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *DexConfig) Reset()         { *m = DexConfig{} }
func (m *DexConfig) String() string { return proto.CompactTextString(m) }
func (*DexConfig) ProtoMessage()    {}
func (*DexConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_a480d494da040caa, []int{5}
}
func (m *DexConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DexConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DexConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DexConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DexConfig.Merge(m, src)
}
func (m *DexConfig) XXX_Size() int {
	return m.Size()
}
func (m *DexConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_DexConfig.DiscardUnknown(m)
}

var xxx_messageInfo_DexConfig proto.InternalMessageInfo

func (m *DexConfig) GetConnectors() []*Connector {
	if m != nil {
		return m.Connectors
	}
	return nil
}

type Connector struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type                 string   `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Connector) Reset()         { *m = Connector{} }
func (m *Connector) String() string { return proto.CompactTextString(m) }
func (*Connector) ProtoMessage()    {}
func (*Connector) Descriptor() ([]byte, []int) {
	return fileDescriptor_a480d494da040caa, []int{6}
}
func (m *Connector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Connector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Connector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Connector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Connector.Merge(m, src)
}
func (m *Connector) XXX_Size() int {
	return m.Size()
}
func (m *Connector) XXX_DiscardUnknown() {
	xxx_messageInfo_Connector.DiscardUnknown(m)
}

var xxx_messageInfo_Connector proto.InternalMessageInfo

func (m *Connector) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Connector) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

type OIDCConfig struct {
	Name                 string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Issuer               string                 `protobuf:"bytes,2,opt,name=issuer,proto3" json:"issuer,omitempty"`
	ClientID             string                 `protobuf:"bytes,3,opt,name=clientID,proto3" json:"clientID,omitempty"`
	CLIClientID          string                 `protobuf:"bytes,4,opt,name=cliClientID,proto3" json:"cliClientID,omitempty"`
	Scopes               []string               `protobuf:"bytes,5,rep,name=scopes,proto3" json:"scopes,omitempty"`
	IDTokenClaims        map[string]*oidc.Claim `protobuf:"bytes,6,rep,name=idTokenClaims,proto3" json:"idTokenClaims,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *OIDCConfig) Reset()         { *m = OIDCConfig{} }
func (m *OIDCConfig) String() string { return proto.CompactTextString(m) }
func (*OIDCConfig) ProtoMessage()    {}
func (*OIDCConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_a480d494da040caa, []int{7}
}
func (m *OIDCConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OIDCConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OIDCConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OIDCConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OIDCConfig.Merge(m, src)
}
func (m *OIDCConfig) XXX_Size() int {
	return m.Size()
}
func (m *OIDCConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OIDCConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OIDCConfig proto.InternalMessageInfo

func (m *OIDCConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *OIDCConfig) GetIssuer() string {
	if m != nil {
		return m.Issuer
	}
	return ""
}

func (m *OIDCConfig) GetClientID() string {
	if m != nil {
		return m.ClientID
	}
	return ""
}

func (m *OIDCConfig) GetCLIClientID() string {
	if m != nil {
		return m.CLIClientID
	}
	return ""
}

func (m *OIDCConfig) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *OIDCConfig) GetIDTokenClaims() map[string]*oidc.Claim {
	if m != nil {
		return m.IDTokenClaims
	}
	return nil
}

func init() {
	proto.RegisterType((*SettingsQuery)(nil), "cluster.SettingsQuery")
	proto.RegisterType((*Settings)(nil), "cluster.Settings")
	proto.RegisterMapType((map[string]*v1alpha1.ResourceOverride)(nil), "cluster.Settings.ResourceOverridesEntry")
	proto.RegisterType((*GoogleAnalyticsConfig)(nil), "cluster.GoogleAnalyticsConfig")
	proto.RegisterType((*Help)(nil), "cluster.Help")
	proto.RegisterType((*Plugin)(nil), "cluster.Plugin")
	proto.RegisterType((*DexConfig)(nil), "cluster.DexConfig")
	proto.RegisterType((*Connector)(nil), "cluster.Connector")
	proto.RegisterType((*OIDCConfig)(nil), "cluster.OIDCConfig")
	proto.RegisterMapType((map[string]*oidc.Claim)(nil), "cluster.OIDCConfig.IdTokenClaimsEntry")
}

func init() { proto.RegisterFile("server/settings/settings.proto", fileDescriptor_a480d494da040caa) }

var fileDescriptor_a480d494da040caa = []byte{
	// 971 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xcf, 0x6f, 0x1b, 0xc5,
	0x17, 0xd7, 0xc6, 0x69, 0x62, 0x3f, 0x37, 0x71, 0x32, 0xdf, 0x2f, 0x61, 0xb1, 0x2a, 0xc7, 0xf8,
	0x50, 0x19, 0x09, 0xd6, 0x24, 0x3d, 0x80, 0x10, 0x08, 0xb0, 0x5d, 0xb5, 0x26, 0xa9, 0xd2, 0x4e,
	0x9b, 0x1e, 0x90, 0x50, 0x34, 0x59, 0x3f, 0x36, 0x83, 0x37, 0x33, 0xab, 0x99, 0x59, 0x53, 0x73,
	0xe4, 0x86, 0x38, 0x21, 0xfe, 0x20, 0xae, 0x1c, 0x91, 0xb8, 0x5b, 0xc8, 0xe2, 0x0f, 0x41, 0x3b,
	0xfb, 0x23, 0x1b, 0xdb, 0x54, 0x48, 0xbd, 0xbd, 0x79, 0x9f, 0xf7, 0x6b, 0xde, 0x7c, 0xf6, 0xbd,
	0x85, 0x96, 0x46, 0x35, 0x45, 0xd5, 0xd3, 0x68, 0x0c, 0x17, 0x81, 0x2e, 0x04, 0x2f, 0x52, 0xd2,
	0x48, 0xb2, 0xed, 0x87, 0xb1, 0x36, 0xa8, 0x9a, 0xff, 0x0f, 0x64, 0x20, 0xad, 0xae, 0x97, 0x48,
	0x29, 0xdc, 0xbc, 0x17, 0x48, 0x19, 0x84, 0xd8, 0x63, 0x11, 0xef, 0x31, 0x21, 0xa4, 0x61, 0x86,
	0x4b, 0x91, 0x39, 0x37, 0x47, 0x01, 0x37, 0x57, 0xf1, 0xa5, 0xe7, 0xcb, 0xeb, 0x1e, 0x53, 0xd6,
	0xfd, 0x3b, 0x2b, 0x7c, 0xe0, 0x8f, 0x7b, 0xd1, 0x24, 0x48, 0xdc, 0x74, 0x8f, 0x45, 0x51, 0xc8,
	0x7d, 0xeb, 0xd8, 0x9b, 0x1e, 0xb1, 0x30, 0xba, 0x62, 0x47, 0xbd, 0x00, 0x05, 0x2a, 0x66, 0x70,
	0x9c, 0x85, 0xfa, 0xec, 0x75, 0xa1, 0x96, 0xef, 0x20, 0xf9, 0xd8, 0xef, 0xf9, 0x21, 0xe3, 0xd7,
	0x59, 0x25, 0x9d, 0x06, 0xec, 0x3c, 0xcf, 0xd0, 0x67, 0x31, 0xaa, 0x59, 0xe7, 0xb7, 0x2a, 0x54,
	0x73, 0x0d, 0x79, 0x07, 0x2a, 0xb1, 0x0a, 0x5d, 0xa7, 0xed, 0x74, 0x6b, 0xfd, 0xed, 0xc5, 0xfc,
	0xb0, 0x72, 0x4e, 0x4f, 0x69, 0xa2, 0x23, 0x1f, 0x42, 0x6d, 0x8c, 0xaf, 0x06, 0x52, 0x7c, 0xcb,
	0x03, 0x77, 0xa3, 0xed, 0x74, 0xeb, 0xc7, 0xc4, 0xcb, 0x7a, 0xe2, 0x0d, 0x73, 0x84, 0xde, 0x18,
	0x91, 0x01, 0x40, 0x92, 0x3f, 0x73, 0xa9, 0x58, 0x97, 0xff, 0x15, 0x2e, 0x67, 0xa3, 0xe1, 0x20,
	0x85, 0xfa, 0xbb, 0x8b, 0xf9, 0x21, 0xdc, 0x9c, 0x69, 0xc9, 0x8d, 0xb4, 0xa1, 0xce, 0xa2, 0xe8,
	0x94, 0x5d, 0x62, 0x78, 0x82, 0x33, 0x77, 0x33, 0xa9, 0x8c, 0x96, 0x55, 0xe4, 0x25, 0xec, 0x2b,
	0xd4, 0x32, 0x56, 0x3e, 0x9e, 0x4d, 0x51, 0x29, 0x3e, 0x46, 0xed, 0xde, 0x69, 0x57, 0xba, 0xf5,
	0xe3, 0x6e, 0x91, 0x2d, 0xbf, 0xa1, 0x47, 0x97, 0x4d, 0x1f, 0x0a, 0xa3, 0x66, 0x74, 0x35, 0x04,
	0xf1, 0x80, 0x68, 0xc3, 0x4c, 0xac, 0xfb, 0x6c, 0x1c, 0xe0, 0x43, 0xc1, 0x2e, 0x43, 0x1c, 0xbb,
	0x5b, 0x6d, 0xa7, 0x5b, 0xa5, 0x6b, 0x10, 0xf2, 0x18, 0x1a, 0x29, 0x07, 0xbe, 0x14, 0x2c, 0x9c,
	0x19, 0xee, 0x6b, 0x77, 0xdb, 0xde, 0xb9, 0x55, 0x54, 0xf1, 0xe8, 0x36, 0x9e, 0x5d, 0x77, 0xd9,
	0x8d, 0x7c, 0x0f, 0x7b, 0x93, 0x58, 0x1b, 0x79, 0xcd, 0x7f, 0xc0, 0xb3, 0xc8, 0xf2, 0xc8, 0xad,
	0xda, 0x50, 0x27, 0xde, 0xcd, 0xeb, 0x7b, 0xf9, 0xeb, 0x5b, 0xe1, 0xc2, 0x1f, 0x7b, 0xd1, 0x24,
	0xf0, 0x12, 0x22, 0x79, 0x25, 0x22, 0x79, 0x39, 0x91, 0xbc, 0x93, 0xa5, 0x90, 0x74, 0x25, 0x09,
	0x79, 0x17, 0x36, 0xaf, 0x30, 0x8c, 0xdc, 0x9a, 0x4d, 0xb6, 0x53, 0xd4, 0xfd, 0x18, 0xc3, 0x88,
	0x5a, 0x88, 0xbc, 0x07, 0xdb, 0x51, 0x18, 0x07, 0x5c, 0x68, 0x17, 0x6c, 0x8f, 0x1b, 0x85, 0xd5,
	0x53, 0xab, 0xa7, 0x39, 0x9e, 0x34, 0x30, 0xd6, 0xa8, 0x4e, 0x65, 0x72, 0x1a, 0x72, 0x9d, 0x36,
	0xb0, 0x9e, 0x36, 0x70, 0x15, 0x21, 0x3f, 0x3b, 0xf0, 0xb6, 0x6f, 0x5b, 0xf2, 0x84, 0x09, 0x16,
	0xe0, 0x35, 0x0a, 0xf3, 0x34, 0xcb, 0x75, 0xd7, 0xe6, 0x7a, 0xf6, 0x06, 0xd7, 0x1f, 0xac, 0x8d,
	0x4c, 0xff, 0x2d, 0x23, 0x79, 0x1f, 0xf6, 0x8b, 0xfe, 0xbc, 0x44, 0xa5, 0xed, 0x2b, 0xec, 0xb4,
	0x2b, 0xdd, 0x1a, 0x5d, 0x05, 0x48, 0x13, 0xaa, 0x31, 0x1f, 0x68, 0x7d, 0x4e, 0x4f, 0xdd, 0x5d,
	0xcb, 0xd1, 0xe2, 0x4c, 0xba, 0xd0, 0x88, 0x79, 0x9f, 0x09, 0x81, 0x6a, 0x20, 0x85, 0x41, 0x61,
	0xdc, 0x86, 0x35, 0x59, 0x56, 0x27, 0x64, 0xcf, 0x55, 0x49, 0xa0, 0xbd, 0x94, 0xec, 0x25, 0x55,
	0xf3, 0x17, 0x07, 0x0e, 0xd6, 0x53, 0x98, 0xec, 0x41, 0x65, 0x82, 0xb3, 0xf4, 0xdb, 0xa5, 0x89,
	0x48, 0x18, 0xdc, 0x99, 0xb2, 0x30, 0xc6, 0xec, 0x73, 0x7d, 0x13, 0xf2, 0x2c, 0xe7, 0xa4, 0x69,
	0xe4, 0x4f, 0x36, 0x3e, 0x76, 0x3a, 0x17, 0xf0, 0xd6, 0x5a, 0x62, 0x93, 0x16, 0x80, 0x51, 0xcc,
	0x9f, 0x70, 0x11, 0x8c, 0x86, 0x59, 0x61, 0x25, 0x0d, 0xb9, 0x0f, 0xbb, 0x4c, 0x48, 0x31, 0x4b,
	0x3a, 0x79, 0xae, 0x51, 0x69, 0x5b, 0x68, 0x95, 0x2e, 0x69, 0x3b, 0x9f, 0xc2, 0x66, 0xc2, 0x40,
	0xe2, 0xc2, 0xb6, 0x7f, 0xc5, 0xcc, 0x79, 0x3e, 0xa1, 0x68, 0x7e, 0x4c, 0xda, 0x9f, 0x88, 0x2f,
	0xf0, 0x95, 0xb1, 0x31, 0x6a, 0xb4, 0x38, 0x77, 0xee, 0xc1, 0x56, 0xfa, 0xa6, 0x84, 0xc0, 0xa6,
	0x60, 0xd7, 0x98, 0x39, 0x5b, 0xb9, 0xf3, 0x39, 0xd4, 0x8a, 0xe1, 0x45, 0x8e, 0x01, 0x7c, 0x29,
	0x04, 0xfa, 0x46, 0x2a, 0xed, 0x3a, 0x96, 0x73, 0x37, 0x43, 0x6e, 0x90, 0x43, 0xb4, 0x64, 0xd5,
	0x79, 0x00, 0xb5, 0x02, 0x58, 0x97, 0x21, 0xd1, 0x99, 0x59, 0x84, 0x59, 0x5d, 0x56, 0xee, 0xfc,
	0x54, 0x81, 0xd2, 0xc0, 0x5b, 0xeb, 0x76, 0x00, 0x5b, 0x5c, 0xeb, 0x18, 0x55, 0xe6, 0x98, 0x9d,
	0x48, 0x17, 0xaa, 0x7e, 0xc8, 0x51, 0x98, 0xd1, 0xd0, 0xce, 0xd4, 0x5a, 0xff, 0xee, 0x62, 0x7e,
	0x58, 0x1d, 0x64, 0x3a, 0x5a, 0xa0, 0xe4, 0x08, 0xea, 0x7e, 0xc8, 0x73, 0x20, 0x1d, 0x9d, 0xfd,
	0xc6, 0x62, 0x7e, 0x58, 0x1f, 0x9c, 0x8e, 0x0a, 0xfb, 0xb2, 0x4d, 0x92, 0x54, 0xfb, 0x32, 0xca,
	0x06, 0x68, 0x8d, 0x66, 0x27, 0x72, 0x01, 0x3b, 0x7c, 0xfc, 0x42, 0x4e, 0x50, 0x0c, 0xec, 0x32,
	0x71, 0xb7, 0x6c, 0x6f, 0xee, 0xaf, 0x99, 0xe6, 0xde, 0xa8, 0x6c, 0x68, 0xa9, 0xd9, 0xdf, 0x5f,
	0xcc, 0x0f, 0x77, 0x46, 0xc3, 0x92, 0x9e, 0xde, 0x8e, 0xd7, 0x9c, 0x01, 0x59, 0xf5, 0x5b, 0x43,
	0xe9, 0x27, 0xb7, 0x29, 0xfd, 0xd1, 0x6b, 0x29, 0x9d, 0x6e, 0x43, 0xaf, 0x58, 0xe4, 0xc9, 0x5a,
	0xf1, 0x6c, 0xfc, 0x12, 0x7d, 0x8f, 0xbf, 0x81, 0x46, 0xbe, 0x1d, 0x9e, 0xa3, 0x9a, 0x72, 0x1f,
	0xc9, 0x57, 0x50, 0x79, 0x84, 0x86, 0x1c, 0xac, 0xac, 0x0f, 0xbb, 0x32, 0x9b, 0xfb, 0x2b, 0xfa,
	0x8e, 0xfb, 0xe3, 0x9f, 0x7f, 0xff, 0xba, 0x41, 0xc8, 0x9e, 0xfd, 0x01, 0x98, 0x1e, 0x15, 0x2b,
	0xb8, 0xff, 0xc5, 0xef, 0x8b, 0x96, 0xf3, 0xc7, 0xa2, 0xe5, 0xfc, 0xb5, 0x68, 0x39, 0x5f, 0x1f,
	0xff, 0x87, 0x1f, 0x81, 0xf4, 0x01, 0x8b, 0x08, 0x97, 0x5b, 0x76, 0x73, 0x3f, 0xf8, 0x27, 0x00,
	0x00, 0xff, 0xff, 0x43, 0x8a, 0x12, 0xdf, 0xa2, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SettingsServiceClient is the client API for SettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SettingsServiceClient interface {
	// Get returns Argo CD settings
	Get(ctx context.Context, in *SettingsQuery, opts ...grpc.CallOption) (*Settings, error)
}

type settingsServiceClient struct {
	cc *grpc.ClientConn
}

func NewSettingsServiceClient(cc *grpc.ClientConn) SettingsServiceClient {
	return &settingsServiceClient{cc}
}

func (c *settingsServiceClient) Get(ctx context.Context, in *SettingsQuery, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/cluster.SettingsService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SettingsServiceServer is the server API for SettingsService service.
type SettingsServiceServer interface {
	// Get returns Argo CD settings
	Get(context.Context, *SettingsQuery) (*Settings, error)
}

// UnimplementedSettingsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSettingsServiceServer struct {
}

func (*UnimplementedSettingsServiceServer) Get(ctx context.Context, req *SettingsQuery) (*Settings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}

func RegisterSettingsServiceServer(s *grpc.Server, srv SettingsServiceServer) {
	s.RegisterService(&_SettingsService_serviceDesc, srv)
}

func _SettingsService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SettingsQuery)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SettingsServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cluster.SettingsService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SettingsServiceServer).Get(ctx, req.(*SettingsQuery))
	}
	return interceptor(ctx, in, info, handler)
}

var _SettingsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cluster.SettingsService",
	HandlerType: (*SettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _SettingsService_Get_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "server/settings/settings.proto",
}

func (m *SettingsQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SettingsQuery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SettingsQuery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *Settings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Settings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Settings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.UiBannerURL) > 0 {
		i -= len(m.UiBannerURL)
		copy(dAtA[i:], m.UiBannerURL)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.UiBannerURL)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if len(m.UiBannerContent) > 0 {
		i -= len(m.UiBannerContent)
		copy(dAtA[i:], m.UiBannerContent)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.UiBannerContent)))
		i--
		dAtA[i] = 0x7a
	}
	if len(m.UiCssURL) > 0 {
		i -= len(m.UiCssURL)
		copy(dAtA[i:], m.UiCssURL)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.UiCssURL)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.KustomizeVersions) > 0 {
		for iNdEx := len(m.KustomizeVersions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.KustomizeVersions[iNdEx])
			copy(dAtA[i:], m.KustomizeVersions[iNdEx])
			i = encodeVarintSettings(dAtA, i, uint64(len(m.KustomizeVersions[iNdEx])))
			i--
			dAtA[i] = 0x6a
		}
	}
	if len(m.ConfigManagementPlugins) > 0 {
		for iNdEx := len(m.ConfigManagementPlugins) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ConfigManagementPlugins[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSettings(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x62
		}
	}
	if m.UserLoginsDisabled {
		i--
		if m.UserLoginsDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.Plugins) > 0 {
		for iNdEx := len(m.Plugins) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Plugins[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSettings(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x52
		}
	}
	if m.Help != nil {
		{
			size, err := m.Help.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSettings(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.KustomizeOptions != nil {
		{
			size, err := m.KustomizeOptions.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSettings(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.GoogleAnalytics != nil {
		{
			size, err := m.GoogleAnalytics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSettings(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.StatusBadgeEnabled {
		i--
		if m.StatusBadgeEnabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.ResourceOverrides) > 0 {
		for k := range m.ResourceOverrides {
			v := m.ResourceOverrides[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintSettings(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintSettings(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintSettings(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.AppLabelKey) > 0 {
		i -= len(m.AppLabelKey)
		copy(dAtA[i:], m.AppLabelKey)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.AppLabelKey)))
		i--
		dAtA[i] = 0x22
	}
	if m.OIDCConfig != nil {
		{
			size, err := m.OIDCConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSettings(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.DexConfig != nil {
		{
			size, err := m.DexConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSettings(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.URL) > 0 {
		i -= len(m.URL)
		copy(dAtA[i:], m.URL)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.URL)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GoogleAnalyticsConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GoogleAnalyticsConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GoogleAnalyticsConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AnonymizeUsers {
		i--
		if m.AnonymizeUsers {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.TrackingID) > 0 {
		i -= len(m.TrackingID)
		copy(dAtA[i:], m.TrackingID)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.TrackingID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Help) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Help) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Help) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ChatText) > 0 {
		i -= len(m.ChatText)
		copy(dAtA[i:], m.ChatText)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.ChatText)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ChatUrl) > 0 {
		i -= len(m.ChatUrl)
		copy(dAtA[i:], m.ChatUrl)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.ChatUrl)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Plugin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Plugin) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Plugin) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DexConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DexConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DexConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Connectors) > 0 {
		for iNdEx := len(m.Connectors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Connectors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSettings(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Connector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connector) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Connector) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OIDCConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OIDCConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OIDCConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.IDTokenClaims) > 0 {
		for k := range m.IDTokenClaims {
			v := m.IDTokenClaims[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintSettings(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintSettings(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintSettings(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Scopes) > 0 {
		for iNdEx := len(m.Scopes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Scopes[iNdEx])
			copy(dAtA[i:], m.Scopes[iNdEx])
			i = encodeVarintSettings(dAtA, i, uint64(len(m.Scopes[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.CLIClientID) > 0 {
		i -= len(m.CLIClientID)
		copy(dAtA[i:], m.CLIClientID)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.CLIClientID)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClientID) > 0 {
		i -= len(m.ClientID)
		copy(dAtA[i:], m.ClientID)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.ClientID)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Issuer) > 0 {
		i -= len(m.Issuer)
		copy(dAtA[i:], m.Issuer)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.Issuer)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSettings(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintSettings(dAtA []byte, offset int, v uint64) int {
	offset -= sovSettings(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *SettingsQuery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Settings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.URL)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	if m.DexConfig != nil {
		l = m.DexConfig.Size()
		n += 1 + l + sovSettings(uint64(l))
	}
	if m.OIDCConfig != nil {
		l = m.OIDCConfig.Size()
		n += 1 + l + sovSettings(uint64(l))
	}
	l = len(m.AppLabelKey)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	if len(m.ResourceOverrides) > 0 {
		for k, v := range m.ResourceOverrides {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovSettings(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovSettings(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovSettings(uint64(mapEntrySize))
		}
	}
	if m.StatusBadgeEnabled {
		n += 2
	}
	if m.GoogleAnalytics != nil {
		l = m.GoogleAnalytics.Size()
		n += 1 + l + sovSettings(uint64(l))
	}
	if m.KustomizeOptions != nil {
		l = m.KustomizeOptions.Size()
		n += 1 + l + sovSettings(uint64(l))
	}
	if m.Help != nil {
		l = m.Help.Size()
		n += 1 + l + sovSettings(uint64(l))
	}
	if len(m.Plugins) > 0 {
		for _, e := range m.Plugins {
			l = e.Size()
			n += 1 + l + sovSettings(uint64(l))
		}
	}
	if m.UserLoginsDisabled {
		n += 2
	}
	if len(m.ConfigManagementPlugins) > 0 {
		for _, e := range m.ConfigManagementPlugins {
			l = e.Size()
			n += 1 + l + sovSettings(uint64(l))
		}
	}
	if len(m.KustomizeVersions) > 0 {
		for _, s := range m.KustomizeVersions {
			l = len(s)
			n += 1 + l + sovSettings(uint64(l))
		}
	}
	l = len(m.UiCssURL)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	l = len(m.UiBannerContent)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	l = len(m.UiBannerURL)
	if l > 0 {
		n += 2 + l + sovSettings(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GoogleAnalyticsConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TrackingID)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	if m.AnonymizeUsers {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Help) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ChatUrl)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	l = len(m.ChatText)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Plugin) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DexConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Connectors) > 0 {
		for _, e := range m.Connectors {
			l = e.Size()
			n += 1 + l + sovSettings(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Connector) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *OIDCConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	l = len(m.Issuer)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	l = len(m.ClientID)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	l = len(m.CLIClientID)
	if l > 0 {
		n += 1 + l + sovSettings(uint64(l))
	}
	if len(m.Scopes) > 0 {
		for _, s := range m.Scopes {
			l = len(s)
			n += 1 + l + sovSettings(uint64(l))
		}
	}
	if len(m.IDTokenClaims) > 0 {
		for k, v := range m.IDTokenClaims {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovSettings(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovSettings(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovSettings(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSettings(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSettings(x uint64) (n int) {
	return sovSettings(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *SettingsQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSettings
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SettingsQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SettingsQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipSettings(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Settings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSettings
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Settings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Settings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DexConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DexConfig == nil {
				m.DexConfig = &DexConfig{}
			}
			if err := m.DexConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OIDCConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OIDCConfig == nil {
				m.OIDCConfig = &OIDCConfig{}
			}
			if err := m.OIDCConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppLabelKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppLabelKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceOverrides", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResourceOverrides == nil {
				m.ResourceOverrides = make(map[string]*v1alpha1.ResourceOverride)
			}
			var mapkey string
			var mapvalue *v1alpha1.ResourceOverride
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSettings
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSettings
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthSettings
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthSettings
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSettings
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthSettings
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthSettings
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v1alpha1.ResourceOverride{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipSettings(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthSettings
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResourceOverrides[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusBadgeEnabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StatusBadgeEnabled = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GoogleAnalytics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GoogleAnalytics == nil {
				m.GoogleAnalytics = &GoogleAnalyticsConfig{}
			}
			if err := m.GoogleAnalytics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KustomizeOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KustomizeOptions == nil {
				m.KustomizeOptions = &v1alpha1.KustomizeOptions{}
			}
			if err := m.KustomizeOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Help", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Help == nil {
				m.Help = &Help{}
			}
			if err := m.Help.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Plugins", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Plugins = append(m.Plugins, &Plugin{})
			if err := m.Plugins[len(m.Plugins)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserLoginsDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UserLoginsDisabled = bool(v != 0)
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigManagementPlugins", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigManagementPlugins = append(m.ConfigManagementPlugins, &v1alpha1.ConfigManagementPlugin{})
			if err := m.ConfigManagementPlugins[len(m.ConfigManagementPlugins)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KustomizeVersions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KustomizeVersions = append(m.KustomizeVersions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UiCssURL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UiCssURL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UiBannerContent", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UiBannerContent = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UiBannerURL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UiBannerURL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSettings(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GoogleAnalyticsConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSettings
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GoogleAnalyticsConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GoogleAnalyticsConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrackingID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TrackingID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AnonymizeUsers", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AnonymizeUsers = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipSettings(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Help) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSettings
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Help: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Help: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChatUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ChatUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChatText", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ChatText = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSettings(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Plugin) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSettings
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Plugin: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Plugin: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSettings(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DexConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSettings
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DexConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DexConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connectors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Connectors = append(m.Connectors, &Connector{})
			if err := m.Connectors[len(m.Connectors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSettings(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSettings
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Connector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Connector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSettings(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OIDCConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSettings
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OIDCConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OIDCConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issuer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issuer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CLIClientID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CLIClientID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scopes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Scopes = append(m.Scopes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IDTokenClaims", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSettings
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSettings
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IDTokenClaims == nil {
				m.IDTokenClaims = make(map[string]*oidc.Claim)
			}
			var mapkey string
			var mapvalue *oidc.Claim
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSettings
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSettings
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthSettings
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthSettings
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSettings
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthSettings
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthSettings
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &oidc.Claim{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipSettings(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthSettings
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.IDTokenClaims[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSettings(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSettings
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSettings(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSettings
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSettings
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSettings
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupSettings
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthSettings
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthSettings        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSettings          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupSettings = fmt.Errorf("proto: unexpected end of group")
)
