// Code generated by entc, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/dexidp/dex/storage/ent/db/authrequest"
)

// AuthRequestCreate is the builder for creating a AuthRequest entity.
type AuthRequestCreate struct {
	config
	mutation *AuthRequestMutation
	hooks    []Hook
}

// SetClientID sets the "client_id" field.
func (arc *AuthRequestCreate) SetClientID(s string) *AuthRequestCreate {
	arc.mutation.SetClientID(s)
	return arc
}

// SetScopes sets the "scopes" field.
func (arc *AuthRequestCreate) SetScopes(s []string) *AuthRequestCreate {
	arc.mutation.SetScopes(s)
	return arc
}

// SetResponseTypes sets the "response_types" field.
func (arc *AuthRequestCreate) SetResponseTypes(s []string) *AuthRequestCreate {
	arc.mutation.SetResponseTypes(s)
	return arc
}

// SetRedirectURI sets the "redirect_uri" field.
func (arc *AuthRequestCreate) SetRedirectURI(s string) *AuthRequestCreate {
	arc.mutation.SetRedirectURI(s)
	return arc
}

// SetNonce sets the "nonce" field.
func (arc *AuthRequestCreate) SetNonce(s string) *AuthRequestCreate {
	arc.mutation.SetNonce(s)
	return arc
}

// SetState sets the "state" field.
func (arc *AuthRequestCreate) SetState(s string) *AuthRequestCreate {
	arc.mutation.SetState(s)
	return arc
}

// SetForceApprovalPrompt sets the "force_approval_prompt" field.
func (arc *AuthRequestCreate) SetForceApprovalPrompt(b bool) *AuthRequestCreate {
	arc.mutation.SetForceApprovalPrompt(b)
	return arc
}

// SetLoggedIn sets the "logged_in" field.
func (arc *AuthRequestCreate) SetLoggedIn(b bool) *AuthRequestCreate {
	arc.mutation.SetLoggedIn(b)
	return arc
}

// SetClaimsUserID sets the "claims_user_id" field.
func (arc *AuthRequestCreate) SetClaimsUserID(s string) *AuthRequestCreate {
	arc.mutation.SetClaimsUserID(s)
	return arc
}

// SetClaimsUsername sets the "claims_username" field.
func (arc *AuthRequestCreate) SetClaimsUsername(s string) *AuthRequestCreate {
	arc.mutation.SetClaimsUsername(s)
	return arc
}

// SetClaimsEmail sets the "claims_email" field.
func (arc *AuthRequestCreate) SetClaimsEmail(s string) *AuthRequestCreate {
	arc.mutation.SetClaimsEmail(s)
	return arc
}

// SetClaimsEmailVerified sets the "claims_email_verified" field.
func (arc *AuthRequestCreate) SetClaimsEmailVerified(b bool) *AuthRequestCreate {
	arc.mutation.SetClaimsEmailVerified(b)
	return arc
}

// SetClaimsGroups sets the "claims_groups" field.
func (arc *AuthRequestCreate) SetClaimsGroups(s []string) *AuthRequestCreate {
	arc.mutation.SetClaimsGroups(s)
	return arc
}

// SetClaimsPreferredUsername sets the "claims_preferred_username" field.
func (arc *AuthRequestCreate) SetClaimsPreferredUsername(s string) *AuthRequestCreate {
	arc.mutation.SetClaimsPreferredUsername(s)
	return arc
}

// SetNillableClaimsPreferredUsername sets the "claims_preferred_username" field if the given value is not nil.
func (arc *AuthRequestCreate) SetNillableClaimsPreferredUsername(s *string) *AuthRequestCreate {
	if s != nil {
		arc.SetClaimsPreferredUsername(*s)
	}
	return arc
}

// SetConnectorID sets the "connector_id" field.
func (arc *AuthRequestCreate) SetConnectorID(s string) *AuthRequestCreate {
	arc.mutation.SetConnectorID(s)
	return arc
}

// SetConnectorData sets the "connector_data" field.
func (arc *AuthRequestCreate) SetConnectorData(b []byte) *AuthRequestCreate {
	arc.mutation.SetConnectorData(b)
	return arc
}

// SetExpiry sets the "expiry" field.
func (arc *AuthRequestCreate) SetExpiry(t time.Time) *AuthRequestCreate {
	arc.mutation.SetExpiry(t)
	return arc
}

// SetCodeChallenge sets the "code_challenge" field.
func (arc *AuthRequestCreate) SetCodeChallenge(s string) *AuthRequestCreate {
	arc.mutation.SetCodeChallenge(s)
	return arc
}

// SetNillableCodeChallenge sets the "code_challenge" field if the given value is not nil.
func (arc *AuthRequestCreate) SetNillableCodeChallenge(s *string) *AuthRequestCreate {
	if s != nil {
		arc.SetCodeChallenge(*s)
	}
	return arc
}

// SetCodeChallengeMethod sets the "code_challenge_method" field.
func (arc *AuthRequestCreate) SetCodeChallengeMethod(s string) *AuthRequestCreate {
	arc.mutation.SetCodeChallengeMethod(s)
	return arc
}

// SetNillableCodeChallengeMethod sets the "code_challenge_method" field if the given value is not nil.
func (arc *AuthRequestCreate) SetNillableCodeChallengeMethod(s *string) *AuthRequestCreate {
	if s != nil {
		arc.SetCodeChallengeMethod(*s)
	}
	return arc
}

// SetID sets the "id" field.
func (arc *AuthRequestCreate) SetID(s string) *AuthRequestCreate {
	arc.mutation.SetID(s)
	return arc
}

// Mutation returns the AuthRequestMutation object of the builder.
func (arc *AuthRequestCreate) Mutation() *AuthRequestMutation {
	return arc.mutation
}

// Save creates the AuthRequest in the database.
func (arc *AuthRequestCreate) Save(ctx context.Context) (*AuthRequest, error) {
	var (
		err  error
		node *AuthRequest
	)
	arc.defaults()
	if len(arc.hooks) == 0 {
		if err = arc.check(); err != nil {
			return nil, err
		}
		node, err = arc.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*AuthRequestMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = arc.check(); err != nil {
				return nil, err
			}
			arc.mutation = mutation
			node, err = arc.sqlSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(arc.hooks) - 1; i >= 0; i-- {
			mut = arc.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, arc.mutation); err != nil {
			return nil, err
		}
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (arc *AuthRequestCreate) SaveX(ctx context.Context) *AuthRequest {
	v, err := arc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// defaults sets the default values of the builder before save.
func (arc *AuthRequestCreate) defaults() {
	if _, ok := arc.mutation.ClaimsPreferredUsername(); !ok {
		v := authrequest.DefaultClaimsPreferredUsername
		arc.mutation.SetClaimsPreferredUsername(v)
	}
	if _, ok := arc.mutation.CodeChallenge(); !ok {
		v := authrequest.DefaultCodeChallenge
		arc.mutation.SetCodeChallenge(v)
	}
	if _, ok := arc.mutation.CodeChallengeMethod(); !ok {
		v := authrequest.DefaultCodeChallengeMethod
		arc.mutation.SetCodeChallengeMethod(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (arc *AuthRequestCreate) check() error {
	if _, ok := arc.mutation.ClientID(); !ok {
		return &ValidationError{Name: "client_id", err: errors.New("db: missing required field \"client_id\"")}
	}
	if _, ok := arc.mutation.RedirectURI(); !ok {
		return &ValidationError{Name: "redirect_uri", err: errors.New("db: missing required field \"redirect_uri\"")}
	}
	if _, ok := arc.mutation.Nonce(); !ok {
		return &ValidationError{Name: "nonce", err: errors.New("db: missing required field \"nonce\"")}
	}
	if _, ok := arc.mutation.State(); !ok {
		return &ValidationError{Name: "state", err: errors.New("db: missing required field \"state\"")}
	}
	if _, ok := arc.mutation.ForceApprovalPrompt(); !ok {
		return &ValidationError{Name: "force_approval_prompt", err: errors.New("db: missing required field \"force_approval_prompt\"")}
	}
	if _, ok := arc.mutation.LoggedIn(); !ok {
		return &ValidationError{Name: "logged_in", err: errors.New("db: missing required field \"logged_in\"")}
	}
	if _, ok := arc.mutation.ClaimsUserID(); !ok {
		return &ValidationError{Name: "claims_user_id", err: errors.New("db: missing required field \"claims_user_id\"")}
	}
	if _, ok := arc.mutation.ClaimsUsername(); !ok {
		return &ValidationError{Name: "claims_username", err: errors.New("db: missing required field \"claims_username\"")}
	}
	if _, ok := arc.mutation.ClaimsEmail(); !ok {
		return &ValidationError{Name: "claims_email", err: errors.New("db: missing required field \"claims_email\"")}
	}
	if _, ok := arc.mutation.ClaimsEmailVerified(); !ok {
		return &ValidationError{Name: "claims_email_verified", err: errors.New("db: missing required field \"claims_email_verified\"")}
	}
	if _, ok := arc.mutation.ClaimsPreferredUsername(); !ok {
		return &ValidationError{Name: "claims_preferred_username", err: errors.New("db: missing required field \"claims_preferred_username\"")}
	}
	if _, ok := arc.mutation.ConnectorID(); !ok {
		return &ValidationError{Name: "connector_id", err: errors.New("db: missing required field \"connector_id\"")}
	}
	if _, ok := arc.mutation.Expiry(); !ok {
		return &ValidationError{Name: "expiry", err: errors.New("db: missing required field \"expiry\"")}
	}
	if _, ok := arc.mutation.CodeChallenge(); !ok {
		return &ValidationError{Name: "code_challenge", err: errors.New("db: missing required field \"code_challenge\"")}
	}
	if _, ok := arc.mutation.CodeChallengeMethod(); !ok {
		return &ValidationError{Name: "code_challenge_method", err: errors.New("db: missing required field \"code_challenge_method\"")}
	}
	if v, ok := arc.mutation.ID(); ok {
		if err := authrequest.IDValidator(v); err != nil {
			return &ValidationError{Name: "id", err: fmt.Errorf("db: validator failed for field \"id\": %w", err)}
		}
	}
	return nil
}

func (arc *AuthRequestCreate) sqlSave(ctx context.Context) (*AuthRequest, error) {
	_node, _spec := arc.createSpec()
	if err := sqlgraph.CreateNode(ctx, arc.driver, _spec); err != nil {
		if cerr, ok := isSQLConstraintError(err); ok {
			err = cerr
		}
		return nil, err
	}
	return _node, nil
}

func (arc *AuthRequestCreate) createSpec() (*AuthRequest, *sqlgraph.CreateSpec) {
	var (
		_node = &AuthRequest{config: arc.config}
		_spec = &sqlgraph.CreateSpec{
			Table: authrequest.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeString,
				Column: authrequest.FieldID,
			},
		}
	)
	if id, ok := arc.mutation.ID(); ok {
		_node.ID = id
		_spec.ID.Value = id
	}
	if value, ok := arc.mutation.ClientID(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldClientID,
		})
		_node.ClientID = value
	}
	if value, ok := arc.mutation.Scopes(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeJSON,
			Value:  value,
			Column: authrequest.FieldScopes,
		})
		_node.Scopes = value
	}
	if value, ok := arc.mutation.ResponseTypes(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeJSON,
			Value:  value,
			Column: authrequest.FieldResponseTypes,
		})
		_node.ResponseTypes = value
	}
	if value, ok := arc.mutation.RedirectURI(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldRedirectURI,
		})
		_node.RedirectURI = value
	}
	if value, ok := arc.mutation.Nonce(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldNonce,
		})
		_node.Nonce = value
	}
	if value, ok := arc.mutation.State(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldState,
		})
		_node.State = value
	}
	if value, ok := arc.mutation.ForceApprovalPrompt(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: authrequest.FieldForceApprovalPrompt,
		})
		_node.ForceApprovalPrompt = value
	}
	if value, ok := arc.mutation.LoggedIn(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: authrequest.FieldLoggedIn,
		})
		_node.LoggedIn = value
	}
	if value, ok := arc.mutation.ClaimsUserID(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldClaimsUserID,
		})
		_node.ClaimsUserID = value
	}
	if value, ok := arc.mutation.ClaimsUsername(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldClaimsUsername,
		})
		_node.ClaimsUsername = value
	}
	if value, ok := arc.mutation.ClaimsEmail(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldClaimsEmail,
		})
		_node.ClaimsEmail = value
	}
	if value, ok := arc.mutation.ClaimsEmailVerified(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeBool,
			Value:  value,
			Column: authrequest.FieldClaimsEmailVerified,
		})
		_node.ClaimsEmailVerified = value
	}
	if value, ok := arc.mutation.ClaimsGroups(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeJSON,
			Value:  value,
			Column: authrequest.FieldClaimsGroups,
		})
		_node.ClaimsGroups = value
	}
	if value, ok := arc.mutation.ClaimsPreferredUsername(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldClaimsPreferredUsername,
		})
		_node.ClaimsPreferredUsername = value
	}
	if value, ok := arc.mutation.ConnectorID(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldConnectorID,
		})
		_node.ConnectorID = value
	}
	if value, ok := arc.mutation.ConnectorData(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeBytes,
			Value:  value,
			Column: authrequest.FieldConnectorData,
		})
		_node.ConnectorData = &value
	}
	if value, ok := arc.mutation.Expiry(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: authrequest.FieldExpiry,
		})
		_node.Expiry = value
	}
	if value, ok := arc.mutation.CodeChallenge(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldCodeChallenge,
		})
		_node.CodeChallenge = value
	}
	if value, ok := arc.mutation.CodeChallengeMethod(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: authrequest.FieldCodeChallengeMethod,
		})
		_node.CodeChallengeMethod = value
	}
	return _node, _spec
}

// AuthRequestCreateBulk is the builder for creating many AuthRequest entities in bulk.
type AuthRequestCreateBulk struct {
	config
	builders []*AuthRequestCreate
}

// Save creates the AuthRequest entities in the database.
func (arcb *AuthRequestCreateBulk) Save(ctx context.Context) ([]*AuthRequest, error) {
	specs := make([]*sqlgraph.CreateSpec, len(arcb.builders))
	nodes := make([]*AuthRequest, len(arcb.builders))
	mutators := make([]Mutator, len(arcb.builders))
	for i := range arcb.builders {
		func(i int, root context.Context) {
			builder := arcb.builders[i]
			builder.defaults()
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*AuthRequestMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, arcb.builders[i+1].mutation)
				} else {
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, arcb.driver, &sqlgraph.BatchCreateSpec{Nodes: specs}); err != nil {
						if cerr, ok := isSQLConstraintError(err); ok {
							err = cerr
						}
					}
				}
				mutation.done = true
				if err != nil {
					return nil, err
				}
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, arcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (arcb *AuthRequestCreateBulk) SaveX(ctx context.Context) []*AuthRequest {
	v, err := arcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}
