// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"entgo.io/ent/entc/integration/privacy/ent/predicate"
	"entgo.io/ent/entc/integration/privacy/ent/task"
	"entgo.io/ent/entc/integration/privacy/ent/team"
	"entgo.io/ent/entc/integration/privacy/ent/user"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entql"
	"entgo.io/ent/schema/field"
)

// schemaGraph holds a representation of ent/schema at runtime.
var schemaGraph = func() *sqlgraph.Schema {
	graph := &sqlgraph.Schema{Nodes: make([]*sqlgraph.Node, 3)}
	graph.Nodes[0] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   task.Table,
			Columns: task.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: task.FieldID,
			},
		},
		Type: "Task",
		Fields: map[string]*sqlgraph.FieldSpec{
			task.FieldTitle:       {Type: field.TypeString, Column: task.FieldTitle},
			task.FieldDescription: {Type: field.TypeString, Column: task.FieldDescription},
			task.FieldStatus:      {Type: field.TypeEnum, Column: task.FieldStatus},
			task.FieldUUID:        {Type: field.TypeUUID, Column: task.FieldUUID},
		},
	}
	graph.Nodes[1] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   team.Table,
			Columns: team.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: team.FieldID,
			},
		},
		Type: "Team",
		Fields: map[string]*sqlgraph.FieldSpec{
			team.FieldName: {Type: field.TypeString, Column: team.FieldName},
		},
	}
	graph.Nodes[2] = &sqlgraph.Node{
		NodeSpec: sqlgraph.NodeSpec{
			Table:   user.Table,
			Columns: user.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: user.FieldID,
			},
		},
		Type: "User",
		Fields: map[string]*sqlgraph.FieldSpec{
			user.FieldName: {Type: field.TypeString, Column: user.FieldName},
			user.FieldAge:  {Type: field.TypeUint, Column: user.FieldAge},
		},
	}
	graph.MustAddE(
		"teams",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   task.TeamsTable,
			Columns: task.TeamsPrimaryKey,
			Bidi:    false,
		},
		"Task",
		"Team",
	)
	graph.MustAddE(
		"owner",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   task.OwnerTable,
			Columns: []string{task.OwnerColumn},
			Bidi:    false,
		},
		"Task",
		"User",
	)
	graph.MustAddE(
		"tasks",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   team.TasksTable,
			Columns: team.TasksPrimaryKey,
			Bidi:    false,
		},
		"Team",
		"Task",
	)
	graph.MustAddE(
		"users",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: true,
			Table:   team.UsersTable,
			Columns: team.UsersPrimaryKey,
			Bidi:    false,
		},
		"Team",
		"User",
	)
	graph.MustAddE(
		"teams",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2M,
			Inverse: false,
			Table:   user.TeamsTable,
			Columns: user.TeamsPrimaryKey,
			Bidi:    false,
		},
		"User",
		"Team",
	)
	graph.MustAddE(
		"tasks",
		&sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   user.TasksTable,
			Columns: []string{user.TasksColumn},
			Bidi:    false,
		},
		"User",
		"Task",
	)
	return graph
}()

// predicateAdder wraps the addPredicate method.
// All update, update-one and query builders implement this interface.
type predicateAdder interface {
	addPredicate(func(s *sql.Selector))
}

// addPredicate implements the predicateAdder interface.
func (tq *TaskQuery) addPredicate(pred func(s *sql.Selector)) {
	tq.predicates = append(tq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the TaskQuery builder.
func (tq *TaskQuery) Filter() *TaskFilter {
	return &TaskFilter{tq}
}

// addPredicate implements the predicateAdder interface.
func (m *TaskMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the TaskMutation builder.
func (m *TaskMutation) Filter() *TaskFilter {
	return &TaskFilter{m}
}

// TaskFilter provides a generic filtering capability at runtime for TaskQuery.
type TaskFilter struct {
	predicateAdder
}

// Where applies the entql predicate on the query filter.
func (f *TaskFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[0].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *TaskFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(task.FieldID))
}

// WhereTitle applies the entql string predicate on the title field.
func (f *TaskFilter) WhereTitle(p entql.StringP) {
	f.Where(p.Field(task.FieldTitle))
}

// WhereDescription applies the entql string predicate on the description field.
func (f *TaskFilter) WhereDescription(p entql.StringP) {
	f.Where(p.Field(task.FieldDescription))
}

// WhereStatus applies the entql string predicate on the status field.
func (f *TaskFilter) WhereStatus(p entql.StringP) {
	f.Where(p.Field(task.FieldStatus))
}

// WhereUUID applies the entql [16]byte predicate on the uuid field.
func (f *TaskFilter) WhereUUID(p entql.ValueP) {
	f.Where(p.Field(task.FieldUUID))
}

// WhereHasTeams applies a predicate to check if query has an edge teams.
func (f *TaskFilter) WhereHasTeams() {
	f.Where(entql.HasEdge("teams"))
}

// WhereHasTeamsWith applies a predicate to check if query has an edge teams with a given conditions (other predicates).
func (f *TaskFilter) WhereHasTeamsWith(preds ...predicate.Team) {
	f.Where(entql.HasEdgeWith("teams", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasOwner applies a predicate to check if query has an edge owner.
func (f *TaskFilter) WhereHasOwner() {
	f.Where(entql.HasEdge("owner"))
}

// WhereHasOwnerWith applies a predicate to check if query has an edge owner with a given conditions (other predicates).
func (f *TaskFilter) WhereHasOwnerWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("owner", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (tq *TeamQuery) addPredicate(pred func(s *sql.Selector)) {
	tq.predicates = append(tq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the TeamQuery builder.
func (tq *TeamQuery) Filter() *TeamFilter {
	return &TeamFilter{tq}
}

// addPredicate implements the predicateAdder interface.
func (m *TeamMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the TeamMutation builder.
func (m *TeamMutation) Filter() *TeamFilter {
	return &TeamFilter{m}
}

// TeamFilter provides a generic filtering capability at runtime for TeamQuery.
type TeamFilter struct {
	predicateAdder
}

// Where applies the entql predicate on the query filter.
func (f *TeamFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[1].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *TeamFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(team.FieldID))
}

// WhereName applies the entql string predicate on the name field.
func (f *TeamFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(team.FieldName))
}

// WhereHasTasks applies a predicate to check if query has an edge tasks.
func (f *TeamFilter) WhereHasTasks() {
	f.Where(entql.HasEdge("tasks"))
}

// WhereHasTasksWith applies a predicate to check if query has an edge tasks with a given conditions (other predicates).
func (f *TeamFilter) WhereHasTasksWith(preds ...predicate.Task) {
	f.Where(entql.HasEdgeWith("tasks", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasUsers applies a predicate to check if query has an edge users.
func (f *TeamFilter) WhereHasUsers() {
	f.Where(entql.HasEdge("users"))
}

// WhereHasUsersWith applies a predicate to check if query has an edge users with a given conditions (other predicates).
func (f *TeamFilter) WhereHasUsersWith(preds ...predicate.User) {
	f.Where(entql.HasEdgeWith("users", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// addPredicate implements the predicateAdder interface.
func (uq *UserQuery) addPredicate(pred func(s *sql.Selector)) {
	uq.predicates = append(uq.predicates, pred)
}

// Filter returns a Filter implementation to apply filters on the UserQuery builder.
func (uq *UserQuery) Filter() *UserFilter {
	return &UserFilter{uq}
}

// addPredicate implements the predicateAdder interface.
func (m *UserMutation) addPredicate(pred func(s *sql.Selector)) {
	m.predicates = append(m.predicates, pred)
}

// Filter returns an entql.Where implementation to apply filters on the UserMutation builder.
func (m *UserMutation) Filter() *UserFilter {
	return &UserFilter{m}
}

// UserFilter provides a generic filtering capability at runtime for UserQuery.
type UserFilter struct {
	predicateAdder
}

// Where applies the entql predicate on the query filter.
func (f *UserFilter) Where(p entql.P) {
	f.addPredicate(func(s *sql.Selector) {
		if err := schemaGraph.EvalP(schemaGraph.Nodes[2].Type, p, s); err != nil {
			s.AddError(err)
		}
	})
}

// WhereID applies the entql int predicate on the id field.
func (f *UserFilter) WhereID(p entql.IntP) {
	f.Where(p.Field(user.FieldID))
}

// WhereName applies the entql string predicate on the name field.
func (f *UserFilter) WhereName(p entql.StringP) {
	f.Where(p.Field(user.FieldName))
}

// WhereAge applies the entql uint predicate on the age field.
func (f *UserFilter) WhereAge(p entql.UintP) {
	f.Where(p.Field(user.FieldAge))
}

// WhereHasTeams applies a predicate to check if query has an edge teams.
func (f *UserFilter) WhereHasTeams() {
	f.Where(entql.HasEdge("teams"))
}

// WhereHasTeamsWith applies a predicate to check if query has an edge teams with a given conditions (other predicates).
func (f *UserFilter) WhereHasTeamsWith(preds ...predicate.Team) {
	f.Where(entql.HasEdgeWith("teams", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}

// WhereHasTasks applies a predicate to check if query has an edge tasks.
func (f *UserFilter) WhereHasTasks() {
	f.Where(entql.HasEdge("tasks"))
}

// WhereHasTasksWith applies a predicate to check if query has an edge tasks with a given conditions (other predicates).
func (f *UserFilter) WhereHasTasksWith(preds ...predicate.Task) {
	f.Where(entql.HasEdgeWith("tasks", sqlgraph.WrapFunc(func(s *sql.Selector) {
		for _, p := range preds {
			p(s)
		}
	})))
}
