// Code generated by entc, DO NOT EDIT.

package db

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/dexidp/dex/storage/ent/db/devicetoken"
)

// DeviceTokenCreate is the builder for creating a DeviceToken entity.
type DeviceTokenCreate struct {
	config
	mutation *DeviceTokenMutation
	hooks    []Hook
}

// SetDeviceCode sets the "device_code" field.
func (dtc *DeviceTokenCreate) SetDeviceCode(s string) *DeviceTokenCreate {
	dtc.mutation.SetDeviceCode(s)
	return dtc
}

// SetStatus sets the "status" field.
func (dtc *DeviceTokenCreate) SetStatus(s string) *DeviceTokenCreate {
	dtc.mutation.SetStatus(s)
	return dtc
}

// SetToken sets the "token" field.
func (dtc *DeviceTokenCreate) SetToken(b []byte) *DeviceTokenCreate {
	dtc.mutation.SetToken(b)
	return dtc
}

// SetExpiry sets the "expiry" field.
func (dtc *DeviceTokenCreate) SetExpiry(t time.Time) *DeviceTokenCreate {
	dtc.mutation.SetExpiry(t)
	return dtc
}

// SetLastRequest sets the "last_request" field.
func (dtc *DeviceTokenCreate) SetLastRequest(t time.Time) *DeviceTokenCreate {
	dtc.mutation.SetLastRequest(t)
	return dtc
}

// SetPollInterval sets the "poll_interval" field.
func (dtc *DeviceTokenCreate) SetPollInterval(i int) *DeviceTokenCreate {
	dtc.mutation.SetPollInterval(i)
	return dtc
}

// Mutation returns the DeviceTokenMutation object of the builder.
func (dtc *DeviceTokenCreate) Mutation() *DeviceTokenMutation {
	return dtc.mutation
}

// Save creates the DeviceToken in the database.
func (dtc *DeviceTokenCreate) Save(ctx context.Context) (*DeviceToken, error) {
	var (
		err  error
		node *DeviceToken
	)
	if len(dtc.hooks) == 0 {
		if err = dtc.check(); err != nil {
			return nil, err
		}
		node, err = dtc.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*DeviceTokenMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = dtc.check(); err != nil {
				return nil, err
			}
			dtc.mutation = mutation
			node, err = dtc.sqlSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(dtc.hooks) - 1; i >= 0; i-- {
			mut = dtc.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, dtc.mutation); err != nil {
			return nil, err
		}
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (dtc *DeviceTokenCreate) SaveX(ctx context.Context) *DeviceToken {
	v, err := dtc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// check runs all checks and user-defined validators on the builder.
func (dtc *DeviceTokenCreate) check() error {
	if _, ok := dtc.mutation.DeviceCode(); !ok {
		return &ValidationError{Name: "device_code", err: errors.New("db: missing required field \"device_code\"")}
	}
	if v, ok := dtc.mutation.DeviceCode(); ok {
		if err := devicetoken.DeviceCodeValidator(v); err != nil {
			return &ValidationError{Name: "device_code", err: fmt.Errorf("db: validator failed for field \"device_code\": %w", err)}
		}
	}
	if _, ok := dtc.mutation.Status(); !ok {
		return &ValidationError{Name: "status", err: errors.New("db: missing required field \"status\"")}
	}
	if v, ok := dtc.mutation.Status(); ok {
		if err := devicetoken.StatusValidator(v); err != nil {
			return &ValidationError{Name: "status", err: fmt.Errorf("db: validator failed for field \"status\": %w", err)}
		}
	}
	if _, ok := dtc.mutation.Expiry(); !ok {
		return &ValidationError{Name: "expiry", err: errors.New("db: missing required field \"expiry\"")}
	}
	if _, ok := dtc.mutation.LastRequest(); !ok {
		return &ValidationError{Name: "last_request", err: errors.New("db: missing required field \"last_request\"")}
	}
	if _, ok := dtc.mutation.PollInterval(); !ok {
		return &ValidationError{Name: "poll_interval", err: errors.New("db: missing required field \"poll_interval\"")}
	}
	return nil
}

func (dtc *DeviceTokenCreate) sqlSave(ctx context.Context) (*DeviceToken, error) {
	_node, _spec := dtc.createSpec()
	if err := sqlgraph.CreateNode(ctx, dtc.driver, _spec); err != nil {
		if cerr, ok := isSQLConstraintError(err); ok {
			err = cerr
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	return _node, nil
}

func (dtc *DeviceTokenCreate) createSpec() (*DeviceToken, *sqlgraph.CreateSpec) {
	var (
		_node = &DeviceToken{config: dtc.config}
		_spec = &sqlgraph.CreateSpec{
			Table: devicetoken.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: devicetoken.FieldID,
			},
		}
	)
	if value, ok := dtc.mutation.DeviceCode(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: devicetoken.FieldDeviceCode,
		})
		_node.DeviceCode = value
	}
	if value, ok := dtc.mutation.Status(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: devicetoken.FieldStatus,
		})
		_node.Status = value
	}
	if value, ok := dtc.mutation.Token(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeBytes,
			Value:  value,
			Column: devicetoken.FieldToken,
		})
		_node.Token = &value
	}
	if value, ok := dtc.mutation.Expiry(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: devicetoken.FieldExpiry,
		})
		_node.Expiry = value
	}
	if value, ok := dtc.mutation.LastRequest(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeTime,
			Value:  value,
			Column: devicetoken.FieldLastRequest,
		})
		_node.LastRequest = value
	}
	if value, ok := dtc.mutation.PollInterval(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeInt,
			Value:  value,
			Column: devicetoken.FieldPollInterval,
		})
		_node.PollInterval = value
	}
	return _node, _spec
}

// DeviceTokenCreateBulk is the builder for creating many DeviceToken entities in bulk.
type DeviceTokenCreateBulk struct {
	config
	builders []*DeviceTokenCreate
}

// Save creates the DeviceToken entities in the database.
func (dtcb *DeviceTokenCreateBulk) Save(ctx context.Context) ([]*DeviceToken, error) {
	specs := make([]*sqlgraph.CreateSpec, len(dtcb.builders))
	nodes := make([]*DeviceToken, len(dtcb.builders))
	mutators := make([]Mutator, len(dtcb.builders))
	for i := range dtcb.builders {
		func(i int, root context.Context) {
			builder := dtcb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*DeviceTokenMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, dtcb.builders[i+1].mutation)
				} else {
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, dtcb.driver, &sqlgraph.BatchCreateSpec{Nodes: specs}); err != nil {
						if cerr, ok := isSQLConstraintError(err); ok {
							err = cerr
						}
					}
				}
				mutation.done = true
				if err != nil {
					return nil, err
				}
				id := specs[i].ID.Value.(int64)
				nodes[i].ID = int(id)
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, dtcb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (dtcb *DeviceTokenCreateBulk) SaveX(ctx context.Context) []*DeviceToken {
	v, err := dtcb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}
