// Do not edit, this file was generated by github.com/apex/rpc.

package logs

import (
	"bytes"
	"encoding/json"
	"fmt"
	"io"
	"net/http"
	"time"
)

// Alert represents configuration for performing alerting.
type Alert struct {
	// ID is the alert id.
	ID string `json:"id"`

	// ProjectID is the associated project id.
	ProjectID string `json:"project_id"`

	// Name is the name of the alert.
	Name string `json:"name"`

	// Description is the description of the alert.
	Description string `json:"description"`

	// Severity is the severity of the alert.
	Severity string `json:"severity"`

	// Query is the query performed by the alert.
	Query string `json:"query"`

	// Operator is the query performed by the alert.
	Operator string `json:"operator"`

	// Threshold is the threshold for comparison against the selected operator.
	Threshold int `json:"threshold"`

	// Limit is the maximum number of events in the alert notification.
	Limit int `json:"limit"`

	// Interval is the interval in minutes for performing the alert.
	Interval int `json:"interval"`

	// NotificationID is the notification id for reporting alerts, when omitted the alert will not be run.
	NotificationID string `json:"notification_id"`

	// Triggered is a boolean indicating whether or not the alert is currently triggered.
	Triggered bool `json:"triggered"`

	// Muted is a boolean used ignore trigger and resolve notifications.
	Muted bool `json:"muted"`

	// UpdatedAt is a timestamp indicating when the alert was last updated.
	UpdatedAt time.Time `json:"updated_at"`

	// CreatedAt is a timestamp indicating when the alert was created.
	CreatedAt time.Time `json:"created_at"`
}

// BooleanFieldStat represents a boolean field's stats.
type BooleanFieldStat struct {
	// Value is the boolean value.
	Value bool `json:"value"`

	// Count is the number of times this field occurred in the sampled events.
	Count int `json:"count"`

	// Percent is the percentage of occurrences in the sampled events.
	Percent float64 `json:"percent"`
}

// DiscoveredField represents a single discovered field.
type DiscoveredField struct {
	// Name is the field name.
	Name string `json:"name"`

	// Type is the type of discovered field.
	Type string `json:"type"`

	// Count is the number of times this field occurred in the sampled events.
	Count int `json:"count"`

	// Percent is the percentage of occurrences in the sampled events.
	Percent float64 `json:"percent"`
}

// Event represents a single log event.
type Event struct {
	// ID is the event id.
	ID string `json:"id"`

	// Level is the severity level.
	Level string `json:"level"`

	// Message is the log message.
	Message string `json:"message"`

	// Fields is the log fields.
	Fields map[string]interface{} `json:"fields"`

	// Timestamp is the creation timestamp.
	Timestamp time.Time `json:"timestamp"`
}

// Notification represents an alert notification.
type Notification struct {
	// ID is the notification id.
	ID string `json:"id"`

	// ProjectID is the associated project id.
	ProjectID string `json:"project_id"`

	// Name is the name of the notification.
	Name string `json:"name"`

	// Type is the type of notification.
	Type string `json:"type"`

	// SlackWebhookURL is the Slack webhook URL.
	SlackWebhookURL string `json:"slack_webhook_url"`

	// SlackChannel is the Slack channel name, otherwise the default for the webhook is used.
	SlackChannel string `json:"slack_channel"`

	// WebhookURL is the webhook URL which receives the alert payloads.
	WebhookURL string `json:"webhook_url"`

	// SmsNumbers is the receipients of the alert notifications.
	SmsNumbers []string `json:"sms_numbers"`

	// EmailAddresses is the receipients of the alert notifications.
	EmailAddresses []string `json:"email_addresses"`

	// PagerdutyServiceKey is the PagerDuty service key.
	PagerdutyServiceKey string `json:"pagerduty_service_key"`

	// UpdatedAt is a timestamp indicating when the notification was last updated.
	UpdatedAt time.Time `json:"updated_at"`

	// CreatedAt is a timestamp indicating when the notification was created.
	CreatedAt time.Time `json:"created_at"`
}

// Project represents a customer application.
type Project struct {
	// ID is the project id.
	ID string `json:"id"`

	// Name is the human-friendly project name.
	Name string `json:"name"`

	// Retention is the retention of log events in days. When zero the logs do not expire.
	Retention int `json:"retention"`

	// Location is the geographical location where the log events are stored.
	Location string `json:"location"`

	// Description is the project description.
	Description string `json:"description"`

	// UpdatedAt is a timestamp indicating when the project was last updated.
	UpdatedAt time.Time `json:"updated_at"`

	// CreatedAt is a timestamp indicating when the project was created.
	CreatedAt time.Time `json:"created_at"`
}

// QueryStats represents query statistics.
type QueryStats struct {
	// TotalBytesProcessed is the total number of bytes processed by the query.
	TotalBytesProcessed int `json:"total_bytes_processed"`

	// TotalBytesBilled is the total number of bytes billed by the query.
	TotalBytesBilled int `json:"total_bytes_billed"`

	// CacheHit is a boolean indicating if the query was cached.
	CacheHit bool `json:"cache_hit"`
}

// Search represents a saved search query.
type Search struct {
	// ID is the saved search id.
	ID string `json:"id"`

	// Name is the name of the saved search.
	Name string `json:"name"`

	// ProjectID is the associated project id.
	ProjectID string `json:"project_id"`

	// Query is the saved search query.
	Query string `json:"query"`

	// UpdatedAt is a timestamp indicating when the saved search was last updated.
	UpdatedAt time.Time `json:"updated_at"`

	// CreatedAt is a timestamp indicating when the saved search was created.
	CreatedAt time.Time `json:"created_at"`
}

// StringFieldStat represents a string field's stats.
type StringFieldStat struct {
	// Value is the string value.
	Value string `json:"value"`

	// Count is the number of times this field occurred in the sampled events.
	Count int `json:"count"`

	// Percent is the percentage of occurrences in the sampled events.
	Percent float64 `json:"percent"`
}

// TimeseriesPoint represents a single point in a timeseries query.
type TimeseriesPoint struct {
	// Timestamp is the bucket timestamp.
	Timestamp time.Time `json:"timestamp"`

	// Count is the number of events for this bucket.
	Count int `json:"count"`
}

// Token represents an API token.
type Token struct {
	// ID is the token.
	ID string `json:"id"`

	// ProjectID is the associated project id.
	ProjectID string `json:"project_id"`

	// Description is the description of the token.
	Description string `json:"description"`

	// Scopes is available to this token, permitting access to read and write data.
	Scopes []string `json:"scopes"`

	// LastUsedAt is a timestamp indicating when the token was last used.
	LastUsedAt time.Time `json:"last_used_at"`

	// CreatedAt is a timestamp indicating when the token was created.
	CreatedAt time.Time `json:"created_at"`
}

// AddAlertInput params.
type AddAlertInput struct {
	// Alert is the alert.
	Alert Alert `json:"alert"`
}

// AddAlertOutput params.
type AddAlertOutput struct {
	// ID is the alert id.
	ID string `json:"id"`
}

// AddEventsInput params.
type AddEventsInput struct {
	// Events is the batch of events.
	Events []Event `json:"events"`

	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// AddNotificationInput params.
type AddNotificationInput struct {
	// Notification is the notification.
	Notification Notification `json:"notification"`
}

// AddNotificationOutput params.
type AddNotificationOutput struct {
	// ID is the notification id.
	ID string `json:"id"`
}

// AddProjectInput params.
type AddProjectInput struct {
	// Project is the project.
	Project Project `json:"project"`
}

// AddProjectOutput params.
type AddProjectOutput struct {
	// ID is the project id.
	ID string `json:"id"`
}

// AddSearchInput params.
type AddSearchInput struct {
	// Search is the saved search.
	Search Search `json:"search"`
}

// AddSearchOutput params.
type AddSearchOutput struct {
	// ID is the saved search id.
	ID string `json:"id"`
}

// AddTokenInput params.
type AddTokenInput struct {
	// Token is the token.
	Token Token `json:"token"`
}

// AddTokenOutput params.
type AddTokenOutput struct {
	// ID is the token id.
	ID string `json:"id"`
}

// GetAlertInput params.
type GetAlertInput struct {
	// AlertID is the alert id.
	AlertID string `json:"alert_id"`

	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// GetAlertOutput params.
type GetAlertOutput struct {
	// Alert is the alert.
	Alert Alert `json:"alert"`
}

// GetAlertsInput params.
type GetAlertsInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// GetAlertsOutput params.
type GetAlertsOutput struct {
	// Alerts is the alerts.
	Alerts []Alert `json:"alerts"`
}

// GetBooleanFieldStatsInput params.
type GetBooleanFieldStatsInput struct {
	// Field is the field name.
	Field string `json:"field"`

	// ProjectID is the project id.
	ProjectID string `json:"project_id"`

	// Query is the search query string.
	Query string `json:"query"`

	// Start is the start timestamp, events before this time are not included.
	Start time.Time `json:"start"`

	// Stop is the stop timestamp, events after this time are not included.
	Stop time.Time `json:"stop"`

	// Timeout is a request timeout in seconds, after which a timeout error is returned.
	Timeout int `json:"timeout"`
}

// GetBooleanFieldStatsOutput params.
type GetBooleanFieldStatsOutput struct {
	// Stats is the query statistics.
	Stats QueryStats `json:"stats"`

	// Values is the boolean values.
	Values []BooleanFieldStat `json:"values"`
}

// GetCountInput params.
type GetCountInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`

	// Query is the search query string.
	Query string `json:"query"`

	// Start is the start timestamp, events before this time are not included.
	Start time.Time `json:"start"`

	// Stop is the stop timestamp, events after this time are not included.
	Stop time.Time `json:"stop"`

	// Timeout is a request timeout in seconds, after which a timeout error is returned.
	Timeout int `json:"timeout"`
}

// GetCountOutput params.
type GetCountOutput struct {
	// Count is the query result count.
	Count int `json:"count"`

	// Stats is the query statistics.
	Stats QueryStats `json:"stats"`
}

// GetDiscoveredFieldsInput params.
type GetDiscoveredFieldsInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`

	// Query is the search query string.
	Query string `json:"query"`

	// Start is the start timestamp, events before this time are not included.
	Start time.Time `json:"start"`

	// Stop is the stop timestamp, events after this time are not included.
	Stop time.Time `json:"stop"`

	// Timeout is a request timeout in seconds, after which a timeout error is returned.
	Timeout int `json:"timeout"`
}

// GetDiscoveredFieldsOutput params.
type GetDiscoveredFieldsOutput struct {
	// Fields is the fields discovered.
	Fields []DiscoveredField `json:"fields"`

	// Stats is the query statistics.
	Stats QueryStats `json:"stats"`
}

// GetNotificationInput params.
type GetNotificationInput struct {
	// NotificationID is the notification id.
	NotificationID string `json:"notification_id"`

	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// GetNotificationOutput params.
type GetNotificationOutput struct {
	// Notification is the notification.
	Notification Notification `json:"notification"`
}

// GetNotificationsInput params.
type GetNotificationsInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// GetNotificationsOutput params.
type GetNotificationsOutput struct {
	// Notifications is the notifications.
	Notifications []Notification `json:"notifications"`
}

// GetNumericFieldStatsInput params.
type GetNumericFieldStatsInput struct {
	// Field is the field name.
	Field string `json:"field"`

	// ProjectID is the project id.
	ProjectID string `json:"project_id"`

	// Query is the search query string.
	Query string `json:"query"`

	// Start is the start timestamp, events before this time are not included.
	Start time.Time `json:"start"`

	// Stop is the stop timestamp, events after this time are not included.
	Stop time.Time `json:"stop"`

	// Timeout is a request timeout in seconds, after which a timeout error is returned.
	Timeout int `json:"timeout"`
}

// GetNumericFieldStatsOutput params.
type GetNumericFieldStatsOutput struct {
	// Avg is the avg value.
	Avg float64 `json:"avg"`

	// Max is The max value.
	Max float64 `json:"max"`

	// Min is the min value.
	Min float64 `json:"min"`

	// Stats is the query statistics.
	Stats QueryStats `json:"stats"`
}

// GetProjectStatsInput params.
type GetProjectStatsInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// GetProjectStatsOutput params.
type GetProjectStatsOutput struct {
	// BytesTotal is the total number of bytes stored.
	BytesTotal int `json:"bytes_total"`

	// EventsTotal is the total number of events stored.
	EventsTotal int `json:"events_total"`
}

// GetProjectsOutput params.
type GetProjectsOutput struct {
	// Projects is the projects.
	Projects []Project `json:"projects"`
}

// GetSearchesInput params.
type GetSearchesInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// GetSearchesOutput params.
type GetSearchesOutput struct {
	// Searches is the saved searches.
	Searches []Search `json:"searches"`
}

// GetStringFieldStatsInput params.
type GetStringFieldStatsInput struct {
	// Field is the field name.
	Field string `json:"field"`

	// Limit is the maximum number of values to return.
	Limit int `json:"limit"`

	// ProjectID is the project id.
	ProjectID string `json:"project_id"`

	// Query is the search query string.
	Query string `json:"query"`

	// Start is the start timestamp, events before this time are not included.
	Start time.Time `json:"start"`

	// Stop is the stop timestamp, events after this time are not included.
	Stop time.Time `json:"stop"`

	// Timeout is a request timeout in seconds, after which a timeout error is returned.
	Timeout int `json:"timeout"`
}

// GetStringFieldStatsOutput params.
type GetStringFieldStatsOutput struct {
	// Stats is the query statistics.
	Stats QueryStats `json:"stats"`

	// Values is the string values.
	Values []StringFieldStat `json:"values"`
}

// GetTimeseriesInput params.
type GetTimeseriesInput struct {
	// MaxPoints is the maxmimum number of datapoints to return.
	MaxPoints int `json:"max_points"`

	// ProjectID is the project id.
	ProjectID string `json:"project_id"`

	// Query is the search query string.
	Query string `json:"query"`

	// Start is the start timestamp, events before this time are not included.
	Start time.Time `json:"start"`

	// Stop is the stop timestamp, events after this time are not included.
	Stop time.Time `json:"stop"`

	// Timeout is a request timeout in seconds, after which a timeout error is returned.
	Timeout int `json:"timeout"`
}

// GetTimeseriesOutput params.
type GetTimeseriesOutput struct {
	// Points is the series.
	Points []TimeseriesPoint `json:"points"`

	// Stats is the query statistics.
	Stats QueryStats `json:"stats"`
}

// GetTokensInput params.
type GetTokensInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// GetTokensOutput params.
type GetTokensOutput struct {
	// Tokens is the tokens.
	Tokens []Token `json:"tokens"`
}

// QueryInput params.
type QueryInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`

	// Query is the SQL query string.
	Query string `json:"query"`

	// Timeout is a request timeout in seconds, after which a timeout error is returned.
	Timeout int `json:"timeout"`
}

// QueryOutput params.
type QueryOutput struct {
	// Results is the query results.
	Results []map[string]interface{} `json:"results"`

	// Stats is the query statistics.
	Stats QueryStats `json:"stats"`
}

// RemoveAlertInput params.
type RemoveAlertInput struct {
	// AlertID is the alert id.
	AlertID string `json:"alert_id"`

	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// RemoveNotificationInput params.
type RemoveNotificationInput struct {
	// NotificationID is the notification id.
	NotificationID string `json:"notification_id"`

	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// RemoveProjectInput params.
type RemoveProjectInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`
}

// RemoveSearchInput params.
type RemoveSearchInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`

	// SearchID is the saved search id.
	SearchID string `json:"search_id"`
}

// RemoveTokenInput params.
type RemoveTokenInput struct {
	// ProjectID is the project id.
	ProjectID string `json:"project_id"`

	// TokenID is the token id.
	TokenID string `json:"token_id"`
}

// SearchInput params.
type SearchInput struct {
	// Limit is the maxmimum number of events to return.
	Limit int `json:"limit"`

	// ProjectID is the project id.
	ProjectID string `json:"project_id"`

	// Query is the search query string.
	Query string `json:"query"`

	// Start is the start timestamp, events before this time are not included.
	Start time.Time `json:"start"`

	// Stop is the stop timestamp, events after this time are not included.
	Stop time.Time `json:"stop"`

	// Timeout is a request timeout in seconds, after which a timeout error is returned.
	Timeout int `json:"timeout"`
}

// SearchOutput params.
type SearchOutput struct {
	// Results is the query results.
	Results []map[string]interface{} `json:"results"`

	// Stats is the query statistics.
	Stats QueryStats `json:"stats"`
}

// TestAlertInput params.
type TestAlertInput struct {
	// Alert is the alert.
	Alert Alert `json:"alert"`
}

// UpdateAlertInput params.
type UpdateAlertInput struct {
	// Alert is the alert.
	Alert Alert `json:"alert"`
}

// UpdateNotificationInput params.
type UpdateNotificationInput struct {
	// Notification is the notification.
	Notification Notification `json:"notification"`
}

// UpdateProjectInput params.
type UpdateProjectInput struct {
	// Project is the project.
	Project Project `json:"project"`
}

// UpdateSearchInput params.
type UpdateSearchInput struct {
	// Search is the saved search.
	Search Search `json:"search"`
}

// Client is the API client.
type Client struct {
	// URL is the required API endpoint address.
	URL string

	// HTTPClient is the client used for making requests, defaulting to http.DefaultClient.
	HTTPClient *http.Client
}

// AddAlert creates a new alert.
func (c *Client) AddAlert(in AddAlertInput) (*AddAlertOutput, error) {
	var out AddAlertOutput
	return &out, call(c.HTTPClient, c.URL, "add_alert", in, &out)
}

// AddEvents ingests a batch of events.
func (c *Client) AddEvents(in AddEventsInput) error {
	return call(c.HTTPClient, c.URL, "add_events", in, nil)
}

// AddNotification creates a new notification.
func (c *Client) AddNotification(in AddNotificationInput) (*AddNotificationOutput, error) {
	var out AddNotificationOutput
	return &out, call(c.HTTPClient, c.URL, "add_notification", in, &out)
}

// AddProject creates a new project.
func (c *Client) AddProject(in AddProjectInput) (*AddProjectOutput, error) {
	var out AddProjectOutput
	return &out, call(c.HTTPClient, c.URL, "add_project", in, &out)
}

// AddSearch creates a new saved search.
func (c *Client) AddSearch(in AddSearchInput) (*AddSearchOutput, error) {
	var out AddSearchOutput
	return &out, call(c.HTTPClient, c.URL, "add_search", in, &out)
}

// AddToken creates a new token.
func (c *Client) AddToken(in AddTokenInput) (*AddTokenOutput, error) {
	var out AddTokenOutput
	return &out, call(c.HTTPClient, c.URL, "add_token", in, &out)
}

// GetAlert returns an alert.
func (c *Client) GetAlert(in GetAlertInput) (*GetAlertOutput, error) {
	var out GetAlertOutput
	return &out, call(c.HTTPClient, c.URL, "get_alert", in, &out)
}

// GetAlerts returns all alerts in a project.
func (c *Client) GetAlerts(in GetAlertsInput) (*GetAlertsOutput, error) {
	var out GetAlertsOutput
	return &out, call(c.HTTPClient, c.URL, "get_alerts", in, &out)
}

// GetBooleanFieldStats returns field statistics for a boolean field.
func (c *Client) GetBooleanFieldStats(in GetBooleanFieldStatsInput) (*GetBooleanFieldStatsOutput, error) {
	var out GetBooleanFieldStatsOutput
	return &out, call(c.HTTPClient, c.URL, "get_boolean_field_stats", in, &out)
}

// GetCount performs a search query against the log events, returning the number of matches.
func (c *Client) GetCount(in GetCountInput) (*GetCountOutput, error) {
	var out GetCountOutput
	return &out, call(c.HTTPClient, c.URL, "get_count", in, &out)
}

// GetDiscoveredFields returns fields discovered in the provided time range.
func (c *Client) GetDiscoveredFields(in GetDiscoveredFieldsInput) (*GetDiscoveredFieldsOutput, error) {
	var out GetDiscoveredFieldsOutput
	return &out, call(c.HTTPClient, c.URL, "get_discovered_fields", in, &out)
}

// GetNotification returns a notification.
func (c *Client) GetNotification(in GetNotificationInput) (*GetNotificationOutput, error) {
	var out GetNotificationOutput
	return &out, call(c.HTTPClient, c.URL, "get_notification", in, &out)
}

// GetNotifications returns all notifications.
func (c *Client) GetNotifications(in GetNotificationsInput) (*GetNotificationsOutput, error) {
	var out GetNotificationsOutput
	return &out, call(c.HTTPClient, c.URL, "get_notifications", in, &out)
}

// GetNumericFieldStats returns field statistics for a numeric field.
func (c *Client) GetNumericFieldStats(in GetNumericFieldStatsInput) (*GetNumericFieldStatsOutput, error) {
	var out GetNumericFieldStatsOutput
	return &out, call(c.HTTPClient, c.URL, "get_numeric_field_stats", in, &out)
}

// GetProjectStats returns project statistics.
func (c *Client) GetProjectStats(in GetProjectStatsInput) (*GetProjectStatsOutput, error) {
	var out GetProjectStatsOutput
	return &out, call(c.HTTPClient, c.URL, "get_project_stats", in, &out)
}

// GetProjects returns all projects.
func (c *Client) GetProjects() (*GetProjectsOutput, error) {
	var out GetProjectsOutput
	return &out, call(c.HTTPClient, c.URL, "get_projects", nil, &out)
}

// GetSearches returns all saved searches in a project.
func (c *Client) GetSearches(in GetSearchesInput) (*GetSearchesOutput, error) {
	var out GetSearchesOutput
	return &out, call(c.HTTPClient, c.URL, "get_searches", in, &out)
}

// GetStringFieldStats returns field statistics for a string field.
func (c *Client) GetStringFieldStats(in GetStringFieldStatsInput) (*GetStringFieldStatsOutput, error) {
	var out GetStringFieldStatsOutput
	return &out, call(c.HTTPClient, c.URL, "get_string_field_stats", in, &out)
}

// GetTimeseries returns a timeseries of event counts in the provided time range.
func (c *Client) GetTimeseries(in GetTimeseriesInput) (*GetTimeseriesOutput, error) {
	var out GetTimeseriesOutput
	return &out, call(c.HTTPClient, c.URL, "get_timeseries", in, &out)
}

// GetTokens returns all tokens in a project.
func (c *Client) GetTokens(in GetTokensInput) (*GetTokensOutput, error) {
	var out GetTokensOutput
	return &out, call(c.HTTPClient, c.URL, "get_tokens", in, &out)
}

// Query performs a SQL query against the log events.
func (c *Client) Query(in QueryInput) (*QueryOutput, error) {
	var out QueryOutput
	return &out, call(c.HTTPClient, c.URL, "query", in, &out)
}

// RemoveAlert removes an alert.
func (c *Client) RemoveAlert(in RemoveAlertInput) error {
	return call(c.HTTPClient, c.URL, "remove_alert", in, nil)
}

// RemoveNotification removes a notification.
func (c *Client) RemoveNotification(in RemoveNotificationInput) error {
	return call(c.HTTPClient, c.URL, "remove_notification", in, nil)
}

// RemoveProject removes a project.
func (c *Client) RemoveProject(in RemoveProjectInput) error {
	return call(c.HTTPClient, c.URL, "remove_project", in, nil)
}

// RemoveSearch removes a saved search.
func (c *Client) RemoveSearch(in RemoveSearchInput) error {
	return call(c.HTTPClient, c.URL, "remove_search", in, nil)
}

// RemoveToken removes a token.
func (c *Client) RemoveToken(in RemoveTokenInput) error {
	return call(c.HTTPClient, c.URL, "remove_token", in, nil)
}

// Search performs a search query against the log events.
func (c *Client) Search(in SearchInput) (*SearchOutput, error) {
	var out SearchOutput
	return &out, call(c.HTTPClient, c.URL, "search", in, &out)
}

// TestAlert test the alert configuration.
func (c *Client) TestAlert(in TestAlertInput) error {
	return call(c.HTTPClient, c.URL, "test_alert", in, nil)
}

// UpdateAlert updates an alert.
func (c *Client) UpdateAlert(in UpdateAlertInput) error {
	return call(c.HTTPClient, c.URL, "update_alert", in, nil)
}

// UpdateNotification updates a notification.
func (c *Client) UpdateNotification(in UpdateNotificationInput) error {
	return call(c.HTTPClient, c.URL, "update_notification", in, nil)
}

// UpdateProject updates a project.
func (c *Client) UpdateProject(in UpdateProjectInput) error {
	return call(c.HTTPClient, c.URL, "update_project", in, nil)
}

// UpdateSearch updates a saved search.
func (c *Client) UpdateSearch(in UpdateSearchInput) error {
	return call(c.HTTPClient, c.URL, "update_search", in, nil)
}

// Error is an error returned by the client.
type Error struct {
	Status     string
	StatusCode int
	Type       string
	Message    string
}

// Error implementation.
func (e Error) Error() string {
	if e.Type == "" {
		return fmt.Sprintf("%s: %d", e.Status, e.StatusCode)
	}
	return fmt.Sprintf("%s: %s", e.Type, e.Message)
}

// call implementation.
func call(client *http.Client, endpoint, method string, in, out interface{}) error {
	var body io.Reader

	// default client
	if client == nil {
		client = http.DefaultClient
	}

	// input params
	if in != nil {
		var buf bytes.Buffer
		err := json.NewEncoder(&buf).Encode(in)
		if err != nil {
			return fmt.Errorf("encoding: %w", err)
		}
		body = &buf
	}

	// POST request
	req, err := http.NewRequest("POST", endpoint+"/"+method, body)
	if err != nil {
		return err
	}
	req.Header.Set("Content-Type", "application/json")

	// response
	res, err := client.Do(req)
	if err != nil {
		return err
	}
	defer res.Body.Close()

	// error
	if res.StatusCode >= 300 {
		var e Error
		if res.Header.Get("Content-Type") == "application/json" {
			if err := json.NewDecoder(res.Body).Decode(&e); err != nil {
				return err
			}
		}
		e.Status = http.StatusText(res.StatusCode)
		e.StatusCode = res.StatusCode
		return e
	}

	// output params
	if out != nil {
		err = json.NewDecoder(res.Body).Decode(out)
		if err != nil {
			return err
		}
	}

	return nil
}
