/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: config.proto

package config

import (
	fmt "fmt"
	custom_evaluator "github.com/GoogleCloudPlatform/testgrid/pb/custom_evaluator"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type TestGroup_TestsName int32

const (
	TestGroup_TESTS_NAME_UNSPECIFIED TestGroup_TestsName = 0
	TestGroup_TESTS_NAME_IGNORE      TestGroup_TestsName = 1
	TestGroup_TESTS_NAME_REPLACE     TestGroup_TestsName = 2
	TestGroup_TESTS_NAME_APPEND      TestGroup_TestsName = 3
)

var TestGroup_TestsName_name = map[int32]string{
	0: "TESTS_NAME_UNSPECIFIED",
	1: "TESTS_NAME_IGNORE",
	2: "TESTS_NAME_REPLACE",
	3: "TESTS_NAME_APPEND",
}

var TestGroup_TestsName_value = map[string]int32{
	"TESTS_NAME_UNSPECIFIED": 0,
	"TESTS_NAME_IGNORE":      1,
	"TESTS_NAME_REPLACE":     2,
	"TESTS_NAME_APPEND":      3,
}

func (x TestGroup_TestsName) String() string {
	return proto.EnumName(TestGroup_TestsName_name, int32(x))
}

func (TestGroup_TestsName) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 0}
}

type TestGroup_FallbackGrouping int32

const (
	TestGroup_FALLBACK_GROUPING_NONE       TestGroup_FallbackGrouping = 0
	TestGroup_FALLBACK_GROUPING_DATE       TestGroup_FallbackGrouping = 1
	TestGroup_FALLBACK_GROUPING_LABELS     TestGroup_FallbackGrouping = 2
	TestGroup_FALLBACK_GROUPING_ID         TestGroup_FallbackGrouping = 3
	TestGroup_FALLBACK_GROUPING_COMMIT_NUM TestGroup_FallbackGrouping = 4
	// When using this, ensure fallback_grouping_configuration_value is
	// also set.
	TestGroup_FALLBACK_GROUPING_CONFIGURATION_VALUE TestGroup_FallbackGrouping = 5
)

var TestGroup_FallbackGrouping_name = map[int32]string{
	0: "FALLBACK_GROUPING_NONE",
	1: "FALLBACK_GROUPING_DATE",
	2: "FALLBACK_GROUPING_LABELS",
	3: "FALLBACK_GROUPING_ID",
	4: "FALLBACK_GROUPING_COMMIT_NUM",
	5: "FALLBACK_GROUPING_CONFIGURATION_VALUE",
}

var TestGroup_FallbackGrouping_value = map[string]int32{
	"FALLBACK_GROUPING_NONE":                0,
	"FALLBACK_GROUPING_DATE":                1,
	"FALLBACK_GROUPING_LABELS":              2,
	"FALLBACK_GROUPING_ID":                  3,
	"FALLBACK_GROUPING_COMMIT_NUM":          4,
	"FALLBACK_GROUPING_CONFIGURATION_VALUE": 5,
}

func (x TestGroup_FallbackGrouping) String() string {
	return proto.EnumName(TestGroup_FallbackGrouping_name, int32(x))
}

func (TestGroup_FallbackGrouping) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 1}
}

type TestGroup_ColumnSortBy int32

const (
	TestGroup_COLUMN_SORT_DATE       TestGroup_ColumnSortBy = 0
	TestGroup_COLUMN_SORT_COMMIT_NUM TestGroup_ColumnSortBy = 1
)

var TestGroup_ColumnSortBy_name = map[int32]string{
	0: "COLUMN_SORT_DATE",
	1: "COLUMN_SORT_COMMIT_NUM",
}

var TestGroup_ColumnSortBy_value = map[string]int32{
	"COLUMN_SORT_DATE":       0,
	"COLUMN_SORT_COMMIT_NUM": 1,
}

func (x TestGroup_ColumnSortBy) String() string {
	return proto.EnumName(TestGroup_ColumnSortBy_name, int32(x))
}

func (TestGroup_ColumnSortBy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 2}
}

type TestGroup_PrimaryGrouping int32

const (
	TestGroup_PRIMARY_GROUPING_NONE       TestGroup_PrimaryGrouping = 0
	TestGroup_PRIMARY_GROUPING_COMMIT_NUM TestGroup_PrimaryGrouping = 1
)

var TestGroup_PrimaryGrouping_name = map[int32]string{
	0: "PRIMARY_GROUPING_NONE",
	1: "PRIMARY_GROUPING_COMMIT_NUM",
}

var TestGroup_PrimaryGrouping_value = map[string]int32{
	"PRIMARY_GROUPING_NONE":       0,
	"PRIMARY_GROUPING_COMMIT_NUM": 1,
}

func (x TestGroup_PrimaryGrouping) String() string {
	return proto.EnumName(TestGroup_PrimaryGrouping_name, int32(x))
}

func (TestGroup_PrimaryGrouping) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 3}
}

type TestGroup_Environment int32

const (
	TestGroup_PROD TestGroup_Environment = 0
	TestGroup_QA   TestGroup_Environment = 1
)

var TestGroup_Environment_name = map[int32]string{
	0: "PROD",
	1: "QA",
}

var TestGroup_Environment_value = map[string]int32{
	"PROD": 0,
	"QA":   1,
}

func (x TestGroup_Environment) String() string {
	return proto.EnumName(TestGroup_Environment_name, int32(x))
}

func (TestGroup_Environment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 4}
}

// Scale of issue priority, used to indicate importance of issue.
type AutoBugOptions_Priority int32

const (
	// Unspecified; may not set priority at all
	AutoBugOptions_PRIORITY_UNSPECIFIED AutoBugOptions_Priority = 0
	// See https://developers.google.com/issue-tracker/concepts/issues
	AutoBugOptions_P0 AutoBugOptions_Priority = 1
	AutoBugOptions_P1 AutoBugOptions_Priority = 2
	AutoBugOptions_P2 AutoBugOptions_Priority = 3
	AutoBugOptions_P3 AutoBugOptions_Priority = 4
	AutoBugOptions_P4 AutoBugOptions_Priority = 5
)

var AutoBugOptions_Priority_name = map[int32]string{
	0: "PRIORITY_UNSPECIFIED",
	1: "P0",
	2: "P1",
	3: "P2",
	4: "P3",
	5: "P4",
}

var AutoBugOptions_Priority_value = map[string]int32{
	"PRIORITY_UNSPECIFIED": 0,
	"P0":                   1,
	"P1":                   2,
	"P2":                   3,
	"P3":                   4,
	"P4":                   5,
}

func (x AutoBugOptions_Priority) String() string {
	return proto.EnumName(AutoBugOptions_Priority_name, int32(x))
}

func (AutoBugOptions_Priority) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{5, 0}
}

// Specifies the test name, and its source
type TestNameConfig struct {
	// The name elements specifying the target test name for this tab.
	NameElements []*TestNameConfig_NameElement `protobuf:"bytes,1,rep,name=name_elements,json=nameElements,proto3" json:"name_elements,omitempty"`
	// Specifies a printf-style format string for name elements. The format
	// string should have as many conversions as there are name_elements.
	// For example, two name_elements could be used with name_format="%s: %s".
	NameFormat           string   `protobuf:"bytes,2,opt,name=name_format,json=nameFormat,proto3" json:"name_format,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestNameConfig) Reset()         { *m = TestNameConfig{} }
func (m *TestNameConfig) String() string { return proto.CompactTextString(m) }
func (*TestNameConfig) ProtoMessage()    {}
func (*TestNameConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{0}
}

func (m *TestNameConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestNameConfig.Unmarshal(m, b)
}
func (m *TestNameConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestNameConfig.Marshal(b, m, deterministic)
}
func (m *TestNameConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestNameConfig.Merge(m, src)
}
func (m *TestNameConfig) XXX_Size() int {
	return xxx_messageInfo_TestNameConfig.Size(m)
}
func (m *TestNameConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TestNameConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TestNameConfig proto.InternalMessageInfo

func (m *TestNameConfig) GetNameElements() []*TestNameConfig_NameElement {
	if m != nil {
		return m.NameElements
	}
	return nil
}

func (m *TestNameConfig) GetNameFormat() string {
	if m != nil {
		return m.NameFormat
	}
	return ""
}

// Specifies name elements to be selected from configuration values
type TestNameConfig_NameElement struct {
	// A space-delimited string of labels
	Labels string `protobuf:"bytes,1,opt,name=labels,proto3" json:"labels,omitempty"`
	// Configuration value to use.
	// Valid choice are:
	// 'Tests name': The name of a test case
	// 'Commit': The commit number of the build
	// 'Context', 'Thread': The info extracted from each junit files:
	//    - junit_core-os_01.xml -> Context: core-os, Thread: 01
	//    - junit_runner.xml -> Context: runner
	//    - junit_01.xml -> Thread: 01
	// or any metadata key from finished.json, which is copied from your test suite.
	//
	// A valid sample TestNameConfig looks like:
	// test_name_config:
	//   name_elements:
	//   - target_config: Tests name
	//   - target_config: Context
	//   name_format: '%s [%s]'
	TargetConfig string `protobuf:"bytes,2,opt,name=target_config,json=targetConfig,proto3" json:"target_config,omitempty"`
	// Whether to use the build-target name
	BuildTarget bool `protobuf:"varint,3,opt,name=build_target,json=buildTarget,proto3" json:"build_target,omitempty"`
	// A space-delimited string of Bazel build tags.
	Tags string `protobuf:"bytes,4,opt,name=tags,proto3" json:"tags,omitempty"`
	// The key of a test result's property.
	TestProperty         string   `protobuf:"bytes,5,opt,name=test_property,json=testProperty,proto3" json:"test_property,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestNameConfig_NameElement) Reset()         { *m = TestNameConfig_NameElement{} }
func (m *TestNameConfig_NameElement) String() string { return proto.CompactTextString(m) }
func (*TestNameConfig_NameElement) ProtoMessage()    {}
func (*TestNameConfig_NameElement) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{0, 0}
}

func (m *TestNameConfig_NameElement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestNameConfig_NameElement.Unmarshal(m, b)
}
func (m *TestNameConfig_NameElement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestNameConfig_NameElement.Marshal(b, m, deterministic)
}
func (m *TestNameConfig_NameElement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestNameConfig_NameElement.Merge(m, src)
}
func (m *TestNameConfig_NameElement) XXX_Size() int {
	return xxx_messageInfo_TestNameConfig_NameElement.Size(m)
}
func (m *TestNameConfig_NameElement) XXX_DiscardUnknown() {
	xxx_messageInfo_TestNameConfig_NameElement.DiscardUnknown(m)
}

var xxx_messageInfo_TestNameConfig_NameElement proto.InternalMessageInfo

func (m *TestNameConfig_NameElement) GetLabels() string {
	if m != nil {
		return m.Labels
	}
	return ""
}

func (m *TestNameConfig_NameElement) GetTargetConfig() string {
	if m != nil {
		return m.TargetConfig
	}
	return ""
}

func (m *TestNameConfig_NameElement) GetBuildTarget() bool {
	if m != nil {
		return m.BuildTarget
	}
	return false
}

func (m *TestNameConfig_NameElement) GetTags() string {
	if m != nil {
		return m.Tags
	}
	return ""
}

func (m *TestNameConfig_NameElement) GetTestProperty() string {
	if m != nil {
		return m.TestProperty
	}
	return ""
}

// A single notification.
type Notification struct {
	// Required: Text summary of the issue or notice.
	Summary string `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary,omitempty"`
	// Optional: Link to further information, such as a bug, email, document, etc.
	ContextLink          string   `protobuf:"bytes,2,opt,name=context_link,json=contextLink,proto3" json:"context_link,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Notification) Reset()         { *m = Notification{} }
func (m *Notification) String() string { return proto.CompactTextString(m) }
func (*Notification) ProtoMessage()    {}
func (*Notification) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{1}
}

func (m *Notification) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Notification.Unmarshal(m, b)
}
func (m *Notification) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Notification.Marshal(b, m, deterministic)
}
func (m *Notification) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Notification.Merge(m, src)
}
func (m *Notification) XXX_Size() int {
	return xxx_messageInfo_Notification.Size(m)
}
func (m *Notification) XXX_DiscardUnknown() {
	xxx_messageInfo_Notification.DiscardUnknown(m)
}

var xxx_messageInfo_Notification proto.InternalMessageInfo

func (m *Notification) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *Notification) GetContextLink() string {
	if m != nil {
		return m.ContextLink
	}
	return ""
}

// Specifies a group of tests to gather.
type TestGroup struct {
	// Name of this TestGroup, for mapping dashboard tabs to tests.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Path to the test result stored in gcs (gs://some/path)
	GcsPrefix string `protobuf:"bytes,2,opt,name=gcs_prefix,json=gcsPrefix,proto3" json:"gcs_prefix,omitempty"`
	// Number of days of test results to gather and serve.
	DaysOfResults int32 `protobuf:"varint,3,opt,name=days_of_results,json=daysOfResults,proto3" json:"days_of_results,omitempty"`
	// Whether to ignore pending (currently running) test results.
	IgnorePending bool `protobuf:"varint,4,opt,name=ignore_pending,json=ignorePending,proto3" json:"ignore_pending,omitempty"`
	// Whether to ignore reported build results. It is recommended that tests
	// report BUILD_FAIL instead of relying on this being disabled.
	IgnoreBuilt bool `protobuf:"varint,5,opt,name=ignore_built,json=ignoreBuilt,proto3" json:"ignore_built,omitempty"`
	// What to do with the 'Tests name' configuration value. It can replace the
	// name of the test, be appended to the name of the test, or ignored. If it is
	// ignored, then the name of the tests will be the build target.
	TestsNamePolicy TestGroup_TestsName `protobuf:"varint,6,opt,name=tests_name_policy,json=testsNamePolicy,proto3,enum=TestGroup_TestsName" json:"tests_name_policy,omitempty"`
	// Whether to infer the test properties from the test results.
	// Deprecated; recommended as "true"
	GatherTestProperties bool `protobuf:"varint,7,opt,name=gather_test_properties,json=gatherTestProperties,proto3" json:"gather_test_properties,omitempty"` // Deprecated: Do not use.
	// Tests with names that include these substrings will be removed from the
	// table.
	IgnoreTestSubstring []string                  `protobuf:"bytes,8,rep,name=ignore_test_substring,json=ignoreTestSubstring,proto3" json:"ignore_test_substring,omitempty"`
	ColumnHeader        []*TestGroup_ColumnHeader `protobuf:"bytes,9,rep,name=column_header,json=columnHeader,proto3" json:"column_header,omitempty"`
	// A test grouping option used if not specified by primary_grouping (#29)
	FallbackGrouping TestGroup_FallbackGrouping `protobuf:"varint,10,opt,name=fallback_grouping,json=fallbackGrouping,proto3,enum=TestGroup_FallbackGrouping" json:"fallback_grouping,omitempty"`
	// Time in hours before an alert will be added to a test results table if the
	// run date of the latest results are older than this time.  If zero, no
	// alerts are raised.
	AlertStaleResultsHours int32 `protobuf:"varint,11,opt,name=alert_stale_results_hours,json=alertStaleResultsHours,proto3" json:"alert_stale_results_hours,omitempty"`
	// The number of consecutive test result failures to see before alerting of
	// a consistent failure. If zero, no alerts are raised.
	NumFailuresToAlert int32 `protobuf:"varint,12,opt,name=num_failures_to_alert,json=numFailuresToAlert,proto3" json:"num_failures_to_alert,omitempty"`
	// Whether to automatically file bugs, and what component to file them to.
	// Requires further implementation of additional components.
	BugComponent int32 `protobuf:"varint,13,opt,name=bug_component,json=bugComponent,proto3" json:"bug_component,omitempty"`
	// Default code search path for searching regressions. Overridden by
	// code_search_path in DashboardTab.
	CodeSearchPath string `protobuf:"bytes,14,opt,name=code_search_path,json=codeSearchPath,proto3" json:"code_search_path,omitempty"`
	// The number of columns to consider "recent" for a variety of purposes.
	NumColumnsRecent int32 `protobuf:"varint,15,opt,name=num_columns_recent,json=numColumnsRecent,proto3" json:"num_columns_recent,omitempty"`
	// Whether to read test metadata from the test results. Information
	// from the test metadata is used to determine where bugs are filed in
	// specific cases.
	UseTestMetadata bool `protobuf:"varint,16,opt,name=use_test_metadata,json=useTestMetadata,proto3" json:"use_test_metadata,omitempty"`
	// The comma-separated addresses to send mail.
	// Note that this can also be configured for particular Dashboard Tabs also
	AlertMailToAddresses string `protobuf:"bytes,17,opt,name=alert_mail_to_addresses,json=alertMailToAddresses,proto3" json:"alert_mail_to_addresses,omitempty"`
	// Subject line of an alert mail.
	AlertMailSubject string `protobuf:"bytes,18,opt,name=alert_mail_subject,json=alertMailSubject,proto3" json:"alert_mail_subject,omitempty"`
	// Failure message in alert mail.
	AlertMailFailureMessage string `protobuf:"bytes,19,opt,name=alert_mail_failure_message,json=alertMailFailureMessage,proto3" json:"alert_mail_failure_message,omitempty"`
	// An url which will help in debugging failure. This will be hyperlinked on
	// failure message.
	AlertMailDebugUrl string `protobuf:"bytes,20,opt,name=alert_mail_debug_url,json=alertMailDebugUrl,proto3" json:"alert_mail_debug_url,omitempty"`
	// Minimum time between sending mails.
	MinElapsedMinutesBetweenMails int32 `protobuf:"varint,21,opt,name=min_elapsed_minutes_between_mails,json=minElapsedMinutesBetweenMails,proto3" json:"min_elapsed_minutes_between_mails,omitempty"`
	// Whether to read configuration values from invocation and use that
	// to send email alerts. If this is true, values for
	// alert_mail_to_addresses, alert_mail_failure_message and
	// alert_mail_debug_url will be gathered from invocation properties and will
	// get precedence.
	UseConfigurationValuesAsAlertParams bool `protobuf:"varint,22,opt,name=use_configuration_values_as_alert_params,json=useConfigurationValuesAsAlertParams,proto3" json:"use_configuration_values_as_alert_params,omitempty"`
	// Whether to treat a combination of passes and failures within one test as a
	// flaky status.
	EnableFlakyStatus bool `protobuf:"varint,23,opt,name=enable_flaky_status,json=enableFlakyStatus,proto3" json:"enable_flaky_status,omitempty"`
	// deprecated - always set to true
	UseKubernetesClient bool `protobuf:"varint,24,opt,name=use_kubernetes_client,json=useKubernetesClient,proto3" json:"use_kubernetes_client,omitempty"`
	// deprecated - always set to true
	IsExternal bool `protobuf:"varint,25,opt,name=is_external,json=isExternal,proto3" json:"is_external,omitempty"`
	// Specifies the test name for a test.
	TestNameConfig *TestNameConfig `protobuf:"bytes,26,opt,name=test_name_config,json=testNameConfig,proto3" json:"test_name_config,omitempty"`
	// A list of notifications attached to this test group.
	// This is displayed on any dashboard tab backed by this test group.
	Notifications []*Notification `protobuf:"bytes,27,rep,name=notifications,proto3" json:"notifications,omitempty"`
	// Specifies how to sort a test group's columns. The default is to sort by
	// date, from most recent to oldest.
	ColumnSortBy TestGroup_ColumnSortBy `protobuf:"varint,28,opt,name=column_sort_by,json=columnSortBy,proto3,enum=TestGroup_ColumnSortBy" json:"column_sort_by,omitempty"`
	// A primary grouping strategy for grouping test results in columns.
	// If a primary grouping is specified, the fallback grouping is ignored.
	PrimaryGrouping TestGroup_PrimaryGrouping `protobuf:"varint,29,opt,name=primary_grouping,json=primaryGrouping,proto3,enum=TestGroup_PrimaryGrouping" json:"primary_grouping,omitempty"`
	// Whether to collect pass-fail data for test methods. Additional test cases
	// will be added for each test method in a target.
	EnableTestMethods bool `protobuf:"varint,30,opt,name=enable_test_methods,json=enableTestMethods,proto3" json:"enable_test_methods,omitempty"`
	// Test annotations to look for. Adds custom short text overlays to results.
	TestAnnotations []*TestGroup_TestAnnotation `protobuf:"bytes,31,rep,name=test_annotations,json=testAnnotations,proto3" json:"test_annotations,omitempty"`
	// Maximum number of individual test methods to collect for any given test row.
	// If a test has more than this many methods, no methods will be displayed.
	MaxTestMethodsPerTest int32 `protobuf:"varint,32,opt,name=max_test_methods_per_test,json=maxTestMethodsPerTest,proto3" json:"max_test_methods_per_test,omitempty"`
	// A regex to select a label that takes the place of the commit number.
	// This is useful for cases where there is no commit or where the
	// commit is not the primary identifier.
	// The regex should have a capturing group; the captured content becomes the value.
	CommitOverrideLabelPattern string `protobuf:"bytes,33,opt,name=commit_override_label_pattern,json=commitOverrideLabelPattern,proto3" json:"commit_override_label_pattern,omitempty"`
	// Default metadata that should be applied for opening bugs, if a given regex
	// matches against a test's name.
	// Requires 'use_test_metadata = true'.
	TestMetadataOptions []*TestMetadataOptions `protobuf:"bytes,34,rep,name=test_metadata_options,json=testMetadataOptions,proto3" json:"test_metadata_options,omitempty"`
	// A space-delimited string of tags that are used to filter test targets.
	// A leading - before the tag means this tag should not be present
	// in the target.
	// Example:
	//  contains tag1, but not tag2: test_tag_pattern = 'tag1 -tag2'
	TestTagPattern string `protobuf:"bytes,35,opt,name=test_tag_pattern,json=testTagPattern,proto3" json:"test_tag_pattern,omitempty"`
	// Options for auto-filed bugs, if enabled.
	AutoBugOptions *AutoBugOptions `protobuf:"bytes,36,opt,name=auto_bug_options,json=autoBugOptions,proto3" json:"auto_bug_options,omitempty"`
	// Max number of days any single test can take.
	MaxTestRuntimeHours int32 `protobuf:"varint,37,opt,name=max_test_runtime_hours,json=maxTestRuntimeHours,proto3" json:"max_test_runtime_hours,omitempty"`
	// The number of consecutive test passes to close the alert.
	NumPassesToDisableAlert int32 `protobuf:"varint,38,opt,name=num_passes_to_disable_alert,json=numPassesToDisableAlert,proto3" json:"num_passes_to_disable_alert,omitempty"`
	// If true, also associate bugs with tests if the test result's overview/group
	// ID is in the bug.
	LinkBugsByGroup bool `protobuf:"varint,39,opt,name=link_bugs_by_group,json=linkBugsByGroup,proto3" json:"link_bugs_by_group,omitempty"`
	// Test instance to query for this test group. Optionally used by updater.
	EnvironmentInstance TestGroup_Environment `protobuf:"varint,40,opt,name=environment_instance,json=environmentInstance,proto3,enum=TestGroup_Environment" json:"environment_instance,omitempty"`
	// Only show test methods with all required properties
	TestMethodProperties []*TestGroup_KeyValue `protobuf:"bytes,41,rep,name=test_method_properties,json=testMethodProperties,proto3" json:"test_method_properties,omitempty"`
	// If true, allows gathering and associating bugs with targets in the dashboard.
	// Required in order to auto-file bugs.
	GatherBugs bool `protobuf:"varint,42,opt,name=gather_bugs,json=gatherBugs,proto3" json:"gather_bugs,omitempty"`
	// Numeric property metric value to be used for short text. If this property
	// is present, it will override all the other short text values.
	ShortTextMetric string `protobuf:"bytes,43,opt,name=short_text_metric,json=shortTextMetric,proto3" json:"short_text_metric,omitempty"`
	// A test configuration value that takes the place of the commit number.
	// This is useful for cases where there is no commit or where the
	// commit is not the primary identifier.
	CommitOverrideConfigurationValue string `protobuf:"bytes,44,opt,name=commit_override_configuration_value,json=commitOverrideConfigurationValue,proto3" json:"commit_override_configuration_value,omitempty"`
	// If true, only associate bugs with test methods if that test method is
	// mentioned in the bug. If false, bugs will be associated with all test
	// methods.
	LinkBugsByTestMethods bool `protobuf:"varint,45,opt,name=link_bugs_by_test_methods,json=linkBugsByTestMethods,proto3" json:"link_bugs_by_test_methods,omitempty"`
	// Regex to match test methods. Only tests methods with names that match
	// this regex will be included in the table.
	TestMethodMatchRegex string `protobuf:"bytes,46,opt,name=test_method_match_regex,json=testMethodMatchRegex,proto3" json:"test_method_match_regex,omitempty"`
	// If true, test method names are printed with the full class names.
	UseFullMethodNames bool `protobuf:"varint,47,opt,name=use_full_method_names,json=useFullMethodNames,proto3" json:"use_full_method_names,omitempty"`
	// The string list of full path evaluator rules in the format:
	// <config_directory>.<rule_set_file>.<RuleSetClassName>.<rule_name>
	//
	// Deprecated feature
	CustomResultEvaluatorRules []string `protobuf:"bytes,48,rep,name=custom_result_evaluator_rules,json=customResultEvaluatorRules,proto3" json:"custom_result_evaluator_rules,omitempty"` // Deprecated: Do not use.
	// A configuration value that is used as a fallback grouping.
	// This is useful for cases where there are builds that shared the same
	// commit but are run at separate times of day.
	FallbackGroupingConfigurationValue string `protobuf:"bytes,49,opt,name=fallback_grouping_configuration_value,json=fallbackGroupingConfigurationValue,proto3" json:"fallback_grouping_configuration_value,omitempty"`
	// Configuration type of the result source.
	ResultSource *TestGroup_ResultSource `protobuf:"bytes,50,opt,name=result_source,json=resultSource,proto3" json:"result_source,omitempty"`
	// Set of rules that are evaluated with each test result. If an evaluation is
	// successful, the status of that test result will be whatever is specified
	// for a given rule. For more information, look at RuleSet documention
	CustomEvaluatorRuleSet *custom_evaluator.RuleSet `protobuf:"bytes,51,opt,name=custom_evaluator_rule_set,json=customEvaluatorRuleSet,proto3" json:"custom_evaluator_rule_set,omitempty"`
	// If true, instead of updating the group, read the state proto from storage
	// and update summary, alerts, etc. from that state.
	// This only applies to test group state, not bug state for a test group.
	// This assumes that the state proto is updated through other means (another
	// updater, manually, etc).
	ReadStateFromStorage bool `protobuf:"varint,52,opt,name=read_state_from_storage,json=readStateFromStorage,proto3" json:"read_state_from_storage,omitempty"`
	// If true, only add the most recent result for a test when multiple results
	// for a test with the same name are encountered.
	IgnoreOldResults bool `protobuf:"varint,53,opt,name=ignore_old_results,json=ignoreOldResults,proto3" json:"ignore_old_results,omitempty"`
	// If True, ignore the 'pass with skips' status (show as a blank cell).
	IgnoreSkip           bool     `protobuf:"varint,54,opt,name=ignore_skip,json=ignoreSkip,proto3" json:"ignore_skip,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestGroup) Reset()         { *m = TestGroup{} }
func (m *TestGroup) String() string { return proto.CompactTextString(m) }
func (*TestGroup) ProtoMessage()    {}
func (*TestGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2}
}

func (m *TestGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup.Unmarshal(m, b)
}
func (m *TestGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup.Marshal(b, m, deterministic)
}
func (m *TestGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup.Merge(m, src)
}
func (m *TestGroup) XXX_Size() int {
	return xxx_messageInfo_TestGroup.Size(m)
}
func (m *TestGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup proto.InternalMessageInfo

func (m *TestGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TestGroup) GetGcsPrefix() string {
	if m != nil {
		return m.GcsPrefix
	}
	return ""
}

func (m *TestGroup) GetDaysOfResults() int32 {
	if m != nil {
		return m.DaysOfResults
	}
	return 0
}

func (m *TestGroup) GetIgnorePending() bool {
	if m != nil {
		return m.IgnorePending
	}
	return false
}

func (m *TestGroup) GetIgnoreBuilt() bool {
	if m != nil {
		return m.IgnoreBuilt
	}
	return false
}

func (m *TestGroup) GetTestsNamePolicy() TestGroup_TestsName {
	if m != nil {
		return m.TestsNamePolicy
	}
	return TestGroup_TESTS_NAME_UNSPECIFIED
}

// Deprecated: Do not use.
func (m *TestGroup) GetGatherTestProperties() bool {
	if m != nil {
		return m.GatherTestProperties
	}
	return false
}

func (m *TestGroup) GetIgnoreTestSubstring() []string {
	if m != nil {
		return m.IgnoreTestSubstring
	}
	return nil
}

func (m *TestGroup) GetColumnHeader() []*TestGroup_ColumnHeader {
	if m != nil {
		return m.ColumnHeader
	}
	return nil
}

func (m *TestGroup) GetFallbackGrouping() TestGroup_FallbackGrouping {
	if m != nil {
		return m.FallbackGrouping
	}
	return TestGroup_FALLBACK_GROUPING_NONE
}

func (m *TestGroup) GetAlertStaleResultsHours() int32 {
	if m != nil {
		return m.AlertStaleResultsHours
	}
	return 0
}

func (m *TestGroup) GetNumFailuresToAlert() int32 {
	if m != nil {
		return m.NumFailuresToAlert
	}
	return 0
}

func (m *TestGroup) GetBugComponent() int32 {
	if m != nil {
		return m.BugComponent
	}
	return 0
}

func (m *TestGroup) GetCodeSearchPath() string {
	if m != nil {
		return m.CodeSearchPath
	}
	return ""
}

func (m *TestGroup) GetNumColumnsRecent() int32 {
	if m != nil {
		return m.NumColumnsRecent
	}
	return 0
}

func (m *TestGroup) GetUseTestMetadata() bool {
	if m != nil {
		return m.UseTestMetadata
	}
	return false
}

func (m *TestGroup) GetAlertMailToAddresses() string {
	if m != nil {
		return m.AlertMailToAddresses
	}
	return ""
}

func (m *TestGroup) GetAlertMailSubject() string {
	if m != nil {
		return m.AlertMailSubject
	}
	return ""
}

func (m *TestGroup) GetAlertMailFailureMessage() string {
	if m != nil {
		return m.AlertMailFailureMessage
	}
	return ""
}

func (m *TestGroup) GetAlertMailDebugUrl() string {
	if m != nil {
		return m.AlertMailDebugUrl
	}
	return ""
}

func (m *TestGroup) GetMinElapsedMinutesBetweenMails() int32 {
	if m != nil {
		return m.MinElapsedMinutesBetweenMails
	}
	return 0
}

func (m *TestGroup) GetUseConfigurationValuesAsAlertParams() bool {
	if m != nil {
		return m.UseConfigurationValuesAsAlertParams
	}
	return false
}

func (m *TestGroup) GetEnableFlakyStatus() bool {
	if m != nil {
		return m.EnableFlakyStatus
	}
	return false
}

func (m *TestGroup) GetUseKubernetesClient() bool {
	if m != nil {
		return m.UseKubernetesClient
	}
	return false
}

func (m *TestGroup) GetIsExternal() bool {
	if m != nil {
		return m.IsExternal
	}
	return false
}

func (m *TestGroup) GetTestNameConfig() *TestNameConfig {
	if m != nil {
		return m.TestNameConfig
	}
	return nil
}

func (m *TestGroup) GetNotifications() []*Notification {
	if m != nil {
		return m.Notifications
	}
	return nil
}

func (m *TestGroup) GetColumnSortBy() TestGroup_ColumnSortBy {
	if m != nil {
		return m.ColumnSortBy
	}
	return TestGroup_COLUMN_SORT_DATE
}

func (m *TestGroup) GetPrimaryGrouping() TestGroup_PrimaryGrouping {
	if m != nil {
		return m.PrimaryGrouping
	}
	return TestGroup_PRIMARY_GROUPING_NONE
}

func (m *TestGroup) GetEnableTestMethods() bool {
	if m != nil {
		return m.EnableTestMethods
	}
	return false
}

func (m *TestGroup) GetTestAnnotations() []*TestGroup_TestAnnotation {
	if m != nil {
		return m.TestAnnotations
	}
	return nil
}

func (m *TestGroup) GetMaxTestMethodsPerTest() int32 {
	if m != nil {
		return m.MaxTestMethodsPerTest
	}
	return 0
}

func (m *TestGroup) GetCommitOverrideLabelPattern() string {
	if m != nil {
		return m.CommitOverrideLabelPattern
	}
	return ""
}

func (m *TestGroup) GetTestMetadataOptions() []*TestMetadataOptions {
	if m != nil {
		return m.TestMetadataOptions
	}
	return nil
}

func (m *TestGroup) GetTestTagPattern() string {
	if m != nil {
		return m.TestTagPattern
	}
	return ""
}

func (m *TestGroup) GetAutoBugOptions() *AutoBugOptions {
	if m != nil {
		return m.AutoBugOptions
	}
	return nil
}

func (m *TestGroup) GetMaxTestRuntimeHours() int32 {
	if m != nil {
		return m.MaxTestRuntimeHours
	}
	return 0
}

func (m *TestGroup) GetNumPassesToDisableAlert() int32 {
	if m != nil {
		return m.NumPassesToDisableAlert
	}
	return 0
}

func (m *TestGroup) GetLinkBugsByGroup() bool {
	if m != nil {
		return m.LinkBugsByGroup
	}
	return false
}

func (m *TestGroup) GetEnvironmentInstance() TestGroup_Environment {
	if m != nil {
		return m.EnvironmentInstance
	}
	return TestGroup_PROD
}

func (m *TestGroup) GetTestMethodProperties() []*TestGroup_KeyValue {
	if m != nil {
		return m.TestMethodProperties
	}
	return nil
}

func (m *TestGroup) GetGatherBugs() bool {
	if m != nil {
		return m.GatherBugs
	}
	return false
}

func (m *TestGroup) GetShortTextMetric() string {
	if m != nil {
		return m.ShortTextMetric
	}
	return ""
}

func (m *TestGroup) GetCommitOverrideConfigurationValue() string {
	if m != nil {
		return m.CommitOverrideConfigurationValue
	}
	return ""
}

func (m *TestGroup) GetLinkBugsByTestMethods() bool {
	if m != nil {
		return m.LinkBugsByTestMethods
	}
	return false
}

func (m *TestGroup) GetTestMethodMatchRegex() string {
	if m != nil {
		return m.TestMethodMatchRegex
	}
	return ""
}

func (m *TestGroup) GetUseFullMethodNames() bool {
	if m != nil {
		return m.UseFullMethodNames
	}
	return false
}

// Deprecated: Do not use.
func (m *TestGroup) GetCustomResultEvaluatorRules() []string {
	if m != nil {
		return m.CustomResultEvaluatorRules
	}
	return nil
}

func (m *TestGroup) GetFallbackGroupingConfigurationValue() string {
	if m != nil {
		return m.FallbackGroupingConfigurationValue
	}
	return ""
}

func (m *TestGroup) GetResultSource() *TestGroup_ResultSource {
	if m != nil {
		return m.ResultSource
	}
	return nil
}

func (m *TestGroup) GetCustomEvaluatorRuleSet() *custom_evaluator.RuleSet {
	if m != nil {
		return m.CustomEvaluatorRuleSet
	}
	return nil
}

func (m *TestGroup) GetReadStateFromStorage() bool {
	if m != nil {
		return m.ReadStateFromStorage
	}
	return false
}

func (m *TestGroup) GetIgnoreOldResults() bool {
	if m != nil {
		return m.IgnoreOldResults
	}
	return false
}

func (m *TestGroup) GetIgnoreSkip() bool {
	if m != nil {
		return m.IgnoreSkip
	}
	return false
}

// Custom column headers for defining extra column-heading rows from values in
// the test result.
type TestGroup_ColumnHeader struct {
	Label                string   `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	Property             string   `protobuf:"bytes,2,opt,name=property,proto3" json:"property,omitempty"`
	ConfigurationValue   string   `protobuf:"bytes,3,opt,name=configuration_value,json=configurationValue,proto3" json:"configuration_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestGroup_ColumnHeader) Reset()         { *m = TestGroup_ColumnHeader{} }
func (m *TestGroup_ColumnHeader) String() string { return proto.CompactTextString(m) }
func (*TestGroup_ColumnHeader) ProtoMessage()    {}
func (*TestGroup_ColumnHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 0}
}

func (m *TestGroup_ColumnHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup_ColumnHeader.Unmarshal(m, b)
}
func (m *TestGroup_ColumnHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup_ColumnHeader.Marshal(b, m, deterministic)
}
func (m *TestGroup_ColumnHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup_ColumnHeader.Merge(m, src)
}
func (m *TestGroup_ColumnHeader) XXX_Size() int {
	return xxx_messageInfo_TestGroup_ColumnHeader.Size(m)
}
func (m *TestGroup_ColumnHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup_ColumnHeader.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup_ColumnHeader proto.InternalMessageInfo

func (m *TestGroup_ColumnHeader) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *TestGroup_ColumnHeader) GetProperty() string {
	if m != nil {
		return m.Property
	}
	return ""
}

func (m *TestGroup_ColumnHeader) GetConfigurationValue() string {
	if m != nil {
		return m.ConfigurationValue
	}
	return ""
}

// Associates the presence of a named test property with a custom short text
// displayed over the results. Short text must be <=5 characters long.
type TestGroup_TestAnnotation struct {
	ShortText string `protobuf:"bytes,1,opt,name=short_text,json=shortText,proto3" json:"short_text,omitempty"`
	// Types that are valid to be assigned to ShortTextMessageSource:
	//	*TestGroup_TestAnnotation_PropertyName
	ShortTextMessageSource isTestGroup_TestAnnotation_ShortTextMessageSource `protobuf_oneof:"short_text_message_source"`
	XXX_NoUnkeyedLiteral   struct{}                                          `json:"-"`
	XXX_unrecognized       []byte                                            `json:"-"`
	XXX_sizecache          int32                                             `json:"-"`
}

func (m *TestGroup_TestAnnotation) Reset()         { *m = TestGroup_TestAnnotation{} }
func (m *TestGroup_TestAnnotation) String() string { return proto.CompactTextString(m) }
func (*TestGroup_TestAnnotation) ProtoMessage()    {}
func (*TestGroup_TestAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 1}
}

func (m *TestGroup_TestAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup_TestAnnotation.Unmarshal(m, b)
}
func (m *TestGroup_TestAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup_TestAnnotation.Marshal(b, m, deterministic)
}
func (m *TestGroup_TestAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup_TestAnnotation.Merge(m, src)
}
func (m *TestGroup_TestAnnotation) XXX_Size() int {
	return xxx_messageInfo_TestGroup_TestAnnotation.Size(m)
}
func (m *TestGroup_TestAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup_TestAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup_TestAnnotation proto.InternalMessageInfo

func (m *TestGroup_TestAnnotation) GetShortText() string {
	if m != nil {
		return m.ShortText
	}
	return ""
}

type isTestGroup_TestAnnotation_ShortTextMessageSource interface {
	isTestGroup_TestAnnotation_ShortTextMessageSource()
}

type TestGroup_TestAnnotation_PropertyName struct {
	PropertyName string `protobuf:"bytes,2,opt,name=property_name,json=propertyName,proto3,oneof"`
}

func (*TestGroup_TestAnnotation_PropertyName) isTestGroup_TestAnnotation_ShortTextMessageSource() {}

func (m *TestGroup_TestAnnotation) GetShortTextMessageSource() isTestGroup_TestAnnotation_ShortTextMessageSource {
	if m != nil {
		return m.ShortTextMessageSource
	}
	return nil
}

func (m *TestGroup_TestAnnotation) GetPropertyName() string {
	if x, ok := m.GetShortTextMessageSource().(*TestGroup_TestAnnotation_PropertyName); ok {
		return x.PropertyName
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TestGroup_TestAnnotation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TestGroup_TestAnnotation_PropertyName)(nil),
	}
}

// A string key value pair message
type TestGroup_KeyValue struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestGroup_KeyValue) Reset()         { *m = TestGroup_KeyValue{} }
func (m *TestGroup_KeyValue) String() string { return proto.CompactTextString(m) }
func (*TestGroup_KeyValue) ProtoMessage()    {}
func (*TestGroup_KeyValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 2}
}

func (m *TestGroup_KeyValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup_KeyValue.Unmarshal(m, b)
}
func (m *TestGroup_KeyValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup_KeyValue.Marshal(b, m, deterministic)
}
func (m *TestGroup_KeyValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup_KeyValue.Merge(m, src)
}
func (m *TestGroup_KeyValue) XXX_Size() int {
	return xxx_messageInfo_TestGroup_KeyValue.Size(m)
}
func (m *TestGroup_KeyValue) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup_KeyValue.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup_KeyValue proto.InternalMessageInfo

func (m *TestGroup_KeyValue) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *TestGroup_KeyValue) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type TestGroup_ResultSource struct {
	// Types that are valid to be assigned to ResultSourceConfig:
	//	*TestGroup_ResultSource_JunitConfig
	ResultSourceConfig   isTestGroup_ResultSource_ResultSourceConfig `protobuf_oneof:"result_source_config"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *TestGroup_ResultSource) Reset()         { *m = TestGroup_ResultSource{} }
func (m *TestGroup_ResultSource) String() string { return proto.CompactTextString(m) }
func (*TestGroup_ResultSource) ProtoMessage()    {}
func (*TestGroup_ResultSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{2, 3}
}

func (m *TestGroup_ResultSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestGroup_ResultSource.Unmarshal(m, b)
}
func (m *TestGroup_ResultSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestGroup_ResultSource.Marshal(b, m, deterministic)
}
func (m *TestGroup_ResultSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestGroup_ResultSource.Merge(m, src)
}
func (m *TestGroup_ResultSource) XXX_Size() int {
	return xxx_messageInfo_TestGroup_ResultSource.Size(m)
}
func (m *TestGroup_ResultSource) XXX_DiscardUnknown() {
	xxx_messageInfo_TestGroup_ResultSource.DiscardUnknown(m)
}

var xxx_messageInfo_TestGroup_ResultSource proto.InternalMessageInfo

type isTestGroup_ResultSource_ResultSourceConfig interface {
	isTestGroup_ResultSource_ResultSourceConfig()
}

type TestGroup_ResultSource_JunitConfig struct {
	JunitConfig *JUnitConfig `protobuf:"bytes,2,opt,name=junit_config,json=junitConfig,proto3,oneof"`
}

func (*TestGroup_ResultSource_JunitConfig) isTestGroup_ResultSource_ResultSourceConfig() {}

func (m *TestGroup_ResultSource) GetResultSourceConfig() isTestGroup_ResultSource_ResultSourceConfig {
	if m != nil {
		return m.ResultSourceConfig
	}
	return nil
}

func (m *TestGroup_ResultSource) GetJunitConfig() *JUnitConfig {
	if x, ok := m.GetResultSourceConfig().(*TestGroup_ResultSource_JunitConfig); ok {
		return x.JunitConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TestGroup_ResultSource) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TestGroup_ResultSource_JunitConfig)(nil),
	}
}

type JUnitConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JUnitConfig) Reset()         { *m = JUnitConfig{} }
func (m *JUnitConfig) String() string { return proto.CompactTextString(m) }
func (*JUnitConfig) ProtoMessage()    {}
func (*JUnitConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{3}
}

func (m *JUnitConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JUnitConfig.Unmarshal(m, b)
}
func (m *JUnitConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JUnitConfig.Marshal(b, m, deterministic)
}
func (m *JUnitConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JUnitConfig.Merge(m, src)
}
func (m *JUnitConfig) XXX_Size() int {
	return xxx_messageInfo_JUnitConfig.Size(m)
}
func (m *JUnitConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_JUnitConfig.DiscardUnknown(m)
}

var xxx_messageInfo_JUnitConfig proto.InternalMessageInfo

// Default metadata to apply when opening bugs.
type TestMetadataOptions struct {
	// Apply the following metadata if this regex matches a test's name.
	TestNameRegex string `protobuf:"bytes,1,opt,name=test_name_regex,json=testNameRegex,proto3" json:"test_name_regex,omitempty"`
	// Default bug component to open a bug in.
	BugComponent int32 `protobuf:"varint,2,opt,name=bug_component,json=bugComponent,proto3" json:"bug_component,omitempty"`
	// Default owner to assign a bug to.
	Owner string `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	// List of default users to CC a bug to.
	Cc []string `protobuf:"bytes,4,rep,name=cc,proto3" json:"cc,omitempty"`
	// Apply following metadata if this regex matches a test’s failure message.
	MessageRegex         string   `protobuf:"bytes,5,opt,name=message_regex,json=messageRegex,proto3" json:"message_regex,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestMetadataOptions) Reset()         { *m = TestMetadataOptions{} }
func (m *TestMetadataOptions) String() string { return proto.CompactTextString(m) }
func (*TestMetadataOptions) ProtoMessage()    {}
func (*TestMetadataOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{4}
}

func (m *TestMetadataOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestMetadataOptions.Unmarshal(m, b)
}
func (m *TestMetadataOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestMetadataOptions.Marshal(b, m, deterministic)
}
func (m *TestMetadataOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestMetadataOptions.Merge(m, src)
}
func (m *TestMetadataOptions) XXX_Size() int {
	return xxx_messageInfo_TestMetadataOptions.Size(m)
}
func (m *TestMetadataOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_TestMetadataOptions.DiscardUnknown(m)
}

var xxx_messageInfo_TestMetadataOptions proto.InternalMessageInfo

func (m *TestMetadataOptions) GetTestNameRegex() string {
	if m != nil {
		return m.TestNameRegex
	}
	return ""
}

func (m *TestMetadataOptions) GetBugComponent() int32 {
	if m != nil {
		return m.BugComponent
	}
	return 0
}

func (m *TestMetadataOptions) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *TestMetadataOptions) GetCc() []string {
	if m != nil {
		return m.Cc
	}
	return nil
}

func (m *TestMetadataOptions) GetMessageRegex() string {
	if m != nil {
		return m.MessageRegex
	}
	return ""
}

type AutoBugOptions struct {
	// Whether to auto-close auto-filed bugs.
	AutoClose bool `protobuf:"varint,1,opt,name=auto_close,json=autoClose,proto3" json:"auto_close,omitempty"`
	// A list of hotlist ids attached to auto-filed bugs.
	HotlistIds []int64 `protobuf:"varint,2,rep,packed,name=hotlist_ids,json=hotlistIds,proto3" json:"hotlist_ids,omitempty"`
	// The priority of the auto-filed bug. If provided, this will overwrite the
	// priority in the component default template
	Priority AutoBugOptions_Priority `protobuf:"varint,3,opt,name=priority,proto3,enum=AutoBugOptions_Priority" json:"priority,omitempty"`
	// A list of hotlist id sources
	// Corresponds with the list hotlist_ids (#2)
	HotlistIdsFromSource []*HotlistIdFromSource `protobuf:"bytes,4,rep,name=hotlist_ids_from_source,json=hotlistIdsFromSource,proto3" json:"hotlist_ids_from_source,omitempty"`
	// If True, files separate bugs for each failing target, instead of one bug
	// for each set of targets failing at the same run.
	FileIndividual bool `protobuf:"varint,5,opt,name=file_individual,json=fileIndividual,proto3" json:"file_individual,omitempty"`
	// If True; keep only one automantic bug per target, regardless of the number of
	// separate failures a target gets. This also requires `auto_close` and
	// `file_individual` to be True.
	// Consider setting `num_passes_to_disable_alert` instead if you're tracking
	// flaky tests.
	SingletonAutobug bool `protobuf:"varint,6,opt,name=singleton_autobug,json=singletonAutobug,proto3" json:"singleton_autobug,omitempty"`
	// If provided: only raise one bug if the number of failures for a single
	// query by testgrid for a single failure group exceeds this value. Requires
	// 'file_individual' to be True.
	MaxAllowedIndividualBugs int32 `protobuf:"varint,7,opt,name=max_allowed_individual_bugs,json=maxAllowedIndividualBugs,proto3" json:"max_allowed_individual_bugs,omitempty"`
	// If True; file issues for the 'Overall' target, even if otherwise invalid.
	FileOverall          bool     `protobuf:"varint,8,opt,name=file_overall,json=fileOverall,proto3" json:"file_overall,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AutoBugOptions) Reset()         { *m = AutoBugOptions{} }
func (m *AutoBugOptions) String() string { return proto.CompactTextString(m) }
func (*AutoBugOptions) ProtoMessage()    {}
func (*AutoBugOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{5}
}

func (m *AutoBugOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoBugOptions.Unmarshal(m, b)
}
func (m *AutoBugOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoBugOptions.Marshal(b, m, deterministic)
}
func (m *AutoBugOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoBugOptions.Merge(m, src)
}
func (m *AutoBugOptions) XXX_Size() int {
	return xxx_messageInfo_AutoBugOptions.Size(m)
}
func (m *AutoBugOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoBugOptions.DiscardUnknown(m)
}

var xxx_messageInfo_AutoBugOptions proto.InternalMessageInfo

func (m *AutoBugOptions) GetAutoClose() bool {
	if m != nil {
		return m.AutoClose
	}
	return false
}

func (m *AutoBugOptions) GetHotlistIds() []int64 {
	if m != nil {
		return m.HotlistIds
	}
	return nil
}

func (m *AutoBugOptions) GetPriority() AutoBugOptions_Priority {
	if m != nil {
		return m.Priority
	}
	return AutoBugOptions_PRIORITY_UNSPECIFIED
}

func (m *AutoBugOptions) GetHotlistIdsFromSource() []*HotlistIdFromSource {
	if m != nil {
		return m.HotlistIdsFromSource
	}
	return nil
}

func (m *AutoBugOptions) GetFileIndividual() bool {
	if m != nil {
		return m.FileIndividual
	}
	return false
}

func (m *AutoBugOptions) GetSingletonAutobug() bool {
	if m != nil {
		return m.SingletonAutobug
	}
	return false
}

func (m *AutoBugOptions) GetMaxAllowedIndividualBugs() int32 {
	if m != nil {
		return m.MaxAllowedIndividualBugs
	}
	return 0
}

func (m *AutoBugOptions) GetFileOverall() bool {
	if m != nil {
		return m.FileOverall
	}
	return false
}

type HotlistIdFromSource struct {
	// Types that are valid to be assigned to HotlistIdSource:
	//	*HotlistIdFromSource_Value
	//	*HotlistIdFromSource_Label
	HotlistIdSource      isHotlistIdFromSource_HotlistIdSource `protobuf_oneof:"hotlist_id_source"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *HotlistIdFromSource) Reset()         { *m = HotlistIdFromSource{} }
func (m *HotlistIdFromSource) String() string { return proto.CompactTextString(m) }
func (*HotlistIdFromSource) ProtoMessage()    {}
func (*HotlistIdFromSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{6}
}

func (m *HotlistIdFromSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotlistIdFromSource.Unmarshal(m, b)
}
func (m *HotlistIdFromSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotlistIdFromSource.Marshal(b, m, deterministic)
}
func (m *HotlistIdFromSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotlistIdFromSource.Merge(m, src)
}
func (m *HotlistIdFromSource) XXX_Size() int {
	return xxx_messageInfo_HotlistIdFromSource.Size(m)
}
func (m *HotlistIdFromSource) XXX_DiscardUnknown() {
	xxx_messageInfo_HotlistIdFromSource.DiscardUnknown(m)
}

var xxx_messageInfo_HotlistIdFromSource proto.InternalMessageInfo

type isHotlistIdFromSource_HotlistIdSource interface {
	isHotlistIdFromSource_HotlistIdSource()
}

type HotlistIdFromSource_Value struct {
	Value int64 `protobuf:"varint,1,opt,name=value,proto3,oneof"`
}

type HotlistIdFromSource_Label struct {
	Label string `protobuf:"bytes,2,opt,name=label,proto3,oneof"`
}

func (*HotlistIdFromSource_Value) isHotlistIdFromSource_HotlistIdSource() {}

func (*HotlistIdFromSource_Label) isHotlistIdFromSource_HotlistIdSource() {}

func (m *HotlistIdFromSource) GetHotlistIdSource() isHotlistIdFromSource_HotlistIdSource {
	if m != nil {
		return m.HotlistIdSource
	}
	return nil
}

func (m *HotlistIdFromSource) GetValue() int64 {
	if x, ok := m.GetHotlistIdSource().(*HotlistIdFromSource_Value); ok {
		return x.Value
	}
	return 0
}

func (m *HotlistIdFromSource) GetLabel() string {
	if x, ok := m.GetHotlistIdSource().(*HotlistIdFromSource_Label); ok {
		return x.Label
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HotlistIdFromSource) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HotlistIdFromSource_Value)(nil),
		(*HotlistIdFromSource_Label)(nil),
	}
}

// Specifies a dashboard.
type Dashboard struct {
	// A list of the tabs on the dashboard.
	DashboardTab []*DashboardTab `protobuf:"bytes,1,rep,name=dashboard_tab,json=dashboardTab,proto3" json:"dashboard_tab,omitempty"`
	// A name for the Dashboard.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// A list of notifications attached to this dashboard.
	// This is displayed on any dashboard tab in this dashboard.
	Notifications []*Notification `protobuf:"bytes,3,rep,name=notifications,proto3" json:"notifications,omitempty"`
	// Control which tab is displayed when first opening a dashboard.
	// Defaults to Summary
	DefaultTab string `protobuf:"bytes,5,opt,name=default_tab,json=defaultTab,proto3" json:"default_tab,omitempty"`
	// Controls whether to suppress highlighting of failing tabs.
	DownplayFailingTabs bool `protobuf:"varint,8,opt,name=downplay_failing_tabs,json=downplayFailingTabs,proto3" json:"downplay_failing_tabs,omitempty"`
	// Deprecated: Invert of 'downplay_failing_tabs'
	HighlightFailingTabs bool `protobuf:"varint,6,opt,name=highlight_failing_tabs,json=highlightFailingTabs,proto3" json:"highlight_failing_tabs,omitempty"` // Deprecated: Do not use.
	// Controls whether to apply special highlighting to result header columns for
	// the current day.
	HighlightToday       bool     `protobuf:"varint,7,opt,name=highlight_today,json=highlightToday,proto3" json:"highlight_today,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Dashboard) Reset()         { *m = Dashboard{} }
func (m *Dashboard) String() string { return proto.CompactTextString(m) }
func (*Dashboard) ProtoMessage()    {}
func (*Dashboard) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{7}
}

func (m *Dashboard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Dashboard.Unmarshal(m, b)
}
func (m *Dashboard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Dashboard.Marshal(b, m, deterministic)
}
func (m *Dashboard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Dashboard.Merge(m, src)
}
func (m *Dashboard) XXX_Size() int {
	return xxx_messageInfo_Dashboard.Size(m)
}
func (m *Dashboard) XXX_DiscardUnknown() {
	xxx_messageInfo_Dashboard.DiscardUnknown(m)
}

var xxx_messageInfo_Dashboard proto.InternalMessageInfo

func (m *Dashboard) GetDashboardTab() []*DashboardTab {
	if m != nil {
		return m.DashboardTab
	}
	return nil
}

func (m *Dashboard) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Dashboard) GetNotifications() []*Notification {
	if m != nil {
		return m.Notifications
	}
	return nil
}

func (m *Dashboard) GetDefaultTab() string {
	if m != nil {
		return m.DefaultTab
	}
	return ""
}

func (m *Dashboard) GetDownplayFailingTabs() bool {
	if m != nil {
		return m.DownplayFailingTabs
	}
	return false
}

// Deprecated: Do not use.
func (m *Dashboard) GetHighlightFailingTabs() bool {
	if m != nil {
		return m.HighlightFailingTabs
	}
	return false
}

func (m *Dashboard) GetHighlightToday() bool {
	if m != nil {
		return m.HighlightToday
	}
	return false
}

type LinkTemplate struct {
	// The URL template.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The options templates.
	Options              []*LinkOptionsTemplate `protobuf:"bytes,2,rep,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *LinkTemplate) Reset()         { *m = LinkTemplate{} }
func (m *LinkTemplate) String() string { return proto.CompactTextString(m) }
func (*LinkTemplate) ProtoMessage()    {}
func (*LinkTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{8}
}

func (m *LinkTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LinkTemplate.Unmarshal(m, b)
}
func (m *LinkTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LinkTemplate.Marshal(b, m, deterministic)
}
func (m *LinkTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinkTemplate.Merge(m, src)
}
func (m *LinkTemplate) XXX_Size() int {
	return xxx_messageInfo_LinkTemplate.Size(m)
}
func (m *LinkTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_LinkTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_LinkTemplate proto.InternalMessageInfo

func (m *LinkTemplate) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *LinkTemplate) GetOptions() []*LinkOptionsTemplate {
	if m != nil {
		return m.Options
	}
	return nil
}

// A simple key/value pair for link options.
type LinkOptionsTemplate struct {
	// The key for the option. This is not expanded.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value for the option. This is expanded the same as the LinkTemplate.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LinkOptionsTemplate) Reset()         { *m = LinkOptionsTemplate{} }
func (m *LinkOptionsTemplate) String() string { return proto.CompactTextString(m) }
func (*LinkOptionsTemplate) ProtoMessage()    {}
func (*LinkOptionsTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{9}
}

func (m *LinkOptionsTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LinkOptionsTemplate.Unmarshal(m, b)
}
func (m *LinkOptionsTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LinkOptionsTemplate.Marshal(b, m, deterministic)
}
func (m *LinkOptionsTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LinkOptionsTemplate.Merge(m, src)
}
func (m *LinkOptionsTemplate) XXX_Size() int {
	return xxx_messageInfo_LinkOptionsTemplate.Size(m)
}
func (m *LinkOptionsTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_LinkOptionsTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_LinkOptionsTemplate proto.InternalMessageInfo

func (m *LinkOptionsTemplate) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *LinkOptionsTemplate) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A single tab on a dashboard.
type DashboardTab struct {
	// The name of the dashboard tab to display in the client.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the TestGroup specifying the test results for this tab.
	TestGroupName string `protobuf:"bytes,2,opt,name=test_group_name,json=testGroupName,proto3" json:"test_group_name,omitempty"`
	// Default bug component for manually filing bugs from the dashboard
	BugComponent int32 `protobuf:"varint,3,opt,name=bug_component,json=bugComponent,proto3" json:"bug_component,omitempty"`
	// Default code search path for searching regressions. This value overrides
	// the default in the TestGroup config so that dashboards may be customized
	// separately.
	CodeSearchPath string `protobuf:"bytes,4,opt,name=code_search_path,json=codeSearchPath,proto3" json:"code_search_path,omitempty"`
	// See TestGroup.num_columns_recent. This value overrides the default in the
	// TestGroup config so that dashboards may be customized separately.
	NumColumnsRecent int32 `protobuf:"varint,5,opt,name=num_columns_recent,json=numColumnsRecent,proto3" json:"num_columns_recent,omitempty"`
	// Base options to always include, for example:
	// width=20&include-filter-by-regex=level_tests
	// This is taken from the #fragment part of the testgrid url.
	// Best way to create these is to setup the options on testgrid and then
	// copy the #fragment part.
	BaseOptions string `protobuf:"bytes,6,opt,name=base_options,json=baseOptions,proto3" json:"base_options,omitempty"`
	// The URL template to visit after clicking on a cell.
	OpenTestTemplate *LinkTemplate `protobuf:"bytes,7,opt,name=open_test_template,json=openTestTemplate,proto3" json:"open_test_template,omitempty"`
	// The URL template to visit when filing a bug.
	FileBugTemplate *LinkTemplate `protobuf:"bytes,8,opt,name=file_bug_template,json=fileBugTemplate,proto3" json:"file_bug_template,omitempty"`
	// The URL template to visit when attaching a bug
	AttachBugTemplate *LinkTemplate `protobuf:"bytes,9,opt,name=attach_bug_template,json=attachBugTemplate,proto3" json:"attach_bug_template,omitempty"`
	// Text to show in the about menu as a link to another view of the results.
	ResultsText string `protobuf:"bytes,10,opt,name=results_text,json=resultsText,proto3" json:"results_text,omitempty"`
	// The URL template to visit after clicking.
	ResultsUrlTemplate *LinkTemplate `protobuf:"bytes,11,opt,name=results_url_template,json=resultsUrlTemplate,proto3" json:"results_url_template,omitempty"`
	// The URL template to visit when searching for code changes, such as pull requests
	CodeSearchUrlTemplate *LinkTemplate `protobuf:"bytes,12,opt,name=code_search_url_template,json=codeSearchUrlTemplate,proto3" json:"code_search_url_template,omitempty"`
	// A description paragraph to be displayed.
	Description string `protobuf:"bytes,13,opt,name=description,proto3" json:"description,omitempty"`
	// A regular expression that uses the named group syntax to specify how to
	// show names in a table.
	TabularNamesRegex string `protobuf:"bytes,14,opt,name=tabular_names_regex,json=tabularNamesRegex,proto3" json:"tabular_names_regex,omitempty"`
	// Configuration options for dashboard tab alerts.
	AlertOptions *DashboardTabAlertOptions `protobuf:"bytes,15,opt,name=alert_options,json=alertOptions,proto3" json:"alert_options,omitempty"`
	// A URL for the "About this Dashboard" menu option
	AboutDashboardUrl string `protobuf:"bytes,16,opt,name=about_dashboard_url,json=aboutDashboardUrl,proto3" json:"about_dashboard_url,omitempty"`
	// The URL template to visit when viewing an associated bug.
	OpenBugTemplate      *LinkTemplate `protobuf:"bytes,17,opt,name=open_bug_template,json=openBugTemplate,proto3" json:"open_bug_template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DashboardTab) Reset()         { *m = DashboardTab{} }
func (m *DashboardTab) String() string { return proto.CompactTextString(m) }
func (*DashboardTab) ProtoMessage()    {}
func (*DashboardTab) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{10}
}

func (m *DashboardTab) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardTab.Unmarshal(m, b)
}
func (m *DashboardTab) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardTab.Marshal(b, m, deterministic)
}
func (m *DashboardTab) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardTab.Merge(m, src)
}
func (m *DashboardTab) XXX_Size() int {
	return xxx_messageInfo_DashboardTab.Size(m)
}
func (m *DashboardTab) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardTab.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardTab proto.InternalMessageInfo

func (m *DashboardTab) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DashboardTab) GetTestGroupName() string {
	if m != nil {
		return m.TestGroupName
	}
	return ""
}

func (m *DashboardTab) GetBugComponent() int32 {
	if m != nil {
		return m.BugComponent
	}
	return 0
}

func (m *DashboardTab) GetCodeSearchPath() string {
	if m != nil {
		return m.CodeSearchPath
	}
	return ""
}

func (m *DashboardTab) GetNumColumnsRecent() int32 {
	if m != nil {
		return m.NumColumnsRecent
	}
	return 0
}

func (m *DashboardTab) GetBaseOptions() string {
	if m != nil {
		return m.BaseOptions
	}
	return ""
}

func (m *DashboardTab) GetOpenTestTemplate() *LinkTemplate {
	if m != nil {
		return m.OpenTestTemplate
	}
	return nil
}

func (m *DashboardTab) GetFileBugTemplate() *LinkTemplate {
	if m != nil {
		return m.FileBugTemplate
	}
	return nil
}

func (m *DashboardTab) GetAttachBugTemplate() *LinkTemplate {
	if m != nil {
		return m.AttachBugTemplate
	}
	return nil
}

func (m *DashboardTab) GetResultsText() string {
	if m != nil {
		return m.ResultsText
	}
	return ""
}

func (m *DashboardTab) GetResultsUrlTemplate() *LinkTemplate {
	if m != nil {
		return m.ResultsUrlTemplate
	}
	return nil
}

func (m *DashboardTab) GetCodeSearchUrlTemplate() *LinkTemplate {
	if m != nil {
		return m.CodeSearchUrlTemplate
	}
	return nil
}

func (m *DashboardTab) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DashboardTab) GetTabularNamesRegex() string {
	if m != nil {
		return m.TabularNamesRegex
	}
	return ""
}

func (m *DashboardTab) GetAlertOptions() *DashboardTabAlertOptions {
	if m != nil {
		return m.AlertOptions
	}
	return nil
}

func (m *DashboardTab) GetAboutDashboardUrl() string {
	if m != nil {
		return m.AboutDashboardUrl
	}
	return ""
}

func (m *DashboardTab) GetOpenBugTemplate() *LinkTemplate {
	if m != nil {
		return m.OpenBugTemplate
	}
	return nil
}

// Configuration options for dashboard tab alerts.
type DashboardTabAlertOptions struct {
	// Time in hours before an alert will be added to a test results table if the
	// run date of the latest results are older than this time.  If zero, no
	// alerts are raised.
	AlertStaleResultsHours int32 `protobuf:"varint,1,opt,name=alert_stale_results_hours,json=alertStaleResultsHours,proto3" json:"alert_stale_results_hours,omitempty"`
	// The number of consecutive test result failures to see before alerting of
	// a consistent failure. If zero, no alerts are raised.
	NumFailuresToAlert int32 `protobuf:"varint,2,opt,name=num_failures_to_alert,json=numFailuresToAlert,proto3" json:"num_failures_to_alert,omitempty"`
	// The comma-separated addresses to send mail.
	AlertMailToAddresses string `protobuf:"bytes,3,opt,name=alert_mail_to_addresses,json=alertMailToAddresses,proto3" json:"alert_mail_to_addresses,omitempty"`
	// The number of consecutive test passes to close the alert.
	NumPassesToDisableAlert int32 `protobuf:"varint,4,opt,name=num_passes_to_disable_alert,json=numPassesToDisableAlert,proto3" json:"num_passes_to_disable_alert,omitempty"`
	// Custom subject for alert mails.
	Subject string `protobuf:"bytes,5,opt,name=subject,proto3" json:"subject,omitempty"`
	// Custom link for further help/instructions on debugging this alert.
	DebugUrl string `protobuf:"bytes,6,opt,name=debug_url,json=debugUrl,proto3" json:"debug_url,omitempty"`
	// Custom text to show for the debug link.
	DebugMessage         string   `protobuf:"bytes,7,opt,name=debug_message,json=debugMessage,proto3" json:"debug_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DashboardTabAlertOptions) Reset()         { *m = DashboardTabAlertOptions{} }
func (m *DashboardTabAlertOptions) String() string { return proto.CompactTextString(m) }
func (*DashboardTabAlertOptions) ProtoMessage()    {}
func (*DashboardTabAlertOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{11}
}

func (m *DashboardTabAlertOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardTabAlertOptions.Unmarshal(m, b)
}
func (m *DashboardTabAlertOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardTabAlertOptions.Marshal(b, m, deterministic)
}
func (m *DashboardTabAlertOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardTabAlertOptions.Merge(m, src)
}
func (m *DashboardTabAlertOptions) XXX_Size() int {
	return xxx_messageInfo_DashboardTabAlertOptions.Size(m)
}
func (m *DashboardTabAlertOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardTabAlertOptions.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardTabAlertOptions proto.InternalMessageInfo

func (m *DashboardTabAlertOptions) GetAlertStaleResultsHours() int32 {
	if m != nil {
		return m.AlertStaleResultsHours
	}
	return 0
}

func (m *DashboardTabAlertOptions) GetNumFailuresToAlert() int32 {
	if m != nil {
		return m.NumFailuresToAlert
	}
	return 0
}

func (m *DashboardTabAlertOptions) GetAlertMailToAddresses() string {
	if m != nil {
		return m.AlertMailToAddresses
	}
	return ""
}

func (m *DashboardTabAlertOptions) GetNumPassesToDisableAlert() int32 {
	if m != nil {
		return m.NumPassesToDisableAlert
	}
	return 0
}

func (m *DashboardTabAlertOptions) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *DashboardTabAlertOptions) GetDebugUrl() string {
	if m != nil {
		return m.DebugUrl
	}
	return ""
}

func (m *DashboardTabAlertOptions) GetDebugMessage() string {
	if m != nil {
		return m.DebugMessage
	}
	return ""
}

// Specifies a dashboard group.
type DashboardGroup struct {
	// The name for the dashboard group.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of names specifying dashboards to show links to in a separate tabbed
	// bar at the top of the page for each of the given dashboards.
	DashboardNames       []string `protobuf:"bytes,2,rep,name=dashboard_names,json=dashboardNames,proto3" json:"dashboard_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DashboardGroup) Reset()         { *m = DashboardGroup{} }
func (m *DashboardGroup) String() string { return proto.CompactTextString(m) }
func (*DashboardGroup) ProtoMessage()    {}
func (*DashboardGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{12}
}

func (m *DashboardGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardGroup.Unmarshal(m, b)
}
func (m *DashboardGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardGroup.Marshal(b, m, deterministic)
}
func (m *DashboardGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardGroup.Merge(m, src)
}
func (m *DashboardGroup) XXX_Size() int {
	return xxx_messageInfo_DashboardGroup.Size(m)
}
func (m *DashboardGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardGroup.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardGroup proto.InternalMessageInfo

func (m *DashboardGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DashboardGroup) GetDashboardNames() []string {
	if m != nil {
		return m.DashboardNames
	}
	return nil
}

// A service configuration consisting of multiple test groups and dashboards.
type Configuration struct {
	// A list of groups of tests to gather.
	TestGroups []*TestGroup `protobuf:"bytes,1,rep,name=test_groups,json=testGroups,proto3" json:"test_groups,omitempty"`
	// A list of all of the dashboards for a server.
	Dashboards []*Dashboard `protobuf:"bytes,2,rep,name=dashboards,proto3" json:"dashboards,omitempty"`
	// A list of all the dashboard groups for a server.
	DashboardGroups      []*DashboardGroup `protobuf:"bytes,3,rep,name=dashboard_groups,json=dashboardGroups,proto3" json:"dashboard_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Configuration) Reset()         { *m = Configuration{} }
func (m *Configuration) String() string { return proto.CompactTextString(m) }
func (*Configuration) ProtoMessage()    {}
func (*Configuration) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{13}
}

func (m *Configuration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Configuration.Unmarshal(m, b)
}
func (m *Configuration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Configuration.Marshal(b, m, deterministic)
}
func (m *Configuration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Configuration.Merge(m, src)
}
func (m *Configuration) XXX_Size() int {
	return xxx_messageInfo_Configuration.Size(m)
}
func (m *Configuration) XXX_DiscardUnknown() {
	xxx_messageInfo_Configuration.DiscardUnknown(m)
}

var xxx_messageInfo_Configuration proto.InternalMessageInfo

func (m *Configuration) GetTestGroups() []*TestGroup {
	if m != nil {
		return m.TestGroups
	}
	return nil
}

func (m *Configuration) GetDashboards() []*Dashboard {
	if m != nil {
		return m.Dashboards
	}
	return nil
}

func (m *Configuration) GetDashboardGroups() []*DashboardGroup {
	if m != nil {
		return m.DashboardGroups
	}
	return nil
}

// The DefaultConfiguration Proto is deprecated, and will be deleted after Nov 1, 2019
// For defaulting behavior, use the yamlcfg library instead.
type DefaultConfiguration struct {
	// A default testgroup with default initialization data
	DefaultTestGroup *TestGroup `protobuf:"bytes,1,opt,name=default_test_group,json=defaultTestGroup,proto3" json:"default_test_group,omitempty"` // Deprecated: Do not use.
	// A default dashboard tab with default initialization data
	DefaultDashboardTab  *DashboardTab `protobuf:"bytes,2,opt,name=default_dashboard_tab,json=defaultDashboardTab,proto3" json:"default_dashboard_tab,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DefaultConfiguration) Reset()         { *m = DefaultConfiguration{} }
func (m *DefaultConfiguration) String() string { return proto.CompactTextString(m) }
func (*DefaultConfiguration) ProtoMessage()    {}
func (*DefaultConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_3eaf2c85e69e9ea4, []int{14}
}

func (m *DefaultConfiguration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DefaultConfiguration.Unmarshal(m, b)
}
func (m *DefaultConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DefaultConfiguration.Marshal(b, m, deterministic)
}
func (m *DefaultConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DefaultConfiguration.Merge(m, src)
}
func (m *DefaultConfiguration) XXX_Size() int {
	return xxx_messageInfo_DefaultConfiguration.Size(m)
}
func (m *DefaultConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_DefaultConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_DefaultConfiguration proto.InternalMessageInfo

// Deprecated: Do not use.
func (m *DefaultConfiguration) GetDefaultTestGroup() *TestGroup {
	if m != nil {
		return m.DefaultTestGroup
	}
	return nil
}

// Deprecated: Do not use.
func (m *DefaultConfiguration) GetDefaultDashboardTab() *DashboardTab {
	if m != nil {
		return m.DefaultDashboardTab
	}
	return nil
}

func init() {
	proto.RegisterEnum("TestGroup_TestsName", TestGroup_TestsName_name, TestGroup_TestsName_value)
	proto.RegisterEnum("TestGroup_FallbackGrouping", TestGroup_FallbackGrouping_name, TestGroup_FallbackGrouping_value)
	proto.RegisterEnum("TestGroup_ColumnSortBy", TestGroup_ColumnSortBy_name, TestGroup_ColumnSortBy_value)
	proto.RegisterEnum("TestGroup_PrimaryGrouping", TestGroup_PrimaryGrouping_name, TestGroup_PrimaryGrouping_value)
	proto.RegisterEnum("TestGroup_Environment", TestGroup_Environment_name, TestGroup_Environment_value)
	proto.RegisterEnum("AutoBugOptions_Priority", AutoBugOptions_Priority_name, AutoBugOptions_Priority_value)
	proto.RegisterType((*TestNameConfig)(nil), "TestNameConfig")
	proto.RegisterType((*TestNameConfig_NameElement)(nil), "TestNameConfig.NameElement")
	proto.RegisterType((*Notification)(nil), "Notification")
	proto.RegisterType((*TestGroup)(nil), "TestGroup")
	proto.RegisterType((*TestGroup_ColumnHeader)(nil), "TestGroup.ColumnHeader")
	proto.RegisterType((*TestGroup_TestAnnotation)(nil), "TestGroup.TestAnnotation")
	proto.RegisterType((*TestGroup_KeyValue)(nil), "TestGroup.KeyValue")
	proto.RegisterType((*TestGroup_ResultSource)(nil), "TestGroup.ResultSource")
	proto.RegisterType((*JUnitConfig)(nil), "JUnitConfig")
	proto.RegisterType((*TestMetadataOptions)(nil), "TestMetadataOptions")
	proto.RegisterType((*AutoBugOptions)(nil), "AutoBugOptions")
	proto.RegisterType((*HotlistIdFromSource)(nil), "HotlistIdFromSource")
	proto.RegisterType((*Dashboard)(nil), "Dashboard")
	proto.RegisterType((*LinkTemplate)(nil), "LinkTemplate")
	proto.RegisterType((*LinkOptionsTemplate)(nil), "LinkOptionsTemplate")
	proto.RegisterType((*DashboardTab)(nil), "DashboardTab")
	proto.RegisterType((*DashboardTabAlertOptions)(nil), "DashboardTabAlertOptions")
	proto.RegisterType((*DashboardGroup)(nil), "DashboardGroup")
	proto.RegisterType((*Configuration)(nil), "Configuration")
	proto.RegisterType((*DefaultConfiguration)(nil), "DefaultConfiguration")
}

func init() { proto.RegisterFile("config.proto", fileDescriptor_3eaf2c85e69e9ea4) }

var fileDescriptor_3eaf2c85e69e9ea4 = []byte{
	// 3010 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x59, 0x5b, 0x73, 0x1b, 0xc7,
	0xb1, 0x16, 0x00, 0x92, 0x02, 0x1b, 0x17, 0x2e, 0x07, 0x20, 0xb9, 0x24, 0x2d, 0x8b, 0x82, 0x8e,
	0x2c, 0x5a, 0xf2, 0xa1, 0x2c, 0xca, 0x3e, 0x65, 0x1d, 0x4b, 0xe7, 0x18, 0x24, 0x41, 0x11, 0x12,
	0x2f, 0xf0, 0x02, 0x74, 0x95, 0xf3, 0xb2, 0x35, 0x58, 0x0c, 0x81, 0x35, 0xf7, 0x82, 0xec, 0xcc,
	0x4a, 0xe4, 0x6f, 0x49, 0xaa, 0xf2, 0x92, 0xca, 0x5b, 0xfe, 0x46, 0x1e, 0xf2, 0x92, 0x67, 0xff,
	0x9b, 0xd4, 0xf4, 0xcc, 0x2e, 0x16, 0x24, 0xa4, 0x38, 0x79, 0x02, 0xa6, 0x2f, 0x73, 0xe9, 0xee,
	0xf9, 0xba, 0xa7, 0x17, 0xca, 0x4e, 0x18, 0x5c, 0xb8, 0xc3, 0x9d, 0x71, 0x14, 0x8a, 0x70, 0xe3,
	0xc9, 0xb8, 0xff, 0xcc, 0x89, 0xb9, 0x08, 0x7d, 0x9b, 0xbd, 0xa7, 0x5e, 0x4c, 0x45, 0x18, 0xdd,
	0x22, 0x28, 0xd9, 0xc6, 0x1f, 0xf3, 0x50, 0xed, 0x31, 0x2e, 0x4e, 0xa9, 0xcf, 0xf6, 0x71, 0x12,
	0xf2, 0x03, 0x54, 0x02, 0xea, 0x33, 0x9b, 0x79, 0xcc, 0x67, 0x81, 0xe0, 0x66, 0x6e, 0xab, 0xb0,
	0x5d, 0xda, 0xdd, 0xdc, 0x99, 0x96, 0xdb, 0x91, 0x7f, 0x5b, 0x4a, 0xc6, 0x2a, 0x07, 0x93, 0x01,
	0x27, 0xf7, 0xa1, 0x84, 0x33, 0x5c, 0x84, 0x91, 0x4f, 0x85, 0x99, 0xdf, 0xca, 0x6d, 0x2f, 0x5a,
	0x20, 0x49, 0x87, 0x48, 0xd9, 0xf8, 0x4b, 0x0e, 0x4a, 0x19, 0x75, 0xb2, 0x0a, 0x0b, 0x1e, 0xed,
	0x33, 0x4f, 0xae, 0x25, 0x65, 0xf5, 0x88, 0x3c, 0x84, 0x8a, 0xa0, 0xd1, 0x90, 0x09, 0x5b, 0x1d,
	0x50, 0x4f, 0x55, 0x56, 0x44, 0xbd, 0xdf, 0x07, 0x50, 0xee, 0xc7, 0xae, 0x37, 0xb0, 0x15, 0xd5,
	0x2c, 0x6c, 0xe5, 0xb6, 0x8b, 0x56, 0x09, 0x69, 0x3d, 0x24, 0x11, 0x02, 0x73, 0x82, 0x0e, 0xb9,
	0x39, 0x87, 0xea, 0xf8, 0x1f, 0xe7, 0x66, 0x5c, 0xd8, 0xe3, 0x28, 0x1c, 0xb3, 0x48, 0x5c, 0x9b,
	0xf3, 0x7a, 0x6e, 0xc6, 0x45, 0x47, 0xd3, 0x1a, 0xef, 0xa0, 0x7c, 0x1a, 0x0a, 0xf7, 0xc2, 0x75,
	0xa8, 0x70, 0xc3, 0x80, 0x98, 0x70, 0x97, 0xc7, 0xbe, 0x4f, 0xa3, 0x6b, 0xbd, 0xd3, 0x64, 0x28,
	0x77, 0xe1, 0x84, 0x81, 0x60, 0x57, 0xc2, 0xf6, 0xdc, 0xe0, 0x52, 0xef, 0xb4, 0xa4, 0x69, 0xc7,
	0x6e, 0x70, 0xd9, 0xf8, 0xd3, 0xe7, 0xb0, 0x28, 0x6d, 0xf8, 0x26, 0x0a, 0xe3, 0xb1, 0xdc, 0x93,
	0xb4, 0x88, 0x9e, 0x07, 0xff, 0x93, 0x7b, 0x00, 0x43, 0x87, 0xdb, 0xe3, 0x88, 0x5d, 0xb8, 0x57,
	0x7a, 0x8a, 0xc5, 0xa1, 0xc3, 0x3b, 0x48, 0x20, 0x5f, 0xc0, 0xd2, 0x80, 0x5e, 0x73, 0x3b, 0xbc,
	0xb0, 0x23, 0xc6, 0x63, 0x4f, 0x70, 0x3c, 0xec, 0xbc, 0x55, 0x91, 0xe4, 0xb3, 0x0b, 0x4b, 0x11,
	0xc9, 0x23, 0xa8, 0xba, 0xc3, 0x20, 0x8c, 0x98, 0x3d, 0x66, 0xc1, 0xc0, 0x0d, 0x86, 0x78, 0xf0,
	0xa2, 0x55, 0x51, 0xd4, 0x8e, 0x22, 0xca, 0x2d, 0x6b, 0x31, 0x69, 0x2b, 0x81, 0x06, 0x28, 0x5a,
	0x25, 0x45, 0xdb, 0x93, 0x24, 0xf2, 0x03, 0x2c, 0x4b, 0x7b, 0x70, 0x1b, 0xfd, 0x39, 0x0e, 0x3d,
	0xd7, 0xb9, 0x36, 0x17, 0xb6, 0x72, 0xdb, 0xd5, 0xdd, 0xfa, 0x4e, 0x7a, 0x16, 0xfc, 0xc7, 0xa5,
	0x43, 0xad, 0x25, 0x91, 0xfc, 0xed, 0xa0, 0x30, 0xf9, 0x0e, 0x56, 0x87, 0x54, 0x8c, 0x58, 0x64,
	0x67, 0xad, 0xed, 0x32, 0x6e, 0xde, 0x95, 0xcb, 0xed, 0xe5, 0xcd, 0x9c, 0x55, 0x57, 0x12, 0xbd,
	0x89, 0xe5, 0x5d, 0xc6, 0xc9, 0x2e, 0xac, 0xe8, 0xed, 0xa1, 0x26, 0x8f, 0xfb, 0x5c, 0x44, 0xf2,
	0x30, 0xc5, 0xad, 0xc2, 0xf6, 0xa2, 0x55, 0x53, 0x4c, 0xa9, 0xd4, 0x4d, 0x58, 0xe4, 0x15, 0x54,
	0x9c, 0xd0, 0x8b, 0xfd, 0xc0, 0x1e, 0x31, 0x3a, 0x60, 0x91, 0xb9, 0x88, 0xb1, 0xbb, 0x96, 0xd9,
	0xeb, 0x3e, 0xf2, 0x8f, 0x90, 0x6d, 0x95, 0x9d, 0xcc, 0x88, 0x1c, 0xc1, 0xf2, 0x05, 0xf5, 0xbc,
	0x3e, 0x75, 0x2e, 0xed, 0xa1, 0x14, 0x96, 0xab, 0x01, 0x9e, 0x76, 0x33, 0x33, 0xc3, 0xa1, 0x96,
	0x79, 0xa3, 0x45, 0x2c, 0xe3, 0xe2, 0x06, 0x85, 0xbc, 0x84, 0x75, 0xea, 0xb1, 0x48, 0xd8, 0x5c,
	0x50, 0x8f, 0x25, 0xde, 0xb2, 0x47, 0x61, 0x1c, 0x71, 0xb3, 0x84, 0x3e, 0x5b, 0x45, 0x81, 0xae,
	0xe4, 0x6b, 0xbf, 0x1d, 0x49, 0x2e, 0x79, 0x0e, 0x2b, 0x41, 0xec, 0xdb, 0x17, 0xd4, 0xf5, 0xe2,
	0x88, 0x71, 0x5b, 0x84, 0x36, 0x4a, 0x9a, 0x65, 0x54, 0x23, 0x41, 0xec, 0x1f, 0x6a, 0x5e, 0x2f,
	0x6c, 0x4a, 0x8e, 0x0c, 0xe5, 0x7e, 0x3c, 0xb4, 0x9d, 0xd0, 0x1f, 0x87, 0x01, 0x0b, 0x84, 0x59,
	0x41, 0xd1, 0x72, 0x3f, 0x1e, 0xee, 0x27, 0x34, 0xb2, 0x0d, 0x86, 0x13, 0x0e, 0x98, 0xcd, 0x19,
	0x8d, 0x9c, 0x91, 0x3d, 0xa6, 0x62, 0x64, 0x56, 0x31, 0xc2, 0xaa, 0x92, 0xde, 0x45, 0x72, 0x87,
	0x8a, 0x11, 0xf9, 0x0a, 0xe4, 0x22, 0xb6, 0x32, 0x0d, 0xb7, 0x23, 0xe6, 0xc8, 0x39, 0x97, 0x70,
	0x4e, 0x23, 0x88, 0x7d, 0x65, 0x41, 0x6e, 0x21, 0x9d, 0x3c, 0x81, 0xe5, 0x98, 0x6b, 0x1f, 0xf9,
	0x4c, 0xd0, 0x01, 0x15, 0xd4, 0x34, 0x30, 0x94, 0x96, 0x62, 0x8e, 0xfe, 0x39, 0xd1, 0x64, 0xf2,
	0x2d, 0xac, 0x29, 0xb3, 0xf8, 0xd4, 0xf5, 0xf0, 0x64, 0x83, 0x41, 0xc4, 0x38, 0x67, 0xdc, 0x5c,
	0xc6, 0xad, 0xd4, 0x91, 0x7d, 0x42, 0x5d, 0xaf, 0x17, 0x36, 0x13, 0x9e, 0xdc, 0x50, 0x46, 0x8d,
	0xc7, 0xfd, 0x5f, 0x98, 0x23, 0x4c, 0x82, 0x1a, 0x46, 0xaa, 0xd1, 0x55, 0x74, 0xf2, 0x3d, 0x6c,
	0x64, 0xa4, 0xb5, 0x1d, 0x6d, 0x9f, 0x71, 0x4e, 0x87, 0xcc, 0xac, 0xa1, 0xd6, 0x5a, 0xaa, 0xa5,
	0x6d, 0x79, 0xa2, 0xd8, 0xe4, 0x19, 0xd4, 0x33, 0xca, 0x03, 0x26, 0xed, 0x1a, 0x47, 0x9e, 0x59,
	0x47, 0xb5, 0xe5, 0x54, 0xed, 0x40, 0x72, 0xce, 0x23, 0x8f, 0x1c, 0xc1, 0x03, 0xdf, 0x0d, 0x6c,
	0xe6, 0xd1, 0x31, 0x67, 0x03, 0xdb, 0x77, 0x83, 0x58, 0x30, 0x6e, 0xf7, 0x99, 0xf8, 0xc0, 0x58,
	0x80, 0xd3, 0x70, 0x73, 0x05, 0x6d, 0x77, 0xcf, 0x77, 0x83, 0x96, 0x92, 0x3b, 0x51, 0x62, 0x7b,
	0x4a, 0x4a, 0x4e, 0xc8, 0xc9, 0x39, 0x6c, 0x4b, 0x43, 0x2a, 0xa4, 0x8b, 0x23, 0x04, 0x1c, 0x5b,
	0xc2, 0x35, 0xe3, 0x36, 0xe5, 0x2a, 0x08, 0xec, 0x31, 0x8d, 0xa8, 0xcf, 0xcd, 0x55, 0xb4, 0xef,
	0xc3, 0x98, 0x6b, 0x30, 0xd6, 0xe2, 0x3f, 0xa1, 0x74, 0x93, 0x63, 0x58, 0x74, 0x50, 0x94, 0xec,
	0x40, 0x8d, 0x05, 0xb4, 0xef, 0x31, 0xfb, 0xc2, 0xa3, 0x97, 0xd7, 0x32, 0x22, 0x45, 0xcc, 0xcd,
	0x35, 0x9c, 0x61, 0x59, 0xb1, 0x0e, 0x25, 0xa7, 0x8b, 0x0c, 0x79, 0xed, 0xe4, 0x36, 0x2e, 0xe3,
	0x3e, 0x8b, 0x02, 0x26, 0xcf, 0xe2, 0x78, 0xae, 0x0c, 0x00, 0x13, 0x35, 0x6a, 0x31, 0x67, 0xef,
	0x52, 0xde, 0x3e, 0xb2, 0x24, 0xe0, 0xbb, 0xdc, 0x66, 0x57, 0x82, 0x45, 0x01, 0xf5, 0xcc, 0x75,
	0x94, 0x04, 0x97, 0xb7, 0x34, 0x85, 0xbc, 0x04, 0x03, 0x03, 0x04, 0x61, 0x44, 0x63, 0xf9, 0xc6,
	0x56, 0x6e, 0xbb, 0xb4, 0xbb, 0x74, 0x23, 0xad, 0x58, 0x55, 0x31, 0x9d, 0x8e, 0x5e, 0x40, 0x25,
	0xc8, 0x40, 0x30, 0x37, 0x37, 0xf1, 0x4a, 0x57, 0x76, 0xb2, 0xc0, 0x6c, 0x4d, 0xcb, 0x90, 0xd7,
	0x50, 0xd5, 0x38, 0xc0, 0xc3, 0x48, 0xd8, 0xfd, 0x6b, 0xf3, 0x33, 0xbc, 0xc6, 0xb7, 0x81, 0xa0,
	0x1b, 0x46, 0x62, 0xef, 0x3a, 0x01, 0x02, 0x35, 0x22, 0x2d, 0x30, 0xc6, 0x91, 0x2b, 0x71, 0x7d,
	0x82, 0x03, 0xf7, 0x70, 0x82, 0x8d, 0xcc, 0x04, 0x1d, 0x25, 0x92, 0xc2, 0xc0, 0xd2, 0x78, 0x9a,
	0x90, 0x31, 0x7d, 0x72, 0x3b, 0x46, 0xe1, 0x80, 0x9b, 0x9f, 0x67, 0x4d, 0xaf, 0xef, 0x87, 0x64,
	0x90, 0x03, 0x6d, 0x25, 0x1a, 0x04, 0xa1, 0xd0, 0xa7, 0xbd, 0x8f, 0xa7, 0x5d, 0xbf, 0x01, 0xb6,
	0xcd, 0x54, 0x42, 0x21, 0xee, 0x64, 0xcc, 0xc9, 0x77, 0xb0, 0xee, 0xd3, 0xab, 0xa9, 0x25, 0xed,
	0xb1, 0xc6, 0x5f, 0x73, 0x0b, 0x23, 0x71, 0xc5, 0xa7, 0x57, 0x99, 0x85, 0x3b, 0x0a, 0x7b, 0x49,
	0x13, 0xee, 0x39, 0xa1, 0xef, 0xbb, 0xc2, 0x0e, 0xdf, 0xb3, 0x28, 0x72, 0x07, 0xcc, 0xc6, 0x44,
	0x2c, 0xc1, 0x42, 0x3a, 0xd2, 0x7c, 0x80, 0xb7, 0x60, 0x43, 0x09, 0x9d, 0x69, 0x99, 0x63, 0x29,
	0xd2, 0x51, 0x12, 0xe4, 0x08, 0x56, 0xa6, 0x90, 0xc0, 0x0e, 0xc7, 0xea, 0x1c, 0x0d, 0x3c, 0x87,
	0x4a, 0x1a, 0x09, 0x1e, 0x9c, 0x29, 0x9e, 0x55, 0x13, 0xb7, 0x89, 0x12, 0xaf, 0x70, 0x26, 0x41,
	0x87, 0xe9, 0xfa, 0x0f, 0x15, 0x5e, 0x49, 0x7a, 0x8f, 0x0e, 0x93, 0x35, 0x5f, 0x82, 0x41, 0x63,
	0x11, 0xda, 0xf2, 0xae, 0x26, 0xcb, 0xfd, 0x97, 0x0e, 0xae, 0x66, 0x2c, 0xc2, 0xbd, 0x78, 0x98,
	0xac, 0x54, 0xa5, 0x53, 0x63, 0xf2, 0x02, 0x56, 0x53, 0x5b, 0x45, 0x71, 0x20, 0x5c, 0x9f, 0x69,
	0x90, 0x7e, 0x84, 0x86, 0xaa, 0x69, 0x43, 0x59, 0x8a, 0xa7, 0x10, 0xfa, 0x15, 0x6c, 0x4a, 0x7c,
	0x1c, 0x53, 0x09, 0x4e, 0x12, 0xc5, 0x06, 0x2e, 0x47, 0x2f, 0x2b, 0x9c, 0xfe, 0x02, 0x35, 0xd7,
	0x82, 0xd8, 0xef, 0xa0, 0x44, 0x2f, 0x3c, 0x50, 0x7c, 0x05, 0xd6, 0x4f, 0x81, 0xc8, 0x02, 0x41,
	0xee, 0x96, 0xdb, 0x7d, 0x1d, 0x60, 0xe6, 0x63, 0x05, 0x98, 0x92, 0xb3, 0x17, 0x0f, 0xf9, 0x9e,
	0x0a, 0x22, 0xd2, 0x86, 0x3a, 0x0b, 0xde, 0xbb, 0x51, 0x18, 0xc8, 0x3a, 0xc9, 0x76, 0x03, 0x2e,
	0x68, 0xe0, 0x30, 0x73, 0x1b, 0x83, 0x71, 0x35, 0x13, 0x15, 0xad, 0x89, 0x98, 0x55, 0xcb, 0xe8,
	0xb4, 0xb5, 0x0a, 0x69, 0xc3, 0x6a, 0x26, 0x24, 0xb2, 0x89, 0xf8, 0x4b, 0x74, 0x4d, 0x2d, 0x33,
	0xd9, 0x3b, 0x76, 0x8d, 0x50, 0x62, 0xd5, 0x45, 0x1a, 0x25, 0x99, 0xcc, 0x7c, 0x1f, 0x4a, 0x3a,
	0xa7, 0xcb, 0x43, 0x98, 0x4f, 0xd4, 0x75, 0x57, 0x24, 0xb9, 0x7b, 0x99, 0x13, 0xf8, 0x48, 0x5e,
	0x3c, 0xac, 0x87, 0x7c, 0x26, 0x22, 0xd7, 0x31, 0x9f, 0xa2, 0xf3, 0x96, 0x90, 0xd1, 0x63, 0x57,
	0x72, 0xda, 0xc8, 0x75, 0xc8, 0x09, 0x3c, 0xbc, 0x19, 0x74, 0x33, 0x20, 0xd0, 0xfc, 0x0a, 0xb5,
	0xb7, 0xa6, 0x43, 0xef, 0x36, 0xf8, 0xc9, 0xe8, 0x9f, 0x32, 0xef, 0xd4, 0xcd, 0xfb, 0x6f, 0xdc,
	0xe9, 0xca, 0xc4, 0xca, 0xd9, 0xdb, 0xf7, 0x2d, 0xac, 0x65, 0x0d, 0xe4, 0x53, 0xe1, 0x8c, 0xec,
	0x88, 0x0d, 0xd9, 0x95, 0xb9, 0xa3, 0x92, 0xd3, 0xc4, 0x18, 0x27, 0x92, 0x69, 0x49, 0x9e, 0xcc,
	0xd7, 0x12, 0x2f, 0x2f, 0x62, 0xcf, 0x4b, 0x54, 0x25, 0xca, 0x71, 0xf3, 0x19, 0x2e, 0x46, 0x62,
	0xce, 0x0e, 0x63, 0xcf, 0x53, 0x7a, 0x12, 0xd7, 0x38, 0x69, 0xc1, 0x3d, 0x5d, 0x8e, 0xab, 0xc2,
	0x60, 0x52, 0x95, 0xdb, 0x51, 0xec, 0x31, 0x6e, 0x7e, 0x2d, 0x2b, 0x1c, 0x2c, 0x8d, 0x36, 0x94,
	0xa0, 0xaa, 0x10, 0x5a, 0x89, 0x98, 0x25, 0xa5, 0xc8, 0x8f, 0xf0, 0xe8, 0x56, 0xb9, 0x32, 0xd3,
	0x76, 0xcf, 0x71, 0xfb, 0x8d, 0x9b, 0x55, 0xca, 0x0c, 0xeb, 0xbd, 0x82, 0x8a, 0xde, 0x12, 0x0f,
	0xe3, 0xc8, 0x61, 0xe6, 0x2e, 0xde, 0xa3, 0x2c, 0x6c, 0xaa, 0xad, 0x74, 0x91, 0x6d, 0x95, 0xa3,
	0xcc, 0x88, 0xec, 0xc3, 0xfa, 0xcd, 0x67, 0x06, 0x1e, 0xc8, 0xe6, 0x4c, 0x98, 0x2f, 0x70, 0xa6,
	0xe2, 0x8e, 0xdc, 0x7b, 0x97, 0x09, 0x6b, 0x55, 0x89, 0x4e, 0x9d, 0xa9, 0xcb, 0x84, 0x74, 0x43,
	0xc4, 0xe8, 0x00, 0xf3, 0x14, 0xb3, 0x2f, 0xa2, 0xd0, 0xb7, 0xb9, 0x08, 0x23, 0x99, 0xbb, 0xbf,
	0x41, 0x8b, 0xd6, 0x25, 0x5b, 0x26, 0x2b, 0x76, 0x18, 0x85, 0x7e, 0x57, 0xf1, 0x64, 0x8d, 0xa0,
	0xab, 0xc5, 0xd0, 0x1b, 0xa4, 0xe5, 0xf1, 0xb7, 0xa8, 0x61, 0x28, 0xce, 0x99, 0x37, 0x48, 0x2a,
	0x64, 0x99, 0xb0, 0x94, 0x34, 0xbf, 0x74, 0xc7, 0xe6, 0xff, 0xe8, 0x84, 0x85, 0xa4, 0xee, 0xa5,
	0x3b, 0xde, 0xf8, 0x3d, 0x94, 0xb3, 0x85, 0x22, 0xa9, 0xc3, 0x3c, 0x42, 0xa1, 0x2e, 0xd7, 0xd5,
	0x80, 0x6c, 0x40, 0x31, 0x7d, 0x3e, 0xa8, 0x6a, 0x3d, 0x1d, 0x93, 0x67, 0x50, 0x9b, 0xe5, 0x8b,
	0x02, 0x8a, 0x11, 0xe7, 0x96, 0xed, 0x37, 0xb8, 0x7a, 0x89, 0x4d, 0xa0, 0x5c, 0x3e, 0x07, 0x26,
	0xd7, 0x48, 0xaf, 0xbc, 0x98, 0xde, 0x1f, 0xf2, 0x08, 0x2a, 0xc9, 0x6a, 0x18, 0x72, 0x6a, 0x0b,
	0x47, 0x77, 0xac, 0x72, 0x42, 0x96, 0xe1, 0xb6, 0xb7, 0x09, 0xeb, 0x53, 0x97, 0x11, 0x0b, 0x1d,
	0xed, 0xdf, 0x8d, 0x5d, 0x28, 0x26, 0x97, 0x9d, 0x18, 0x50, 0xb8, 0x64, 0xc9, 0xc3, 0x46, 0xfe,
	0x95, 0xa7, 0x56, 0xbb, 0x56, 0x87, 0x53, 0x83, 0x0d, 0x06, 0xe5, 0x6c, 0x10, 0x90, 0xe7, 0x50,
	0xfe, 0x25, 0x0e, 0xdc, 0xa9, 0x47, 0x5a, 0x69, 0xb7, 0xbc, 0xf3, 0xf6, 0x3c, 0x70, 0xf5, 0x23,
	0xed, 0xe8, 0x8e, 0x55, 0x42, 0x19, 0x35, 0xdc, 0x5b, 0x85, 0xfa, 0x54, 0x9c, 0x69, 0xd5, 0xb7,
	0x73, 0xc5, 0x9c, 0x91, 0x7f, 0x3b, 0x57, 0x2c, 0x18, 0x73, 0x0d, 0x5f, 0xbd, 0x96, 0xf0, 0x31,
	0x41, 0x36, 0x60, 0xb5, 0xd7, 0xea, 0xf6, 0xba, 0xf6, 0x69, 0xf3, 0xa4, 0x65, 0x9f, 0x9f, 0x76,
	0x3b, 0xad, 0xfd, 0xf6, 0x61, 0xbb, 0x75, 0x60, 0xdc, 0x21, 0x2b, 0xb0, 0x9c, 0xe1, 0xb5, 0xdf,
	0x9c, 0x9e, 0x59, 0x2d, 0x23, 0x47, 0x56, 0x81, 0x64, 0xc8, 0x56, 0xab, 0x73, 0xdc, 0xdc, 0x6f,
	0x19, 0xf9, 0x1b, 0xe2, 0xcd, 0x4e, 0xa7, 0x75, 0x7a, 0x60, 0x14, 0x1a, 0xff, 0xc8, 0x81, 0x71,
	0xb3, 0xb2, 0x97, 0xcb, 0x1e, 0x36, 0x8f, 0x8f, 0xf7, 0x9a, 0xfb, 0xef, 0xec, 0x37, 0xd6, 0xd9,
	0x79, 0xa7, 0x7d, 0xfa, 0xc6, 0x3e, 0x3d, 0x3b, 0x6d, 0x19, 0x77, 0x66, 0xf3, 0x0e, 0x9a, 0x3d,
	0xb9, 0xf6, 0x67, 0x60, 0xde, 0xe6, 0x1d, 0x37, 0xf7, 0x5a, 0xc7, 0x5d, 0x23, 0x4f, 0x4c, 0xa8,
	0xdf, 0xe6, 0xb6, 0x0f, 0x8c, 0x02, 0xd9, 0x82, 0xcf, 0x6e, 0x73, 0xf6, 0xcf, 0x4e, 0x4e, 0xda,
	0x3d, 0xfb, 0xf4, 0xfc, 0xc4, 0x98, 0x23, 0x5f, 0xc2, 0xa3, 0x59, 0x12, 0xa7, 0x87, 0xed, 0x37,
	0xe7, 0x56, 0xb3, 0xd7, 0x3e, 0x3b, 0xb5, 0x7f, 0x6a, 0x1e, 0x9f, 0xb7, 0x8c, 0xf9, 0xc6, 0x0f,
	0x49, 0x0c, 0xeb, 0xaa, 0xa6, 0x0e, 0xc6, 0xfe, 0xd9, 0xf1, 0xf9, 0xc9, 0xa9, 0xdd, 0x3d, 0xb3,
	0x7a, 0x6a, 0xab, 0x78, 0x8c, 0x2c, 0x35, 0xb3, 0x58, 0xae, 0x71, 0x02, 0x4b, 0x37, 0x8a, 0x1c,
	0xb2, 0x0e, 0x2b, 0x1d, 0xab, 0x7d, 0xd2, 0xb4, 0x7e, 0xbe, 0x65, 0x90, 0xfb, 0xb0, 0x79, 0x8b,
	0x35, 0x35, 0xdd, 0x7d, 0x28, 0x65, 0xd2, 0x14, 0x29, 0xc2, 0x5c, 0xc7, 0x3a, 0x93, 0x1e, 0x5c,
	0x80, 0xfc, 0x8f, 0x4d, 0x23, 0xd7, 0xa8, 0x40, 0x29, 0x13, 0x34, 0x8d, 0xbf, 0xe6, 0xa0, 0x36,
	0xa3, 0x5e, 0x90, 0xef, 0xe0, 0x49, 0x35, 0xa9, 0x10, 0x5a, 0x05, 0x6d, 0x25, 0xa9, 0x1d, 0x15,
	0x34, 0xdf, 0x7a, 0x17, 0xe5, 0x67, 0xbc, 0x8b, 0xea, 0x30, 0x1f, 0x7e, 0x08, 0x58, 0xa4, 0x6f,
	0xa6, 0x1a, 0x90, 0x2a, 0xe4, 0x1d, 0xc7, 0x9c, 0xc3, 0x97, 0x66, 0xde, 0x71, 0xe4, 0x54, 0xc9,
	0xcd, 0x51, 0x0b, 0xea, 0x6e, 0x81, 0x26, 0xe2, 0x7a, 0x8d, 0x5f, 0x0b, 0x50, 0x9d, 0x2e, 0x38,
	0xe4, 0x15, 0xc6, 0xda, 0xc4, 0xf1, 0x42, 0xae, 0xde, 0xfa, 0x45, 0x6b, 0x51, 0x52, 0xf6, 0x25,
	0x41, 0xe2, 0xd0, 0x28, 0x14, 0x9e, 0xcb, 0x85, 0xed, 0x0e, 0xb8, 0x99, 0xdf, 0x2a, 0x6c, 0x17,
	0x2c, 0xd0, 0xa4, 0xf6, 0x80, 0x93, 0x6f, 0x24, 0xc2, 0xb8, 0x61, 0xe4, 0x8a, 0x6b, 0xdc, 0x60,
	0x75, 0xd7, 0xbc, 0x51, 0xd3, 0xc8, 0x32, 0x14, 0xf9, 0x56, 0x2a, 0x49, 0xde, 0xc1, 0x5a, 0x66,
	0x5a, 0x0d, 0xa2, 0x0a, 0xd0, 0xe7, 0x74, 0x1d, 0x76, 0x94, 0xac, 0x81, 0x20, 0xaa, 0xd0, 0xbc,
	0x3e, 0x59, 0x78, 0x42, 0x25, 0x8f, 0x61, 0xe9, 0xc2, 0xf5, 0x98, 0xed, 0x06, 0x03, 0xf7, 0xbd,
	0x3b, 0x88, 0xa9, 0xa7, 0x3b, 0x05, 0x55, 0x49, 0x6e, 0xa7, 0x54, 0xf2, 0x14, 0x96, 0xb9, 0x1b,
	0x0c, 0x3d, 0x26, 0xc2, 0xc0, 0x96, 0x67, 0xec, 0xc7, 0x43, 0x6c, 0x16, 0x14, 0x2d, 0x23, 0x65,
	0x34, 0x15, 0x9d, 0xbc, 0x86, 0x4d, 0x59, 0x79, 0x51, 0xcf, 0x0b, 0x3f, 0xb0, 0x41, 0x66, 0x72,
	0x55, 0x53, 0xdc, 0x45, 0x4f, 0x99, 0x3e, 0xbd, 0x6a, 0x2a, 0x89, 0xc9, 0x3a, 0x58, 0x61, 0x3c,
	0x80, 0x32, 0x6e, 0x4a, 0xd6, 0x0c, 0xd4, 0xf3, 0xcc, 0xa2, 0xea, 0x5d, 0x48, 0xda, 0x99, 0x22,
	0x35, 0x8e, 0xa1, 0x98, 0x98, 0x46, 0xde, 0xb8, 0x8e, 0xd5, 0x3e, 0xb3, 0xda, 0xbd, 0x9f, 0x6f,
	0x80, 0xc7, 0x02, 0xe4, 0x3b, 0x5f, 0x1b, 0x39, 0xfc, 0x7d, 0x6e, 0xe4, 0xf1, 0x77, 0xd7, 0x28,
	0xe0, 0xef, 0x0b, 0x63, 0x0e, 0x7f, 0xbf, 0x31, 0xe6, 0x1b, 0xbf, 0x83, 0xda, 0x0c, 0x93, 0x91,
	0xd5, 0x04, 0x21, 0xa5, 0x6b, 0x0b, 0x47, 0x77, 0x34, 0x46, 0x4a, 0xba, 0xca, 0x17, 0x09, 0x26,
	0xab, 0xe1, 0x5e, 0x0d, 0x96, 0x27, 0x9e, 0xd1, 0x3e, 0x69, 0xfc, 0x2d, 0x0f, 0x8b, 0x07, 0x94,
	0x8f, 0xfa, 0x21, 0x8d, 0x06, 0x64, 0x17, 0x2a, 0x83, 0x64, 0x60, 0x0b, 0xda, 0xd7, 0xfd, 0xb7,
	0xca, 0x4e, 0x2a, 0xd2, 0xa3, 0x7d, 0xab, 0x3c, 0xc8, 0x8c, 0xd2, 0x66, 0x52, 0x3e, 0xd3, 0x4c,
	0xba, 0xf5, 0x70, 0x2a, 0xfc, 0x86, 0x87, 0xd3, 0x7d, 0x28, 0x0d, 0xd8, 0x05, 0x95, 0xc8, 0x2c,
	0x97, 0x56, 0x51, 0x0e, 0x9a, 0x24, 0x57, 0xda, 0x85, 0x95, 0x41, 0xf8, 0x21, 0x18, 0x7b, 0xf4,
	0x1a, 0xdf, 0xd6, 0xb2, 0xe6, 0x10, 0xb4, 0xcf, 0xb5, 0x07, 0x6a, 0x09, 0xf3, 0x50, 0xf1, 0x7a,
	0xb4, 0x2f, 0x5f, 0x24, 0xab, 0x23, 0x77, 0x38, 0xf2, 0xdc, 0xe1, 0x48, 0x4c, 0x2b, 0x2d, 0x4c,
	0x7a, 0x40, 0xa9, 0x44, 0x56, 0xf3, 0x31, 0x2c, 0x4d, 0x34, 0x45, 0x38, 0xa0, 0xd7, 0xaa, 0x6d,
	0x64, 0x55, 0x53, 0x72, 0x4f, 0x52, 0xdf, 0xce, 0x15, 0xe7, 0x8c, 0xf9, 0x46, 0x07, 0xca, 0xc7,
	0x6e, 0x70, 0xd9, 0x63, 0xfe, 0xd8, 0xa3, 0x02, 0x33, 0x9a, 0x7c, 0xbc, 0xeb, 0x8c, 0x16, 0x47,
	0x1e, 0xd9, 0x81, 0xbb, 0xc9, 0x13, 0x21, 0xaf, 0x6f, 0x82, 0xd4, 0xd0, 0x77, 0x29, 0x51, 0xb4,
	0x12, 0xa1, 0xc6, 0x6b, 0xa8, 0xcd, 0xe0, 0xff, 0xd6, 0x54, 0xd9, 0xf8, 0xfb, 0x02, 0x94, 0x0f,
	0x66, 0x39, 0x2a, 0xdb, 0xf5, 0x4b, 0xe0, 0x0c, 0x6b, 0xb8, 0x4c, 0x26, 0x57, 0x70, 0x86, 0xc8,
	0x8b, 0x39, 0xf0, 0x16, 0x9c, 0x15, 0x7e, 0x63, 0x9b, 0x67, 0xee, 0xdf, 0x68, 0xf3, 0xcc, 0x7f,
	0xa4, 0xcd, 0xf3, 0x00, 0xca, 0x7d, 0xca, 0x59, 0xfa, 0xc0, 0x5a, 0x50, 0xfd, 0x4d, 0x49, 0x4b,
	0xb0, 0xee, 0x7b, 0x20, 0xe1, 0x98, 0x05, 0xaa, 0xe4, 0x16, 0xda, 0x54, 0xe8, 0x2f, 0x19, 0x75,
	0x59, 0xc7, 0x58, 0x86, 0x14, 0x94, 0xd0, 0x9e, 0x5a, 0xf4, 0x25, 0x2c, 0xe3, 0x85, 0x96, 0x27,
	0x4c, 0x75, 0x8b, 0xb3, 0x74, 0x11, 0x8d, 0xf6, 0xe2, 0x61, 0xaa, 0xfa, 0x1a, 0x6a, 0x54, 0x08,
	0xea, 0x8c, 0xa6, 0x95, 0x17, 0x67, 0x29, 0x2f, 0x2b, 0xc9, 0xac, 0xfa, 0x03, 0x28, 0x27, 0xfd,
	0x39, 0xac, 0xb3, 0x40, 0x9d, 0x4c, 0xd3, 0xb0, 0xd2, 0xfa, 0xff, 0xa4, 0x5c, 0xe1, 0x76, 0x1c,
	0x79, 0x93, 0x25, 0x4a, 0xb3, 0x96, 0x20, 0x5a, 0xf4, 0x3c, 0xf2, 0xd2, 0x35, 0x0e, 0xc1, 0xcc,
	0x7a, 0x65, 0x6a, 0x92, 0xf2, 0xac, 0x49, 0x56, 0x26, 0xce, 0xca, 0xce, 0xb3, 0x25, 0xaf, 0x27,
	0x77, 0x22, 0x17, 0x4d, 0x8e, 0x7d, 0xbe, 0x45, 0x2b, 0x4b, 0x22, 0x3b, 0x50, 0x13, 0xb4, 0x1f,
	0x7b, 0x34, 0x52, 0xcf, 0x10, 0x9d, 0xae, 0x54, 0xa7, 0x6f, 0x59, 0xb3, 0xf0, 0x19, 0xa2, 0x72,
	0xe4, 0xff, 0x41, 0x45, 0x75, 0x96, 0x12, 0xc7, 0x2e, 0xe1, 0x76, 0xd6, 0xa7, 0xd0, 0x06, 0x5f,
	0xae, 0xc9, 0x1b, 0xba, 0x4c, 0x33, 0x23, 0xb9, 0x1e, 0xed, 0x87, 0xb1, 0xb0, 0x27, 0x98, 0x25,
	0xaf, 0x9c, 0xa1, 0xfb, 0x65, 0x92, 0x95, 0xce, 0x74, 0x1e, 0x79, 0xd2, 0xcf, 0x18, 0x24, 0x53,
	0xae, 0x5a, 0x9e, 0xe9, 0x67, 0x29, 0x97, 0x71, 0x54, 0xe3, 0xd7, 0x3c, 0x98, 0x1f, 0xdb, 0xd5,
	0xa7, 0x3b, 0xae, 0xb9, 0xff, 0xac, 0xe3, 0x9a, 0xff, 0x68, 0xc7, 0xf5, 0x13, 0x8d, 0xcc, 0xc2,
	0x27, 0x1a, 0x99, 0xff, 0xa2, 0x73, 0x30, 0xf7, 0xe9, 0xce, 0x01, 0x7e, 0x7c, 0x50, 0xbd, 0xcf,
	0xf9, 0xe4, 0xe3, 0x83, 0x6a, 0x79, 0x6e, 0xc2, 0xe2, 0xa4, 0x55, 0xa9, 0x6e, 0x66, 0x71, 0x90,
	0x74, 0x28, 0x1f, 0x42, 0x45, 0x31, 0x93, 0x16, 0xe8, 0x5d, 0x55, 0xba, 0x20, 0x51, 0xf7, 0x3d,
	0x1b, 0x27, 0x50, 0x4d, 0x4d, 0xfb, 0xf1, 0xef, 0x13, 0x8f, 0x61, 0x69, 0xe2, 0x66, 0xf5, 0xca,
	0xcd, 0x63, 0x89, 0x54, 0x4d, 0xc9, 0x18, 0x5a, 0x8d, 0x3f, 0xe7, 0xa0, 0x32, 0xf5, 0xbc, 0x24,
	0x4f, 0xa1, 0x34, 0x01, 0xb9, 0xe4, 0x9b, 0x12, 0x4c, 0xde, 0x95, 0x16, 0xa4, 0x60, 0xc7, 0xc9,
	0x13, 0x80, 0x74, 0xc2, 0x04, 0xa8, 0x61, 0x12, 0x91, 0x56, 0x86, 0x4b, 0xfe, 0x17, 0x8c, 0xc9,
	0x9e, 0xf4, 0xec, 0x2a, 0xd3, 0x2d, 0xed, 0x4c, 0x1f, 0xc9, 0x9a, 0x6c, 0x5e, 0xad, 0xd3, 0xf8,
	0x43, 0x0e, 0xea, 0x07, 0x2a, 0xb7, 0x4d, 0xef, 0xf6, 0x15, 0x90, 0x34, 0x0d, 0xa6, 0xbb, 0x46,
	0x53, 0x4c, 0x6d, 0x1a, 0x33, 0x97, 0x91, 0x64, 0xc7, 0xf4, 0xd3, 0x4e, 0x0b, 0x56, 0x12, 0xed,
	0xe9, 0x4c, 0x9e, 0xd7, 0x71, 0x9e, 0x8d, 0x62, 0x9c, 0xa3, 0xa6, 0xe5, 0xb3, 0x8c, 0xfe, 0x02,
	0x7e, 0xa2, 0x7b, 0xf1, 0xcf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x04, 0xdc, 0x7c, 0x74, 0xde, 0x1b,
	0x00, 0x00,
}
