/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: updater.proto

package updater

import (
	context "context"
	fmt "fmt"
	config "github.com/GoogleCloudPlatform/testgrid/pb/config"
	state "github.com/GoogleCloudPlatform/testgrid/pb/state"
	summary "github.com/GoogleCloudPlatform/testgrid/pb/summary"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An identifier of a dashboard tab, i.e., the name of the dashboard and tab.
type DashboardTabIdentifier struct {
	// The name of a dashboard containing the dashboard tab.
	DashboardName string `protobuf:"bytes,1,opt,name=dashboard_name,json=dashboardName,proto3" json:"dashboard_name,omitempty"`
	// The dashboard tab to update.
	DashboardTab         *config.DashboardTab `protobuf:"bytes,2,opt,name=dashboard_tab,json=dashboardTab,proto3" json:"dashboard_tab,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DashboardTabIdentifier) Reset()         { *m = DashboardTabIdentifier{} }
func (m *DashboardTabIdentifier) String() string { return proto.CompactTextString(m) }
func (*DashboardTabIdentifier) ProtoMessage()    {}
func (*DashboardTabIdentifier) Descriptor() ([]byte, []int) {
	return fileDescriptor_064b66b400b30f45, []int{0}
}

func (m *DashboardTabIdentifier) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DashboardTabIdentifier.Unmarshal(m, b)
}
func (m *DashboardTabIdentifier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DashboardTabIdentifier.Marshal(b, m, deterministic)
}
func (m *DashboardTabIdentifier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DashboardTabIdentifier.Merge(m, src)
}
func (m *DashboardTabIdentifier) XXX_Size() int {
	return xxx_messageInfo_DashboardTabIdentifier.Size(m)
}
func (m *DashboardTabIdentifier) XXX_DiscardUnknown() {
	xxx_messageInfo_DashboardTabIdentifier.DiscardUnknown(m)
}

var xxx_messageInfo_DashboardTabIdentifier proto.InternalMessageInfo

func (m *DashboardTabIdentifier) GetDashboardName() string {
	if m != nil {
		return m.DashboardName
	}
	return ""
}

func (m *DashboardTabIdentifier) GetDashboardTab() *config.DashboardTab {
	if m != nil {
		return m.DashboardTab
	}
	return nil
}

// An updater request to update a test group.
type UpdateRequest struct {
	// The test group configuration to update.
	TestGroup *config.TestGroup `protobuf:"bytes,1,opt,name=test_group,json=testGroup,proto3" json:"test_group,omitempty"`
	// A list of dashboards tabs backed by the group being updated.
	DashboardTabIdentifiers []*DashboardTabIdentifier `protobuf:"bytes,2,rep,name=dashboard_tab_identifiers,json=dashboardTabIdentifiers,proto3" json:"dashboard_tab_identifiers,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                  `json:"-"`
	XXX_unrecognized        []byte                    `json:"-"`
	XXX_sizecache           int32                     `json:"-"`
}

func (m *UpdateRequest) Reset()         { *m = UpdateRequest{} }
func (m *UpdateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateRequest) ProtoMessage()    {}
func (*UpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_064b66b400b30f45, []int{1}
}

func (m *UpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRequest.Unmarshal(m, b)
}
func (m *UpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRequest.Marshal(b, m, deterministic)
}
func (m *UpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRequest.Merge(m, src)
}
func (m *UpdateRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateRequest.Size(m)
}
func (m *UpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRequest proto.InternalMessageInfo

func (m *UpdateRequest) GetTestGroup() *config.TestGroup {
	if m != nil {
		return m.TestGroup
	}
	return nil
}

func (m *UpdateRequest) GetDashboardTabIdentifiers() []*DashboardTabIdentifier {
	if m != nil {
		return m.DashboardTabIdentifiers
	}
	return nil
}

// An updater response after updating a test group.
type UpdateResponse struct {
	// The time taken to perform the update in milliseconds.
	UpdateTimeMillis uint32 `protobuf:"varint,1,opt,name=update_time_millis,json=updateTimeMillis,proto3" json:"update_time_millis,omitempty"`
	// The size of the compressed output file in bytes.
	OutputSizeBytes uint32 `protobuf:"varint,2,opt,name=output_size_bytes,json=outputSizeBytes,proto3" json:"output_size_bytes,omitempty"`
	// Summaries of dashboard tabs associated with this group.
	DashboardTabSummaries []*summary.DashboardTabSummary `protobuf:"bytes,3,rep,name=dashboard_tab_summaries,json=dashboardTabSummaries,proto3" json:"dashboard_tab_summaries,omitempty"`
	// Metrics associated with the update for this group.
	UpdateEntry          *state.UpdateInfo `protobuf:"bytes,4,opt,name=update_entry,json=updateEntry,proto3" json:"update_entry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *UpdateResponse) Reset()         { *m = UpdateResponse{} }
func (m *UpdateResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateResponse) ProtoMessage()    {}
func (*UpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_064b66b400b30f45, []int{2}
}

func (m *UpdateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateResponse.Unmarshal(m, b)
}
func (m *UpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateResponse.Marshal(b, m, deterministic)
}
func (m *UpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateResponse.Merge(m, src)
}
func (m *UpdateResponse) XXX_Size() int {
	return xxx_messageInfo_UpdateResponse.Size(m)
}
func (m *UpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateResponse proto.InternalMessageInfo

func (m *UpdateResponse) GetUpdateTimeMillis() uint32 {
	if m != nil {
		return m.UpdateTimeMillis
	}
	return 0
}

func (m *UpdateResponse) GetOutputSizeBytes() uint32 {
	if m != nil {
		return m.OutputSizeBytes
	}
	return 0
}

func (m *UpdateResponse) GetDashboardTabSummaries() []*summary.DashboardTabSummary {
	if m != nil {
		return m.DashboardTabSummaries
	}
	return nil
}

func (m *UpdateResponse) GetUpdateEntry() *state.UpdateInfo {
	if m != nil {
		return m.UpdateEntry
	}
	return nil
}

func init() {
	proto.RegisterType((*DashboardTabIdentifier)(nil), "DashboardTabIdentifier")
	proto.RegisterType((*UpdateRequest)(nil), "UpdateRequest")
	proto.RegisterType((*UpdateResponse)(nil), "UpdateResponse")
}

func init() { proto.RegisterFile("updater.proto", fileDescriptor_064b66b400b30f45) }

var fileDescriptor_064b66b400b30f45 = []byte{
	// 388 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xdf, 0x6e, 0xd3, 0x30,
	0x14, 0xc6, 0xc9, 0x86, 0x86, 0x76, 0xb2, 0x74, 0x60, 0x8d, 0x35, 0xec, 0xaa, 0xaa, 0x84, 0x54,
	0xfe, 0xc8, 0x95, 0xc2, 0x1b, 0x4c, 0x20, 0x34, 0x09, 0xb8, 0x70, 0xcb, 0xb5, 0xe5, 0x90, 0xd3,
	0x62, 0x69, 0x89, 0x83, 0xcf, 0xc9, 0x45, 0xf7, 0x12, 0xbc, 0x26, 0x8f, 0x81, 0x6a, 0x27, 0x63,
	0x11, 0xbd, 0xd8, 0x4d, 0xec, 0xfc, 0xbe, 0x24, 0xfe, 0xbe, 0xef, 0x04, 0xb2, 0xae, 0xad, 0x0c,
	0xa3, 0x97, 0xad, 0x77, 0xec, 0xae, 0x2e, 0xdb, 0x72, 0xf9, 0xc3, 0x35, 0x1b, 0xbb, 0xed, 0x97,
	0x9e, 0xe7, 0x6d, 0xb9, 0xa4, 0xae, 0xae, 0x8d, 0xdf, 0x0d, 0x6b, 0xaf, 0x5c, 0xec, 0x15, 0x36,
	0x8c, 0xf1, 0x1a, 0xe9, 0x9c, 0xe0, 0xf2, 0xa3, 0xa1, 0x9f, 0xa5, 0x33, 0xbe, 0x5a, 0x9b, 0xf2,
	0xa6, 0xc2, 0x86, 0xed, 0xc6, 0xa2, 0x17, 0xaf, 0x61, 0x52, 0x0d, 0x8a, 0x6e, 0x4c, 0x8d, 0x79,
	0x32, 0x4b, 0x16, 0xa7, 0x2a, 0xbb, 0xa7, 0xdf, 0x4c, 0x8d, 0xa2, 0x80, 0x7f, 0x40, 0xb3, 0x29,
	0xf3, 0xa3, 0x59, 0xb2, 0x48, 0x8b, 0x4c, 0x3e, 0xfc, 0xac, 0x3a, 0xab, 0x1e, 0xdc, 0xcd, 0x7f,
	0x27, 0x90, 0x7d, 0x0f, 0x71, 0x14, 0xfe, 0xea, 0x90, 0x58, 0xbc, 0x01, 0x60, 0x24, 0xd6, 0x5b,
	0xef, 0xba, 0x36, 0x1c, 0x94, 0x16, 0x20, 0xd7, 0x48, 0xfc, 0x79, 0x4f, 0xd4, 0x29, 0x0f, 0x5b,
	0xb1, 0x82, 0x57, 0xa3, 0x03, 0xb5, 0xbd, 0xf7, 0x4c, 0xf9, 0xd1, 0xec, 0x78, 0x91, 0x16, 0x53,
	0x79, 0x38, 0x93, 0x9a, 0x56, 0x07, 0x39, 0xcd, 0xff, 0x24, 0x30, 0x19, 0x1c, 0x51, 0xeb, 0x1a,
	0x42, 0xf1, 0x1e, 0x44, 0xac, 0x5c, 0xb3, 0xad, 0x51, 0xd7, 0xf6, 0xf6, 0xd6, 0x52, 0xb0, 0x96,
	0xa9, 0xe7, 0x51, 0x59, 0xdb, 0x1a, 0xbf, 0x06, 0x2e, 0xde, 0xc2, 0x0b, 0xd7, 0x71, 0xdb, 0xb1,
	0x26, 0x7b, 0x87, 0xba, 0xdc, 0x31, 0x52, 0xa8, 0x22, 0x53, 0xe7, 0x51, 0x58, 0xd9, 0x3b, 0xbc,
	0xde, 0x63, 0xf1, 0x05, 0xa6, 0xe3, 0x04, 0x71, 0x50, 0x16, 0x29, 0x3f, 0x0e, 0xfe, 0x2f, 0x46,
	0xfe, 0x57, 0x71, 0x8c, 0xea, 0x65, 0xf5, 0x1f, 0xb4, 0x48, 0x42, 0xc2, 0x59, 0xef, 0x13, 0x1b,
	0xf6, 0xbb, 0xfc, 0x69, 0x28, 0x2f, 0x95, 0x31, 0xce, 0x4d, 0xb3, 0x71, 0x2a, 0x8d, 0x0f, 0x7c,
	0xda, 0xeb, 0xc5, 0x16, 0x9e, 0x45, 0xc9, 0x8b, 0x77, 0x70, 0x12, 0xb7, 0x62, 0x22, 0x47, 0xf3,
	0xb8, 0x3a, 0x97, 0xe3, 0x36, 0xe6, 0x4f, 0xc4, 0x12, 0x20, 0xb2, 0xeb, 0x6e, 0x4b, 0x8f, 0x78,
	0xa1, 0x3c, 0x09, 0x7f, 0xd8, 0x87, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0xbf, 0x5b, 0xb5, 0x02,
	0xba, 0x02, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// UpdaterClient is the client API for Updater service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type UpdaterClient interface {
	// Updates a test group state object either incrementally or by creating it.
	Update(ctx context.Context, in *UpdateRequest, opts ...grpc.CallOption) (*UpdateResponse, error)
	// Updates a bug state object for a given test group.
	UpdateBugs(ctx context.Context, in *UpdateRequest, opts ...grpc.CallOption) (*UpdateResponse, error)
}

type updaterClient struct {
	cc *grpc.ClientConn
}

func NewUpdaterClient(cc *grpc.ClientConn) UpdaterClient {
	return &updaterClient{cc}
}

func (c *updaterClient) Update(ctx context.Context, in *UpdateRequest, opts ...grpc.CallOption) (*UpdateResponse, error) {
	out := new(UpdateResponse)
	err := c.cc.Invoke(ctx, "/Updater/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *updaterClient) UpdateBugs(ctx context.Context, in *UpdateRequest, opts ...grpc.CallOption) (*UpdateResponse, error) {
	out := new(UpdateResponse)
	err := c.cc.Invoke(ctx, "/Updater/UpdateBugs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// UpdaterServer is the server API for Updater service.
type UpdaterServer interface {
	// Updates a test group state object either incrementally or by creating it.
	Update(context.Context, *UpdateRequest) (*UpdateResponse, error)
	// Updates a bug state object for a given test group.
	UpdateBugs(context.Context, *UpdateRequest) (*UpdateResponse, error)
}

// UnimplementedUpdaterServer can be embedded to have forward compatible implementations.
type UnimplementedUpdaterServer struct {
}

func (*UnimplementedUpdaterServer) Update(ctx context.Context, req *UpdateRequest) (*UpdateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedUpdaterServer) UpdateBugs(ctx context.Context, req *UpdateRequest) (*UpdateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBugs not implemented")
}

func RegisterUpdaterServer(s *grpc.Server, srv UpdaterServer) {
	s.RegisterService(&_Updater_serviceDesc, srv)
}

func _Updater_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UpdaterServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/Updater/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UpdaterServer).Update(ctx, req.(*UpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Updater_UpdateBugs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(UpdaterServer).UpdateBugs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/Updater/UpdateBugs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(UpdaterServer).UpdateBugs(ctx, req.(*UpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Updater_serviceDesc = grpc.ServiceDesc{
	ServiceName: "Updater",
	HandlerType: (*UpdaterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Update",
			Handler:    _Updater_Update_Handler,
		},
		{
			MethodName: "UpdateBugs",
			Handler:    _Updater_UpdateBugs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "updater.proto",
}
