package aws

// AirportToRegion maps airport code to each region.
var AirportToRegion = map[string]string{
	"ARN": "eu-north-1",
	"BAH": "me-south-1",
	"BJS": "cn-north-1",
	"BOM": "ap-south-1",
	"CDG": "eu-west-3",
	"CGK": "ap-southeast-3",
	"CMH": "us-east-2",
	"CPT": "af-south-1",
	"DUB": "eu-west-1",
	"FRA": "eu-central-1",
	"GRU": "sa-east-1",
	"HKG": "ap-east-1",
	"HYD": "ap-south-2",
	"IAD": "us-east-1",
	"ICN": "ap-northeast-2",
	"KIX": "ap-northeast-3",
	"LHR": "eu-west-2",
	"MXP": "eu-south-1",
	"NRT": "ap-northeast-1",
	"PDX": "us-west-2",
	"SFO": "us-west-1",
	"SIN": "ap-southeast-1",
	"SYD": "ap-southeast-2",
	"YUL": "ca-central-1",
	"ZAZ": "eu-south-2",
	"ZHY": "cn-northwest-1",
}

// RegionToAiport maps each region to airport code.
var RegionToAiport = map[string]string{
	"eu-north-1":     "ARN",
	"me-south-1":     "BAH",
	"cn-north-1":     "BJS",
	"ap-south-1":     "BOM",
	"eu-west-3":      "CDG",
	"ap-southeast-3": "CGK",
	"us-east-2":      "CMH",
	"af-south-1":     "CPT",
	"eu-west-1":      "DUB",
	"eu-central-1":   "FRA",
	"sa-east-1":      "GRU",
	"ap-east-1":      "HKG",
	"ap-south-2":     "HYD",
	"us-east-1":      "IAD",
	"ap-northeast-2": "ICN",
	"ap-northeast-3": "KIX",
	"eu-west-2":      "LHR",
	"eu-south-1":     "MXP",
	"ap-northeast-1": "NRT",
	"us-west-2":      "PDX",
	"us-west-1":      "SFO",
	"ap-southeast-1": "SIN",
	"ap-southeast-2": "SYD",
	"ca-central-1":   "YUL",
	"eu-south-2":     "ZAZ",
	"cn-northwest-1": "ZHY",
}
