/*
Copyright 2019 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "knative.dev/eventing-contrib/couchdb/source/pkg/apis/sources/v1alpha1"
	scheme "knative.dev/eventing-contrib/couchdb/source/pkg/client/clientset/versioned/scheme"
)

// CouchDbSourcesGetter has a method to return a CouchDbSourceInterface.
// A group's client should implement this interface.
type CouchDbSourcesGetter interface {
	CouchDbSources(namespace string) CouchDbSourceInterface
}

// CouchDbSourceInterface has methods to work with CouchDbSource resources.
type CouchDbSourceInterface interface {
	Create(*v1alpha1.CouchDbSource) (*v1alpha1.CouchDbSource, error)
	Update(*v1alpha1.CouchDbSource) (*v1alpha1.CouchDbSource, error)
	UpdateStatus(*v1alpha1.CouchDbSource) (*v1alpha1.CouchDbSource, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.CouchDbSource, error)
	List(opts v1.ListOptions) (*v1alpha1.CouchDbSourceList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.CouchDbSource, err error)
	CouchDbSourceExpansion
}

// couchDbSources implements CouchDbSourceInterface
type couchDbSources struct {
	client rest.Interface
	ns     string
}

// newCouchDbSources returns a CouchDbSources
func newCouchDbSources(c *SourcesV1alpha1Client, namespace string) *couchDbSources {
	return &couchDbSources{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the couchDbSource, and returns the corresponding couchDbSource object, and an error if there is any.
func (c *couchDbSources) Get(name string, options v1.GetOptions) (result *v1alpha1.CouchDbSource, err error) {
	result = &v1alpha1.CouchDbSource{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("couchdbsources").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CouchDbSources that match those selectors.
func (c *couchDbSources) List(opts v1.ListOptions) (result *v1alpha1.CouchDbSourceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.CouchDbSourceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("couchdbsources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested couchDbSources.
func (c *couchDbSources) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("couchdbsources").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a couchDbSource and creates it.  Returns the server's representation of the couchDbSource, and an error, if there is any.
func (c *couchDbSources) Create(couchDbSource *v1alpha1.CouchDbSource) (result *v1alpha1.CouchDbSource, err error) {
	result = &v1alpha1.CouchDbSource{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("couchdbsources").
		Body(couchDbSource).
		Do().
		Into(result)
	return
}

// Update takes the representation of a couchDbSource and updates it. Returns the server's representation of the couchDbSource, and an error, if there is any.
func (c *couchDbSources) Update(couchDbSource *v1alpha1.CouchDbSource) (result *v1alpha1.CouchDbSource, err error) {
	result = &v1alpha1.CouchDbSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("couchdbsources").
		Name(couchDbSource.Name).
		Body(couchDbSource).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *couchDbSources) UpdateStatus(couchDbSource *v1alpha1.CouchDbSource) (result *v1alpha1.CouchDbSource, err error) {
	result = &v1alpha1.CouchDbSource{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("couchdbsources").
		Name(couchDbSource.Name).
		SubResource("status").
		Body(couchDbSource).
		Do().
		Into(result)
	return
}

// Delete takes name of the couchDbSource and deletes it. Returns an error if one occurs.
func (c *couchDbSources) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("couchdbsources").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *couchDbSources) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("couchdbsources").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched couchDbSource.
func (c *couchDbSources) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.CouchDbSource, err error) {
	result = &v1alpha1.CouchDbSource{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("couchdbsources").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
