/*
Copyright 2019 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1alpha1 "knative.dev/eventing-contrib/natss/pkg/apis/messaging/v1alpha1"
)

// FakeNatssChannels implements NatssChannelInterface
type FakeNatssChannels struct {
	Fake *FakeMessagingV1alpha1
	ns   string
}

var natsschannelsResource = schema.GroupVersionResource{Group: "messaging.knative.dev", Version: "v1alpha1", Resource: "natsschannels"}

var natsschannelsKind = schema.GroupVersionKind{Group: "messaging.knative.dev", Version: "v1alpha1", Kind: "NatssChannel"}

// Get takes name of the natssChannel, and returns the corresponding natssChannel object, and an error if there is any.
func (c *FakeNatssChannels) Get(name string, options v1.GetOptions) (result *v1alpha1.NatssChannel, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(natsschannelsResource, c.ns, name), &v1alpha1.NatssChannel{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.NatssChannel), err
}

// List takes label and field selectors, and returns the list of NatssChannels that match those selectors.
func (c *FakeNatssChannels) List(opts v1.ListOptions) (result *v1alpha1.NatssChannelList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(natsschannelsResource, natsschannelsKind, c.ns, opts), &v1alpha1.NatssChannelList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.NatssChannelList{ListMeta: obj.(*v1alpha1.NatssChannelList).ListMeta}
	for _, item := range obj.(*v1alpha1.NatssChannelList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested natssChannels.
func (c *FakeNatssChannels) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(natsschannelsResource, c.ns, opts))

}

// Create takes the representation of a natssChannel and creates it.  Returns the server's representation of the natssChannel, and an error, if there is any.
func (c *FakeNatssChannels) Create(natssChannel *v1alpha1.NatssChannel) (result *v1alpha1.NatssChannel, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(natsschannelsResource, c.ns, natssChannel), &v1alpha1.NatssChannel{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.NatssChannel), err
}

// Update takes the representation of a natssChannel and updates it. Returns the server's representation of the natssChannel, and an error, if there is any.
func (c *FakeNatssChannels) Update(natssChannel *v1alpha1.NatssChannel) (result *v1alpha1.NatssChannel, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(natsschannelsResource, c.ns, natssChannel), &v1alpha1.NatssChannel{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.NatssChannel), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeNatssChannels) UpdateStatus(natssChannel *v1alpha1.NatssChannel) (*v1alpha1.NatssChannel, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(natsschannelsResource, "status", c.ns, natssChannel), &v1alpha1.NatssChannel{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.NatssChannel), err
}

// Delete takes name of the natssChannel and deletes it. Returns an error if one occurs.
func (c *FakeNatssChannels) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(natsschannelsResource, c.ns, name), &v1alpha1.NatssChannel{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeNatssChannels) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(natsschannelsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.NatssChannelList{})
	return err
}

// Patch applies the patch and returns the patched natssChannel.
func (c *FakeNatssChannels) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.NatssChannel, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(natsschannelsResource, c.ns, name, pt, data, subresources...), &v1alpha1.NatssChannel{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.NatssChannel), err
}
