/*
Copyright 2019 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "knative.dev/eventing-contrib/prometheus/pkg/apis/sources/v1alpha1"
)

// PrometheusSourceLister helps list PrometheusSources.
type PrometheusSourceLister interface {
	// List lists all PrometheusSources in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.PrometheusSource, err error)
	// PrometheusSources returns an object that can list and get PrometheusSources.
	PrometheusSources(namespace string) PrometheusSourceNamespaceLister
	PrometheusSourceListerExpansion
}

// prometheusSourceLister implements the PrometheusSourceLister interface.
type prometheusSourceLister struct {
	indexer cache.Indexer
}

// NewPrometheusSourceLister returns a new PrometheusSourceLister.
func NewPrometheusSourceLister(indexer cache.Indexer) PrometheusSourceLister {
	return &prometheusSourceLister{indexer: indexer}
}

// List lists all PrometheusSources in the indexer.
func (s *prometheusSourceLister) List(selector labels.Selector) (ret []*v1alpha1.PrometheusSource, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.PrometheusSource))
	})
	return ret, err
}

// PrometheusSources returns an object that can list and get PrometheusSources.
func (s *prometheusSourceLister) PrometheusSources(namespace string) PrometheusSourceNamespaceLister {
	return prometheusSourceNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PrometheusSourceNamespaceLister helps list and get PrometheusSources.
type PrometheusSourceNamespaceLister interface {
	// List lists all PrometheusSources in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.PrometheusSource, err error)
	// Get retrieves the PrometheusSource from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.PrometheusSource, error)
	PrometheusSourceNamespaceListerExpansion
}

// prometheusSourceNamespaceLister implements the PrometheusSourceNamespaceLister
// interface.
type prometheusSourceNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all PrometheusSources in the indexer for a given namespace.
func (s prometheusSourceNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.PrometheusSource, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.PrometheusSource))
	})
	return ret, err
}

// Get retrieves the PrometheusSource from the indexer for a given namespace and name.
func (s prometheusSourceNamespaceLister) Get(name string) (*v1alpha1.PrometheusSource, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("prometheussource"), name)
	}
	return obj.(*v1alpha1.PrometheusSource), nil
}
