/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package logging

import (
	"os"
	"testing"

	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"
)

func TestSpewEncoder(t *testing.T) {
	enc := NewSpewEncoder(zap.NewDevelopmentEncoderConfig())
	stdOut := zapcore.Lock(os.Stdout)
	core := zapcore.NewCore(enc, stdOut, zapcore.InfoLevel)
	logger := zap.New(core, zap.AddCaller(), zap.Development())
	logger.Sugar().Infow("Message", "someStruct", someStruct, zap.Stack("thestack"), "zlast", "a string", "afirst", 25.8)
}
