// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.2
// source: google/devtools/cloudtrace/v2/trace.proto

package cloudtrace

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Indicates whether the message was sent or received.
type Span_TimeEvent_MessageEvent_Type int32

const (
	// Unknown event type.
	Span_TimeEvent_MessageEvent_TYPE_UNSPECIFIED Span_TimeEvent_MessageEvent_Type = 0
	// Indicates a sent message.
	Span_TimeEvent_MessageEvent_SENT Span_TimeEvent_MessageEvent_Type = 1
	// Indicates a received message.
	Span_TimeEvent_MessageEvent_RECEIVED Span_TimeEvent_MessageEvent_Type = 2
)

// Enum value maps for Span_TimeEvent_MessageEvent_Type.
var (
	Span_TimeEvent_MessageEvent_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SENT",
		2: "RECEIVED",
	}
	Span_TimeEvent_MessageEvent_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SENT":             1,
		"RECEIVED":         2,
	}
)

func (x Span_TimeEvent_MessageEvent_Type) Enum() *Span_TimeEvent_MessageEvent_Type {
	p := new(Span_TimeEvent_MessageEvent_Type)
	*p = x
	return p
}

func (x Span_TimeEvent_MessageEvent_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Span_TimeEvent_MessageEvent_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudtrace_v2_trace_proto_enumTypes[0].Descriptor()
}

func (Span_TimeEvent_MessageEvent_Type) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudtrace_v2_trace_proto_enumTypes[0]
}

func (x Span_TimeEvent_MessageEvent_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Span_TimeEvent_MessageEvent_Type.Descriptor instead.
func (Span_TimeEvent_MessageEvent_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{0, 1, 1, 0}
}

// The relationship of the current span relative to the linked span: child,
// parent, or unspecified.
type Span_Link_Type int32

const (
	// The relationship of the two spans is unknown.
	Span_Link_TYPE_UNSPECIFIED Span_Link_Type = 0
	// The linked span is a child of the current span.
	Span_Link_CHILD_LINKED_SPAN Span_Link_Type = 1
	// The linked span is a parent of the current span.
	Span_Link_PARENT_LINKED_SPAN Span_Link_Type = 2
)

// Enum value maps for Span_Link_Type.
var (
	Span_Link_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "CHILD_LINKED_SPAN",
		2: "PARENT_LINKED_SPAN",
	}
	Span_Link_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":   0,
		"CHILD_LINKED_SPAN":  1,
		"PARENT_LINKED_SPAN": 2,
	}
)

func (x Span_Link_Type) Enum() *Span_Link_Type {
	p := new(Span_Link_Type)
	*p = x
	return p
}

func (x Span_Link_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Span_Link_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudtrace_v2_trace_proto_enumTypes[1].Descriptor()
}

func (Span_Link_Type) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudtrace_v2_trace_proto_enumTypes[1]
}

func (x Span_Link_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Span_Link_Type.Descriptor instead.
func (Span_Link_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{0, 3, 0}
}

// A span represents a single operation within a trace. Spans can be
// nested to form a trace tree. Often, a trace contains a root span
// that describes the end-to-end latency, and one or more subspans for
// its sub-operations. A trace can also contain multiple root spans,
// or none at all. Spans do not need to be contiguous&mdash;there may be
// gaps or overlaps between spans in a trace.
type Span struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the span in the following format:
	//
	//     projects/[PROJECT_ID]/traces/[TRACE_ID]/spans/[SPAN_ID]
	//
	// [TRACE_ID] is a unique identifier for a trace within a project;
	// it is a 32-character hexadecimal encoding of a 16-byte array.
	//
	// [SPAN_ID] is a unique identifier for a span within a trace; it
	// is a 16-character hexadecimal encoding of an 8-byte array.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The [SPAN_ID] portion of the span's resource name.
	SpanId string `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// The [SPAN_ID] of this span's parent span. If this is a root span,
	// then this field must be empty.
	ParentSpanId string `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// A description of the span's operation (up to 128 bytes).
	// Stackdriver Trace displays the description in the
	// Google Cloud Platform Console.
	// For example, the display name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name within an application and at the same call point.
	// This makes it easier to correlate spans in different traces.
	DisplayName *TruncatableString `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The start time of the span. On the client side, this is the time kept by
	// the local machine where the span execution starts. On the server side, this
	// is the time when the server's application handler starts running.
	StartTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time of the span. On the client side, this is the time kept by
	// the local machine where the span execution ends. On the server side, this
	// is the time when the server application handler stops running.
	EndTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// A set of attributes on the span. You can have up to 32 attributes per
	// span.
	Attributes *Span_Attributes `protobuf:"bytes,7,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// Stack trace captured at the start of the span.
	StackTrace *StackTrace `protobuf:"bytes,8,opt,name=stack_trace,json=stackTrace,proto3" json:"stack_trace,omitempty"`
	// A set of time events. You can have up to 32 annotations and 128 message
	// events per span.
	TimeEvents *Span_TimeEvents `protobuf:"bytes,9,opt,name=time_events,json=timeEvents,proto3" json:"time_events,omitempty"`
	// Links associated with the span. You can have up to 128 links per Span.
	Links *Span_Links `protobuf:"bytes,10,opt,name=links,proto3" json:"links,omitempty"`
	// Optional. The final status for this span.
	Status *status.Status `protobuf:"bytes,11,opt,name=status,proto3" json:"status,omitempty"`
	// Optional. Set this parameter to indicate whether this span is in
	// the same process as its parent. If you do not set this parameter,
	// Stackdriver Trace is unable to take advantage of this helpful
	// information.
	SameProcessAsParentSpan *wrappers.BoolValue `protobuf:"bytes,12,opt,name=same_process_as_parent_span,json=sameProcessAsParentSpan,proto3" json:"same_process_as_parent_span,omitempty"`
	// Optional. The number of child spans that were generated while this span
	// was active. If set, allows implementation to detect missing child spans.
	ChildSpanCount *wrappers.Int32Value `protobuf:"bytes,13,opt,name=child_span_count,json=childSpanCount,proto3" json:"child_span_count,omitempty"`
}

func (x *Span) Reset() {
	*x = Span{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span) ProtoMessage() {}

func (x *Span) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span.ProtoReflect.Descriptor instead.
func (*Span) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{0}
}

func (x *Span) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Span) GetSpanId() string {
	if x != nil {
		return x.SpanId
	}
	return ""
}

func (x *Span) GetParentSpanId() string {
	if x != nil {
		return x.ParentSpanId
	}
	return ""
}

func (x *Span) GetDisplayName() *TruncatableString {
	if x != nil {
		return x.DisplayName
	}
	return nil
}

func (x *Span) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Span) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Span) GetAttributes() *Span_Attributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Span) GetStackTrace() *StackTrace {
	if x != nil {
		return x.StackTrace
	}
	return nil
}

func (x *Span) GetTimeEvents() *Span_TimeEvents {
	if x != nil {
		return x.TimeEvents
	}
	return nil
}

func (x *Span) GetLinks() *Span_Links {
	if x != nil {
		return x.Links
	}
	return nil
}

func (x *Span) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Span) GetSameProcessAsParentSpan() *wrappers.BoolValue {
	if x != nil {
		return x.SameProcessAsParentSpan
	}
	return nil
}

func (x *Span) GetChildSpanCount() *wrappers.Int32Value {
	if x != nil {
		return x.ChildSpanCount
	}
	return nil
}

// The allowed types for [VALUE] in a `[KEY]:[VALUE]` attribute.
type AttributeValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the value.
	//
	// Types that are assignable to Value:
	//	*AttributeValue_StringValue
	//	*AttributeValue_IntValue
	//	*AttributeValue_BoolValue
	Value isAttributeValue_Value `protobuf_oneof:"value"`
}

func (x *AttributeValue) Reset() {
	*x = AttributeValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeValue) ProtoMessage() {}

func (x *AttributeValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeValue.ProtoReflect.Descriptor instead.
func (*AttributeValue) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{1}
}

func (m *AttributeValue) GetValue() isAttributeValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *AttributeValue) GetStringValue() *TruncatableString {
	if x, ok := x.GetValue().(*AttributeValue_StringValue); ok {
		return x.StringValue
	}
	return nil
}

func (x *AttributeValue) GetIntValue() int64 {
	if x, ok := x.GetValue().(*AttributeValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *AttributeValue) GetBoolValue() bool {
	if x, ok := x.GetValue().(*AttributeValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

type isAttributeValue_Value interface {
	isAttributeValue_Value()
}

type AttributeValue_StringValue struct {
	// A string up to 256 bytes long.
	StringValue *TruncatableString `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type AttributeValue_IntValue struct {
	// A 64-bit signed integer.
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}

type AttributeValue_BoolValue struct {
	// A Boolean value represented by `true` or `false`.
	BoolValue bool `protobuf:"varint,3,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

func (*AttributeValue_StringValue) isAttributeValue_Value() {}

func (*AttributeValue_IntValue) isAttributeValue_Value() {}

func (*AttributeValue_BoolValue) isAttributeValue_Value() {}

// A call stack appearing in a trace.
type StackTrace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stack frames in this stack trace. A maximum of 128 frames are allowed.
	StackFrames *StackTrace_StackFrames `protobuf:"bytes,1,opt,name=stack_frames,json=stackFrames,proto3" json:"stack_frames,omitempty"`
	// The hash ID is used to conserve network bandwidth for duplicate
	// stack traces within a single trace.
	//
	// Often multiple spans will have identical stack traces.
	// The first occurrence of a stack trace should contain both the
	// `stackFrame` content and a value in `stackTraceHashId`.
	//
	// Subsequent spans within the same request can refer
	// to that stack trace by only setting `stackTraceHashId`.
	StackTraceHashId int64 `protobuf:"varint,2,opt,name=stack_trace_hash_id,json=stackTraceHashId,proto3" json:"stack_trace_hash_id,omitempty"`
}

func (x *StackTrace) Reset() {
	*x = StackTrace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StackTrace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackTrace) ProtoMessage() {}

func (x *StackTrace) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackTrace.ProtoReflect.Descriptor instead.
func (*StackTrace) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{2}
}

func (x *StackTrace) GetStackFrames() *StackTrace_StackFrames {
	if x != nil {
		return x.StackFrames
	}
	return nil
}

func (x *StackTrace) GetStackTraceHashId() int64 {
	if x != nil {
		return x.StackTraceHashId
	}
	return 0
}

// Binary module.
type Module struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For example: main binary, kernel modules, and dynamic libraries
	// such as libc.so, sharedlib.so (up to 256 bytes).
	Module *TruncatableString `protobuf:"bytes,1,opt,name=module,proto3" json:"module,omitempty"`
	// A unique identifier for the module, usually a hash of its
	// contents (up to 128 bytes).
	BuildId *TruncatableString `protobuf:"bytes,2,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
}

func (x *Module) Reset() {
	*x = Module{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Module) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Module) ProtoMessage() {}

func (x *Module) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Module.ProtoReflect.Descriptor instead.
func (*Module) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{3}
}

func (x *Module) GetModule() *TruncatableString {
	if x != nil {
		return x.Module
	}
	return nil
}

func (x *Module) GetBuildId() *TruncatableString {
	if x != nil {
		return x.BuildId
	}
	return nil
}

// Represents a string that might be shortened to a specified length.
type TruncatableString struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The shortened string. For example, if the original string is 500
	// bytes long and the limit of the string is 128 bytes, then
	// `value` contains the first 128 bytes of the 500-byte string.
	//
	// Truncation always happens on a UTF8 character boundary. If there
	// are multi-byte characters in the string, then the length of the
	// shortened string might be less than the size limit.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The number of bytes removed from the original string. If this
	// value is 0, then the string was not shortened.
	TruncatedByteCount int32 `protobuf:"varint,2,opt,name=truncated_byte_count,json=truncatedByteCount,proto3" json:"truncated_byte_count,omitempty"`
}

func (x *TruncatableString) Reset() {
	*x = TruncatableString{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TruncatableString) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TruncatableString) ProtoMessage() {}

func (x *TruncatableString) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TruncatableString.ProtoReflect.Descriptor instead.
func (*TruncatableString) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{4}
}

func (x *TruncatableString) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *TruncatableString) GetTruncatedByteCount() int32 {
	if x != nil {
		return x.TruncatedByteCount
	}
	return 0
}

// A set of attributes, each in the format `[KEY]:[VALUE]`.
type Span_Attributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of attributes. Each attribute's key can be up to 128 bytes
	// long. The value can be a string up to 256 bytes, a signed 64-bit integer,
	// or the Boolean values `true` and `false`. For example:
	//
	//     "/instance_id": "my-instance"
	//     "/http/user_agent": ""
	//     "/http/request_bytes": 300
	//     "abc.com/myattribute": true
	AttributeMap map[string]*AttributeValue `protobuf:"bytes,1,rep,name=attribute_map,json=attributeMap,proto3" json:"attribute_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The number of attributes that were discarded. Attributes can be discarded
	// because their keys are too long or because there are too many attributes.
	// If this value is 0 then all attributes are valid.
	DroppedAttributesCount int32 `protobuf:"varint,2,opt,name=dropped_attributes_count,json=droppedAttributesCount,proto3" json:"dropped_attributes_count,omitempty"`
}

func (x *Span_Attributes) Reset() {
	*x = Span_Attributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_Attributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_Attributes) ProtoMessage() {}

func (x *Span_Attributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_Attributes.ProtoReflect.Descriptor instead.
func (*Span_Attributes) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Span_Attributes) GetAttributeMap() map[string]*AttributeValue {
	if x != nil {
		return x.AttributeMap
	}
	return nil
}

func (x *Span_Attributes) GetDroppedAttributesCount() int32 {
	if x != nil {
		return x.DroppedAttributesCount
	}
	return 0
}

// A time-stamped annotation or message event in the Span.
type Span_TimeEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp indicating the time the event occurred.
	Time *timestamp.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// A `TimeEvent` can contain either an `Annotation` object or a
	// `MessageEvent` object, but not both.
	//
	// Types that are assignable to Value:
	//	*Span_TimeEvent_Annotation_
	//	*Span_TimeEvent_MessageEvent_
	Value isSpan_TimeEvent_Value `protobuf_oneof:"value"`
}

func (x *Span_TimeEvent) Reset() {
	*x = Span_TimeEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_TimeEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_TimeEvent) ProtoMessage() {}

func (x *Span_TimeEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_TimeEvent.ProtoReflect.Descriptor instead.
func (*Span_TimeEvent) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Span_TimeEvent) GetTime() *timestamp.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (m *Span_TimeEvent) GetValue() isSpan_TimeEvent_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Span_TimeEvent) GetAnnotation() *Span_TimeEvent_Annotation {
	if x, ok := x.GetValue().(*Span_TimeEvent_Annotation_); ok {
		return x.Annotation
	}
	return nil
}

func (x *Span_TimeEvent) GetMessageEvent() *Span_TimeEvent_MessageEvent {
	if x, ok := x.GetValue().(*Span_TimeEvent_MessageEvent_); ok {
		return x.MessageEvent
	}
	return nil
}

type isSpan_TimeEvent_Value interface {
	isSpan_TimeEvent_Value()
}

type Span_TimeEvent_Annotation_ struct {
	// Text annotation with a set of attributes.
	Annotation *Span_TimeEvent_Annotation `protobuf:"bytes,2,opt,name=annotation,proto3,oneof"`
}

type Span_TimeEvent_MessageEvent_ struct {
	// An event describing a message sent/received between Spans.
	MessageEvent *Span_TimeEvent_MessageEvent `protobuf:"bytes,3,opt,name=message_event,json=messageEvent,proto3,oneof"`
}

func (*Span_TimeEvent_Annotation_) isSpan_TimeEvent_Value() {}

func (*Span_TimeEvent_MessageEvent_) isSpan_TimeEvent_Value() {}

// A collection of `TimeEvent`s. A `TimeEvent` is a time-stamped annotation
// on the span, consisting of either user-supplied key:value pairs, or
// details of a message sent/received between Spans.
type Span_TimeEvents struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of `TimeEvent`s.
	TimeEvent []*Span_TimeEvent `protobuf:"bytes,1,rep,name=time_event,json=timeEvent,proto3" json:"time_event,omitempty"`
	// The number of dropped annotations in all the included time events.
	// If the value is 0, then no annotations were dropped.
	DroppedAnnotationsCount int32 `protobuf:"varint,2,opt,name=dropped_annotations_count,json=droppedAnnotationsCount,proto3" json:"dropped_annotations_count,omitempty"`
	// The number of dropped message events in all the included time events.
	// If the value is 0, then no message events were dropped.
	DroppedMessageEventsCount int32 `protobuf:"varint,3,opt,name=dropped_message_events_count,json=droppedMessageEventsCount,proto3" json:"dropped_message_events_count,omitempty"`
}

func (x *Span_TimeEvents) Reset() {
	*x = Span_TimeEvents{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_TimeEvents) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_TimeEvents) ProtoMessage() {}

func (x *Span_TimeEvents) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_TimeEvents.ProtoReflect.Descriptor instead.
func (*Span_TimeEvents) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Span_TimeEvents) GetTimeEvent() []*Span_TimeEvent {
	if x != nil {
		return x.TimeEvent
	}
	return nil
}

func (x *Span_TimeEvents) GetDroppedAnnotationsCount() int32 {
	if x != nil {
		return x.DroppedAnnotationsCount
	}
	return 0
}

func (x *Span_TimeEvents) GetDroppedMessageEventsCount() int32 {
	if x != nil {
		return x.DroppedMessageEventsCount
	}
	return 0
}

// A pointer from the current span to another span in the same trace or in a
// different trace. For example, this can be used in batching operations,
// where a single batch handler processes multiple requests from different
// traces or when the handler receives a request from a different project.
type Span_Link struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [TRACE_ID] for a trace within a project.
	TraceId string `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// The [SPAN_ID] for a span within a trace.
	SpanId string `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// The relationship of the current span relative to the linked span.
	Type Span_Link_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.devtools.cloudtrace.v2.Span_Link_Type" json:"type,omitempty"`
	// A set of attributes on the link. You have have up to  32 attributes per
	// link.
	Attributes *Span_Attributes `protobuf:"bytes,4,opt,name=attributes,proto3" json:"attributes,omitempty"`
}

func (x *Span_Link) Reset() {
	*x = Span_Link{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_Link) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_Link) ProtoMessage() {}

func (x *Span_Link) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_Link.ProtoReflect.Descriptor instead.
func (*Span_Link) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Span_Link) GetTraceId() string {
	if x != nil {
		return x.TraceId
	}
	return ""
}

func (x *Span_Link) GetSpanId() string {
	if x != nil {
		return x.SpanId
	}
	return ""
}

func (x *Span_Link) GetType() Span_Link_Type {
	if x != nil {
		return x.Type
	}
	return Span_Link_TYPE_UNSPECIFIED
}

func (x *Span_Link) GetAttributes() *Span_Attributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// A collection of links, which are references from this span to a span
// in the same or different trace.
type Span_Links struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of links.
	Link []*Span_Link `protobuf:"bytes,1,rep,name=link,proto3" json:"link,omitempty"`
	// The number of dropped links after the maximum size was enforced. If
	// this value is 0, then no links were dropped.
	DroppedLinksCount int32 `protobuf:"varint,2,opt,name=dropped_links_count,json=droppedLinksCount,proto3" json:"dropped_links_count,omitempty"`
}

func (x *Span_Links) Reset() {
	*x = Span_Links{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_Links) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_Links) ProtoMessage() {}

func (x *Span_Links) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_Links.ProtoReflect.Descriptor instead.
func (*Span_Links) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Span_Links) GetLink() []*Span_Link {
	if x != nil {
		return x.Link
	}
	return nil
}

func (x *Span_Links) GetDroppedLinksCount() int32 {
	if x != nil {
		return x.DroppedLinksCount
	}
	return 0
}

// Text annotation with a set of attributes.
type Span_TimeEvent_Annotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-supplied message describing the event. The maximum length for
	// the description is 256 bytes.
	Description *TruncatableString `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// A set of attributes on the annotation. You can have up to 4 attributes
	// per Annotation.
	Attributes *Span_Attributes `protobuf:"bytes,2,opt,name=attributes,proto3" json:"attributes,omitempty"`
}

func (x *Span_TimeEvent_Annotation) Reset() {
	*x = Span_TimeEvent_Annotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_TimeEvent_Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_TimeEvent_Annotation) ProtoMessage() {}

func (x *Span_TimeEvent_Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_TimeEvent_Annotation.ProtoReflect.Descriptor instead.
func (*Span_TimeEvent_Annotation) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Span_TimeEvent_Annotation) GetDescription() *TruncatableString {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *Span_TimeEvent_Annotation) GetAttributes() *Span_Attributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// An event describing a message sent/received between Spans.
type Span_TimeEvent_MessageEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of MessageEvent. Indicates whether the message was sent or
	// received.
	Type Span_TimeEvent_MessageEvent_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.devtools.cloudtrace.v2.Span_TimeEvent_MessageEvent_Type" json:"type,omitempty"`
	// An identifier for the MessageEvent's message that can be used to match
	// SENT and RECEIVED MessageEvents. It is recommended to be unique within
	// a Span.
	Id int64 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// The number of uncompressed bytes sent or received.
	UncompressedSizeBytes int64 `protobuf:"varint,3,opt,name=uncompressed_size_bytes,json=uncompressedSizeBytes,proto3" json:"uncompressed_size_bytes,omitempty"`
	// The number of compressed bytes sent or received. If missing assumed to
	// be the same size as uncompressed.
	CompressedSizeBytes int64 `protobuf:"varint,4,opt,name=compressed_size_bytes,json=compressedSizeBytes,proto3" json:"compressed_size_bytes,omitempty"`
}

func (x *Span_TimeEvent_MessageEvent) Reset() {
	*x = Span_TimeEvent_MessageEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Span_TimeEvent_MessageEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span_TimeEvent_MessageEvent) ProtoMessage() {}

func (x *Span_TimeEvent_MessageEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span_TimeEvent_MessageEvent.ProtoReflect.Descriptor instead.
func (*Span_TimeEvent_MessageEvent) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{0, 1, 1}
}

func (x *Span_TimeEvent_MessageEvent) GetType() Span_TimeEvent_MessageEvent_Type {
	if x != nil {
		return x.Type
	}
	return Span_TimeEvent_MessageEvent_TYPE_UNSPECIFIED
}

func (x *Span_TimeEvent_MessageEvent) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Span_TimeEvent_MessageEvent) GetUncompressedSizeBytes() int64 {
	if x != nil {
		return x.UncompressedSizeBytes
	}
	return 0
}

func (x *Span_TimeEvent_MessageEvent) GetCompressedSizeBytes() int64 {
	if x != nil {
		return x.CompressedSizeBytes
	}
	return 0
}

// Represents a single stack frame in a stack trace.
type StackTrace_StackFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fully-qualified name that uniquely identifies the function or
	// method that is active in this frame (up to 1024 bytes).
	FunctionName *TruncatableString `protobuf:"bytes,1,opt,name=function_name,json=functionName,proto3" json:"function_name,omitempty"`
	// An un-mangled function name, if `function_name` is
	// [mangled](http://www.avabodh.com/cxxin/namemangling.html). The name can
	// be fully-qualified (up to 1024 bytes).
	OriginalFunctionName *TruncatableString `protobuf:"bytes,2,opt,name=original_function_name,json=originalFunctionName,proto3" json:"original_function_name,omitempty"`
	// The name of the source file where the function call appears (up to 256
	// bytes).
	FileName *TruncatableString `protobuf:"bytes,3,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// The line number in `file_name` where the function call appears.
	LineNumber int64 `protobuf:"varint,4,opt,name=line_number,json=lineNumber,proto3" json:"line_number,omitempty"`
	// The column number where the function call appears, if available.
	// This is important in JavaScript because of its anonymous functions.
	ColumnNumber int64 `protobuf:"varint,5,opt,name=column_number,json=columnNumber,proto3" json:"column_number,omitempty"`
	// The binary module from where the code was loaded.
	LoadModule *Module `protobuf:"bytes,6,opt,name=load_module,json=loadModule,proto3" json:"load_module,omitempty"`
	// The version of the deployed source code (up to 128 bytes).
	SourceVersion *TruncatableString `protobuf:"bytes,7,opt,name=source_version,json=sourceVersion,proto3" json:"source_version,omitempty"`
}

func (x *StackTrace_StackFrame) Reset() {
	*x = StackTrace_StackFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StackTrace_StackFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackTrace_StackFrame) ProtoMessage() {}

func (x *StackTrace_StackFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackTrace_StackFrame.ProtoReflect.Descriptor instead.
func (*StackTrace_StackFrame) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{2, 0}
}

func (x *StackTrace_StackFrame) GetFunctionName() *TruncatableString {
	if x != nil {
		return x.FunctionName
	}
	return nil
}

func (x *StackTrace_StackFrame) GetOriginalFunctionName() *TruncatableString {
	if x != nil {
		return x.OriginalFunctionName
	}
	return nil
}

func (x *StackTrace_StackFrame) GetFileName() *TruncatableString {
	if x != nil {
		return x.FileName
	}
	return nil
}

func (x *StackTrace_StackFrame) GetLineNumber() int64 {
	if x != nil {
		return x.LineNumber
	}
	return 0
}

func (x *StackTrace_StackFrame) GetColumnNumber() int64 {
	if x != nil {
		return x.ColumnNumber
	}
	return 0
}

func (x *StackTrace_StackFrame) GetLoadModule() *Module {
	if x != nil {
		return x.LoadModule
	}
	return nil
}

func (x *StackTrace_StackFrame) GetSourceVersion() *TruncatableString {
	if x != nil {
		return x.SourceVersion
	}
	return nil
}

// A collection of stack frames, which can be truncated.
type StackTrace_StackFrames struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Stack frames in this call stack.
	Frame []*StackTrace_StackFrame `protobuf:"bytes,1,rep,name=frame,proto3" json:"frame,omitempty"`
	// The number of stack frames that were dropped because there
	// were too many stack frames.
	// If this value is 0, then no stack frames were dropped.
	DroppedFramesCount int32 `protobuf:"varint,2,opt,name=dropped_frames_count,json=droppedFramesCount,proto3" json:"dropped_frames_count,omitempty"`
}

func (x *StackTrace_StackFrames) Reset() {
	*x = StackTrace_StackFrames{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StackTrace_StackFrames) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackTrace_StackFrames) ProtoMessage() {}

func (x *StackTrace_StackFrames) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackTrace_StackFrames.ProtoReflect.Descriptor instead.
func (*StackTrace_StackFrames) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP(), []int{2, 1}
}

func (x *StackTrace_StackFrames) GetFrame() []*StackTrace_StackFrame {
	if x != nil {
		return x.Frame
	}
	return nil
}

func (x *StackTrace_StackFrames) GetDroppedFramesCount() int32 {
	if x != nil {
		return x.DroppedFramesCount
	}
	return 0
}

var File_google_devtools_cloudtrace_v2_trace_proto protoreflect.FileDescriptor

var file_google_devtools_cloudtrace_v2_trace_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2f, 0x76, 0x32, 0x2f,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70,
	0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf7,
	0x13, 0x0a, 0x04, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1c, 0x0a, 0x07, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x70, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x24,
	0x0a, 0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x70,
	0x61, 0x6e, 0x49, 0x64, 0x12, 0x58, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63,
	0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x0a, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x70, 0x61, 0x6e, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x0a,
	0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x4f, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x0a, 0x74, 0x69, 0x6d,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5d, 0x0a, 0x1b, 0x73, 0x61, 0x6d,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x61, 0x73, 0x5f, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x17, 0x73, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x41, 0x73, 0x50, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x4a, 0x0a, 0x10, 0x63, 0x68, 0x69, 0x6c,
	0x64, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x53, 0x70, 0x61, 0x6e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x9d, 0x02, 0x0a, 0x0a, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x12, 0x65, 0x0a, 0x0d, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x70, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x38, 0x0a, 0x18, 0x64, 0x72,
	0x6f, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x16, 0x64, 0x72,
	0x6f, 0x70, 0x70, 0x65, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x6e, 0x0a, 0x11, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x43, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0xce, 0x05, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69,
	0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61,
	0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x1a, 0xb0, 0x01, 0x0a, 0x0a, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x52, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x1a, 0x95, 0x02, 0x0a, 0x0c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x36, 0x0a, 0x17, 0x75, 0x6e,
	0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x75, 0x6e, 0x63,
	0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x53, 0x69, 0x7a,
	0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x34, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56, 0x45, 0x44, 0x10, 0x02, 0x42, 0x07, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xd7, 0x01, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x19, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3f,
	0x0a, 0x1c, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x19, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a,
	0x9a, 0x02, 0x0a, 0x04, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63,
	0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x70, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e,
	0x4c, 0x69, 0x6e, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x4e, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x22,
	0x4b, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a,
	0x11, 0x43, 0x48, 0x49, 0x4c, 0x44, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x45, 0x44, 0x5f, 0x53, 0x50,
	0x41, 0x4e, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x41, 0x52, 0x45, 0x4e, 0x54, 0x5f, 0x4c,
	0x49, 0x4e, 0x4b, 0x45, 0x44, 0x5f, 0x53, 0x50, 0x41, 0x4e, 0x10, 0x02, 0x1a, 0x75, 0x0a, 0x05,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3c, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6c,
	0x69, 0x6e, 0x6b, 0x12, 0x2e, 0x0a, 0x13, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x11, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x3a, 0x53, 0xea, 0x41, 0x50, 0x0a, 0x1e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74,
	0x72, 0x61, 0x63, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x72, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x70, 0x61, 0x6e,
	0x73, 0x2f, 0x7b, 0x73, 0x70, 0x61, 0x6e, 0x7d, 0x22, 0xb0, 0x01, 0x0a, 0x0e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x55, 0x0a, 0x0c, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xa7, 0x06, 0x0a, 0x0a,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x58, 0x0a, 0x0c, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x63,
	0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x13, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x10, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63, 0x65, 0x48, 0x61, 0x73,
	0x68, 0x49, 0x64, 0x1a, 0x81, 0x04, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72, 0x61,
	0x6d, 0x65, 0x12, 0x55, 0x0a, 0x0d, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0c, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x66, 0x0a, 0x16, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x14, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x4d, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x6c, 0x69, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x46, 0x0a, 0x0b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x52, 0x0a, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x57,
	0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x8b, 0x01, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x63,
	0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x05, 0x66, 0x72, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x72, 0x61, 0x63,
	0x65, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x05, 0x66, 0x72,
	0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x66,
	0x72, 0x61, 0x6d, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x12, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x9f, 0x01, 0x0a, 0x06, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x12, 0x48, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x4b, 0x0a, 0x08, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x75,
	0x6e, 0x63, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x07,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x49, 0x64, 0x22, 0x5b, 0x0a, 0x11, 0x54, 0x72, 0x75, 0x6e, 0x63,
	0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x12, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x42, 0xaa, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x32, 0x42, 0x0a, 0x54, 0x72, 0x61, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x2f, 0x76, 0x32, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63,
	0x65, 0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x54, 0x72, 0x61, 0x63, 0x65, 0x5c, 0x56,
	0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_cloudtrace_v2_trace_proto_rawDescOnce sync.Once
	file_google_devtools_cloudtrace_v2_trace_proto_rawDescData = file_google_devtools_cloudtrace_v2_trace_proto_rawDesc
)

func file_google_devtools_cloudtrace_v2_trace_proto_rawDescGZIP() []byte {
	file_google_devtools_cloudtrace_v2_trace_proto_rawDescOnce.Do(func() {
		file_google_devtools_cloudtrace_v2_trace_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_cloudtrace_v2_trace_proto_rawDescData)
	})
	return file_google_devtools_cloudtrace_v2_trace_proto_rawDescData
}

var file_google_devtools_cloudtrace_v2_trace_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_devtools_cloudtrace_v2_trace_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_devtools_cloudtrace_v2_trace_proto_goTypes = []interface{}{
	(Span_TimeEvent_MessageEvent_Type)(0), // 0: google.devtools.cloudtrace.v2.Span.TimeEvent.MessageEvent.Type
	(Span_Link_Type)(0),                   // 1: google.devtools.cloudtrace.v2.Span.Link.Type
	(*Span)(nil),                          // 2: google.devtools.cloudtrace.v2.Span
	(*AttributeValue)(nil),                // 3: google.devtools.cloudtrace.v2.AttributeValue
	(*StackTrace)(nil),                    // 4: google.devtools.cloudtrace.v2.StackTrace
	(*Module)(nil),                        // 5: google.devtools.cloudtrace.v2.Module
	(*TruncatableString)(nil),             // 6: google.devtools.cloudtrace.v2.TruncatableString
	(*Span_Attributes)(nil),               // 7: google.devtools.cloudtrace.v2.Span.Attributes
	(*Span_TimeEvent)(nil),                // 8: google.devtools.cloudtrace.v2.Span.TimeEvent
	(*Span_TimeEvents)(nil),               // 9: google.devtools.cloudtrace.v2.Span.TimeEvents
	(*Span_Link)(nil),                     // 10: google.devtools.cloudtrace.v2.Span.Link
	(*Span_Links)(nil),                    // 11: google.devtools.cloudtrace.v2.Span.Links
	nil,                                   // 12: google.devtools.cloudtrace.v2.Span.Attributes.AttributeMapEntry
	(*Span_TimeEvent_Annotation)(nil),     // 13: google.devtools.cloudtrace.v2.Span.TimeEvent.Annotation
	(*Span_TimeEvent_MessageEvent)(nil),   // 14: google.devtools.cloudtrace.v2.Span.TimeEvent.MessageEvent
	(*StackTrace_StackFrame)(nil),         // 15: google.devtools.cloudtrace.v2.StackTrace.StackFrame
	(*StackTrace_StackFrames)(nil),        // 16: google.devtools.cloudtrace.v2.StackTrace.StackFrames
	(*timestamp.Timestamp)(nil),           // 17: google.protobuf.Timestamp
	(*status.Status)(nil),                 // 18: google.rpc.Status
	(*wrappers.BoolValue)(nil),            // 19: google.protobuf.BoolValue
	(*wrappers.Int32Value)(nil),           // 20: google.protobuf.Int32Value
}
var file_google_devtools_cloudtrace_v2_trace_proto_depIdxs = []int32{
	6,  // 0: google.devtools.cloudtrace.v2.Span.display_name:type_name -> google.devtools.cloudtrace.v2.TruncatableString
	17, // 1: google.devtools.cloudtrace.v2.Span.start_time:type_name -> google.protobuf.Timestamp
	17, // 2: google.devtools.cloudtrace.v2.Span.end_time:type_name -> google.protobuf.Timestamp
	7,  // 3: google.devtools.cloudtrace.v2.Span.attributes:type_name -> google.devtools.cloudtrace.v2.Span.Attributes
	4,  // 4: google.devtools.cloudtrace.v2.Span.stack_trace:type_name -> google.devtools.cloudtrace.v2.StackTrace
	9,  // 5: google.devtools.cloudtrace.v2.Span.time_events:type_name -> google.devtools.cloudtrace.v2.Span.TimeEvents
	11, // 6: google.devtools.cloudtrace.v2.Span.links:type_name -> google.devtools.cloudtrace.v2.Span.Links
	18, // 7: google.devtools.cloudtrace.v2.Span.status:type_name -> google.rpc.Status
	19, // 8: google.devtools.cloudtrace.v2.Span.same_process_as_parent_span:type_name -> google.protobuf.BoolValue
	20, // 9: google.devtools.cloudtrace.v2.Span.child_span_count:type_name -> google.protobuf.Int32Value
	6,  // 10: google.devtools.cloudtrace.v2.AttributeValue.string_value:type_name -> google.devtools.cloudtrace.v2.TruncatableString
	16, // 11: google.devtools.cloudtrace.v2.StackTrace.stack_frames:type_name -> google.devtools.cloudtrace.v2.StackTrace.StackFrames
	6,  // 12: google.devtools.cloudtrace.v2.Module.module:type_name -> google.devtools.cloudtrace.v2.TruncatableString
	6,  // 13: google.devtools.cloudtrace.v2.Module.build_id:type_name -> google.devtools.cloudtrace.v2.TruncatableString
	12, // 14: google.devtools.cloudtrace.v2.Span.Attributes.attribute_map:type_name -> google.devtools.cloudtrace.v2.Span.Attributes.AttributeMapEntry
	17, // 15: google.devtools.cloudtrace.v2.Span.TimeEvent.time:type_name -> google.protobuf.Timestamp
	13, // 16: google.devtools.cloudtrace.v2.Span.TimeEvent.annotation:type_name -> google.devtools.cloudtrace.v2.Span.TimeEvent.Annotation
	14, // 17: google.devtools.cloudtrace.v2.Span.TimeEvent.message_event:type_name -> google.devtools.cloudtrace.v2.Span.TimeEvent.MessageEvent
	8,  // 18: google.devtools.cloudtrace.v2.Span.TimeEvents.time_event:type_name -> google.devtools.cloudtrace.v2.Span.TimeEvent
	1,  // 19: google.devtools.cloudtrace.v2.Span.Link.type:type_name -> google.devtools.cloudtrace.v2.Span.Link.Type
	7,  // 20: google.devtools.cloudtrace.v2.Span.Link.attributes:type_name -> google.devtools.cloudtrace.v2.Span.Attributes
	10, // 21: google.devtools.cloudtrace.v2.Span.Links.link:type_name -> google.devtools.cloudtrace.v2.Span.Link
	3,  // 22: google.devtools.cloudtrace.v2.Span.Attributes.AttributeMapEntry.value:type_name -> google.devtools.cloudtrace.v2.AttributeValue
	6,  // 23: google.devtools.cloudtrace.v2.Span.TimeEvent.Annotation.description:type_name -> google.devtools.cloudtrace.v2.TruncatableString
	7,  // 24: google.devtools.cloudtrace.v2.Span.TimeEvent.Annotation.attributes:type_name -> google.devtools.cloudtrace.v2.Span.Attributes
	0,  // 25: google.devtools.cloudtrace.v2.Span.TimeEvent.MessageEvent.type:type_name -> google.devtools.cloudtrace.v2.Span.TimeEvent.MessageEvent.Type
	6,  // 26: google.devtools.cloudtrace.v2.StackTrace.StackFrame.function_name:type_name -> google.devtools.cloudtrace.v2.TruncatableString
	6,  // 27: google.devtools.cloudtrace.v2.StackTrace.StackFrame.original_function_name:type_name -> google.devtools.cloudtrace.v2.TruncatableString
	6,  // 28: google.devtools.cloudtrace.v2.StackTrace.StackFrame.file_name:type_name -> google.devtools.cloudtrace.v2.TruncatableString
	5,  // 29: google.devtools.cloudtrace.v2.StackTrace.StackFrame.load_module:type_name -> google.devtools.cloudtrace.v2.Module
	6,  // 30: google.devtools.cloudtrace.v2.StackTrace.StackFrame.source_version:type_name -> google.devtools.cloudtrace.v2.TruncatableString
	15, // 31: google.devtools.cloudtrace.v2.StackTrace.StackFrames.frame:type_name -> google.devtools.cloudtrace.v2.StackTrace.StackFrame
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_devtools_cloudtrace_v2_trace_proto_init() }
func file_google_devtools_cloudtrace_v2_trace_proto_init() {
	if File_google_devtools_cloudtrace_v2_trace_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StackTrace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Module); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TruncatableString); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_Attributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_TimeEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_TimeEvents); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_Link); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_Links); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_TimeEvent_Annotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Span_TimeEvent_MessageEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StackTrace_StackFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StackTrace_StackFrames); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*AttributeValue_StringValue)(nil),
		(*AttributeValue_IntValue)(nil),
		(*AttributeValue_BoolValue)(nil),
	}
	file_google_devtools_cloudtrace_v2_trace_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*Span_TimeEvent_Annotation_)(nil),
		(*Span_TimeEvent_MessageEvent_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_cloudtrace_v2_trace_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_devtools_cloudtrace_v2_trace_proto_goTypes,
		DependencyIndexes: file_google_devtools_cloudtrace_v2_trace_proto_depIdxs,
		EnumInfos:         file_google_devtools_cloudtrace_v2_trace_proto_enumTypes,
		MessageInfos:      file_google_devtools_cloudtrace_v2_trace_proto_msgTypes,
	}.Build()
	File_google_devtools_cloudtrace_v2_trace_proto = out.File
	file_google_devtools_cloudtrace_v2_trace_proto_rawDesc = nil
	file_google_devtools_cloudtrace_v2_trace_proto_goTypes = nil
	file_google_devtools_cloudtrace_v2_trace_proto_depIdxs = nil
}
