// Copyright 2018 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.2
// source: google/devtools/containeranalysis/v1beta1/vulnerability/vulnerability.proto

package vulnerability

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	common "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/common"
	cvss "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/cvss"
	_package "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/package"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Note provider-assigned severity/impact ranking.
type Severity int32

const (
	// Unknown.
	Severity_SEVERITY_UNSPECIFIED Severity = 0
	// Minimal severity.
	Severity_MINIMAL Severity = 1
	// Low severity.
	Severity_LOW Severity = 2
	// Medium severity.
	Severity_MEDIUM Severity = 3
	// High severity.
	Severity_HIGH Severity = 4
	// Critical severity.
	Severity_CRITICAL Severity = 5
)

// Enum value maps for Severity.
var (
	Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "MINIMAL",
		2: "LOW",
		3: "MEDIUM",
		4: "HIGH",
		5: "CRITICAL",
	}
	Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"MINIMAL":              1,
		"LOW":                  2,
		"MEDIUM":               3,
		"HIGH":                 4,
		"CRITICAL":             5,
	}
)

func (x Severity) Enum() *Severity {
	p := new(Severity)
	*p = x
	return p
}

func (x Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_enumTypes[0].Descriptor()
}

func (Severity) Type() protoreflect.EnumType {
	return &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_enumTypes[0]
}

func (x Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Severity.Descriptor instead.
func (Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescGZIP(), []int{0}
}

// Vulnerability provides metadata about a security vulnerability in a Note.
type Vulnerability struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CVSS score for this vulnerability.
	CvssScore float32 `protobuf:"fixed32,1,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// Note provider assigned impact of the vulnerability.
	Severity Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1beta1.vulnerability.Severity" json:"severity,omitempty"`
	// All information about the package to specifically identify this
	// vulnerability. One entry per (version range and cpe_uri) the package
	// vulnerability has manifested in.
	Details []*Vulnerability_Detail `protobuf:"bytes,3,rep,name=details,proto3" json:"details,omitempty"`
	// The full description of the CVSSv3.
	CvssV3 *cvss.CVSSv3 `protobuf:"bytes,4,opt,name=cvss_v3,json=cvssV3,proto3" json:"cvss_v3,omitempty"`
	// Windows details get their own format because the information format and
	// model don't match a normal detail. Specifically Windows updates are done as
	// patches, thus Windows vulnerabilities really are a missing package, rather
	// than a package being at an incorrect version.
	WindowsDetails []*Vulnerability_WindowsDetail `protobuf:"bytes,5,rep,name=windows_details,json=windowsDetails,proto3" json:"windows_details,omitempty"`
	// The time this information was last changed at the source. This is an
	// upstream timestamp from the underlying information source - e.g. Ubuntu
	// security tracker.
	SourceUpdateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=source_update_time,json=sourceUpdateTime,proto3" json:"source_update_time,omitempty"`
}

func (x *Vulnerability) Reset() {
	*x = Vulnerability{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vulnerability) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vulnerability) ProtoMessage() {}

func (x *Vulnerability) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vulnerability.ProtoReflect.Descriptor instead.
func (*Vulnerability) Descriptor() ([]byte, []int) {
	return file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescGZIP(), []int{0}
}

func (x *Vulnerability) GetCvssScore() float32 {
	if x != nil {
		return x.CvssScore
	}
	return 0
}

func (x *Vulnerability) GetSeverity() Severity {
	if x != nil {
		return x.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (x *Vulnerability) GetDetails() []*Vulnerability_Detail {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *Vulnerability) GetCvssV3() *cvss.CVSSv3 {
	if x != nil {
		return x.CvssV3
	}
	return nil
}

func (x *Vulnerability) GetWindowsDetails() []*Vulnerability_WindowsDetail {
	if x != nil {
		return x.WindowsDetails
	}
	return nil
}

func (x *Vulnerability) GetSourceUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.SourceUpdateTime
	}
	return nil
}

// Details of a vulnerability Occurrence.
type Details struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of package; whether native or non native(ruby gems, node.js
	// packages etc)
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The note provider assigned Severity of the vulnerability.
	Severity Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1beta1.vulnerability.Severity" json:"severity,omitempty"`
	// Output only. The CVSS score of this vulnerability. CVSS score is on a
	// scale of 0-10 where 0 indicates low severity and 10 indicates high
	// severity.
	CvssScore float32 `protobuf:"fixed32,3,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// Required. The set of affected locations and their fixes (if available)
	// within the associated resource.
	PackageIssue []*PackageIssue `protobuf:"bytes,4,rep,name=package_issue,json=packageIssue,proto3" json:"package_issue,omitempty"`
	// Output only. A one sentence description of this vulnerability.
	ShortDescription string `protobuf:"bytes,5,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// Output only. A detailed description of this vulnerability.
	LongDescription string `protobuf:"bytes,6,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Output only. URLs related to this vulnerability.
	RelatedUrls []*common.RelatedUrl `protobuf:"bytes,7,rep,name=related_urls,json=relatedUrls,proto3" json:"related_urls,omitempty"`
	// The distro assigned severity for this vulnerability when it is
	// available, and note provider assigned severity when distro has not yet
	// assigned a severity for this vulnerability.
	EffectiveSeverity Severity `protobuf:"varint,8,opt,name=effective_severity,json=effectiveSeverity,proto3,enum=grafeas.v1beta1.vulnerability.Severity" json:"effective_severity,omitempty"`
}

func (x *Details) Reset() {
	*x = Details{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Details) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Details) ProtoMessage() {}

func (x *Details) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Details.ProtoReflect.Descriptor instead.
func (*Details) Descriptor() ([]byte, []int) {
	return file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescGZIP(), []int{1}
}

func (x *Details) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Details) GetSeverity() Severity {
	if x != nil {
		return x.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (x *Details) GetCvssScore() float32 {
	if x != nil {
		return x.CvssScore
	}
	return 0
}

func (x *Details) GetPackageIssue() []*PackageIssue {
	if x != nil {
		return x.PackageIssue
	}
	return nil
}

func (x *Details) GetShortDescription() string {
	if x != nil {
		return x.ShortDescription
	}
	return ""
}

func (x *Details) GetLongDescription() string {
	if x != nil {
		return x.LongDescription
	}
	return ""
}

func (x *Details) GetRelatedUrls() []*common.RelatedUrl {
	if x != nil {
		return x.RelatedUrls
	}
	return nil
}

func (x *Details) GetEffectiveSeverity() Severity {
	if x != nil {
		return x.EffectiveSeverity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

// This message wraps a location affected by a vulnerability and its
// associated fix (if one is available).
type PackageIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of the vulnerability.
	AffectedLocation *VulnerabilityLocation `protobuf:"bytes,1,opt,name=affected_location,json=affectedLocation,proto3" json:"affected_location,omitempty"`
	// The location of the available fix for vulnerability.
	FixedLocation *VulnerabilityLocation `protobuf:"bytes,2,opt,name=fixed_location,json=fixedLocation,proto3" json:"fixed_location,omitempty"`
	// Deprecated, use Details.effective_severity instead
	// The severity (e.g., distro assigned severity) for this vulnerability.
	SeverityName string `protobuf:"bytes,3,opt,name=severity_name,json=severityName,proto3" json:"severity_name,omitempty"`
}

func (x *PackageIssue) Reset() {
	*x = PackageIssue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageIssue) ProtoMessage() {}

func (x *PackageIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageIssue.ProtoReflect.Descriptor instead.
func (*PackageIssue) Descriptor() ([]byte, []int) {
	return file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescGZIP(), []int{2}
}

func (x *PackageIssue) GetAffectedLocation() *VulnerabilityLocation {
	if x != nil {
		return x.AffectedLocation
	}
	return nil
}

func (x *PackageIssue) GetFixedLocation() *VulnerabilityLocation {
	if x != nil {
		return x.FixedLocation
	}
	return nil
}

func (x *PackageIssue) GetSeverityName() string {
	if x != nil {
		return x.SeverityName
	}
	return ""
}

// The location of the vulnerability.
type VulnerabilityLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The CPE URI in [cpe format](https://cpe.mitre.org/specification/)
	// format. Examples include distro or storage location for vulnerable jar.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// Required. The package being described.
	Package string `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
	// Required. The version of the package being described.
	Version *_package.Version `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *VulnerabilityLocation) Reset() {
	*x = VulnerabilityLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityLocation) ProtoMessage() {}

func (x *VulnerabilityLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityLocation.ProtoReflect.Descriptor instead.
func (*VulnerabilityLocation) Descriptor() ([]byte, []int) {
	return file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescGZIP(), []int{3}
}

func (x *VulnerabilityLocation) GetCpeUri() string {
	if x != nil {
		return x.CpeUri
	}
	return ""
}

func (x *VulnerabilityLocation) GetPackage() string {
	if x != nil {
		return x.Package
	}
	return ""
}

func (x *VulnerabilityLocation) GetVersion() *_package.Version {
	if x != nil {
		return x.Version
	}
	return nil
}

// Identifies all appearances of this vulnerability in the package for a
// specific distro/location. For example: glibc in
// cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
type Vulnerability_Detail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The CPE URI in
	// [cpe format](https://cpe.mitre.org/specification/) in which the
	// vulnerability manifests. Examples include distro or storage location for
	// vulnerable jar.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// Required. The name of the package where the vulnerability was found.
	Package string `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
	// The min version of the package in which the vulnerability exists.
	MinAffectedVersion *_package.Version `protobuf:"bytes,3,opt,name=min_affected_version,json=minAffectedVersion,proto3" json:"min_affected_version,omitempty"`
	// The max version of the package in which the vulnerability exists.
	MaxAffectedVersion *_package.Version `protobuf:"bytes,4,opt,name=max_affected_version,json=maxAffectedVersion,proto3" json:"max_affected_version,omitempty"`
	// The severity (eg: distro assigned severity) for this vulnerability.
	SeverityName string `protobuf:"bytes,5,opt,name=severity_name,json=severityName,proto3" json:"severity_name,omitempty"`
	// A vendor-specific description of this note.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// The fix for this specific package version.
	FixedLocation *VulnerabilityLocation `protobuf:"bytes,7,opt,name=fixed_location,json=fixedLocation,proto3" json:"fixed_location,omitempty"`
	// The type of package; whether native or non native(ruby gems, node.js
	// packages etc).
	PackageType string `protobuf:"bytes,8,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	// Whether this detail is obsolete. Occurrences are expected not to point to
	// obsolete details.
	IsObsolete bool `protobuf:"varint,9,opt,name=is_obsolete,json=isObsolete,proto3" json:"is_obsolete,omitempty"`
	// The time this information was last changed at the source. This is an
	// upstream timestamp from the underlying information source - e.g. Ubuntu
	// security tracker.
	SourceUpdateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=source_update_time,json=sourceUpdateTime,proto3" json:"source_update_time,omitempty"`
}

func (x *Vulnerability_Detail) Reset() {
	*x = Vulnerability_Detail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vulnerability_Detail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vulnerability_Detail) ProtoMessage() {}

func (x *Vulnerability_Detail) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vulnerability_Detail.ProtoReflect.Descriptor instead.
func (*Vulnerability_Detail) Descriptor() ([]byte, []int) {
	return file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Vulnerability_Detail) GetCpeUri() string {
	if x != nil {
		return x.CpeUri
	}
	return ""
}

func (x *Vulnerability_Detail) GetPackage() string {
	if x != nil {
		return x.Package
	}
	return ""
}

func (x *Vulnerability_Detail) GetMinAffectedVersion() *_package.Version {
	if x != nil {
		return x.MinAffectedVersion
	}
	return nil
}

func (x *Vulnerability_Detail) GetMaxAffectedVersion() *_package.Version {
	if x != nil {
		return x.MaxAffectedVersion
	}
	return nil
}

func (x *Vulnerability_Detail) GetSeverityName() string {
	if x != nil {
		return x.SeverityName
	}
	return ""
}

func (x *Vulnerability_Detail) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Vulnerability_Detail) GetFixedLocation() *VulnerabilityLocation {
	if x != nil {
		return x.FixedLocation
	}
	return nil
}

func (x *Vulnerability_Detail) GetPackageType() string {
	if x != nil {
		return x.PackageType
	}
	return ""
}

func (x *Vulnerability_Detail) GetIsObsolete() bool {
	if x != nil {
		return x.IsObsolete
	}
	return false
}

func (x *Vulnerability_Detail) GetSourceUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.SourceUpdateTime
	}
	return nil
}

type Vulnerability_WindowsDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The CPE URI in
	// [cpe format](https://cpe.mitre.org/specification/) in which the
	// vulnerability manifests. Examples include distro or storage location for
	// vulnerable jar.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// Required. The name of the vulnerability.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The description of the vulnerability.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The names of the KBs which have hotfixes to mitigate this
	// vulnerability. Note that there may be multiple hotfixes (and thus
	// multiple KBs) that mitigate a given vulnerability. Currently any listed
	// kb's presence is considered a fix.
	FixingKbs []*Vulnerability_WindowsDetail_KnowledgeBase `protobuf:"bytes,4,rep,name=fixing_kbs,json=fixingKbs,proto3" json:"fixing_kbs,omitempty"`
}

func (x *Vulnerability_WindowsDetail) Reset() {
	*x = Vulnerability_WindowsDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vulnerability_WindowsDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vulnerability_WindowsDetail) ProtoMessage() {}

func (x *Vulnerability_WindowsDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vulnerability_WindowsDetail.ProtoReflect.Descriptor instead.
func (*Vulnerability_WindowsDetail) Descriptor() ([]byte, []int) {
	return file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Vulnerability_WindowsDetail) GetCpeUri() string {
	if x != nil {
		return x.CpeUri
	}
	return ""
}

func (x *Vulnerability_WindowsDetail) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Vulnerability_WindowsDetail) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Vulnerability_WindowsDetail) GetFixingKbs() []*Vulnerability_WindowsDetail_KnowledgeBase {
	if x != nil {
		return x.FixingKbs
	}
	return nil
}

type Vulnerability_WindowsDetail_KnowledgeBase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The KB name (generally of the form KB[0-9]+ i.e. KB123456).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A link to the KB in the Windows update catalog -
	// https://www.catalog.update.microsoft.com/
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *Vulnerability_WindowsDetail_KnowledgeBase) Reset() {
	*x = Vulnerability_WindowsDetail_KnowledgeBase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vulnerability_WindowsDetail_KnowledgeBase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vulnerability_WindowsDetail_KnowledgeBase) ProtoMessage() {}

func (x *Vulnerability_WindowsDetail_KnowledgeBase) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vulnerability_WindowsDetail_KnowledgeBase.ProtoReflect.Descriptor instead.
func (*Vulnerability_WindowsDetail_KnowledgeBase) Descriptor() ([]byte, []int) {
	return file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Vulnerability_WindowsDetail_KnowledgeBase) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Vulnerability_WindowsDetail_KnowledgeBase) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

var File_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto protoreflect.FileDescriptor

var file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDesc = []byte{
	0x0a, 0x4b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x75, 0x6c, 0x6e,
	0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76,
	0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x76, 0x73, 0x73, 0x2f, 0x63, 0x76, 0x73,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xca, 0x09, 0x0a, 0x0d, 0x56, 0x75, 0x6c,
	0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x76,
	0x73, 0x73, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09,
	0x63, 0x76, 0x73, 0x73, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x73, 0x65, 0x76,
	0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x75,
	0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x53, 0x65, 0x76, 0x65,
	0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x4d,
	0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e,
	0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3e, 0x0a,
	0x07, 0x63, 0x76, 0x73, 0x73, 0x5f, 0x76, 0x33, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x43,
	0x56, 0x53, 0x53, 0x76, 0x33, 0x52, 0x06, 0x63, 0x76, 0x73, 0x73, 0x56, 0x33, 0x12, 0x63, 0x0a,
	0x0f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x52, 0x0e, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x48, 0x0a, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x95, 0x04, 0x0a,
	0x06, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x70, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x70, 0x65, 0x55, 0x72, 0x69,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x52, 0x0a, 0x14, 0x6d, 0x69,
	0x6e, 0x5f, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x6d, 0x69, 0x6e, 0x41,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x52,
	0x0a, 0x14, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x12,
	0x6d, 0x61, 0x78, 0x41, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x65, 0x76, 0x65, 0x72,
	0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x0e, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x66, 0x69, 0x78, 0x65, 0x64, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f,
	0x6f, 0x62, 0x73, 0x6f, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a,
	0x69, 0x73, 0x4f, 0x62, 0x73, 0x6f, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x1a, 0xfe, 0x01, 0x0a, 0x0d, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x70, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x70, 0x65, 0x55, 0x72, 0x69, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x0a, 0x66, 0x69, 0x78, 0x69, 0x6e, 0x67, 0x5f,
	0x6b, 0x62, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e,
	0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42,
	0x61, 0x73, 0x65, 0x52, 0x09, 0x66, 0x69, 0x78, 0x69, 0x6e, 0x67, 0x4b, 0x62, 0x73, 0x1a, 0x35,
	0x0a, 0x0d, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x72, 0x6c, 0x22, 0xc3, 0x03, 0x0a, 0x07, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x76,
	0x73, 0x73, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09,
	0x63, 0x76, 0x73, 0x73, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x50, 0x0a, 0x0d, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x0c, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73,
	0x68, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x6c, 0x6f, 0x6e, 0x67,
	0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x6c, 0x6f, 0x6e, 0x67, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x75,
	0x72, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61,
	0x74, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x55,
	0x72, 0x6c, 0x73, 0x12, 0x56, 0x0a, 0x12, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x27, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e,
	0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x22, 0xf3, 0x01, 0x0a, 0x0c,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x61, 0x0a, 0x11,
	0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x61,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5b, 0x0a, 0x0e, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x66,
	0x69, 0x78, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d,
	0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0x86, 0x01, 0x0a, 0x15, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x63,
	0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x70,
	0x65, 0x55, 0x72, 0x69, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x3a,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0x5e, 0x0a, 0x08, 0x53, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49,
	0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x4e, 0x49, 0x4d, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x07, 0x0a,
	0x03, 0x4c, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d,
	0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x52, 0x49, 0x54, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x05, 0x42, 0x90, 0x01, 0x0a, 0x20, 0x69,
	0x6f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x50,
	0x01, 0x5a, 0x64, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x75, 0x6c, 0x6e,
	0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x3b, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0xa2, 0x02, 0x03, 0x47, 0x52, 0x41, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescOnce sync.Once
	file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescData = file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDesc
)

func file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescGZIP() []byte {
	file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescOnce.Do(func() {
		file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescData)
	})
	return file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDescData
}

var file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_goTypes = []interface{}{
	(Severity)(0),                                     // 0: grafeas.v1beta1.vulnerability.Severity
	(*Vulnerability)(nil),                             // 1: grafeas.v1beta1.vulnerability.Vulnerability
	(*Details)(nil),                                   // 2: grafeas.v1beta1.vulnerability.Details
	(*PackageIssue)(nil),                              // 3: grafeas.v1beta1.vulnerability.PackageIssue
	(*VulnerabilityLocation)(nil),                     // 4: grafeas.v1beta1.vulnerability.VulnerabilityLocation
	(*Vulnerability_Detail)(nil),                      // 5: grafeas.v1beta1.vulnerability.Vulnerability.Detail
	(*Vulnerability_WindowsDetail)(nil),               // 6: grafeas.v1beta1.vulnerability.Vulnerability.WindowsDetail
	(*Vulnerability_WindowsDetail_KnowledgeBase)(nil), // 7: grafeas.v1beta1.vulnerability.Vulnerability.WindowsDetail.KnowledgeBase
	(*cvss.CVSSv3)(nil),                               // 8: grafeas.v1beta1.vulnerability.CVSSv3
	(*timestamp.Timestamp)(nil),                       // 9: google.protobuf.Timestamp
	(*common.RelatedUrl)(nil),                         // 10: grafeas.v1beta1.RelatedUrl
	(*_package.Version)(nil),                          // 11: grafeas.v1beta1.package.Version
}
var file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_depIdxs = []int32{
	0,  // 0: grafeas.v1beta1.vulnerability.Vulnerability.severity:type_name -> grafeas.v1beta1.vulnerability.Severity
	5,  // 1: grafeas.v1beta1.vulnerability.Vulnerability.details:type_name -> grafeas.v1beta1.vulnerability.Vulnerability.Detail
	8,  // 2: grafeas.v1beta1.vulnerability.Vulnerability.cvss_v3:type_name -> grafeas.v1beta1.vulnerability.CVSSv3
	6,  // 3: grafeas.v1beta1.vulnerability.Vulnerability.windows_details:type_name -> grafeas.v1beta1.vulnerability.Vulnerability.WindowsDetail
	9,  // 4: grafeas.v1beta1.vulnerability.Vulnerability.source_update_time:type_name -> google.protobuf.Timestamp
	0,  // 5: grafeas.v1beta1.vulnerability.Details.severity:type_name -> grafeas.v1beta1.vulnerability.Severity
	3,  // 6: grafeas.v1beta1.vulnerability.Details.package_issue:type_name -> grafeas.v1beta1.vulnerability.PackageIssue
	10, // 7: grafeas.v1beta1.vulnerability.Details.related_urls:type_name -> grafeas.v1beta1.RelatedUrl
	0,  // 8: grafeas.v1beta1.vulnerability.Details.effective_severity:type_name -> grafeas.v1beta1.vulnerability.Severity
	4,  // 9: grafeas.v1beta1.vulnerability.PackageIssue.affected_location:type_name -> grafeas.v1beta1.vulnerability.VulnerabilityLocation
	4,  // 10: grafeas.v1beta1.vulnerability.PackageIssue.fixed_location:type_name -> grafeas.v1beta1.vulnerability.VulnerabilityLocation
	11, // 11: grafeas.v1beta1.vulnerability.VulnerabilityLocation.version:type_name -> grafeas.v1beta1.package.Version
	11, // 12: grafeas.v1beta1.vulnerability.Vulnerability.Detail.min_affected_version:type_name -> grafeas.v1beta1.package.Version
	11, // 13: grafeas.v1beta1.vulnerability.Vulnerability.Detail.max_affected_version:type_name -> grafeas.v1beta1.package.Version
	4,  // 14: grafeas.v1beta1.vulnerability.Vulnerability.Detail.fixed_location:type_name -> grafeas.v1beta1.vulnerability.VulnerabilityLocation
	9,  // 15: grafeas.v1beta1.vulnerability.Vulnerability.Detail.source_update_time:type_name -> google.protobuf.Timestamp
	7,  // 16: grafeas.v1beta1.vulnerability.Vulnerability.WindowsDetail.fixing_kbs:type_name -> grafeas.v1beta1.vulnerability.Vulnerability.WindowsDetail.KnowledgeBase
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_init() }
func file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_init() {
	if File_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vulnerability); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Details); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageIssue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vulnerability_Detail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vulnerability_WindowsDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vulnerability_WindowsDetail_KnowledgeBase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_goTypes,
		DependencyIndexes: file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_depIdxs,
		EnumInfos:         file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_enumTypes,
		MessageInfos:      file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_msgTypes,
	}.Build()
	File_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto = out.File
	file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_rawDesc = nil
	file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_goTypes = nil
	file_google_devtools_containeranalysis_v1beta1_vulnerability_vulnerability_proto_depIdxs = nil
}
