// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.2
// source: google/devtools/remoteworkers/v1test2/bots.proto

package remoteworkers

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A coarse description of the status of the bot that the server uses to
// determine whether to assign the bot new leases.
type BotStatus int32

const (
	// Default value; do not use.
	BotStatus_BOT_STATUS_UNSPECIFIED BotStatus = 0
	// The bot is healthy, and will accept leases as normal.
	BotStatus_OK BotStatus = 1
	// The bot is unhealthy and will not accept new leases. For example, the bot
	// may have detected that available disk space is too low. This situation may
	// resolve itself, but will typically require human intervention.
	BotStatus_UNHEALTHY BotStatus = 2
	// The bot has been asked to reboot the host. The bot will not accept new
	// leases; once all leases are complete, this session will no longer be
	// updated but the bot will be expected to establish a new session after the
	// reboot completes.
	BotStatus_HOST_REBOOTING BotStatus = 3
	// The bot has been asked to shut down. As with HOST_REBOOTING, once all
	// leases are completed, the session will no longer be updated and the bot
	// will not be expected to establish a new session.
	//
	// Bots are typically only asked to shut down if its host computer will be
	// modified in some way, such as deleting a VM.
	BotStatus_BOT_TERMINATING BotStatus = 4
	// The bot is initializing and is not ready to accept leases.
	BotStatus_INITIALIZING BotStatus = 5
)

// Enum value maps for BotStatus.
var (
	BotStatus_name = map[int32]string{
		0: "BOT_STATUS_UNSPECIFIED",
		1: "OK",
		2: "UNHEALTHY",
		3: "HOST_REBOOTING",
		4: "BOT_TERMINATING",
		5: "INITIALIZING",
	}
	BotStatus_value = map[string]int32{
		"BOT_STATUS_UNSPECIFIED": 0,
		"OK":                     1,
		"UNHEALTHY":              2,
		"HOST_REBOOTING":         3,
		"BOT_TERMINATING":        4,
		"INITIALIZING":           5,
	}
)

func (x BotStatus) Enum() *BotStatus {
	p := new(BotStatus)
	*p = x
	return p
}

func (x BotStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BotStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_enumTypes[0].Descriptor()
}

func (BotStatus) Type() protoreflect.EnumType {
	return &file_google_devtools_remoteworkers_v1test2_bots_proto_enumTypes[0]
}

func (x BotStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BotStatus.Descriptor instead.
func (BotStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescGZIP(), []int{0}
}

// The state of the lease. All leases start in the PENDING state. A bot can
// change PENDING to ACTIVE or (in the case of an error) COMPLETED, or from
// ACTIVE to COMPLETED. The server can change PENDING or ACTIVE to CANCELLED if
// it wants the bot to release its resources - for example, if the bot needs to
// be quarantined (it's producing bad output) or a cell needs to be drained.
type LeaseState int32

const (
	// Default value; do not use.
	LeaseState_LEASE_STATE_UNSPECIFIED LeaseState = 0
	// Pending: the server expects the bot to accept this lease. This may only be
	// set by the server.
	LeaseState_PENDING LeaseState = 1
	// Active: the bot has accepted this lease. This may only be set by the bot.
	LeaseState_ACTIVE LeaseState = 2
	// Completed: the bot is no longer leased. This may only be set by the bot,
	// and the status field must be populated iff the state is COMPLETED.
	LeaseState_COMPLETED LeaseState = 4
	// Cancelled: The bot should immediately release all resources associated with
	// the lease. This may only be set by the server.
	LeaseState_CANCELLED LeaseState = 5
)

// Enum value maps for LeaseState.
var (
	LeaseState_name = map[int32]string{
		0: "LEASE_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "ACTIVE",
		4: "COMPLETED",
		5: "CANCELLED",
	}
	LeaseState_value = map[string]int32{
		"LEASE_STATE_UNSPECIFIED": 0,
		"PENDING":                 1,
		"ACTIVE":                  2,
		"COMPLETED":               4,
		"CANCELLED":               5,
	}
)

func (x LeaseState) Enum() *LeaseState {
	p := new(LeaseState)
	*p = x
	return p
}

func (x LeaseState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LeaseState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_enumTypes[1].Descriptor()
}

func (LeaseState) Type() protoreflect.EnumType {
	return &file_google_devtools_remoteworkers_v1test2_bots_proto_enumTypes[1]
}

func (x LeaseState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LeaseState.Descriptor instead.
func (LeaseState) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescGZIP(), []int{1}
}

// Possible administration actions.
type AdminTemp_Command int32

const (
	// Illegal value.
	AdminTemp_UNSPECIFIED AdminTemp_Command = 0
	// Download and run a new version of the bot. `arg` will be a resource
	// accessible via `ByteStream.Read` to obtain the new bot code.
	AdminTemp_BOT_UPDATE AdminTemp_Command = 1
	// Restart the bot without downloading a new version. `arg` will be a
	// message to log.
	AdminTemp_BOT_RESTART AdminTemp_Command = 2
	// Shut down the bot. `arg` will be a task resource name (similar to those
	// in tasks.proto) that the bot can use to tell the server that it is
	// terminating.
	AdminTemp_BOT_TERMINATE AdminTemp_Command = 3
	// Restart the host computer. `arg` will be a message to log.
	AdminTemp_HOST_RESTART AdminTemp_Command = 4
)

// Enum value maps for AdminTemp_Command.
var (
	AdminTemp_Command_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "BOT_UPDATE",
		2: "BOT_RESTART",
		3: "BOT_TERMINATE",
		4: "HOST_RESTART",
	}
	AdminTemp_Command_value = map[string]int32{
		"UNSPECIFIED":   0,
		"BOT_UPDATE":    1,
		"BOT_RESTART":   2,
		"BOT_TERMINATE": 3,
		"HOST_RESTART":  4,
	}
)

func (x AdminTemp_Command) Enum() *AdminTemp_Command {
	p := new(AdminTemp_Command)
	*p = x
	return p
}

func (x AdminTemp_Command) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AdminTemp_Command) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_enumTypes[2].Descriptor()
}

func (AdminTemp_Command) Type() protoreflect.EnumType {
	return &file_google_devtools_remoteworkers_v1test2_bots_proto_enumTypes[2]
}

func (x AdminTemp_Command) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AdminTemp_Command.Descriptor instead.
func (AdminTemp_Command) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescGZIP(), []int{2, 0}
}

// A bot session represents the state of a bot while in continuous contact with
// the server for a period of time. The session includes information about the
// worker - that is, the *worker* (the physical or virtual hardware) is
// considered to be a property of the bot (the software agent running on that
// hardware), which is the reverse of real life, but more natural from the point
// of the view of this API, which communicates solely with the bot and not
// directly with the underlying worker.
type BotSession struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bot session name, as selected by the server. Output only during a call
	// to CreateBotSession.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A unique bot ID within the farm used to persistently identify this bot over
	// time (i.e., over multiple sessions). This ID must be unique within a
	// farm. Typically, the bot ID will be the same as the name of the primary
	// device in the worker (e.g., what you'd get from typing `uname -n` on *nix),
	// but this is not required since a single device may allow multiple bots to
	// run on it, each with access to different resources. What is important is
	// that this ID is meaningful to humans, who might need to hunt a physical
	// machine down to fix it.
	//
	// When CreateBotSession is successfully called with a bot_id, all prior
	// sessions with the same ID are invalidated. If a bot attempts to update an
	// invalid session, the server must reject that request, and may also
	// quarantine the other bot with the same bot IDs (ie, stop sending it new
	// leases and alert an admin).
	BotId string `protobuf:"bytes,2,opt,name=bot_id,json=botId,proto3" json:"bot_id,omitempty"`
	// The status of the bot. This must be populated in every call to
	// UpdateBotSession.
	Status BotStatus `protobuf:"varint,3,opt,name=status,proto3,enum=google.devtools.remoteworkers.v1test2.BotStatus" json:"status,omitempty"`
	// A description of the worker hosting this bot. The Worker message is used
	// here in the Status context (see Worker for more information).  If multiple
	// bots are running on the worker, this field should only describe the
	// resources accessible from this bot.
	//
	// During the call to CreateBotSession, the server may make arbitrary changes
	// to the worker's `server_properties` field (see that field for more
	// information). Otherwise, this field is input-only.
	Worker *Worker `protobuf:"bytes,4,opt,name=worker,proto3" json:"worker,omitempty"`
	// A list of all leases that are a part of this session. See the Lease message
	// for details.
	Leases []*Lease `protobuf:"bytes,5,rep,name=leases,proto3" json:"leases,omitempty"`
	// The time at which this bot session will expire, unless the bot calls
	// UpdateBotSession again. Output only.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// The version of the bot code currently running. The server may use this
	// information to issue an admin action to tell the bot to update itself.
	Version string `protobuf:"bytes,7,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *BotSession) Reset() {
	*x = BotSession{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BotSession) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BotSession) ProtoMessage() {}

func (x *BotSession) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BotSession.ProtoReflect.Descriptor instead.
func (*BotSession) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescGZIP(), []int{0}
}

func (x *BotSession) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BotSession) GetBotId() string {
	if x != nil {
		return x.BotId
	}
	return ""
}

func (x *BotSession) GetStatus() BotStatus {
	if x != nil {
		return x.Status
	}
	return BotStatus_BOT_STATUS_UNSPECIFIED
}

func (x *BotSession) GetWorker() *Worker {
	if x != nil {
		return x.Worker
	}
	return nil
}

func (x *BotSession) GetLeases() []*Lease {
	if x != nil {
		return x.Leases
	}
	return nil
}

func (x *BotSession) GetExpireTime() *timestamp.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *BotSession) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// A Lease is a lease that the scheduler has assigned to this bot. If the bot
// notices (by UpdateBotSession) that it has any leases in the PENDING state, it
// should call UpdateBotSession to put the leases into the ACTIVE state and
// start executing their assignments.
//
// All fields in this message are output-only, *except* the `state` and `status`
// fields. Note that repeated fields can only be updated as a unit, so on every
// update the bot must provide an update for *all* the leases the server expects
// it to report on.
//
// The scheduler *should* ensure that all leases scheduled to a bot can actually
// be accepted, but race conditions may occur. In such cases, the bot should
// attempt to accept the leases in the order they are listed by the server, to
// allow the server to control priorities.
//
// The server will remove COMPLETED leases from time to time, after which the
// bot shouldn't report on them any more (the server will ignore superfluous
// COMPLETED records).
type Lease struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short string uniquely identifing the lease within this bot session.
	Id string `protobuf:"bytes,7,opt,name=id,proto3" json:"id,omitempty"`
	// The actual work to be performed, if any. May be omitted by the server if
	// the lease is not in the `PENDING` state. The message must be meaningful to
	// the bot. Output only (must only be set by the server).
	Payload *any.Any `protobuf:"bytes,8,opt,name=payload,proto3" json:"payload,omitempty"`
	// Any result the bot wishes to provide about the lease. Must not be changed
	// after the first call with the lease in the `COMPLETED` or `CANCELLED`
	// state. Input only (must only be set by the bot, will not be echoed by the
	// server).
	Result *any.Any `protobuf:"bytes,9,opt,name=result,proto3" json:"result,omitempty"`
	// The state of the lease. See LeaseState for more information.
	State LeaseState `protobuf:"varint,2,opt,name=state,proto3,enum=google.devtools.remoteworkers.v1test2.LeaseState" json:"state,omitempty"`
	// The final status of the lease (should be populated by the bot if the state
	// is completed). This is the status of the lease, not of any task represented
	// by the lease. For example, if the bot could not accept the lease because it
	// asked for some resource the bot didn't have, this status will be
	// FAILED_PRECONDITION. But if the assignment in the lease didn't execute
	// correctly, this field will be `OK` while the failure of the assignment must
	// communicated via the `result` field.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	// The requirements that are being claimed by this lease. This field may be
	// omitted by the server if the lease is not pending.
	Requirements *Worker `protobuf:"bytes,4,opt,name=requirements,proto3" json:"requirements,omitempty"`
	// The time at which this lease expires. The server *may* extend this over
	// time, but due to race conditions, the bot is not *required* to respect any
	// expiry date except the first one.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// DEPRECATED. The assignment should be provided to the bot via the `payload`
	// field. Clients that wish to use a simple name (such as a queue of work
	// provided elsewhere) should define a custom message type and encode it into
	// `payload`.
	//
	// Deprecated: Do not use.
	Assignment string `protobuf:"bytes,1,opt,name=assignment,proto3" json:"assignment,omitempty"`
	// DEPRECATED. Use `payload` instead.
	//
	// Deprecated: Do not use.
	InlineAssignment *any.Any `protobuf:"bytes,6,opt,name=inline_assignment,json=inlineAssignment,proto3" json:"inline_assignment,omitempty"`
}

func (x *Lease) Reset() {
	*x = Lease{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Lease) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Lease) ProtoMessage() {}

func (x *Lease) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Lease.ProtoReflect.Descriptor instead.
func (*Lease) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescGZIP(), []int{1}
}

func (x *Lease) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Lease) GetPayload() *any.Any {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *Lease) GetResult() *any.Any {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *Lease) GetState() LeaseState {
	if x != nil {
		return x.State
	}
	return LeaseState_LEASE_STATE_UNSPECIFIED
}

func (x *Lease) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *Lease) GetRequirements() *Worker {
	if x != nil {
		return x.Requirements
	}
	return nil
}

func (x *Lease) GetExpireTime() *timestamp.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

// Deprecated: Do not use.
func (x *Lease) GetAssignment() string {
	if x != nil {
		return x.Assignment
	}
	return ""
}

// Deprecated: Do not use.
func (x *Lease) GetInlineAssignment() *any.Any {
	if x != nil {
		return x.InlineAssignment
	}
	return nil
}

// AdminTemp is a prelimiary set of administration tasks. It's called "Temp"
// because we do not yet know the best way to represent admin tasks; it's
// possible that this will be entirely replaced in later versions of this API.
// If this message proves to be sufficient, it will be renamed in the alpha or
// beta release of this API.
//
// This message (suitably marshalled into a protobuf.Any) can be used as the
// inline_assignment field in a lease; the lease assignment field should simply
// be `"admin"` in these cases.
//
// This message is heavily based on Swarming administration tasks from the LUCI
// project (http://github.com/luci/luci-py/appengine/swarming).
type AdminTemp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The admin action; see `Command` for legal values.
	Command AdminTemp_Command `protobuf:"varint,1,opt,name=command,proto3,enum=google.devtools.remoteworkers.v1test2.AdminTemp_Command" json:"command,omitempty"`
	// The argument to the admin action; see `Command` for semantics.
	Arg string `protobuf:"bytes,2,opt,name=arg,proto3" json:"arg,omitempty"`
}

func (x *AdminTemp) Reset() {
	*x = AdminTemp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdminTemp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdminTemp) ProtoMessage() {}

func (x *AdminTemp) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdminTemp.ProtoReflect.Descriptor instead.
func (*AdminTemp) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescGZIP(), []int{2}
}

func (x *AdminTemp) GetCommand() AdminTemp_Command {
	if x != nil {
		return x.Command
	}
	return AdminTemp_UNSPECIFIED
}

func (x *AdminTemp) GetArg() string {
	if x != nil {
		return x.Arg
	}
	return ""
}

// Request message for CreateBotSession.
type CreateBotSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The farm resource.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The bot session to create. Server-assigned fields like name must be unset.
	BotSession *BotSession `protobuf:"bytes,2,opt,name=bot_session,json=botSession,proto3" json:"bot_session,omitempty"`
}

func (x *CreateBotSessionRequest) Reset() {
	*x = CreateBotSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBotSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBotSessionRequest) ProtoMessage() {}

func (x *CreateBotSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBotSessionRequest.ProtoReflect.Descriptor instead.
func (*CreateBotSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescGZIP(), []int{3}
}

func (x *CreateBotSessionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBotSessionRequest) GetBotSession() *BotSession {
	if x != nil {
		return x.BotSession
	}
	return nil
}

// Request message for UpdateBotSession.
type UpdateBotSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The bot session name. Must match bot_session.name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The bot session resource to update.
	BotSession *BotSession `protobuf:"bytes,2,opt,name=bot_session,json=botSession,proto3" json:"bot_session,omitempty"`
	// Required. The fields on the bot that should be updated. See the BotSession resource
	// for which fields are updatable by which caller.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBotSessionRequest) Reset() {
	*x = UpdateBotSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBotSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBotSessionRequest) ProtoMessage() {}

func (x *UpdateBotSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBotSessionRequest.ProtoReflect.Descriptor instead.
func (*UpdateBotSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateBotSessionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateBotSessionRequest) GetBotSession() *BotSession {
	if x != nil {
		return x.BotSession
	}
	return nil
}

func (x *UpdateBotSessionRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

var File_google_devtools_remoteworkers_v1test2_bots_proto protoreflect.FileDescriptor

var file_google_devtools_remoteworkers_v1test2_bots_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2f,
	0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2f, 0x62, 0x6f, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x74, 0x65,
	0x73, 0x74, 0x32, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc0, 0x03, 0x0a, 0x0a, 0x42, 0x6f, 0x74, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x62, 0x6f,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x62, 0x6f, 0x74, 0x49,
	0x64, 0x12, 0x48, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x42, 0x6f, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x45, 0x0a, 0x06, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65,
	0x73, 0x74, 0x32, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52, 0x06, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x12, 0x44, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x4c, 0x65, 0x61, 0x73, 0x65,
	0x52, 0x06, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3a,
	0x59, 0xea, 0x41, 0x56, 0x0a, 0x27, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x7b,
	0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x3d, 0x2a, 0x2a, 0x7d,
	0x2f, 0x62, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x62, 0x6f,
	0x74, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xe5, 0x03, 0x0a, 0x05, 0x4c,
	0x65, 0x61, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x2e, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x07, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x2c, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x51, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31,
	0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52, 0x0c, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x11, 0x69,
	0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x10, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0xd3, 0x01, 0x0a, 0x09, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x54, 0x65, 0x6d, 0x70,
	0x12, 0x52, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x54,
	0x65, 0x6d, 0x70, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x52, 0x07, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x72, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x61, 0x72, 0x67, 0x22, 0x60, 0x0a, 0x07, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x4f, 0x54, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52,
	0x54, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x4f, 0x54, 0x5f, 0x54, 0x45, 0x52, 0x4d, 0x49,
	0x4e, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x4f, 0x53, 0x54, 0x5f, 0x52,
	0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x04, 0x22, 0x8f, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x42, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x57, 0x0a, 0x0b, 0x62, 0x6f, 0x74, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x42,
	0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x62, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf9, 0x01, 0x0a, 0x17, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x6f, 0x74, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0b, 0x62,
	0x6f, 0x74, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73,
	0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x42, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x6f, 0x74, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x2a, 0x79, 0x0a, 0x09, 0x42, 0x6f, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x4f, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55,
	0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x48, 0x45, 0x41,
	0x4c, 0x54, 0x48, 0x59, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x4f, 0x53, 0x54, 0x5f, 0x52,
	0x45, 0x42, 0x4f, 0x4f, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x42, 0x4f,
	0x54, 0x5f, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12,
	0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10,
	0x05, 0x2a, 0x60, 0x0a, 0x0a, 0x4c, 0x65, 0x61, 0x73, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x1b, 0x0a, 0x17, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54,
	0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45,
	0x44, 0x10, 0x05, 0x32, 0xd9, 0x03, 0x0a, 0x04, 0x42, 0x6f, 0x74, 0x73, 0x12, 0xd1, 0x01, 0x0a,
	0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x42, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x42, 0x6f, 0x74, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x22, 0x20, 0x2f, 0x76,
	0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a,
	0x2a, 0x7d, 0x2f, 0x62, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x0b,
	0x62, 0x6f, 0x74, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x12, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x62, 0x6f, 0x74, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0xdb, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6f, 0x74, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x42, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2e, 0x42, 0x6f,
	0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f,
	0x32, 0x20, 0x2f, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x2a, 0x2a, 0x2f, 0x62, 0x6f, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x0b, 0x62, 0x6f, 0x74, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0xda,
	0x41, 0x1c, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x62, 0x6f, 0x74, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x1a, 0x1f,
	0xca, 0x41, 0x1c, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42,
	0xc1, 0x01, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x42, 0x11, 0x52,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x42, 0x6f, 0x74, 0x73,
	0x50, 0x01, 0x5a, 0x52, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73,
	0x2f, 0x76, 0x31, 0x74, 0x65, 0x73, 0x74, 0x32, 0x3b, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0xa2, 0x02, 0x02, 0x52, 0x57, 0xaa, 0x02, 0x25, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x44, 0x65, 0x76, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x52, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x73, 0x2e, 0x56, 0x31, 0x54, 0x65,
	0x73, 0x74, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescOnce sync.Once
	file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescData = file_google_devtools_remoteworkers_v1test2_bots_proto_rawDesc
)

func file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescGZIP() []byte {
	file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescOnce.Do(func() {
		file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescData)
	})
	return file_google_devtools_remoteworkers_v1test2_bots_proto_rawDescData
}

var file_google_devtools_remoteworkers_v1test2_bots_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_devtools_remoteworkers_v1test2_bots_proto_goTypes = []interface{}{
	(BotStatus)(0),                  // 0: google.devtools.remoteworkers.v1test2.BotStatus
	(LeaseState)(0),                 // 1: google.devtools.remoteworkers.v1test2.LeaseState
	(AdminTemp_Command)(0),          // 2: google.devtools.remoteworkers.v1test2.AdminTemp.Command
	(*BotSession)(nil),              // 3: google.devtools.remoteworkers.v1test2.BotSession
	(*Lease)(nil),                   // 4: google.devtools.remoteworkers.v1test2.Lease
	(*AdminTemp)(nil),               // 5: google.devtools.remoteworkers.v1test2.AdminTemp
	(*CreateBotSessionRequest)(nil), // 6: google.devtools.remoteworkers.v1test2.CreateBotSessionRequest
	(*UpdateBotSessionRequest)(nil), // 7: google.devtools.remoteworkers.v1test2.UpdateBotSessionRequest
	(*Worker)(nil),                  // 8: google.devtools.remoteworkers.v1test2.Worker
	(*timestamp.Timestamp)(nil),     // 9: google.protobuf.Timestamp
	(*any.Any)(nil),                 // 10: google.protobuf.Any
	(*status.Status)(nil),           // 11: google.rpc.Status
	(*field_mask.FieldMask)(nil),    // 12: google.protobuf.FieldMask
}
var file_google_devtools_remoteworkers_v1test2_bots_proto_depIdxs = []int32{
	0,  // 0: google.devtools.remoteworkers.v1test2.BotSession.status:type_name -> google.devtools.remoteworkers.v1test2.BotStatus
	8,  // 1: google.devtools.remoteworkers.v1test2.BotSession.worker:type_name -> google.devtools.remoteworkers.v1test2.Worker
	4,  // 2: google.devtools.remoteworkers.v1test2.BotSession.leases:type_name -> google.devtools.remoteworkers.v1test2.Lease
	9,  // 3: google.devtools.remoteworkers.v1test2.BotSession.expire_time:type_name -> google.protobuf.Timestamp
	10, // 4: google.devtools.remoteworkers.v1test2.Lease.payload:type_name -> google.protobuf.Any
	10, // 5: google.devtools.remoteworkers.v1test2.Lease.result:type_name -> google.protobuf.Any
	1,  // 6: google.devtools.remoteworkers.v1test2.Lease.state:type_name -> google.devtools.remoteworkers.v1test2.LeaseState
	11, // 7: google.devtools.remoteworkers.v1test2.Lease.status:type_name -> google.rpc.Status
	8,  // 8: google.devtools.remoteworkers.v1test2.Lease.requirements:type_name -> google.devtools.remoteworkers.v1test2.Worker
	9,  // 9: google.devtools.remoteworkers.v1test2.Lease.expire_time:type_name -> google.protobuf.Timestamp
	10, // 10: google.devtools.remoteworkers.v1test2.Lease.inline_assignment:type_name -> google.protobuf.Any
	2,  // 11: google.devtools.remoteworkers.v1test2.AdminTemp.command:type_name -> google.devtools.remoteworkers.v1test2.AdminTemp.Command
	3,  // 12: google.devtools.remoteworkers.v1test2.CreateBotSessionRequest.bot_session:type_name -> google.devtools.remoteworkers.v1test2.BotSession
	3,  // 13: google.devtools.remoteworkers.v1test2.UpdateBotSessionRequest.bot_session:type_name -> google.devtools.remoteworkers.v1test2.BotSession
	12, // 14: google.devtools.remoteworkers.v1test2.UpdateBotSessionRequest.update_mask:type_name -> google.protobuf.FieldMask
	6,  // 15: google.devtools.remoteworkers.v1test2.Bots.CreateBotSession:input_type -> google.devtools.remoteworkers.v1test2.CreateBotSessionRequest
	7,  // 16: google.devtools.remoteworkers.v1test2.Bots.UpdateBotSession:input_type -> google.devtools.remoteworkers.v1test2.UpdateBotSessionRequest
	3,  // 17: google.devtools.remoteworkers.v1test2.Bots.CreateBotSession:output_type -> google.devtools.remoteworkers.v1test2.BotSession
	3,  // 18: google.devtools.remoteworkers.v1test2.Bots.UpdateBotSession:output_type -> google.devtools.remoteworkers.v1test2.BotSession
	17, // [17:19] is the sub-list for method output_type
	15, // [15:17] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_devtools_remoteworkers_v1test2_bots_proto_init() }
func file_google_devtools_remoteworkers_v1test2_bots_proto_init() {
	if File_google_devtools_remoteworkers_v1test2_bots_proto != nil {
		return
	}
	file_google_devtools_remoteworkers_v1test2_worker_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BotSession); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Lease); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdminTemp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBotSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBotSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_remoteworkers_v1test2_bots_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_remoteworkers_v1test2_bots_proto_goTypes,
		DependencyIndexes: file_google_devtools_remoteworkers_v1test2_bots_proto_depIdxs,
		EnumInfos:         file_google_devtools_remoteworkers_v1test2_bots_proto_enumTypes,
		MessageInfos:      file_google_devtools_remoteworkers_v1test2_bots_proto_msgTypes,
	}.Build()
	File_google_devtools_remoteworkers_v1test2_bots_proto = out.File
	file_google_devtools_remoteworkers_v1test2_bots_proto_rawDesc = nil
	file_google_devtools_remoteworkers_v1test2_bots_proto_goTypes = nil
	file_google_devtools_remoteworkers_v1test2_bots_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BotsClient is the client API for Bots service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BotsClient interface {
	// CreateBotSession is called when the bot first joins the farm, and
	// establishes a session ID to ensure that multiple machines do not register
	// using the same name accidentally.
	CreateBotSession(ctx context.Context, in *CreateBotSessionRequest, opts ...grpc.CallOption) (*BotSession, error)
	// UpdateBotSession must be called periodically by the bot (on a schedule
	// determined by the server) to let the server know about its status, and to
	// pick up new lease requests from the server.
	UpdateBotSession(ctx context.Context, in *UpdateBotSessionRequest, opts ...grpc.CallOption) (*BotSession, error)
}

type botsClient struct {
	cc grpc.ClientConnInterface
}

func NewBotsClient(cc grpc.ClientConnInterface) BotsClient {
	return &botsClient{cc}
}

func (c *botsClient) CreateBotSession(ctx context.Context, in *CreateBotSessionRequest, opts ...grpc.CallOption) (*BotSession, error) {
	out := new(BotSession)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Bots/CreateBotSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *botsClient) UpdateBotSession(ctx context.Context, in *UpdateBotSessionRequest, opts ...grpc.CallOption) (*BotSession, error) {
	out := new(BotSession)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Bots/UpdateBotSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BotsServer is the server API for Bots service.
type BotsServer interface {
	// CreateBotSession is called when the bot first joins the farm, and
	// establishes a session ID to ensure that multiple machines do not register
	// using the same name accidentally.
	CreateBotSession(context.Context, *CreateBotSessionRequest) (*BotSession, error)
	// UpdateBotSession must be called periodically by the bot (on a schedule
	// determined by the server) to let the server know about its status, and to
	// pick up new lease requests from the server.
	UpdateBotSession(context.Context, *UpdateBotSessionRequest) (*BotSession, error)
}

// UnimplementedBotsServer can be embedded to have forward compatible implementations.
type UnimplementedBotsServer struct {
}

func (*UnimplementedBotsServer) CreateBotSession(context.Context, *CreateBotSessionRequest) (*BotSession, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateBotSession not implemented")
}
func (*UnimplementedBotsServer) UpdateBotSession(context.Context, *UpdateBotSessionRequest) (*BotSession, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateBotSession not implemented")
}

func RegisterBotsServer(s *grpc.Server, srv BotsServer) {
	s.RegisterService(&_Bots_serviceDesc, srv)
}

func _Bots_CreateBotSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBotSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BotsServer).CreateBotSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Bots/CreateBotSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BotsServer).CreateBotSession(ctx, req.(*CreateBotSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Bots_UpdateBotSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBotSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BotsServer).UpdateBotSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Bots/UpdateBotSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BotsServer).UpdateBotSession(ctx, req.(*UpdateBotSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Bots_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.remoteworkers.v1test2.Bots",
	HandlerType: (*BotsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBotSession",
			Handler:    _Bots_CreateBotSession_Handler,
		},
		{
			MethodName: "UpdateBotSession",
			Handler:    _Bots_UpdateBotSession_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/remoteworkers/v1test2/bots.proto",
}
