// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.2
// source: google/devtools/resultstore/v2/resultstore_upload.proto

package resultstore

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The operation for the request (e.g. Create(), Update(), etc.)
type UploadRequest_UploadOperation int32

const (
	// Unspecified
	UploadRequest_UPLOAD_OPERATION_UNSPECIFIED UploadRequest_UploadOperation = 0
	// Create the given resources.
	// For more information, check the Create APIs.
	UploadRequest_CREATE UploadRequest_UploadOperation = 1
	// Applies a standard update to the resource identified by the given
	// proto's name. For more information, see the Update APIs.
	// UploadBatch does not support arbitrary field masks. The list of allowed
	// field masks can be found below.
	UploadRequest_UPDATE UploadRequest_UploadOperation = 2
	// Applies an merge update to the resource identified by the given
	// proto's name. For more information, see the Merge APIs.
	// Currently, only the "files" and "file_processing_errors" fields are
	// supported by this operation.
	UploadRequest_MERGE UploadRequest_UploadOperation = 3
	// Declares the resource with the given name as finalized and immutable by
	// the uploader. Only supported for Invocation, Target, ConfiguredTarget.
	// There must be no operation on child resources after parent resource is
	// Finalized. If there is a Finalize of Invocation, it must be the final
	// UploadRequest. For more information, see the Finalize APIs.
	// An empty resource should be provided below.
	UploadRequest_FINALIZE UploadRequest_UploadOperation = 4
)

// Enum value maps for UploadRequest_UploadOperation.
var (
	UploadRequest_UploadOperation_name = map[int32]string{
		0: "UPLOAD_OPERATION_UNSPECIFIED",
		1: "CREATE",
		2: "UPDATE",
		3: "MERGE",
		4: "FINALIZE",
	}
	UploadRequest_UploadOperation_value = map[string]int32{
		"UPLOAD_OPERATION_UNSPECIFIED": 0,
		"CREATE":                       1,
		"UPDATE":                       2,
		"MERGE":                        3,
		"FINALIZE":                     4,
	}
)

func (x UploadRequest_UploadOperation) Enum() *UploadRequest_UploadOperation {
	p := new(UploadRequest_UploadOperation)
	*p = x
	return p
}

func (x UploadRequest_UploadOperation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UploadRequest_UploadOperation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_enumTypes[0].Descriptor()
}

func (UploadRequest_UploadOperation) Type() protoreflect.EnumType {
	return &file_google_devtools_resultstore_v2_resultstore_upload_proto_enumTypes[0]
}

func (x UploadRequest_UploadOperation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UploadRequest_UploadOperation.Descriptor instead.
func (UploadRequest_UploadOperation) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{28, 0}
}

// Request passed into CreateInvocation
type CreateInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID. If set, invocation_id must also be provided.
	// Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The invocation ID. It is optional, but strongly recommended.
	//
	// If left empty then a new unique ID will be assigned by the server. If
	// populated, a RFC 4122-compliant v4 UUID is preferred, but v3 or v5 UUIDs
	// are allowed too.
	InvocationId string `protobuf:"bytes,2,opt,name=invocation_id,json=invocationId,proto3" json:"invocation_id,omitempty"`
	// The invocation to create.  Its name field will be ignored, since the name
	// will be derived from the id field above and assigned by the server.
	Invocation *Invocation `protobuf:"bytes,3,opt,name=invocation,proto3" json:"invocation,omitempty"`
	// This is a token to authorize upload access to this invocation. It must be
	// set to a RFC 4122-compliant v3, v4, or v5 UUID. Once this is set in
	// CreateInvocation, all other upload RPCs for that Invocation and any of its
	// child resources must also include the exact same token, or they will be
	// rejected. The generated token should be unique to this invocation, and it
	// should be kept secret.
	//
	// The purpose of this field is to prevent other users and tools from
	// clobbering your upload intentionally or accidentally. The standard way of
	// using this token is to create a second v4 UUID when the invocation_id is
	// created, and storing them together during the upload. Essentially, this is
	// a "password" to the invocation.
	AuthorizationToken string `protobuf:"bytes,4,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// By default, Invocations are auto-finalized if they are not modified for 24
	// hours. If you need auto-finalize to happen sooner, set this field to the
	// time you'd like auto-finalize to occur.
	AutoFinalizeTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=auto_finalize_time,json=autoFinalizeTime,proto3" json:"auto_finalize_time,omitempty"`
	// Client provided unique token for batch upload to ensure data integrity and
	// to provide a way to resume batch upload in case of a distributed failure on
	// the client side. The standard uploading client is presumed to have many
	// machines uploading to ResultStore, and that any given machine could process
	// any given Invocation at any time. This field is used to coordinate between
	// the client's machines, resolve concurrency issues, and enforce "exactly
	// once" semantics on each batch within the upload.
	//
	// The typical usage of the resume_token is that it should contain a "key"
	// indicating to the client where it is in the upload process, so that the
	// client can use it to resume the upload by reconstructing the state of
	// upload from the point where it was interrupted.
	//
	// If this matches the previously uploaded resume_token, then this request
	// will silently do nothing, making CreateInvocation idempotent.
	// If this token is provided, all further upload RPCs must be done through
	// UploadBatch. This token must not be combined with request_id.
	// Must be web safe Base64 encoded bytes.
	InitialResumeToken string `protobuf:"bytes,7,opt,name=initial_resume_token,json=initialResumeToken,proto3" json:"initial_resume_token,omitempty"`
	// Client-specific data used to resume batch upload if an error occurs and
	// retry is needed. This serves a role closely related to resume_token, as
	// both fields may be used to provide state required to restore a Batch
	// Upload, but they differ in two important aspects:
	//  - it is not compared to previous values, and as such does not provide
	//    concurrency control;
	//  - it allows for a larger payload, since the contents are never
	//    inspected/compared;
	// The size of the message must be within 1 MiB. Too large requests will be
	// rejected.
	UploaderState []byte `protobuf:"bytes,8,opt,name=uploader_state,json=uploaderState,proto3" json:"uploader_state,omitempty"`
}

func (x *CreateInvocationRequest) Reset() {
	*x = CreateInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInvocationRequest) ProtoMessage() {}

func (x *CreateInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInvocationRequest.ProtoReflect.Descriptor instead.
func (*CreateInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{0}
}

func (x *CreateInvocationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateInvocationRequest) GetInvocationId() string {
	if x != nil {
		return x.InvocationId
	}
	return ""
}

func (x *CreateInvocationRequest) GetInvocation() *Invocation {
	if x != nil {
		return x.Invocation
	}
	return nil
}

func (x *CreateInvocationRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *CreateInvocationRequest) GetAutoFinalizeTime() *timestamp.Timestamp {
	if x != nil {
		return x.AutoFinalizeTime
	}
	return nil
}

func (x *CreateInvocationRequest) GetInitialResumeToken() string {
	if x != nil {
		return x.InitialResumeToken
	}
	return ""
}

func (x *CreateInvocationRequest) GetUploaderState() []byte {
	if x != nil {
		return x.UploaderState
	}
	return nil
}

// Request passed into UpdateInvocation
type UpdateInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains the name and the fields of the invocation to be updated.  The
	// name format must be: invocations/${INVOCATION_ID}
	Invocation *Invocation `protobuf:"bytes,3,opt,name=invocation,proto3" json:"invocation,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *UpdateInvocationRequest) Reset() {
	*x = UpdateInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInvocationRequest) ProtoMessage() {}

func (x *UpdateInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInvocationRequest.ProtoReflect.Descriptor instead.
func (*UpdateInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateInvocationRequest) GetInvocation() *Invocation {
	if x != nil {
		return x.Invocation
	}
	return nil
}

func (x *UpdateInvocationRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateInvocationRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Request passed into MergeInvocation
type MergeInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Contains the name and the fields of the invocation to be merged.  The
	// name format must be: invocations/${INVOCATION_ID}
	Invocation *Invocation `protobuf:"bytes,3,opt,name=invocation,proto3" json:"invocation,omitempty"`
	// Indicates which fields to merge.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *MergeInvocationRequest) Reset() {
	*x = MergeInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MergeInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeInvocationRequest) ProtoMessage() {}

func (x *MergeInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeInvocationRequest.ProtoReflect.Descriptor instead.
func (*MergeInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{2}
}

func (x *MergeInvocationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *MergeInvocationRequest) GetInvocation() *Invocation {
	if x != nil {
		return x.Invocation
	}
	return nil
}

func (x *MergeInvocationRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *MergeInvocationRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Request passed into TouchInvocation
type TouchInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the invocation.  Its format must be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,2,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *TouchInvocationRequest) Reset() {
	*x = TouchInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TouchInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TouchInvocationRequest) ProtoMessage() {}

func (x *TouchInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TouchInvocationRequest.ProtoReflect.Descriptor instead.
func (*TouchInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{3}
}

func (x *TouchInvocationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TouchInvocationRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Response returned from TouchInvocation
type TouchInvocationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the invocation.  Its format will be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Invocation.
	Id *Invocation_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *TouchInvocationResponse) Reset() {
	*x = TouchInvocationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TouchInvocationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TouchInvocationResponse) ProtoMessage() {}

func (x *TouchInvocationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TouchInvocationResponse.ProtoReflect.Descriptor instead.
func (*TouchInvocationResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{4}
}

func (x *TouchInvocationResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TouchInvocationResponse) GetId() *Invocation_Id {
	if x != nil {
		return x.Id
	}
	return nil
}

// Request passed into DeleteInvocation
type DeleteInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the invocation.  Its format must be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteInvocationRequest) Reset() {
	*x = DeleteInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInvocationRequest) ProtoMessage() {}

func (x *DeleteInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInvocationRequest.ProtoReflect.Descriptor instead.
func (*DeleteInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteInvocationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request passed into FinalizeInvocation
type FinalizeInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the invocation.  Its format must be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *FinalizeInvocationRequest) Reset() {
	*x = FinalizeInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeInvocationRequest) ProtoMessage() {}

func (x *FinalizeInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeInvocationRequest.ProtoReflect.Descriptor instead.
func (*FinalizeInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{6}
}

func (x *FinalizeInvocationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FinalizeInvocationRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Response returned from FinalizeInvocation
type FinalizeInvocationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the invocation.  Its format will be:
	// invocations/${INVOCATION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Invocation.
	Id *Invocation_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *FinalizeInvocationResponse) Reset() {
	*x = FinalizeInvocationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeInvocationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeInvocationResponse) ProtoMessage() {}

func (x *FinalizeInvocationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeInvocationResponse.ProtoReflect.Descriptor instead.
func (*FinalizeInvocationResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{7}
}

func (x *FinalizeInvocationResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FinalizeInvocationResponse) GetId() *Invocation_Id {
	if x != nil {
		return x.Id
	}
	return nil
}

// Request passed into CreateTarget
type CreateTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent invocation in which the target is created.
	// Its format must be invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The target identifier.  It can be any string up to 1024 Unicode characters
	// long except for the reserved id '-'.
	TargetId string `protobuf:"bytes,3,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// The target to create.  Its name field will be ignored, since the name will
	// be derived from the id field above and assigned by the server.
	Target *Target `protobuf:"bytes,4,opt,name=target,proto3" json:"target,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *CreateTargetRequest) Reset() {
	*x = CreateTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTargetRequest) ProtoMessage() {}

func (x *CreateTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTargetRequest.ProtoReflect.Descriptor instead.
func (*CreateTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{8}
}

func (x *CreateTargetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateTargetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTargetRequest) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *CreateTargetRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *CreateTargetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateTarget
type UpdateTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains the name and the fields of the target to be updated.  The name
	// format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Target *Target `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Update operation will become a Create operation if the
	// Target is NOT_FOUND.
	CreateIfNotFound bool `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
}

func (x *UpdateTargetRequest) Reset() {
	*x = UpdateTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTargetRequest) ProtoMessage() {}

func (x *UpdateTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTargetRequest.ProtoReflect.Descriptor instead.
func (*UpdateTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateTargetRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *UpdateTargetRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTargetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *UpdateTargetRequest) GetCreateIfNotFound() bool {
	if x != nil {
		return x.CreateIfNotFound
	}
	return false
}

// Request passed into MergeTarget
type MergeTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Contains the name and the fields of the target to be merged.  The name
	// format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Target *Target `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Indicates which fields to merge.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Merge operation will become a Create operation if the
	// Target is NOT_FOUND.
	CreateIfNotFound bool `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
}

func (x *MergeTargetRequest) Reset() {
	*x = MergeTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MergeTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeTargetRequest) ProtoMessage() {}

func (x *MergeTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeTargetRequest.ProtoReflect.Descriptor instead.
func (*MergeTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{10}
}

func (x *MergeTargetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *MergeTargetRequest) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *MergeTargetRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *MergeTargetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *MergeTargetRequest) GetCreateIfNotFound() bool {
	if x != nil {
		return x.CreateIfNotFound
	}
	return false
}

// Request passed into FinalizeTarget
type FinalizeTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the target.  Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *FinalizeTargetRequest) Reset() {
	*x = FinalizeTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeTargetRequest) ProtoMessage() {}

func (x *FinalizeTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeTargetRequest.ProtoReflect.Descriptor instead.
func (*FinalizeTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{11}
}

func (x *FinalizeTargetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FinalizeTargetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Response returned from FinalizeTarget
type FinalizeTargetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the target.  Its format will be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Target.
	Id *Target_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *FinalizeTargetResponse) Reset() {
	*x = FinalizeTargetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeTargetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeTargetResponse) ProtoMessage() {}

func (x *FinalizeTargetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeTargetResponse.ProtoReflect.Descriptor instead.
func (*FinalizeTargetResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{12}
}

func (x *FinalizeTargetResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FinalizeTargetResponse) GetId() *Target_Id {
	if x != nil {
		return x.Id
	}
	return nil
}

// Request passed into CreateConfiguredTarget
type CreateConfiguredTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent target in which the configured target is created.
	// Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The configuration identifier. This must match the ID of an existing
	// Configuration under this Invocation. Cannot be the reserved id '-'.
	ConfigId string `protobuf:"bytes,3,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// The configured target to create. Its name field will be ignored, since the
	// name will be derived from the id field above and assigned by the server.
	ConfiguredTarget *ConfiguredTarget `protobuf:"bytes,4,opt,name=configured_target,json=configuredTarget,proto3" json:"configured_target,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *CreateConfiguredTargetRequest) Reset() {
	*x = CreateConfiguredTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConfiguredTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConfiguredTargetRequest) ProtoMessage() {}

func (x *CreateConfiguredTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConfiguredTargetRequest.ProtoReflect.Descriptor instead.
func (*CreateConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{13}
}

func (x *CreateConfiguredTargetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateConfiguredTargetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConfiguredTargetRequest) GetConfigId() string {
	if x != nil {
		return x.ConfigId
	}
	return ""
}

func (x *CreateConfiguredTargetRequest) GetConfiguredTarget() *ConfiguredTarget {
	if x != nil {
		return x.ConfiguredTarget
	}
	return nil
}

func (x *CreateConfiguredTargetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateConfiguredTarget
type UpdateConfiguredTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains the name and the fields of the configured target to be updated.
	// The name format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}
	ConfiguredTarget *ConfiguredTarget `protobuf:"bytes,3,opt,name=configured_target,json=configuredTarget,proto3" json:"configured_target,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Update operation will become a Create operation if the
	// ConfiguredTarget is NOT_FOUND.
	CreateIfNotFound bool `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
}

func (x *UpdateConfiguredTargetRequest) Reset() {
	*x = UpdateConfiguredTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConfiguredTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConfiguredTargetRequest) ProtoMessage() {}

func (x *UpdateConfiguredTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConfiguredTargetRequest.ProtoReflect.Descriptor instead.
func (*UpdateConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateConfiguredTargetRequest) GetConfiguredTarget() *ConfiguredTarget {
	if x != nil {
		return x.ConfiguredTarget
	}
	return nil
}

func (x *UpdateConfiguredTargetRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateConfiguredTargetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *UpdateConfiguredTargetRequest) GetCreateIfNotFound() bool {
	if x != nil {
		return x.CreateIfNotFound
	}
	return false
}

// Request passed into MergeConfiguredTarget
type MergeConfiguredTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Contains the name and the fields of the configured target to be merged.
	// The name format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}
	ConfiguredTarget *ConfiguredTarget `protobuf:"bytes,3,opt,name=configured_target,json=configuredTarget,proto3" json:"configured_target,omitempty"`
	// Indicates which fields to merge.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Merge operation will become a Create operation if the
	// ConfiguredTarget is NOT_FOUND.
	CreateIfNotFound bool `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
}

func (x *MergeConfiguredTargetRequest) Reset() {
	*x = MergeConfiguredTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MergeConfiguredTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeConfiguredTargetRequest) ProtoMessage() {}

func (x *MergeConfiguredTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeConfiguredTargetRequest.ProtoReflect.Descriptor instead.
func (*MergeConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{15}
}

func (x *MergeConfiguredTargetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *MergeConfiguredTargetRequest) GetConfiguredTarget() *ConfiguredTarget {
	if x != nil {
		return x.ConfiguredTarget
	}
	return nil
}

func (x *MergeConfiguredTargetRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *MergeConfiguredTargetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *MergeConfiguredTargetRequest) GetCreateIfNotFound() bool {
	if x != nil {
		return x.CreateIfNotFound
	}
	return false
}

// Request passed into FinalizeConfiguredTarget
type FinalizeConfiguredTargetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the configured target. Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *FinalizeConfiguredTargetRequest) Reset() {
	*x = FinalizeConfiguredTargetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeConfiguredTargetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeConfiguredTargetRequest) ProtoMessage() {}

func (x *FinalizeConfiguredTargetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeConfiguredTargetRequest.ProtoReflect.Descriptor instead.
func (*FinalizeConfiguredTargetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{16}
}

func (x *FinalizeConfiguredTargetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FinalizeConfiguredTargetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Response returned from FinalizeConfiguredTarget
type FinalizeConfiguredTargetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the configured target. Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the ConfiguredTarget.
	Id *ConfiguredTarget_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *FinalizeConfiguredTargetResponse) Reset() {
	*x = FinalizeConfiguredTargetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeConfiguredTargetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeConfiguredTargetResponse) ProtoMessage() {}

func (x *FinalizeConfiguredTargetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeConfiguredTargetResponse.ProtoReflect.Descriptor instead.
func (*FinalizeConfiguredTargetResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{17}
}

func (x *FinalizeConfiguredTargetResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FinalizeConfiguredTargetResponse) GetId() *ConfiguredTarget_Id {
	if x != nil {
		return x.Id
	}
	return nil
}

// Request passed into CreateAction
type CreateActionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent configured target in which the action is created.
	// Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The action identifier. It can be any string up to 512 Unicode characters
	// long, except for the reserved id '-'.
	//
	// Recommended IDs for Test Actions:
	// "test": For a single test action.
	// "test_shard0_run0_attempt0" ... "test_shard9_run9_attempt9": For tests with
	//  shard/run/attempts.
	//
	// Recommended IDs for Build Actions:
	// "build": If you only have a single build action.
	ActionId string `protobuf:"bytes,3,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// The action to create.  Its name field will be ignored, since the
	// name will be derived from the id field above and assigned by the server.
	Action *Action `protobuf:"bytes,4,opt,name=action,proto3" json:"action,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *CreateActionRequest) Reset() {
	*x = CreateActionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateActionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateActionRequest) ProtoMessage() {}

func (x *CreateActionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateActionRequest.ProtoReflect.Descriptor instead.
func (*CreateActionRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{18}
}

func (x *CreateActionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateActionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateActionRequest) GetActionId() string {
	if x != nil {
		return x.ActionId
	}
	return ""
}

func (x *CreateActionRequest) GetAction() *Action {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *CreateActionRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateAction
type UpdateActionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains the name and the fields of the action to be updated.  The
	// name format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}/actions/${url_encode(ACTION_ID)}
	Action *Action `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Update operation will become a Create operation if the
	// Action is NOT_FOUND.
	CreateIfNotFound bool `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
}

func (x *UpdateActionRequest) Reset() {
	*x = UpdateActionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateActionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateActionRequest) ProtoMessage() {}

func (x *UpdateActionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateActionRequest.ProtoReflect.Descriptor instead.
func (*UpdateActionRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{19}
}

func (x *UpdateActionRequest) GetAction() *Action {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *UpdateActionRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateActionRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *UpdateActionRequest) GetCreateIfNotFound() bool {
	if x != nil {
		return x.CreateIfNotFound
	}
	return false
}

// Request passed into MergeAction
type MergeActionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Contains the name and the fields of the action to be merged.  The
	// name format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/${url_encode(CONFIG_ID)}/actions/${url_encode(ACTION_ID)}
	Action *Action `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// Indicates which fields to merge.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Merge operation will become a Create operation if the
	// Action is NOT_FOUND.
	CreateIfNotFound bool `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
}

func (x *MergeActionRequest) Reset() {
	*x = MergeActionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MergeActionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeActionRequest) ProtoMessage() {}

func (x *MergeActionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeActionRequest.ProtoReflect.Descriptor instead.
func (*MergeActionRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{20}
}

func (x *MergeActionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *MergeActionRequest) GetAction() *Action {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *MergeActionRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *MergeActionRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *MergeActionRequest) GetCreateIfNotFound() bool {
	if x != nil {
		return x.CreateIfNotFound
	}
	return false
}

// Request passed into CreateConfiguration
type CreateConfigurationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent invocation in which the configuration is created.
	// Its format must be invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The configuration identifier. It can be any string up to 256 Unicode
	// characters long. The configuration ID of "default" should be preferred for
	// the default configuration in a single-config invocation. Cannot be the
	// reserved id '-'.
	ConfigId string `protobuf:"bytes,3,opt,name=config_id,json=configId,proto3" json:"config_id,omitempty"`
	// The configuration to create. Its name field will be ignored, since the name
	// will be derived from the id field above and assigned by the server.
	Configuration *Configuration `protobuf:"bytes,4,opt,name=configuration,proto3" json:"configuration,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *CreateConfigurationRequest) Reset() {
	*x = CreateConfigurationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConfigurationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConfigurationRequest) ProtoMessage() {}

func (x *CreateConfigurationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConfigurationRequest.ProtoReflect.Descriptor instead.
func (*CreateConfigurationRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{21}
}

func (x *CreateConfigurationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateConfigurationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConfigurationRequest) GetConfigId() string {
	if x != nil {
		return x.ConfigId
	}
	return ""
}

func (x *CreateConfigurationRequest) GetConfiguration() *Configuration {
	if x != nil {
		return x.Configuration
	}
	return nil
}

func (x *CreateConfigurationRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateConfiguration
type UpdateConfigurationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains the name and fields of the configuration to be updated. The name
	// format must be:
	// invocations/${INVOCATION_ID}/configs/${url_encode(CONFIG_ID)}
	Configuration *Configuration `protobuf:"bytes,3,opt,name=configuration,proto3" json:"configuration,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Update operation will become a Create operation if the
	// Configuration is NOT_FOUND.
	CreateIfNotFound bool `protobuf:"varint,6,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
}

func (x *UpdateConfigurationRequest) Reset() {
	*x = UpdateConfigurationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConfigurationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConfigurationRequest) ProtoMessage() {}

func (x *UpdateConfigurationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConfigurationRequest.ProtoReflect.Descriptor instead.
func (*UpdateConfigurationRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateConfigurationRequest) GetConfiguration() *Configuration {
	if x != nil {
		return x.Configuration
	}
	return nil
}

func (x *UpdateConfigurationRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateConfigurationRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *UpdateConfigurationRequest) GetCreateIfNotFound() bool {
	if x != nil {
		return x.CreateIfNotFound
	}
	return false
}

// Request passed into CreateFileSet
type CreateFileSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The name of the parent invocation in which the file set is created.
	// Its format must be invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The file set identifier. It can be any string up to 256 Unicode characters
	// long.
	FileSetId string `protobuf:"bytes,3,opt,name=file_set_id,json=fileSetId,proto3" json:"file_set_id,omitempty"`
	// The file set to create. Its name field will be ignored, since the name will
	// be derived from the id field above and assigned by the server.
	FileSet *FileSet `protobuf:"bytes,4,opt,name=file_set,json=fileSet,proto3" json:"file_set,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,5,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *CreateFileSetRequest) Reset() {
	*x = CreateFileSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFileSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFileSetRequest) ProtoMessage() {}

func (x *CreateFileSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFileSetRequest.ProtoReflect.Descriptor instead.
func (*CreateFileSetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{23}
}

func (x *CreateFileSetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateFileSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFileSetRequest) GetFileSetId() string {
	if x != nil {
		return x.FileSetId
	}
	return ""
}

func (x *CreateFileSetRequest) GetFileSet() *FileSet {
	if x != nil {
		return x.FileSet
	}
	return nil
}

func (x *CreateFileSetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// Request passed into UpdateFileSet
type UpdateFileSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains the name and fields of the file set to be updated. The name format
	// must be: invocations/${INVOCATION_ID}/fileSets/${url_encode(FILE_SET_ID)}
	FileSet *FileSet `protobuf:"bytes,1,opt,name=file_set,json=fileSet,proto3" json:"file_set,omitempty"`
	// Indicates which fields to update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,3,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Update operation will become a Create operation if the
	// FileSet is NOT_FOUND.
	CreateIfNotFound bool `protobuf:"varint,4,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
}

func (x *UpdateFileSetRequest) Reset() {
	*x = UpdateFileSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFileSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFileSetRequest) ProtoMessage() {}

func (x *UpdateFileSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFileSetRequest.ProtoReflect.Descriptor instead.
func (*UpdateFileSetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{24}
}

func (x *UpdateFileSetRequest) GetFileSet() *FileSet {
	if x != nil {
		return x.FileSet
	}
	return nil
}

func (x *UpdateFileSetRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateFileSetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *UpdateFileSetRequest) GetCreateIfNotFound() bool {
	if x != nil {
		return x.CreateIfNotFound
	}
	return false
}

// Request passed into MergeFileSet
type MergeFileSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for this request. Must be set to a different value for
	// each request that affects a given resource (eg. a random UUID). Required
	// for the operation to be idempotent. This is achieved by ignoring this
	// request if the last successful operation on the resource had the same
	// request ID.  Restricted to 36 Unicode characters.
	RequestId string `protobuf:"bytes,1,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Contains the name and fields of the file set to be merged. The name
	// format must be:
	// invocations/${INVOCATION_ID}/fileSets/${url_encode(FILE_SET_ID)}
	FileSet *FileSet `protobuf:"bytes,2,opt,name=file_set,json=fileSet,proto3" json:"file_set,omitempty"`
	// Indicates which fields to merge.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// This is a token to authorize access to this invocation. It must be set to
	// the same value that was provided in the CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,4,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// If true then the Merge operation will become a Create operation if the
	// FileSet is NOT_FOUND.
	CreateIfNotFound bool `protobuf:"varint,5,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
}

func (x *MergeFileSetRequest) Reset() {
	*x = MergeFileSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MergeFileSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeFileSetRequest) ProtoMessage() {}

func (x *MergeFileSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeFileSetRequest.ProtoReflect.Descriptor instead.
func (*MergeFileSetRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{25}
}

func (x *MergeFileSetRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *MergeFileSetRequest) GetFileSet() *FileSet {
	if x != nil {
		return x.FileSet
	}
	return nil
}

func (x *MergeFileSetRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *MergeFileSetRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *MergeFileSetRequest) GetCreateIfNotFound() bool {
	if x != nil {
		return x.CreateIfNotFound
	}
	return false
}

// Request passed into UploadBatch
type UploadBatchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the invocation being modified.
	// The name format must be: invocations/${INVOCATION_ID}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A UUID that must match the value provided in CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,2,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
	// Required. The token of this batch, that will be committed in this UploadBatchRequest.
	// If this matches the previously uploaded resume_token, then this request
	// will silently do nothing.
	// See CreateInvocationRequest.initial_resume_token for more information.
	// Must be web safe Base64 encoded bytes.
	NextResumeToken string `protobuf:"bytes,3,opt,name=next_resume_token,json=nextResumeToken,proto3" json:"next_resume_token,omitempty"`
	// Required. The token of the previous batch that was committed in a UploadBatchRequest.
	// This will be checked after next_resume_token match is checked. If this does
	// not match the previously uploaded resume_token, a 409 Conflict (HTTPS) or
	// ABORTED (gRPC ) error code indicating a concurrency
	// failure will be returned, and that the user should call
	// GetInvocationUploadMetadata to fetch the current resume_token to
	// reconstruct the state of the upload to resume it.
	// See CreateInvocationRequest.initial_resume_token for more information.
	// Must be web safe Base64 encoded bytes.
	ResumeToken string `protobuf:"bytes,4,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// Client-specific data used to resume batch upload if an error occurs and
	// retry is needed. This serves a role closely related to resume_token, as
	// both fields may be used to provide state required to restore a Batch
	// Upload, but they differ in two important aspects:
	//  - it is not compared to previous values, and as such does not provide
	//    concurrency control;
	//  - it allows for a larger payload, since the contents are never
	//    inspected/compared;
	// The size of the message must be within 1 MiB. Too large requests will be
	// rejected.
	UploaderState []byte `protobuf:"bytes,6,opt,name=uploader_state,json=uploaderState,proto3" json:"uploader_state,omitempty"`
	// The individual upload requests for this batch.
	// The recommend total size for a batch is 10 MiB. Too large requests may be
	// rejected.
	// This field may be empty, allowing this RPC to be used like TouchInvocation.
	UploadRequests []*UploadRequest `protobuf:"bytes,5,rep,name=upload_requests,json=uploadRequests,proto3" json:"upload_requests,omitempty"`
}

func (x *UploadBatchRequest) Reset() {
	*x = UploadBatchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadBatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadBatchRequest) ProtoMessage() {}

func (x *UploadBatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadBatchRequest.ProtoReflect.Descriptor instead.
func (*UploadBatchRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{26}
}

func (x *UploadBatchRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *UploadBatchRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

func (x *UploadBatchRequest) GetNextResumeToken() string {
	if x != nil {
		return x.NextResumeToken
	}
	return ""
}

func (x *UploadBatchRequest) GetResumeToken() string {
	if x != nil {
		return x.ResumeToken
	}
	return ""
}

func (x *UploadBatchRequest) GetUploaderState() []byte {
	if x != nil {
		return x.UploaderState
	}
	return nil
}

func (x *UploadBatchRequest) GetUploadRequests() []*UploadRequest {
	if x != nil {
		return x.UploadRequests
	}
	return nil
}

// Response for UploadBatch
type UploadBatchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UploadBatchResponse) Reset() {
	*x = UploadBatchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadBatchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadBatchResponse) ProtoMessage() {}

func (x *UploadBatchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadBatchResponse.ProtoReflect.Descriptor instead.
func (*UploadBatchResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{27}
}

// The individual upload requests for this batch.
type UploadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource ID components that identify the resource being uploaded.
	Id *UploadRequest_Id `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The operation for the request (e.g. Create(), Update(), etc.)
	UploadOperation UploadRequest_UploadOperation `protobuf:"varint,2,opt,name=upload_operation,json=uploadOperation,proto3,enum=google.devtools.resultstore.v2.UploadRequest_UploadOperation" json:"upload_operation,omitempty"`
	// Required for Update and Merge operations.
	// Ignored for Create and Finalize operations.
	// Masks the fields of the resource being uploaded. Provides support for a
	// more granular upload.
	// FieldMask must match one of the follow patterns, where * means any single
	// field name:
	// Invocation: [*, status_attributes.*, timing.*, invocation_attributes.*,
	// workspace_info.*].
	// Target: [*, status_attributes.*, timing.*].
	// Configuration: [*, status_attributes.*].
	// ConfiguredTarget: [*, status_attributes.*].
	// Action: [*, status_attributes.*, timing.*, test_action.test_suite,
	// test_action.infrastructure_failure_info].
	// FileSet: [*].
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If true then the Update, Merge operation will become a Create operation if
	// the resource is NOT_FOUND. Not supported for Invocation resource.
	CreateIfNotFound bool `protobuf:"varint,10,opt,name=create_if_not_found,json=createIfNotFound,proto3" json:"create_if_not_found,omitempty"`
	// The proto of the resource being uploaded.
	//
	// Types that are assignable to Resource:
	//	*UploadRequest_Invocation
	//	*UploadRequest_Target
	//	*UploadRequest_Configuration
	//	*UploadRequest_ConfiguredTarget
	//	*UploadRequest_Action
	//	*UploadRequest_FileSet
	Resource isUploadRequest_Resource `protobuf_oneof:"resource"`
}

func (x *UploadRequest) Reset() {
	*x = UploadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRequest) ProtoMessage() {}

func (x *UploadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRequest.ProtoReflect.Descriptor instead.
func (*UploadRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{28}
}

func (x *UploadRequest) GetId() *UploadRequest_Id {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *UploadRequest) GetUploadOperation() UploadRequest_UploadOperation {
	if x != nil {
		return x.UploadOperation
	}
	return UploadRequest_UPLOAD_OPERATION_UNSPECIFIED
}

func (x *UploadRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UploadRequest) GetCreateIfNotFound() bool {
	if x != nil {
		return x.CreateIfNotFound
	}
	return false
}

func (m *UploadRequest) GetResource() isUploadRequest_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (x *UploadRequest) GetInvocation() *Invocation {
	if x, ok := x.GetResource().(*UploadRequest_Invocation); ok {
		return x.Invocation
	}
	return nil
}

func (x *UploadRequest) GetTarget() *Target {
	if x, ok := x.GetResource().(*UploadRequest_Target); ok {
		return x.Target
	}
	return nil
}

func (x *UploadRequest) GetConfiguration() *Configuration {
	if x, ok := x.GetResource().(*UploadRequest_Configuration); ok {
		return x.Configuration
	}
	return nil
}

func (x *UploadRequest) GetConfiguredTarget() *ConfiguredTarget {
	if x, ok := x.GetResource().(*UploadRequest_ConfiguredTarget); ok {
		return x.ConfiguredTarget
	}
	return nil
}

func (x *UploadRequest) GetAction() *Action {
	if x, ok := x.GetResource().(*UploadRequest_Action); ok {
		return x.Action
	}
	return nil
}

func (x *UploadRequest) GetFileSet() *FileSet {
	if x, ok := x.GetResource().(*UploadRequest_FileSet); ok {
		return x.FileSet
	}
	return nil
}

type isUploadRequest_Resource interface {
	isUploadRequest_Resource()
}

type UploadRequest_Invocation struct {
	// The Invocation Resource
	Invocation *Invocation `protobuf:"bytes,4,opt,name=invocation,proto3,oneof"`
}

type UploadRequest_Target struct {
	// The Target Resource
	Target *Target `protobuf:"bytes,5,opt,name=target,proto3,oneof"`
}

type UploadRequest_Configuration struct {
	// The Configuration Resource
	Configuration *Configuration `protobuf:"bytes,6,opt,name=configuration,proto3,oneof"`
}

type UploadRequest_ConfiguredTarget struct {
	// The ConfiguredTarget Resource
	ConfiguredTarget *ConfiguredTarget `protobuf:"bytes,7,opt,name=configured_target,json=configuredTarget,proto3,oneof"`
}

type UploadRequest_Action struct {
	// The Action Resource
	Action *Action `protobuf:"bytes,8,opt,name=action,proto3,oneof"`
}

type UploadRequest_FileSet struct {
	// The FileSet Resource
	FileSet *FileSet `protobuf:"bytes,9,opt,name=file_set,json=fileSet,proto3,oneof"`
}

func (*UploadRequest_Invocation) isUploadRequest_Resource() {}

func (*UploadRequest_Target) isUploadRequest_Resource() {}

func (*UploadRequest_Configuration) isUploadRequest_Resource() {}

func (*UploadRequest_ConfiguredTarget) isUploadRequest_Resource() {}

func (*UploadRequest_Action) isUploadRequest_Resource() {}

func (*UploadRequest_FileSet) isUploadRequest_Resource() {}

// Request passed into GetInvocationUploadMetadata
type GetInvocationUploadMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required
	// The name of the UploadMetadata being requested.
	// The name format must be: invocations/${INVOCATION_ID}/uploadMetadata
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. A UUID that must match the value provided in CreateInvocationRequest.
	AuthorizationToken string `protobuf:"bytes,2,opt,name=authorization_token,json=authorizationToken,proto3" json:"authorization_token,omitempty"`
}

func (x *GetInvocationUploadMetadataRequest) Reset() {
	*x = GetInvocationUploadMetadataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInvocationUploadMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInvocationUploadMetadataRequest) ProtoMessage() {}

func (x *GetInvocationUploadMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInvocationUploadMetadataRequest.ProtoReflect.Descriptor instead.
func (*GetInvocationUploadMetadataRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{29}
}

func (x *GetInvocationUploadMetadataRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetInvocationUploadMetadataRequest) GetAuthorizationToken() string {
	if x != nil {
		return x.AuthorizationToken
	}
	return ""
}

// The resource ID components that identify the resource being uploaded.
type UploadRequest_Id struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required for Target, ConfiguredTarget, or Action.
	// The Target ID.
	TargetId string `protobuf:"bytes,1,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// Required for Configuration, ConfiguredTarget, or Action.
	// The Configuration ID.
	ConfigurationId string `protobuf:"bytes,2,opt,name=configuration_id,json=configurationId,proto3" json:"configuration_id,omitempty"`
	// Required for Action.
	// The Action ID.
	ActionId string `protobuf:"bytes,3,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// Required for FileSet.
	// The FileSet ID.
	FileSetId string `protobuf:"bytes,4,opt,name=file_set_id,json=fileSetId,proto3" json:"file_set_id,omitempty"`
}

func (x *UploadRequest_Id) Reset() {
	*x = UploadRequest_Id{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadRequest_Id) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRequest_Id) ProtoMessage() {}

func (x *UploadRequest_Id) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRequest_Id.ProtoReflect.Descriptor instead.
func (*UploadRequest_Id) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP(), []int{28, 0}
}

func (x *UploadRequest_Id) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *UploadRequest_Id) GetConfigurationId() string {
	if x != nil {
		return x.ConfigurationId
	}
	return ""
}

func (x *UploadRequest_Id) GetActionId() string {
	if x != nil {
		return x.ActionId
	}
	return ""
}

func (x *UploadRequest_Id) GetFileSetId() string {
	if x != nil {
		return x.FileSetId
	}
	return ""
}

var File_google_devtools_resultstore_v2_resultstore_upload_proto protoreflect.FileDescriptor

var file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32,
	0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x75, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32,
	0x2f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f,
	0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32,
	0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x75, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfd, 0x02, 0x0a,
	0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x0a,
	0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x69, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x48, 0x0a, 0x12, 0x61, 0x75, 0x74,
	0x6f, 0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x10, 0x61, 0x75, 0x74, 0x6f, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x12, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x65,
	0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x75,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0xd3, 0x01, 0x0a,
	0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0a, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xf1, 0x01, 0x0a, 0x16, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x49, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x0a,
	0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x69, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5d, 0x0a, 0x16, 0x54, 0x6f, 0x75, 0x63, 0x68, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6c, 0x0a, 0x17, 0x54, 0x6f, 0x75, 0x63, 0x68, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x64, 0x52,
	0x02, 0x69, 0x64, 0x22, 0x2d, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x60, 0x0a, 0x19, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6f, 0x0a, 0x1a, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49,
	0x64, 0x52, 0x02, 0x69, 0x64, 0x22, 0xda, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49,
	0x64, 0x12, 0x3e, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xf2, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x13, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x69, 0x66, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x66, 0x4e,
	0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0x90, 0x02, 0x0a, 0x12, 0x4d, 0x65, 0x72, 0x67,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x3e, 0x0a,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3b, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x13, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x66, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75,
	0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x49, 0x66, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0x5c, 0x0a, 0x15, 0x46, 0x69,
	0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x67, 0x0a, 0x16, 0x46, 0x69, 0x6e, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x49, 0x64, 0x52, 0x02, 0x69,
	0x64, 0x22, 0x83, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x5d, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9b, 0x02, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5d, 0x0a, 0x11, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x69, 0x66, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x66, 0x4e, 0x6f, 0x74,
	0x46, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0xb9, 0x02, 0x0a, 0x1c, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x5d, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x66, 0x5f,
	0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x66, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e,
	0x64, 0x22, 0x66, 0x0a, 0x1f, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7b, 0x0a, 0x20, 0x46, 0x69, 0x6e,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x43, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e,
	0x49, 0x64, 0x52, 0x02, 0x69, 0x64, 0x22, 0xda, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x3e, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xf2, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x13, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x69, 0x66, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x66,
	0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0x90, 0x02, 0x0a, 0x12, 0x4d, 0x65, 0x72,
	0x67, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x3e,
	0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x0a, 0x13, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x13,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x66, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f,
	0x75, 0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x49, 0x66, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0xf6, 0x01, 0x0a, 0x1a,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x53,
	0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8e, 0x02, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x69, 0x66, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x66, 0x4e, 0x6f, 0x74,
	0x46, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0xe2, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x6c, 0x65,
	0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x42, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74,
	0x52, 0x07, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf7, 0x01, 0x0a, 0x14, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x07,
	0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x66, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x66, 0x4e, 0x6f, 0x74, 0x46,
	0x6f, 0x75, 0x6e, 0x64, 0x22, 0x95, 0x02, 0x0a, 0x13, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x46, 0x69,
	0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x42, 0x0a, 0x08, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2f, 0x0a, 0x13,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a,
	0x13, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x66, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66,
	0x6f, 0x75, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x49, 0x66, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0xab, 0x02, 0x0a,
	0x12, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x13, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2a, 0x0a, 0x11,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6d, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x75,
	0x6d, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x75,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0d, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x56, 0x0a, 0x0f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0e, 0x75, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x15, 0x0a, 0x13, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xf5, 0x07, 0x0a, 0x0d, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49,
	0x64, 0x52, 0x02, 0x69, 0x64, 0x12, 0x68, 0x0a, 0x10, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2d, 0x0a, 0x13,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x66, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f,
	0x75, 0x6e, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x49, 0x66, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x4c, 0x0a, 0x0a, 0x69,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0a, 0x69,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x48, 0x00, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x48,
	0x00, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74,
	0x48, 0x00, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x1a, 0x89, 0x01, 0x0a, 0x02,
	0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69,
	0x6c, 0x65, 0x53, 0x65, 0x74, 0x49, 0x64, 0x22, 0x64, 0x0a, 0x0f, 0x55, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x55, 0x50,
	0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x46, 0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x10, 0x04, 0x42, 0x0a, 0x0a,
	0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x69, 0x0a, 0x22, 0x47, 0x65, 0x74,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xf5, 0x23, 0x0a, 0x11, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x9c, 0x01, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x22, 0x0f, 0x2f, 0x76,
	0x32, 0x2f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x0a, 0x69,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xb0, 0x01, 0x0a, 0x10, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x32, 0x23, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x0a, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xab, 0x01, 0x0a,
	0x0f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x22, 0x29, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xad, 0x01, 0x0a, 0x0f, 0x54,
	0x6f, 0x75, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x6f, 0x75, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x6f, 0x75, 0x63, 0x68, 0x49, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x22, 0x1e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x74, 0x6f, 0x75, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0x12, 0xb9, 0x01, 0x0a, 0x12, 0x46,
	0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69,
	0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26,
	0x22, 0x21, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x69, 0x6e, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0x85, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x20, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x1a, 0x2a, 0x18, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9f,
	0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x32, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2c, 0x22, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x3a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0xa6, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x39,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x32, 0x29, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0xa5, 0x01, 0x0a, 0x0b, 0x4d, 0x65,
	0x72, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x22, 0x2f, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x3a, 0x01,
	0x2a, 0x12, 0xb7, 0x01, 0x0a, 0x0e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x36, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x22, 0x2b, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x66, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xdc, 0x01, 0x0a, 0x16,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65,
	0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x22,
	0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x69, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x3a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0xee, 0x01, 0x0a, 0x16, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x32, 0x48,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0xe2, 0x01, 0x0a, 0x15,
	0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x22, 0x4e, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x3a, 0x01, 0x2a,
	0x12, 0xe9, 0x01, 0x0a, 0x18, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65,
	0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x22, 0x3f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xbd, 0x01, 0x0a,
	0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4a, 0x22, 0x40, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xc4, 0x01, 0x0a,
	0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x51, 0x32, 0x47, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0xc3, 0x01, 0x0a, 0x0b, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x22, 0x4d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xbb, 0x01, 0x0a, 0x13, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x39, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x33, 0x22, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xc9, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x41, 0x32, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0xa5, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x65, 0x74, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x22, 0x23, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74,
	0x73, 0x3a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x12, 0xae, 0x01, 0x0a, 0x0d,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x22, 0x3e, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x38, 0x32, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x12, 0xab, 0x01, 0x0a,
	0x0c, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d,
	0x65, 0x72, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x22, 0x3d, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x37, 0x22, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73,
	0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xaa, 0x01, 0x0a, 0x0b, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x22, 0x27, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x3a, 0x75, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x3a, 0x01, 0x2a, 0x12, 0xc2, 0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x2f, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x69,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x7d, 0x1a, 0x4e, 0xca, 0x41,
	0x1a, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x71, 0x0a, 0x22,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x32, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2f, 0x76, 0x32, 0x3b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescOnce sync.Once
	file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescData = file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDesc
)

func file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescGZIP() []byte {
	file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescOnce.Do(func() {
		file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescData)
	})
	return file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDescData
}

var file_google_devtools_resultstore_v2_resultstore_upload_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_google_devtools_resultstore_v2_resultstore_upload_proto_goTypes = []interface{}{
	(UploadRequest_UploadOperation)(0),         // 0: google.devtools.resultstore.v2.UploadRequest.UploadOperation
	(*CreateInvocationRequest)(nil),            // 1: google.devtools.resultstore.v2.CreateInvocationRequest
	(*UpdateInvocationRequest)(nil),            // 2: google.devtools.resultstore.v2.UpdateInvocationRequest
	(*MergeInvocationRequest)(nil),             // 3: google.devtools.resultstore.v2.MergeInvocationRequest
	(*TouchInvocationRequest)(nil),             // 4: google.devtools.resultstore.v2.TouchInvocationRequest
	(*TouchInvocationResponse)(nil),            // 5: google.devtools.resultstore.v2.TouchInvocationResponse
	(*DeleteInvocationRequest)(nil),            // 6: google.devtools.resultstore.v2.DeleteInvocationRequest
	(*FinalizeInvocationRequest)(nil),          // 7: google.devtools.resultstore.v2.FinalizeInvocationRequest
	(*FinalizeInvocationResponse)(nil),         // 8: google.devtools.resultstore.v2.FinalizeInvocationResponse
	(*CreateTargetRequest)(nil),                // 9: google.devtools.resultstore.v2.CreateTargetRequest
	(*UpdateTargetRequest)(nil),                // 10: google.devtools.resultstore.v2.UpdateTargetRequest
	(*MergeTargetRequest)(nil),                 // 11: google.devtools.resultstore.v2.MergeTargetRequest
	(*FinalizeTargetRequest)(nil),              // 12: google.devtools.resultstore.v2.FinalizeTargetRequest
	(*FinalizeTargetResponse)(nil),             // 13: google.devtools.resultstore.v2.FinalizeTargetResponse
	(*CreateConfiguredTargetRequest)(nil),      // 14: google.devtools.resultstore.v2.CreateConfiguredTargetRequest
	(*UpdateConfiguredTargetRequest)(nil),      // 15: google.devtools.resultstore.v2.UpdateConfiguredTargetRequest
	(*MergeConfiguredTargetRequest)(nil),       // 16: google.devtools.resultstore.v2.MergeConfiguredTargetRequest
	(*FinalizeConfiguredTargetRequest)(nil),    // 17: google.devtools.resultstore.v2.FinalizeConfiguredTargetRequest
	(*FinalizeConfiguredTargetResponse)(nil),   // 18: google.devtools.resultstore.v2.FinalizeConfiguredTargetResponse
	(*CreateActionRequest)(nil),                // 19: google.devtools.resultstore.v2.CreateActionRequest
	(*UpdateActionRequest)(nil),                // 20: google.devtools.resultstore.v2.UpdateActionRequest
	(*MergeActionRequest)(nil),                 // 21: google.devtools.resultstore.v2.MergeActionRequest
	(*CreateConfigurationRequest)(nil),         // 22: google.devtools.resultstore.v2.CreateConfigurationRequest
	(*UpdateConfigurationRequest)(nil),         // 23: google.devtools.resultstore.v2.UpdateConfigurationRequest
	(*CreateFileSetRequest)(nil),               // 24: google.devtools.resultstore.v2.CreateFileSetRequest
	(*UpdateFileSetRequest)(nil),               // 25: google.devtools.resultstore.v2.UpdateFileSetRequest
	(*MergeFileSetRequest)(nil),                // 26: google.devtools.resultstore.v2.MergeFileSetRequest
	(*UploadBatchRequest)(nil),                 // 27: google.devtools.resultstore.v2.UploadBatchRequest
	(*UploadBatchResponse)(nil),                // 28: google.devtools.resultstore.v2.UploadBatchResponse
	(*UploadRequest)(nil),                      // 29: google.devtools.resultstore.v2.UploadRequest
	(*GetInvocationUploadMetadataRequest)(nil), // 30: google.devtools.resultstore.v2.GetInvocationUploadMetadataRequest
	(*UploadRequest_Id)(nil),                   // 31: google.devtools.resultstore.v2.UploadRequest.Id
	(*Invocation)(nil),                         // 32: google.devtools.resultstore.v2.Invocation
	(*timestamp.Timestamp)(nil),                // 33: google.protobuf.Timestamp
	(*field_mask.FieldMask)(nil),               // 34: google.protobuf.FieldMask
	(*Invocation_Id)(nil),                      // 35: google.devtools.resultstore.v2.Invocation.Id
	(*Target)(nil),                             // 36: google.devtools.resultstore.v2.Target
	(*Target_Id)(nil),                          // 37: google.devtools.resultstore.v2.Target.Id
	(*ConfiguredTarget)(nil),                   // 38: google.devtools.resultstore.v2.ConfiguredTarget
	(*ConfiguredTarget_Id)(nil),                // 39: google.devtools.resultstore.v2.ConfiguredTarget.Id
	(*Action)(nil),                             // 40: google.devtools.resultstore.v2.Action
	(*Configuration)(nil),                      // 41: google.devtools.resultstore.v2.Configuration
	(*FileSet)(nil),                            // 42: google.devtools.resultstore.v2.FileSet
	(*empty.Empty)(nil),                        // 43: google.protobuf.Empty
	(*UploadMetadata)(nil),                     // 44: google.devtools.resultstore.v2.UploadMetadata
}
var file_google_devtools_resultstore_v2_resultstore_upload_proto_depIdxs = []int32{
	32, // 0: google.devtools.resultstore.v2.CreateInvocationRequest.invocation:type_name -> google.devtools.resultstore.v2.Invocation
	33, // 1: google.devtools.resultstore.v2.CreateInvocationRequest.auto_finalize_time:type_name -> google.protobuf.Timestamp
	32, // 2: google.devtools.resultstore.v2.UpdateInvocationRequest.invocation:type_name -> google.devtools.resultstore.v2.Invocation
	34, // 3: google.devtools.resultstore.v2.UpdateInvocationRequest.update_mask:type_name -> google.protobuf.FieldMask
	32, // 4: google.devtools.resultstore.v2.MergeInvocationRequest.invocation:type_name -> google.devtools.resultstore.v2.Invocation
	34, // 5: google.devtools.resultstore.v2.MergeInvocationRequest.update_mask:type_name -> google.protobuf.FieldMask
	35, // 6: google.devtools.resultstore.v2.TouchInvocationResponse.id:type_name -> google.devtools.resultstore.v2.Invocation.Id
	35, // 7: google.devtools.resultstore.v2.FinalizeInvocationResponse.id:type_name -> google.devtools.resultstore.v2.Invocation.Id
	36, // 8: google.devtools.resultstore.v2.CreateTargetRequest.target:type_name -> google.devtools.resultstore.v2.Target
	36, // 9: google.devtools.resultstore.v2.UpdateTargetRequest.target:type_name -> google.devtools.resultstore.v2.Target
	34, // 10: google.devtools.resultstore.v2.UpdateTargetRequest.update_mask:type_name -> google.protobuf.FieldMask
	36, // 11: google.devtools.resultstore.v2.MergeTargetRequest.target:type_name -> google.devtools.resultstore.v2.Target
	34, // 12: google.devtools.resultstore.v2.MergeTargetRequest.update_mask:type_name -> google.protobuf.FieldMask
	37, // 13: google.devtools.resultstore.v2.FinalizeTargetResponse.id:type_name -> google.devtools.resultstore.v2.Target.Id
	38, // 14: google.devtools.resultstore.v2.CreateConfiguredTargetRequest.configured_target:type_name -> google.devtools.resultstore.v2.ConfiguredTarget
	38, // 15: google.devtools.resultstore.v2.UpdateConfiguredTargetRequest.configured_target:type_name -> google.devtools.resultstore.v2.ConfiguredTarget
	34, // 16: google.devtools.resultstore.v2.UpdateConfiguredTargetRequest.update_mask:type_name -> google.protobuf.FieldMask
	38, // 17: google.devtools.resultstore.v2.MergeConfiguredTargetRequest.configured_target:type_name -> google.devtools.resultstore.v2.ConfiguredTarget
	34, // 18: google.devtools.resultstore.v2.MergeConfiguredTargetRequest.update_mask:type_name -> google.protobuf.FieldMask
	39, // 19: google.devtools.resultstore.v2.FinalizeConfiguredTargetResponse.id:type_name -> google.devtools.resultstore.v2.ConfiguredTarget.Id
	40, // 20: google.devtools.resultstore.v2.CreateActionRequest.action:type_name -> google.devtools.resultstore.v2.Action
	40, // 21: google.devtools.resultstore.v2.UpdateActionRequest.action:type_name -> google.devtools.resultstore.v2.Action
	34, // 22: google.devtools.resultstore.v2.UpdateActionRequest.update_mask:type_name -> google.protobuf.FieldMask
	40, // 23: google.devtools.resultstore.v2.MergeActionRequest.action:type_name -> google.devtools.resultstore.v2.Action
	34, // 24: google.devtools.resultstore.v2.MergeActionRequest.update_mask:type_name -> google.protobuf.FieldMask
	41, // 25: google.devtools.resultstore.v2.CreateConfigurationRequest.configuration:type_name -> google.devtools.resultstore.v2.Configuration
	41, // 26: google.devtools.resultstore.v2.UpdateConfigurationRequest.configuration:type_name -> google.devtools.resultstore.v2.Configuration
	34, // 27: google.devtools.resultstore.v2.UpdateConfigurationRequest.update_mask:type_name -> google.protobuf.FieldMask
	42, // 28: google.devtools.resultstore.v2.CreateFileSetRequest.file_set:type_name -> google.devtools.resultstore.v2.FileSet
	42, // 29: google.devtools.resultstore.v2.UpdateFileSetRequest.file_set:type_name -> google.devtools.resultstore.v2.FileSet
	34, // 30: google.devtools.resultstore.v2.UpdateFileSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	42, // 31: google.devtools.resultstore.v2.MergeFileSetRequest.file_set:type_name -> google.devtools.resultstore.v2.FileSet
	34, // 32: google.devtools.resultstore.v2.MergeFileSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	29, // 33: google.devtools.resultstore.v2.UploadBatchRequest.upload_requests:type_name -> google.devtools.resultstore.v2.UploadRequest
	31, // 34: google.devtools.resultstore.v2.UploadRequest.id:type_name -> google.devtools.resultstore.v2.UploadRequest.Id
	0,  // 35: google.devtools.resultstore.v2.UploadRequest.upload_operation:type_name -> google.devtools.resultstore.v2.UploadRequest.UploadOperation
	34, // 36: google.devtools.resultstore.v2.UploadRequest.update_mask:type_name -> google.protobuf.FieldMask
	32, // 37: google.devtools.resultstore.v2.UploadRequest.invocation:type_name -> google.devtools.resultstore.v2.Invocation
	36, // 38: google.devtools.resultstore.v2.UploadRequest.target:type_name -> google.devtools.resultstore.v2.Target
	41, // 39: google.devtools.resultstore.v2.UploadRequest.configuration:type_name -> google.devtools.resultstore.v2.Configuration
	38, // 40: google.devtools.resultstore.v2.UploadRequest.configured_target:type_name -> google.devtools.resultstore.v2.ConfiguredTarget
	40, // 41: google.devtools.resultstore.v2.UploadRequest.action:type_name -> google.devtools.resultstore.v2.Action
	42, // 42: google.devtools.resultstore.v2.UploadRequest.file_set:type_name -> google.devtools.resultstore.v2.FileSet
	1,  // 43: google.devtools.resultstore.v2.ResultStoreUpload.CreateInvocation:input_type -> google.devtools.resultstore.v2.CreateInvocationRequest
	2,  // 44: google.devtools.resultstore.v2.ResultStoreUpload.UpdateInvocation:input_type -> google.devtools.resultstore.v2.UpdateInvocationRequest
	3,  // 45: google.devtools.resultstore.v2.ResultStoreUpload.MergeInvocation:input_type -> google.devtools.resultstore.v2.MergeInvocationRequest
	4,  // 46: google.devtools.resultstore.v2.ResultStoreUpload.TouchInvocation:input_type -> google.devtools.resultstore.v2.TouchInvocationRequest
	7,  // 47: google.devtools.resultstore.v2.ResultStoreUpload.FinalizeInvocation:input_type -> google.devtools.resultstore.v2.FinalizeInvocationRequest
	6,  // 48: google.devtools.resultstore.v2.ResultStoreUpload.DeleteInvocation:input_type -> google.devtools.resultstore.v2.DeleteInvocationRequest
	9,  // 49: google.devtools.resultstore.v2.ResultStoreUpload.CreateTarget:input_type -> google.devtools.resultstore.v2.CreateTargetRequest
	10, // 50: google.devtools.resultstore.v2.ResultStoreUpload.UpdateTarget:input_type -> google.devtools.resultstore.v2.UpdateTargetRequest
	11, // 51: google.devtools.resultstore.v2.ResultStoreUpload.MergeTarget:input_type -> google.devtools.resultstore.v2.MergeTargetRequest
	12, // 52: google.devtools.resultstore.v2.ResultStoreUpload.FinalizeTarget:input_type -> google.devtools.resultstore.v2.FinalizeTargetRequest
	14, // 53: google.devtools.resultstore.v2.ResultStoreUpload.CreateConfiguredTarget:input_type -> google.devtools.resultstore.v2.CreateConfiguredTargetRequest
	15, // 54: google.devtools.resultstore.v2.ResultStoreUpload.UpdateConfiguredTarget:input_type -> google.devtools.resultstore.v2.UpdateConfiguredTargetRequest
	16, // 55: google.devtools.resultstore.v2.ResultStoreUpload.MergeConfiguredTarget:input_type -> google.devtools.resultstore.v2.MergeConfiguredTargetRequest
	17, // 56: google.devtools.resultstore.v2.ResultStoreUpload.FinalizeConfiguredTarget:input_type -> google.devtools.resultstore.v2.FinalizeConfiguredTargetRequest
	19, // 57: google.devtools.resultstore.v2.ResultStoreUpload.CreateAction:input_type -> google.devtools.resultstore.v2.CreateActionRequest
	20, // 58: google.devtools.resultstore.v2.ResultStoreUpload.UpdateAction:input_type -> google.devtools.resultstore.v2.UpdateActionRequest
	21, // 59: google.devtools.resultstore.v2.ResultStoreUpload.MergeAction:input_type -> google.devtools.resultstore.v2.MergeActionRequest
	22, // 60: google.devtools.resultstore.v2.ResultStoreUpload.CreateConfiguration:input_type -> google.devtools.resultstore.v2.CreateConfigurationRequest
	23, // 61: google.devtools.resultstore.v2.ResultStoreUpload.UpdateConfiguration:input_type -> google.devtools.resultstore.v2.UpdateConfigurationRequest
	24, // 62: google.devtools.resultstore.v2.ResultStoreUpload.CreateFileSet:input_type -> google.devtools.resultstore.v2.CreateFileSetRequest
	25, // 63: google.devtools.resultstore.v2.ResultStoreUpload.UpdateFileSet:input_type -> google.devtools.resultstore.v2.UpdateFileSetRequest
	26, // 64: google.devtools.resultstore.v2.ResultStoreUpload.MergeFileSet:input_type -> google.devtools.resultstore.v2.MergeFileSetRequest
	27, // 65: google.devtools.resultstore.v2.ResultStoreUpload.UploadBatch:input_type -> google.devtools.resultstore.v2.UploadBatchRequest
	30, // 66: google.devtools.resultstore.v2.ResultStoreUpload.GetInvocationUploadMetadata:input_type -> google.devtools.resultstore.v2.GetInvocationUploadMetadataRequest
	32, // 67: google.devtools.resultstore.v2.ResultStoreUpload.CreateInvocation:output_type -> google.devtools.resultstore.v2.Invocation
	32, // 68: google.devtools.resultstore.v2.ResultStoreUpload.UpdateInvocation:output_type -> google.devtools.resultstore.v2.Invocation
	32, // 69: google.devtools.resultstore.v2.ResultStoreUpload.MergeInvocation:output_type -> google.devtools.resultstore.v2.Invocation
	5,  // 70: google.devtools.resultstore.v2.ResultStoreUpload.TouchInvocation:output_type -> google.devtools.resultstore.v2.TouchInvocationResponse
	8,  // 71: google.devtools.resultstore.v2.ResultStoreUpload.FinalizeInvocation:output_type -> google.devtools.resultstore.v2.FinalizeInvocationResponse
	43, // 72: google.devtools.resultstore.v2.ResultStoreUpload.DeleteInvocation:output_type -> google.protobuf.Empty
	36, // 73: google.devtools.resultstore.v2.ResultStoreUpload.CreateTarget:output_type -> google.devtools.resultstore.v2.Target
	36, // 74: google.devtools.resultstore.v2.ResultStoreUpload.UpdateTarget:output_type -> google.devtools.resultstore.v2.Target
	36, // 75: google.devtools.resultstore.v2.ResultStoreUpload.MergeTarget:output_type -> google.devtools.resultstore.v2.Target
	13, // 76: google.devtools.resultstore.v2.ResultStoreUpload.FinalizeTarget:output_type -> google.devtools.resultstore.v2.FinalizeTargetResponse
	38, // 77: google.devtools.resultstore.v2.ResultStoreUpload.CreateConfiguredTarget:output_type -> google.devtools.resultstore.v2.ConfiguredTarget
	38, // 78: google.devtools.resultstore.v2.ResultStoreUpload.UpdateConfiguredTarget:output_type -> google.devtools.resultstore.v2.ConfiguredTarget
	38, // 79: google.devtools.resultstore.v2.ResultStoreUpload.MergeConfiguredTarget:output_type -> google.devtools.resultstore.v2.ConfiguredTarget
	18, // 80: google.devtools.resultstore.v2.ResultStoreUpload.FinalizeConfiguredTarget:output_type -> google.devtools.resultstore.v2.FinalizeConfiguredTargetResponse
	40, // 81: google.devtools.resultstore.v2.ResultStoreUpload.CreateAction:output_type -> google.devtools.resultstore.v2.Action
	40, // 82: google.devtools.resultstore.v2.ResultStoreUpload.UpdateAction:output_type -> google.devtools.resultstore.v2.Action
	40, // 83: google.devtools.resultstore.v2.ResultStoreUpload.MergeAction:output_type -> google.devtools.resultstore.v2.Action
	41, // 84: google.devtools.resultstore.v2.ResultStoreUpload.CreateConfiguration:output_type -> google.devtools.resultstore.v2.Configuration
	41, // 85: google.devtools.resultstore.v2.ResultStoreUpload.UpdateConfiguration:output_type -> google.devtools.resultstore.v2.Configuration
	42, // 86: google.devtools.resultstore.v2.ResultStoreUpload.CreateFileSet:output_type -> google.devtools.resultstore.v2.FileSet
	42, // 87: google.devtools.resultstore.v2.ResultStoreUpload.UpdateFileSet:output_type -> google.devtools.resultstore.v2.FileSet
	42, // 88: google.devtools.resultstore.v2.ResultStoreUpload.MergeFileSet:output_type -> google.devtools.resultstore.v2.FileSet
	28, // 89: google.devtools.resultstore.v2.ResultStoreUpload.UploadBatch:output_type -> google.devtools.resultstore.v2.UploadBatchResponse
	44, // 90: google.devtools.resultstore.v2.ResultStoreUpload.GetInvocationUploadMetadata:output_type -> google.devtools.resultstore.v2.UploadMetadata
	67, // [67:91] is the sub-list for method output_type
	43, // [43:67] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_google_devtools_resultstore_v2_resultstore_upload_proto_init() }
func file_google_devtools_resultstore_v2_resultstore_upload_proto_init() {
	if File_google_devtools_resultstore_v2_resultstore_upload_proto != nil {
		return
	}
	file_google_devtools_resultstore_v2_action_proto_init()
	file_google_devtools_resultstore_v2_configuration_proto_init()
	file_google_devtools_resultstore_v2_configured_target_proto_init()
	file_google_devtools_resultstore_v2_file_set_proto_init()
	file_google_devtools_resultstore_v2_invocation_proto_init()
	file_google_devtools_resultstore_v2_target_proto_init()
	file_google_devtools_resultstore_v2_upload_metadata_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MergeInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TouchInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TouchInvocationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeInvocationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MergeTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeTargetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConfiguredTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConfiguredTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MergeConfiguredTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeConfiguredTargetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeConfiguredTargetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateActionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateActionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MergeActionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConfigurationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConfigurationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFileSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFileSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MergeFileSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadBatchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadBatchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInvocationUploadMetadataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadRequest_Id); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes[28].OneofWrappers = []interface{}{
		(*UploadRequest_Invocation)(nil),
		(*UploadRequest_Target)(nil),
		(*UploadRequest_Configuration)(nil),
		(*UploadRequest_ConfiguredTarget)(nil),
		(*UploadRequest_Action)(nil),
		(*UploadRequest_FileSet)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_resultstore_v2_resultstore_upload_proto_goTypes,
		DependencyIndexes: file_google_devtools_resultstore_v2_resultstore_upload_proto_depIdxs,
		EnumInfos:         file_google_devtools_resultstore_v2_resultstore_upload_proto_enumTypes,
		MessageInfos:      file_google_devtools_resultstore_v2_resultstore_upload_proto_msgTypes,
	}.Build()
	File_google_devtools_resultstore_v2_resultstore_upload_proto = out.File
	file_google_devtools_resultstore_v2_resultstore_upload_proto_rawDesc = nil
	file_google_devtools_resultstore_v2_resultstore_upload_proto_goTypes = nil
	file_google_devtools_resultstore_v2_resultstore_upload_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ResultStoreUploadClient is the client API for ResultStoreUpload service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResultStoreUploadClient interface {
	// Creates the given invocation.
	//
	// This is not an implicitly idempotent API, so a request id is required to
	// make it idempotent.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If an invocation with the same ID already exists.
	CreateInvocation(ctx context.Context, in *CreateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error)
	// Applies a standard update to the invocation identified by the given proto's
	// name.  For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths.  Fields that match the mask but aren't populated in the given
	// invocation are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	// - If no field mask was given.
	UpdateInvocation(ctx context.Context, in *UpdateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error)
	// Applies a merge update to the invocation identified by the given proto's
	// name.  For primitive and message fields, replaces them with the ones in
	// the given proto if they are covered under the field mask paths.  For
	// repeated fields, merges to them with the given ones if they are covered
	// under the field mask paths. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	// - If no field mask was given.
	MergeInvocation(ctx context.Context, in *MergeInvocationRequest, opts ...grpc.CallOption) (*Invocation, error)
	// Touches the invocation identified by the given proto's name.
	//
	// This is useful when you need to notify ResultStore that you haven't
	// abandoned the upload, since abandoned uploads will be automatically
	// finalized after a set period.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	TouchInvocation(ctx context.Context, in *TouchInvocationRequest, opts ...grpc.CallOption) (*TouchInvocationResponse, error)
	// Declares the invocation with the given name as finalized and immutable by
	// the user. It may still be mutated by post-processing. This is an implicitly
	// idempotent API.
	//
	// If an Invocation is not updated for 24 hours, some time after that
	// this will be called automatically.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	FinalizeInvocation(ctx context.Context, in *FinalizeInvocationRequest, opts ...grpc.CallOption) (*FinalizeInvocationResponse, error)
	// Deletes an immutable invocation (permanently)
	// Note: this does not delete indirect data, e.g. files stored in other
	// services.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is not finalized.  This can be retried until it is.
	DeleteInvocation(ctx context.Context, in *DeleteInvocationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates the given target under the given parent invocation. The given
	// target ID is URL encoded, converted to the full resource name, and assigned
	// to the target's name field. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no target ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	// - If a target with the same name already exists.
	CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Applies a standard update to the target identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	// - If the target or parent invocation is finalized.
	// - If no field mask was given.
	UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Applies a merge update to the target identified by the given proto's
	// name. For primitive and message fields, replaces them with the ones in the
	// given proto if they are covered under the field mask paths.  For repeated
	// fields, merges to them with the given ones if they are covered under the
	// field mask paths. This is not an implicitly idempotent API, so a request
	// id is required to make it idempotent.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	// - If the target or parent invocation is finalized.
	// - If no field mask was given.
	MergeTarget(ctx context.Context, in *MergeTargetRequest, opts ...grpc.CallOption) (*Target, error)
	// Declares the target with the given name as finalized and immutable by the
	// user. It may still be mutated by post-processing. This is an implicitly
	// idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	FinalizeTarget(ctx context.Context, in *FinalizeTargetRequest, opts ...grpc.CallOption) (*FinalizeTargetResponse, error)
	// Creates the given configured target under the given parent target.
	// The given configured target ID is URL encoded, converted to the full
	// resource name, and assigned to the configured target's name field.
	// This is not an implicitly idempotent API, so a request id is required
	// to make it idempotent.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no config ID is provided.
	// - If a configured target with the same ID already exists.
	// - If the parent target does not exist.
	// - If the parent target or invocation is finalized.
	CreateConfiguredTarget(ctx context.Context, in *CreateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error)
	// Applies a standard update to the configured target identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths. Fields that match the mask but aren't populated in the
	// given configured target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	UpdateConfiguredTarget(ctx context.Context, in *UpdateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error)
	// Applies a merge update to the configured target identified by the given
	// proto's name. For primitive and message fields, replaces them with the
	// ones in the given proto if they are covered under the field mask paths.
	// For repeated fields, merges to them with the given ones if they are
	// covered under the field mask paths. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	MergeConfiguredTarget(ctx context.Context, in *MergeConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error)
	// Declares the configured target with the given name as finalized and
	// immutable by the user. It may still be mutated by post-processing. This is
	// an implicitly idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	FinalizeConfiguredTarget(ctx context.Context, in *FinalizeConfiguredTargetRequest, opts ...grpc.CallOption) (*FinalizeConfiguredTargetResponse, error)
	// Creates the given action under the given configured target. The given
	// action ID is URL encoded, converted to the full resource name, and
	// assigned to the action's name field. This is not an implicitly
	// idempotent API, so a request id is required to make it idempotent.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no action ID provided.
	// - If the parent configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If an action  with the same name already exists.
	CreateAction(ctx context.Context, in *CreateActionRequest, opts ...grpc.CallOption) (*Action, error)
	// Applies a standard update to the action identified by the given
	// proto's name.  For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths.  Fields that match the mask but aren't populated in the
	// given action are cleared.  This is an implicitly idempotent API.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the action does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	UpdateAction(ctx context.Context, in *UpdateActionRequest, opts ...grpc.CallOption) (*Action, error)
	// Applies a merge update to the action identified by the given
	// proto's name.  For primitive and message fields, replaces them with the
	// ones in the given proto if they are covered under the field mask paths.
	// For repeated fields, merges to them with the given ones if they are
	// covered under the field mask paths. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the action does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	MergeAction(ctx context.Context, in *MergeActionRequest, opts ...grpc.CallOption) (*Action, error)
	// Creates the given configuration under the given parent invocation. The
	// given configuration ID is URL encoded, converted to the full resource name,
	// and assigned to the configuration's name field. The configuration ID of
	// "default" should be preferred for the default configuration in a
	// single-config invocation. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no configuration ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	// - If a configuration with the same name already exists.
	CreateConfiguration(ctx context.Context, in *CreateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error)
	// Applies a standard update to the configuration identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given field
	// mask paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configuration does not exist.
	// - If the parent invocation is finalized.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateConfiguration(ctx context.Context, in *UpdateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error)
	// Creates the given file set under the given parent invocation. The given
	// file set ID is URL encoded, converted to the full resource name, and
	// assigned to the file set's name field. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no file set ID is provided.
	// - If a file set with the same name already exists.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	CreateFileSet(ctx context.Context, in *CreateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error)
	// Applies a standard update to the file set identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the file set does not exist.
	// - If the parent invocation is finalized.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateFileSet(ctx context.Context, in *UpdateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error)
	// Applies a merge update to the file set identified by the given proto's
	// name. For primitive and message fields, updates them with the ones in the
	// given proto if they are covered under the field mask paths. For repeated
	// fields, merges to them with the given ones if they are covered under the
	// field mask paths. This is not an implicitly idempotent API, so a request
	// id is required to make it idempotent.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the file set does not exist.
	// - If the parent invocation is finalized.
	// - If a given field mask path is not valid.
	// - If no field mask was given.
	MergeFileSet(ctx context.Context, in *MergeFileSetRequest, opts ...grpc.CallOption) (*FileSet, error)
	// This is the RPC used for batch upload. It supports uploading multiple
	// resources for an invocation in a transaction safe manner.
	//
	// To use this RPC, the CreateInvocationRequest must have been provided a
	// resume_token.
	//
	// Combining batch upload with normal upload on a single Invocation is not
	// supported. If an Invocation is created with a resume_token, all further
	// calls must be through UploadBatch. If an Invocation is created without
	// resume_token normal upload, all further upload calls must be through normal
	// upload RPCs.
	UploadBatch(ctx context.Context, in *UploadBatchRequest, opts ...grpc.CallOption) (*UploadBatchResponse, error)
	// Provides a way to read the metadata for an invocation.
	// The UploadMetadata could still be retrieved by this RPC even the Invocation
	// has been finalized.
	// This API requires setting a response FieldMask via 'fields' URL query
	// parameter or X-Goog-FieldMask HTTP/gRPC header.
	//
	// An error will be reported in the following case:
	// - If the invocation does not exist.
	// - If no field mask was given.
	GetInvocationUploadMetadata(ctx context.Context, in *GetInvocationUploadMetadataRequest, opts ...grpc.CallOption) (*UploadMetadata, error)
}

type resultStoreUploadClient struct {
	cc grpc.ClientConnInterface
}

func NewResultStoreUploadClient(cc grpc.ClientConnInterface) ResultStoreUploadClient {
	return &resultStoreUploadClient{cc}
}

func (c *resultStoreUploadClient) CreateInvocation(ctx context.Context, in *CreateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error) {
	out := new(Invocation)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateInvocation(ctx context.Context, in *UpdateInvocationRequest, opts ...grpc.CallOption) (*Invocation, error) {
	out := new(Invocation)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) MergeInvocation(ctx context.Context, in *MergeInvocationRequest, opts ...grpc.CallOption) (*Invocation, error) {
	out := new(Invocation)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/MergeInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) TouchInvocation(ctx context.Context, in *TouchInvocationRequest, opts ...grpc.CallOption) (*TouchInvocationResponse, error) {
	out := new(TouchInvocationResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/TouchInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) FinalizeInvocation(ctx context.Context, in *FinalizeInvocationRequest, opts ...grpc.CallOption) (*FinalizeInvocationResponse, error) {
	out := new(FinalizeInvocationResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) DeleteInvocation(ctx context.Context, in *DeleteInvocationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/DeleteInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateTarget(ctx context.Context, in *CreateTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateTarget(ctx context.Context, in *UpdateTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) MergeTarget(ctx context.Context, in *MergeTargetRequest, opts ...grpc.CallOption) (*Target, error) {
	out := new(Target)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/MergeTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) FinalizeTarget(ctx context.Context, in *FinalizeTargetRequest, opts ...grpc.CallOption) (*FinalizeTargetResponse, error) {
	out := new(FinalizeTargetResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateConfiguredTarget(ctx context.Context, in *CreateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error) {
	out := new(ConfiguredTarget)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateConfiguredTarget(ctx context.Context, in *UpdateConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error) {
	out := new(ConfiguredTarget)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) MergeConfiguredTarget(ctx context.Context, in *MergeConfiguredTargetRequest, opts ...grpc.CallOption) (*ConfiguredTarget, error) {
	out := new(ConfiguredTarget)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/MergeConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) FinalizeConfiguredTarget(ctx context.Context, in *FinalizeConfiguredTargetRequest, opts ...grpc.CallOption) (*FinalizeConfiguredTargetResponse, error) {
	out := new(FinalizeConfiguredTargetResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeConfiguredTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateAction(ctx context.Context, in *CreateActionRequest, opts ...grpc.CallOption) (*Action, error) {
	out := new(Action)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateAction(ctx context.Context, in *UpdateActionRequest, opts ...grpc.CallOption) (*Action, error) {
	out := new(Action)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) MergeAction(ctx context.Context, in *MergeActionRequest, opts ...grpc.CallOption) (*Action, error) {
	out := new(Action)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/MergeAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateConfiguration(ctx context.Context, in *CreateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error) {
	out := new(Configuration)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateConfiguration(ctx context.Context, in *UpdateConfigurationRequest, opts ...grpc.CallOption) (*Configuration, error) {
	out := new(Configuration)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) CreateFileSet(ctx context.Context, in *CreateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error) {
	out := new(FileSet)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/CreateFileSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UpdateFileSet(ctx context.Context, in *UpdateFileSetRequest, opts ...grpc.CallOption) (*FileSet, error) {
	out := new(FileSet)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateFileSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) MergeFileSet(ctx context.Context, in *MergeFileSetRequest, opts ...grpc.CallOption) (*FileSet, error) {
	out := new(FileSet)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/MergeFileSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) UploadBatch(ctx context.Context, in *UploadBatchRequest, opts ...grpc.CallOption) (*UploadBatchResponse, error) {
	out := new(UploadBatchResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/UploadBatch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resultStoreUploadClient) GetInvocationUploadMetadata(ctx context.Context, in *GetInvocationUploadMetadataRequest, opts ...grpc.CallOption) (*UploadMetadata, error) {
	out := new(UploadMetadata)
	err := c.cc.Invoke(ctx, "/google.devtools.resultstore.v2.ResultStoreUpload/GetInvocationUploadMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResultStoreUploadServer is the server API for ResultStoreUpload service.
type ResultStoreUploadServer interface {
	// Creates the given invocation.
	//
	// This is not an implicitly idempotent API, so a request id is required to
	// make it idempotent.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If an invocation with the same ID already exists.
	CreateInvocation(context.Context, *CreateInvocationRequest) (*Invocation, error)
	// Applies a standard update to the invocation identified by the given proto's
	// name.  For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths.  Fields that match the mask but aren't populated in the given
	// invocation are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	// - If no field mask was given.
	UpdateInvocation(context.Context, *UpdateInvocationRequest) (*Invocation, error)
	// Applies a merge update to the invocation identified by the given proto's
	// name.  For primitive and message fields, replaces them with the ones in
	// the given proto if they are covered under the field mask paths.  For
	// repeated fields, merges to them with the given ones if they are covered
	// under the field mask paths. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Invocation proto with only the name and ID fields
	// populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	// - If no field mask was given.
	MergeInvocation(context.Context, *MergeInvocationRequest) (*Invocation, error)
	// Touches the invocation identified by the given proto's name.
	//
	// This is useful when you need to notify ResultStore that you haven't
	// abandoned the upload, since abandoned uploads will be automatically
	// finalized after a set period.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is finalized.
	TouchInvocation(context.Context, *TouchInvocationRequest) (*TouchInvocationResponse, error)
	// Declares the invocation with the given name as finalized and immutable by
	// the user. It may still be mutated by post-processing. This is an implicitly
	// idempotent API.
	//
	// If an Invocation is not updated for 24 hours, some time after that
	// this will be called automatically.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	FinalizeInvocation(context.Context, *FinalizeInvocationRequest) (*FinalizeInvocationResponse, error)
	// Deletes an immutable invocation (permanently)
	// Note: this does not delete indirect data, e.g. files stored in other
	// services.
	//
	// An error will be reported in the following cases:
	// - If the invocation does not exist.
	// - If the invocation is not finalized.  This can be retried until it is.
	DeleteInvocation(context.Context, *DeleteInvocationRequest) (*empty.Empty, error)
	// Creates the given target under the given parent invocation. The given
	// target ID is URL encoded, converted to the full resource name, and assigned
	// to the target's name field. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no target ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	// - If a target with the same name already exists.
	CreateTarget(context.Context, *CreateTargetRequest) (*Target, error)
	// Applies a standard update to the target identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	// - If the target or parent invocation is finalized.
	// - If no field mask was given.
	UpdateTarget(context.Context, *UpdateTargetRequest) (*Target, error)
	// Applies a merge update to the target identified by the given proto's
	// name. For primitive and message fields, replaces them with the ones in the
	// given proto if they are covered under the field mask paths.  For repeated
	// fields, merges to them with the given ones if they are covered under the
	// field mask paths. This is not an implicitly idempotent API, so a request
	// id is required to make it idempotent.
	//
	// Returns an empty Target proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	// - If the target or parent invocation is finalized.
	// - If no field mask was given.
	MergeTarget(context.Context, *MergeTargetRequest) (*Target, error)
	// Declares the target with the given name as finalized and immutable by the
	// user. It may still be mutated by post-processing. This is an implicitly
	// idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the target does not exist.
	FinalizeTarget(context.Context, *FinalizeTargetRequest) (*FinalizeTargetResponse, error)
	// Creates the given configured target under the given parent target.
	// The given configured target ID is URL encoded, converted to the full
	// resource name, and assigned to the configured target's name field.
	// This is not an implicitly idempotent API, so a request id is required
	// to make it idempotent.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no config ID is provided.
	// - If a configured target with the same ID already exists.
	// - If the parent target does not exist.
	// - If the parent target or invocation is finalized.
	CreateConfiguredTarget(context.Context, *CreateConfiguredTargetRequest) (*ConfiguredTarget, error)
	// Applies a standard update to the configured target identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths. Fields that match the mask but aren't populated in the
	// given configured target are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	UpdateConfiguredTarget(context.Context, *UpdateConfiguredTargetRequest) (*ConfiguredTarget, error)
	// Applies a merge update to the configured target identified by the given
	// proto's name. For primitive and message fields, replaces them with the
	// ones in the given proto if they are covered under the field mask paths.
	// For repeated fields, merges to them with the given ones if they are
	// covered under the field mask paths. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty ConfiguredTarget proto with only the name and ID fields
	// populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	MergeConfiguredTarget(context.Context, *MergeConfiguredTargetRequest) (*ConfiguredTarget, error)
	// Declares the configured target with the given name as finalized and
	// immutable by the user. It may still be mutated by post-processing. This is
	// an implicitly idempotent API.
	//
	// An error will be reported in the following cases:
	// - If the configured target does not exist.
	FinalizeConfiguredTarget(context.Context, *FinalizeConfiguredTargetRequest) (*FinalizeConfiguredTargetResponse, error)
	// Creates the given action under the given configured target. The given
	// action ID is URL encoded, converted to the full resource name, and
	// assigned to the action's name field. This is not an implicitly
	// idempotent API, so a request id is required to make it idempotent.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no action ID provided.
	// - If the parent configured target does not exist.
	// - If the parent target or invocation is finalized.
	// - If an action  with the same name already exists.
	CreateAction(context.Context, *CreateActionRequest) (*Action, error)
	// Applies a standard update to the action identified by the given
	// proto's name.  For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given
	// field mask paths.  Fields that match the mask but aren't populated in the
	// given action are cleared.  This is an implicitly idempotent API.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the action does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	UpdateAction(context.Context, *UpdateActionRequest) (*Action, error)
	// Applies a merge update to the action identified by the given
	// proto's name.  For primitive and message fields, replaces them with the
	// ones in the given proto if they are covered under the field mask paths.
	// For repeated fields, merges to them with the given ones if they are
	// covered under the field mask paths. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty Action proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the action does not exist.
	// - If the parent target or invocation is finalized.
	// - If no field mask was given.
	MergeAction(context.Context, *MergeActionRequest) (*Action, error)
	// Creates the given configuration under the given parent invocation. The
	// given configuration ID is URL encoded, converted to the full resource name,
	// and assigned to the configuration's name field. The configuration ID of
	// "default" should be preferred for the default configuration in a
	// single-config invocation. This is not an implicitly idempotent API, so a
	// request id is required to make it idempotent.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If no configuration ID is provided.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	// - If a configuration with the same name already exists.
	CreateConfiguration(context.Context, *CreateConfigurationRequest) (*Configuration, error)
	// Applies a standard update to the configuration identified by the given
	// proto's name. For all types of fields (primitive, message, or repeated),
	// replaces them with the given proto fields if they are under the given field
	// mask paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty Configuration proto with only the name and ID fields
	// populated.
	//
	// An error will be reported in the following cases:
	// - If the configuration does not exist.
	// - If the parent invocation is finalized.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateConfiguration(context.Context, *UpdateConfigurationRequest) (*Configuration, error)
	// Creates the given file set under the given parent invocation. The given
	// file set ID is URL encoded, converted to the full resource name, and
	// assigned to the file set's name field. This is not an implicitly idempotent
	// API, so a request id is required to make it idempotent.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If no file set ID is provided.
	// - If a file set with the same name already exists.
	// - If the parent invocation does not exist.
	// - If the parent invocation is finalized.
	CreateFileSet(context.Context, *CreateFileSetRequest) (*FileSet, error)
	// Applies a standard update to the file set identified by the given proto's
	// name. For all types of fields (primitive, message, or repeated), replaces
	// them with the given proto fields if they are under the given field mask
	// paths. Fields that match the mask but aren't populated in the given
	// configuration are cleared. This is an implicitly idempotent API.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	// An error will be reported in the following cases:
	// - If the file set does not exist.
	// - If the parent invocation is finalized.
	// - If no field mask was given.
	// - If a given field mask path is not valid.
	UpdateFileSet(context.Context, *UpdateFileSetRequest) (*FileSet, error)
	// Applies a merge update to the file set identified by the given proto's
	// name. For primitive and message fields, updates them with the ones in the
	// given proto if they are covered under the field mask paths. For repeated
	// fields, merges to them with the given ones if they are covered under the
	// field mask paths. This is not an implicitly idempotent API, so a request
	// id is required to make it idempotent.
	//
	// Returns an empty FileSet proto with only the name and ID fields populated.
	//
	//
	// An error will be reported in the following cases:
	// - If the file set does not exist.
	// - If the parent invocation is finalized.
	// - If a given field mask path is not valid.
	// - If no field mask was given.
	MergeFileSet(context.Context, *MergeFileSetRequest) (*FileSet, error)
	// This is the RPC used for batch upload. It supports uploading multiple
	// resources for an invocation in a transaction safe manner.
	//
	// To use this RPC, the CreateInvocationRequest must have been provided a
	// resume_token.
	//
	// Combining batch upload with normal upload on a single Invocation is not
	// supported. If an Invocation is created with a resume_token, all further
	// calls must be through UploadBatch. If an Invocation is created without
	// resume_token normal upload, all further upload calls must be through normal
	// upload RPCs.
	UploadBatch(context.Context, *UploadBatchRequest) (*UploadBatchResponse, error)
	// Provides a way to read the metadata for an invocation.
	// The UploadMetadata could still be retrieved by this RPC even the Invocation
	// has been finalized.
	// This API requires setting a response FieldMask via 'fields' URL query
	// parameter or X-Goog-FieldMask HTTP/gRPC header.
	//
	// An error will be reported in the following case:
	// - If the invocation does not exist.
	// - If no field mask was given.
	GetInvocationUploadMetadata(context.Context, *GetInvocationUploadMetadataRequest) (*UploadMetadata, error)
}

// UnimplementedResultStoreUploadServer can be embedded to have forward compatible implementations.
type UnimplementedResultStoreUploadServer struct {
}

func (*UnimplementedResultStoreUploadServer) CreateInvocation(context.Context, *CreateInvocationRequest) (*Invocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateInvocation(context.Context, *UpdateInvocationRequest) (*Invocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) MergeInvocation(context.Context, *MergeInvocationRequest) (*Invocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) TouchInvocation(context.Context, *TouchInvocationRequest) (*TouchInvocationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TouchInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) FinalizeInvocation(context.Context, *FinalizeInvocationRequest) (*FinalizeInvocationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) DeleteInvocation(context.Context, *DeleteInvocationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInvocation not implemented")
}
func (*UnimplementedResultStoreUploadServer) CreateTarget(context.Context, *CreateTargetRequest) (*Target, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateTarget(context.Context, *UpdateTargetRequest) (*Target, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) MergeTarget(context.Context, *MergeTargetRequest) (*Target, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) FinalizeTarget(context.Context, *FinalizeTargetRequest) (*FinalizeTargetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) CreateConfiguredTarget(context.Context, *CreateConfiguredTargetRequest) (*ConfiguredTarget, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConfiguredTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateConfiguredTarget(context.Context, *UpdateConfiguredTargetRequest) (*ConfiguredTarget, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConfiguredTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) MergeConfiguredTarget(context.Context, *MergeConfiguredTargetRequest) (*ConfiguredTarget, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeConfiguredTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) FinalizeConfiguredTarget(context.Context, *FinalizeConfiguredTargetRequest) (*FinalizeConfiguredTargetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeConfiguredTarget not implemented")
}
func (*UnimplementedResultStoreUploadServer) CreateAction(context.Context, *CreateActionRequest) (*Action, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAction not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateAction(context.Context, *UpdateActionRequest) (*Action, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAction not implemented")
}
func (*UnimplementedResultStoreUploadServer) MergeAction(context.Context, *MergeActionRequest) (*Action, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeAction not implemented")
}
func (*UnimplementedResultStoreUploadServer) CreateConfiguration(context.Context, *CreateConfigurationRequest) (*Configuration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConfiguration not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateConfiguration(context.Context, *UpdateConfigurationRequest) (*Configuration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConfiguration not implemented")
}
func (*UnimplementedResultStoreUploadServer) CreateFileSet(context.Context, *CreateFileSetRequest) (*FileSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFileSet not implemented")
}
func (*UnimplementedResultStoreUploadServer) UpdateFileSet(context.Context, *UpdateFileSetRequest) (*FileSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFileSet not implemented")
}
func (*UnimplementedResultStoreUploadServer) MergeFileSet(context.Context, *MergeFileSetRequest) (*FileSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeFileSet not implemented")
}
func (*UnimplementedResultStoreUploadServer) UploadBatch(context.Context, *UploadBatchRequest) (*UploadBatchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UploadBatch not implemented")
}
func (*UnimplementedResultStoreUploadServer) GetInvocationUploadMetadata(context.Context, *GetInvocationUploadMetadataRequest) (*UploadMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInvocationUploadMetadata not implemented")
}

func RegisterResultStoreUploadServer(s *grpc.Server, srv ResultStoreUploadServer) {
	s.RegisterService(&_ResultStoreUpload_serviceDesc, srv)
}

func _ResultStoreUpload_CreateInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateInvocation(ctx, req.(*CreateInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateInvocation(ctx, req.(*UpdateInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_MergeInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).MergeInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/MergeInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).MergeInvocation(ctx, req.(*MergeInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_TouchInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TouchInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).TouchInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/TouchInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).TouchInvocation(ctx, req.(*TouchInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_FinalizeInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).FinalizeInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).FinalizeInvocation(ctx, req.(*FinalizeInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_DeleteInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).DeleteInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/DeleteInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).DeleteInvocation(ctx, req.(*DeleteInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateTarget(ctx, req.(*CreateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateTarget(ctx, req.(*UpdateTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_MergeTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).MergeTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/MergeTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).MergeTarget(ctx, req.(*MergeTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_FinalizeTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).FinalizeTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).FinalizeTarget(ctx, req.(*FinalizeTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateConfiguredTarget(ctx, req.(*CreateConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateConfiguredTarget(ctx, req.(*UpdateConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_MergeConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).MergeConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/MergeConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).MergeConfiguredTarget(ctx, req.(*MergeConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_FinalizeConfiguredTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeConfiguredTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).FinalizeConfiguredTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/FinalizeConfiguredTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).FinalizeConfiguredTarget(ctx, req.(*FinalizeConfiguredTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateAction(ctx, req.(*CreateActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateAction(ctx, req.(*UpdateActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_MergeAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).MergeAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/MergeAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).MergeAction(ctx, req.(*MergeActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateConfiguration(ctx, req.(*CreateConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateConfiguration(ctx, req.(*UpdateConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_CreateFileSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFileSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).CreateFileSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/CreateFileSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).CreateFileSet(ctx, req.(*CreateFileSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UpdateFileSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFileSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UpdateFileSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UpdateFileSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UpdateFileSet(ctx, req.(*UpdateFileSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_MergeFileSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeFileSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).MergeFileSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/MergeFileSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).MergeFileSet(ctx, req.(*MergeFileSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_UploadBatch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadBatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).UploadBatch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/UploadBatch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).UploadBatch(ctx, req.(*UploadBatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResultStoreUpload_GetInvocationUploadMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInvocationUploadMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResultStoreUploadServer).GetInvocationUploadMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.resultstore.v2.ResultStoreUpload/GetInvocationUploadMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResultStoreUploadServer).GetInvocationUploadMetadata(ctx, req.(*GetInvocationUploadMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResultStoreUpload_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.resultstore.v2.ResultStoreUpload",
	HandlerType: (*ResultStoreUploadServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateInvocation",
			Handler:    _ResultStoreUpload_CreateInvocation_Handler,
		},
		{
			MethodName: "UpdateInvocation",
			Handler:    _ResultStoreUpload_UpdateInvocation_Handler,
		},
		{
			MethodName: "MergeInvocation",
			Handler:    _ResultStoreUpload_MergeInvocation_Handler,
		},
		{
			MethodName: "TouchInvocation",
			Handler:    _ResultStoreUpload_TouchInvocation_Handler,
		},
		{
			MethodName: "FinalizeInvocation",
			Handler:    _ResultStoreUpload_FinalizeInvocation_Handler,
		},
		{
			MethodName: "DeleteInvocation",
			Handler:    _ResultStoreUpload_DeleteInvocation_Handler,
		},
		{
			MethodName: "CreateTarget",
			Handler:    _ResultStoreUpload_CreateTarget_Handler,
		},
		{
			MethodName: "UpdateTarget",
			Handler:    _ResultStoreUpload_UpdateTarget_Handler,
		},
		{
			MethodName: "MergeTarget",
			Handler:    _ResultStoreUpload_MergeTarget_Handler,
		},
		{
			MethodName: "FinalizeTarget",
			Handler:    _ResultStoreUpload_FinalizeTarget_Handler,
		},
		{
			MethodName: "CreateConfiguredTarget",
			Handler:    _ResultStoreUpload_CreateConfiguredTarget_Handler,
		},
		{
			MethodName: "UpdateConfiguredTarget",
			Handler:    _ResultStoreUpload_UpdateConfiguredTarget_Handler,
		},
		{
			MethodName: "MergeConfiguredTarget",
			Handler:    _ResultStoreUpload_MergeConfiguredTarget_Handler,
		},
		{
			MethodName: "FinalizeConfiguredTarget",
			Handler:    _ResultStoreUpload_FinalizeConfiguredTarget_Handler,
		},
		{
			MethodName: "CreateAction",
			Handler:    _ResultStoreUpload_CreateAction_Handler,
		},
		{
			MethodName: "UpdateAction",
			Handler:    _ResultStoreUpload_UpdateAction_Handler,
		},
		{
			MethodName: "MergeAction",
			Handler:    _ResultStoreUpload_MergeAction_Handler,
		},
		{
			MethodName: "CreateConfiguration",
			Handler:    _ResultStoreUpload_CreateConfiguration_Handler,
		},
		{
			MethodName: "UpdateConfiguration",
			Handler:    _ResultStoreUpload_UpdateConfiguration_Handler,
		},
		{
			MethodName: "CreateFileSet",
			Handler:    _ResultStoreUpload_CreateFileSet_Handler,
		},
		{
			MethodName: "UpdateFileSet",
			Handler:    _ResultStoreUpload_UpdateFileSet_Handler,
		},
		{
			MethodName: "MergeFileSet",
			Handler:    _ResultStoreUpload_MergeFileSet_Handler,
		},
		{
			MethodName: "UploadBatch",
			Handler:    _ResultStoreUpload_UploadBatch_Handler,
		},
		{
			MethodName: "GetInvocationUploadMetadata",
			Handler:    _ResultStoreUpload_GetInvocationUploadMetadata_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/resultstore/v2/resultstore_upload.proto",
}
