// Copyright 2016 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.2
// source: google/genomics/v1/annotations.proto

package genomics

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_struct "github.com/golang/protobuf/ptypes/struct"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// When an [Annotation][google.genomics.v1.Annotation] or
// [AnnotationSet][google.genomics.v1.AnnotationSet] is created, if `type` is
// not specified it will be set to `GENERIC`.
type AnnotationType int32

const (
	AnnotationType_ANNOTATION_TYPE_UNSPECIFIED AnnotationType = 0
	// A `GENERIC` annotation type should be used when no other annotation
	// type will suffice. This represents an untyped annotation of the reference
	// genome.
	AnnotationType_GENERIC AnnotationType = 1
	// A `VARIANT` annotation type.
	AnnotationType_VARIANT AnnotationType = 2
	// A `GENE` annotation type represents the existence of a gene at the
	// associated reference coordinates. The start coordinate is typically the
	// gene's transcription start site and the end is typically the end of the
	// gene's last exon.
	AnnotationType_GENE AnnotationType = 3
	// A `TRANSCRIPT` annotation type represents the assertion that a
	// particular region of the reference genome may be transcribed as RNA.
	AnnotationType_TRANSCRIPT AnnotationType = 4
)

// Enum value maps for AnnotationType.
var (
	AnnotationType_name = map[int32]string{
		0: "ANNOTATION_TYPE_UNSPECIFIED",
		1: "GENERIC",
		2: "VARIANT",
		3: "GENE",
		4: "TRANSCRIPT",
	}
	AnnotationType_value = map[string]int32{
		"ANNOTATION_TYPE_UNSPECIFIED": 0,
		"GENERIC":                     1,
		"VARIANT":                     2,
		"GENE":                        3,
		"TRANSCRIPT":                  4,
	}
)

func (x AnnotationType) Enum() *AnnotationType {
	p := new(AnnotationType)
	*p = x
	return p
}

func (x AnnotationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnnotationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_genomics_v1_annotations_proto_enumTypes[0].Descriptor()
}

func (AnnotationType) Type() protoreflect.EnumType {
	return &file_google_genomics_v1_annotations_proto_enumTypes[0]
}

func (x AnnotationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnnotationType.Descriptor instead.
func (AnnotationType) EnumDescriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{0}
}

type VariantAnnotation_Type int32

const (
	VariantAnnotation_TYPE_UNSPECIFIED VariantAnnotation_Type = 0
	// `TYPE_OTHER` should be used when no other Type will suffice.
	// Further explanation of the variant type may be included in the
	// [info][google.genomics.v1.Annotation.info] field.
	VariantAnnotation_TYPE_OTHER VariantAnnotation_Type = 1
	// `INSERTION` indicates an insertion.
	VariantAnnotation_INSERTION VariantAnnotation_Type = 2
	// `DELETION` indicates a deletion.
	VariantAnnotation_DELETION VariantAnnotation_Type = 3
	// `SUBSTITUTION` indicates a block substitution of
	// two or more nucleotides.
	VariantAnnotation_SUBSTITUTION VariantAnnotation_Type = 4
	// `SNP` indicates a single nucleotide polymorphism.
	VariantAnnotation_SNP VariantAnnotation_Type = 5
	// `STRUCTURAL` indicates a large structural variant,
	// including chromosomal fusions, inversions, etc.
	VariantAnnotation_STRUCTURAL VariantAnnotation_Type = 6
	// `CNV` indicates a variation in copy number.
	VariantAnnotation_CNV VariantAnnotation_Type = 7
)

// Enum value maps for VariantAnnotation_Type.
var (
	VariantAnnotation_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TYPE_OTHER",
		2: "INSERTION",
		3: "DELETION",
		4: "SUBSTITUTION",
		5: "SNP",
		6: "STRUCTURAL",
		7: "CNV",
	}
	VariantAnnotation_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"TYPE_OTHER":       1,
		"INSERTION":        2,
		"DELETION":         3,
		"SUBSTITUTION":     4,
		"SNP":              5,
		"STRUCTURAL":       6,
		"CNV":              7,
	}
)

func (x VariantAnnotation_Type) Enum() *VariantAnnotation_Type {
	p := new(VariantAnnotation_Type)
	*p = x
	return p
}

func (x VariantAnnotation_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VariantAnnotation_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_genomics_v1_annotations_proto_enumTypes[1].Descriptor()
}

func (VariantAnnotation_Type) Type() protoreflect.EnumType {
	return &file_google_genomics_v1_annotations_proto_enumTypes[1]
}

func (x VariantAnnotation_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VariantAnnotation_Type.Descriptor instead.
func (VariantAnnotation_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{2, 0}
}

type VariantAnnotation_Effect int32

const (
	VariantAnnotation_EFFECT_UNSPECIFIED VariantAnnotation_Effect = 0
	// `EFFECT_OTHER` should be used when no other Effect
	// will suffice.
	VariantAnnotation_EFFECT_OTHER VariantAnnotation_Effect = 1
	// `FRAMESHIFT` indicates a mutation in which the insertion or
	// deletion of nucleotides resulted in a frameshift change.
	VariantAnnotation_FRAMESHIFT VariantAnnotation_Effect = 2
	// `FRAME_PRESERVING_INDEL` indicates a mutation in which a
	// multiple of three nucleotides has been inserted or deleted, resulting
	// in no change to the reading frame of the coding sequence.
	VariantAnnotation_FRAME_PRESERVING_INDEL VariantAnnotation_Effect = 3
	// `SYNONYMOUS_SNP` indicates a single nucleotide polymorphism
	// mutation that results in no amino acid change.
	VariantAnnotation_SYNONYMOUS_SNP VariantAnnotation_Effect = 4
	// `NONSYNONYMOUS_SNP` indicates a single nucleotide
	// polymorphism mutation that results in an amino acid change.
	VariantAnnotation_NONSYNONYMOUS_SNP VariantAnnotation_Effect = 5
	// `STOP_GAIN` indicates a mutation that leads to the creation
	// of a stop codon at the variant site. Frameshift mutations creating
	// downstream stop codons do not count as `STOP_GAIN`.
	VariantAnnotation_STOP_GAIN VariantAnnotation_Effect = 6
	// `STOP_LOSS` indicates a mutation that eliminates a
	// stop codon at the variant site.
	VariantAnnotation_STOP_LOSS VariantAnnotation_Effect = 7
	// `SPLICE_SITE_DISRUPTION` indicates that this variant is
	// found in a splice site for the associated transcript, and alters the
	// normal splicing pattern.
	VariantAnnotation_SPLICE_SITE_DISRUPTION VariantAnnotation_Effect = 8
)

// Enum value maps for VariantAnnotation_Effect.
var (
	VariantAnnotation_Effect_name = map[int32]string{
		0: "EFFECT_UNSPECIFIED",
		1: "EFFECT_OTHER",
		2: "FRAMESHIFT",
		3: "FRAME_PRESERVING_INDEL",
		4: "SYNONYMOUS_SNP",
		5: "NONSYNONYMOUS_SNP",
		6: "STOP_GAIN",
		7: "STOP_LOSS",
		8: "SPLICE_SITE_DISRUPTION",
	}
	VariantAnnotation_Effect_value = map[string]int32{
		"EFFECT_UNSPECIFIED":     0,
		"EFFECT_OTHER":           1,
		"FRAMESHIFT":             2,
		"FRAME_PRESERVING_INDEL": 3,
		"SYNONYMOUS_SNP":         4,
		"NONSYNONYMOUS_SNP":      5,
		"STOP_GAIN":              6,
		"STOP_LOSS":              7,
		"SPLICE_SITE_DISRUPTION": 8,
	}
)

func (x VariantAnnotation_Effect) Enum() *VariantAnnotation_Effect {
	p := new(VariantAnnotation_Effect)
	*p = x
	return p
}

func (x VariantAnnotation_Effect) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VariantAnnotation_Effect) Descriptor() protoreflect.EnumDescriptor {
	return file_google_genomics_v1_annotations_proto_enumTypes[2].Descriptor()
}

func (VariantAnnotation_Effect) Type() protoreflect.EnumType {
	return &file_google_genomics_v1_annotations_proto_enumTypes[2]
}

func (x VariantAnnotation_Effect) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VariantAnnotation_Effect.Descriptor instead.
func (VariantAnnotation_Effect) EnumDescriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{2, 1}
}

type VariantAnnotation_ClinicalSignificance int32

const (
	VariantAnnotation_CLINICAL_SIGNIFICANCE_UNSPECIFIED VariantAnnotation_ClinicalSignificance = 0
	// `OTHER` should be used when no other clinical significance
	// value will suffice.
	VariantAnnotation_CLINICAL_SIGNIFICANCE_OTHER VariantAnnotation_ClinicalSignificance = 1
	VariantAnnotation_UNCERTAIN                   VariantAnnotation_ClinicalSignificance = 2
	VariantAnnotation_BENIGN                      VariantAnnotation_ClinicalSignificance = 3
	VariantAnnotation_LIKELY_BENIGN               VariantAnnotation_ClinicalSignificance = 4
	VariantAnnotation_LIKELY_PATHOGENIC           VariantAnnotation_ClinicalSignificance = 5
	VariantAnnotation_PATHOGENIC                  VariantAnnotation_ClinicalSignificance = 6
	VariantAnnotation_DRUG_RESPONSE               VariantAnnotation_ClinicalSignificance = 7
	VariantAnnotation_HISTOCOMPATIBILITY          VariantAnnotation_ClinicalSignificance = 8
	VariantAnnotation_CONFERS_SENSITIVITY         VariantAnnotation_ClinicalSignificance = 9
	VariantAnnotation_RISK_FACTOR                 VariantAnnotation_ClinicalSignificance = 10
	VariantAnnotation_ASSOCIATION                 VariantAnnotation_ClinicalSignificance = 11
	VariantAnnotation_PROTECTIVE                  VariantAnnotation_ClinicalSignificance = 12
	// `MULTIPLE_REPORTED` should be used when multiple clinical
	// signficances are reported for a variant. The original clinical
	// significance values may be provided in the `info` field.
	VariantAnnotation_MULTIPLE_REPORTED VariantAnnotation_ClinicalSignificance = 13
)

// Enum value maps for VariantAnnotation_ClinicalSignificance.
var (
	VariantAnnotation_ClinicalSignificance_name = map[int32]string{
		0:  "CLINICAL_SIGNIFICANCE_UNSPECIFIED",
		1:  "CLINICAL_SIGNIFICANCE_OTHER",
		2:  "UNCERTAIN",
		3:  "BENIGN",
		4:  "LIKELY_BENIGN",
		5:  "LIKELY_PATHOGENIC",
		6:  "PATHOGENIC",
		7:  "DRUG_RESPONSE",
		8:  "HISTOCOMPATIBILITY",
		9:  "CONFERS_SENSITIVITY",
		10: "RISK_FACTOR",
		11: "ASSOCIATION",
		12: "PROTECTIVE",
		13: "MULTIPLE_REPORTED",
	}
	VariantAnnotation_ClinicalSignificance_value = map[string]int32{
		"CLINICAL_SIGNIFICANCE_UNSPECIFIED": 0,
		"CLINICAL_SIGNIFICANCE_OTHER":       1,
		"UNCERTAIN":                         2,
		"BENIGN":                            3,
		"LIKELY_BENIGN":                     4,
		"LIKELY_PATHOGENIC":                 5,
		"PATHOGENIC":                        6,
		"DRUG_RESPONSE":                     7,
		"HISTOCOMPATIBILITY":                8,
		"CONFERS_SENSITIVITY":               9,
		"RISK_FACTOR":                       10,
		"ASSOCIATION":                       11,
		"PROTECTIVE":                        12,
		"MULTIPLE_REPORTED":                 13,
	}
)

func (x VariantAnnotation_ClinicalSignificance) Enum() *VariantAnnotation_ClinicalSignificance {
	p := new(VariantAnnotation_ClinicalSignificance)
	*p = x
	return p
}

func (x VariantAnnotation_ClinicalSignificance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VariantAnnotation_ClinicalSignificance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_genomics_v1_annotations_proto_enumTypes[3].Descriptor()
}

func (VariantAnnotation_ClinicalSignificance) Type() protoreflect.EnumType {
	return &file_google_genomics_v1_annotations_proto_enumTypes[3]
}

func (x VariantAnnotation_ClinicalSignificance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VariantAnnotation_ClinicalSignificance.Descriptor instead.
func (VariantAnnotation_ClinicalSignificance) EnumDescriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{2, 2}
}

// An annotation set is a logical grouping of annotations that share consistent
// type information and provenance. Examples of annotation sets include 'all
// genes from refseq', and 'all variant annotations from ClinVar'.
type AnnotationSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The server-generated annotation set ID, unique across all annotation sets.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The dataset to which this annotation set belongs.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The ID of the reference set that defines the coordinate space for this
	// set's annotations.
	ReferenceSetId string `protobuf:"bytes,3,opt,name=reference_set_id,json=referenceSetId,proto3" json:"reference_set_id,omitempty"`
	// The display name for this annotation set.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The source URI describing the file from which this annotation set was
	// generated, if any.
	SourceUri string `protobuf:"bytes,5,opt,name=source_uri,json=sourceUri,proto3" json:"source_uri,omitempty"`
	// The type of annotations contained within this set.
	Type AnnotationType `protobuf:"varint,6,opt,name=type,proto3,enum=google.genomics.v1.AnnotationType" json:"type,omitempty"`
	// A map of additional read alignment information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*_struct.ListValue `protobuf:"bytes,17,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AnnotationSet) Reset() {
	*x = AnnotationSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationSet) ProtoMessage() {}

func (x *AnnotationSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationSet.ProtoReflect.Descriptor instead.
func (*AnnotationSet) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{0}
}

func (x *AnnotationSet) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AnnotationSet) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *AnnotationSet) GetReferenceSetId() string {
	if x != nil {
		return x.ReferenceSetId
	}
	return ""
}

func (x *AnnotationSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnnotationSet) GetSourceUri() string {
	if x != nil {
		return x.SourceUri
	}
	return ""
}

func (x *AnnotationSet) GetType() AnnotationType {
	if x != nil {
		return x.Type
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (x *AnnotationSet) GetInfo() map[string]*_struct.ListValue {
	if x != nil {
		return x.Info
	}
	return nil
}

// An annotation describes a region of reference genome. The value of an
// annotation may be one of several canonical types, supplemented by arbitrary
// info tags. An annotation is not inherently associated with a specific
// sample or individual (though a client could choose to use annotations in
// this way). Example canonical annotation types are `GENE` and
// `VARIANT`.
type Annotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The server-generated annotation ID, unique across all annotations.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The annotation set to which this annotation belongs.
	AnnotationSetId string `protobuf:"bytes,2,opt,name=annotation_set_id,json=annotationSetId,proto3" json:"annotation_set_id,omitempty"`
	// The display name of this annotation.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The ID of the Google Genomics reference associated with this range.
	ReferenceId string `protobuf:"bytes,4,opt,name=reference_id,json=referenceId,proto3" json:"reference_id,omitempty"`
	// The display name corresponding to the reference specified by
	// `referenceId`, for example `chr1`, `1`, or `chrX`.
	ReferenceName string `protobuf:"bytes,5,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// The start position of the range on the reference, 0-based inclusive.
	Start int64 `protobuf:"varint,6,opt,name=start,proto3" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive.
	End int64 `protobuf:"varint,7,opt,name=end,proto3" json:"end,omitempty"`
	// Whether this range refers to the reverse strand, as opposed to the forward
	// strand. Note that regardless of this field, the start/end position of the
	// range always refer to the forward strand.
	ReverseStrand bool `protobuf:"varint,8,opt,name=reverse_strand,json=reverseStrand,proto3" json:"reverse_strand,omitempty"`
	// The data type for this annotation. Must match the containing annotation
	// set's type.
	Type AnnotationType `protobuf:"varint,9,opt,name=type,proto3,enum=google.genomics.v1.AnnotationType" json:"type,omitempty"`
	// Types that are assignable to Value:
	//	*Annotation_Variant
	//	*Annotation_Transcript
	Value isAnnotation_Value `protobuf_oneof:"value"`
	// A map of additional read alignment information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*_struct.ListValue `protobuf:"bytes,12,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Annotation) Reset() {
	*x = Annotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Annotation) ProtoMessage() {}

func (x *Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Annotation.ProtoReflect.Descriptor instead.
func (*Annotation) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{1}
}

func (x *Annotation) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Annotation) GetAnnotationSetId() string {
	if x != nil {
		return x.AnnotationSetId
	}
	return ""
}

func (x *Annotation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Annotation) GetReferenceId() string {
	if x != nil {
		return x.ReferenceId
	}
	return ""
}

func (x *Annotation) GetReferenceName() string {
	if x != nil {
		return x.ReferenceName
	}
	return ""
}

func (x *Annotation) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Annotation) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *Annotation) GetReverseStrand() bool {
	if x != nil {
		return x.ReverseStrand
	}
	return false
}

func (x *Annotation) GetType() AnnotationType {
	if x != nil {
		return x.Type
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (m *Annotation) GetValue() isAnnotation_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Annotation) GetVariant() *VariantAnnotation {
	if x, ok := x.GetValue().(*Annotation_Variant); ok {
		return x.Variant
	}
	return nil
}

func (x *Annotation) GetTranscript() *Transcript {
	if x, ok := x.GetValue().(*Annotation_Transcript); ok {
		return x.Transcript
	}
	return nil
}

func (x *Annotation) GetInfo() map[string]*_struct.ListValue {
	if x != nil {
		return x.Info
	}
	return nil
}

type isAnnotation_Value interface {
	isAnnotation_Value()
}

type Annotation_Variant struct {
	// A variant annotation, which describes the effect of a variant on the
	// genome, the coding sequence, and/or higher level consequences at the
	// organism level e.g. pathogenicity. This field is only set for annotations
	// of type `VARIANT`.
	Variant *VariantAnnotation `protobuf:"bytes,10,opt,name=variant,proto3,oneof"`
}

type Annotation_Transcript struct {
	// A transcript value represents the assertion that a particular region of
	// the reference genome may be transcribed as RNA. An alternative splicing
	// pattern would be represented as a separate transcript object. This field
	// is only set for annotations of type `TRANSCRIPT`.
	Transcript *Transcript `protobuf:"bytes,11,opt,name=transcript,proto3,oneof"`
}

func (*Annotation_Variant) isAnnotation_Value() {}

func (*Annotation_Transcript) isAnnotation_Value() {}

type VariantAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type has been adapted from ClinVar's list of variant types.
	Type VariantAnnotation_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.genomics.v1.VariantAnnotation_Type" json:"type,omitempty"`
	// Effect of the variant on the coding sequence.
	Effect VariantAnnotation_Effect `protobuf:"varint,2,opt,name=effect,proto3,enum=google.genomics.v1.VariantAnnotation_Effect" json:"effect,omitempty"`
	// The alternate allele for this variant. If multiple alternate alleles
	// exist at this location, create a separate variant for each one, as they
	// may represent distinct conditions.
	AlternateBases string `protobuf:"bytes,3,opt,name=alternate_bases,json=alternateBases,proto3" json:"alternate_bases,omitempty"`
	// Google annotation ID of the gene affected by this variant. This should
	// be provided when the variant is created.
	GeneId string `protobuf:"bytes,4,opt,name=gene_id,json=geneId,proto3" json:"gene_id,omitempty"`
	// Google annotation IDs of the transcripts affected by this variant. These
	// should be provided when the variant is created.
	TranscriptIds []string `protobuf:"bytes,5,rep,name=transcript_ids,json=transcriptIds,proto3" json:"transcript_ids,omitempty"`
	// The set of conditions associated with this variant.
	// A condition describes the way a variant influences human health.
	Conditions []*VariantAnnotation_ClinicalCondition `protobuf:"bytes,6,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// Describes the clinical significance of a variant.
	// It is adapted from the ClinVar controlled vocabulary for clinical
	// significance described at:
	// http://www.ncbi.nlm.nih.gov/clinvar/docs/clinsig/
	ClinicalSignificance VariantAnnotation_ClinicalSignificance `protobuf:"varint,7,opt,name=clinical_significance,json=clinicalSignificance,proto3,enum=google.genomics.v1.VariantAnnotation_ClinicalSignificance" json:"clinical_significance,omitempty"`
}

func (x *VariantAnnotation) Reset() {
	*x = VariantAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VariantAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VariantAnnotation) ProtoMessage() {}

func (x *VariantAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VariantAnnotation.ProtoReflect.Descriptor instead.
func (*VariantAnnotation) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{2}
}

func (x *VariantAnnotation) GetType() VariantAnnotation_Type {
	if x != nil {
		return x.Type
	}
	return VariantAnnotation_TYPE_UNSPECIFIED
}

func (x *VariantAnnotation) GetEffect() VariantAnnotation_Effect {
	if x != nil {
		return x.Effect
	}
	return VariantAnnotation_EFFECT_UNSPECIFIED
}

func (x *VariantAnnotation) GetAlternateBases() string {
	if x != nil {
		return x.AlternateBases
	}
	return ""
}

func (x *VariantAnnotation) GetGeneId() string {
	if x != nil {
		return x.GeneId
	}
	return ""
}

func (x *VariantAnnotation) GetTranscriptIds() []string {
	if x != nil {
		return x.TranscriptIds
	}
	return nil
}

func (x *VariantAnnotation) GetConditions() []*VariantAnnotation_ClinicalCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *VariantAnnotation) GetClinicalSignificance() VariantAnnotation_ClinicalSignificance {
	if x != nil {
		return x.ClinicalSignificance
	}
	return VariantAnnotation_CLINICAL_SIGNIFICANCE_UNSPECIFIED
}

// A transcript represents the assertion that a particular region of the
// reference genome may be transcribed as RNA.
type Transcript struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotation ID of the gene from which this transcript is transcribed.
	GeneId string `protobuf:"bytes,1,opt,name=gene_id,json=geneId,proto3" json:"gene_id,omitempty"`
	// The <a href="http://en.wikipedia.org/wiki/Exon">exons</a> that compose
	// this transcript. This field should be unset for genomes where transcript
	// splicing does not occur, for example prokaryotes.
	//
	// Introns are regions of the transcript that are not included in the
	// spliced RNA product. Though not explicitly modeled here, intron ranges can
	// be deduced; all regions of this transcript that are not exons are introns.
	//
	// Exonic sequences do not necessarily code for a translational product
	// (amino acids). Only the regions of exons bounded by the
	// [codingSequence][google.genomics.v1.Transcript.coding_sequence] correspond
	// to coding DNA sequence.
	//
	// Exons are ordered by start position and may not overlap.
	Exons []*Transcript_Exon `protobuf:"bytes,2,rep,name=exons,proto3" json:"exons,omitempty"`
	// The range of the coding sequence for this transcript, if any. To determine
	// the exact ranges of coding sequence, intersect this range with those of the
	// [exons][google.genomics.v1.Transcript.exons], if any. If there are any
	// [exons][google.genomics.v1.Transcript.exons], the
	// [codingSequence][google.genomics.v1.Transcript.coding_sequence] must start
	// and end within them.
	//
	// Note that in some cases, the reference genome will not exactly match the
	// observed mRNA transcript e.g. due to variance in the source genome from
	// reference. In these cases,
	// [exon.frame][google.genomics.v1.Transcript.Exon.frame] will not necessarily
	// match the expected reference reading frame and coding exon reference bases
	// cannot necessarily be concatenated to produce the original transcript mRNA.
	CodingSequence *Transcript_CodingSequence `protobuf:"bytes,3,opt,name=coding_sequence,json=codingSequence,proto3" json:"coding_sequence,omitempty"`
}

func (x *Transcript) Reset() {
	*x = Transcript{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Transcript) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Transcript) ProtoMessage() {}

func (x *Transcript) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Transcript.ProtoReflect.Descriptor instead.
func (*Transcript) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{3}
}

func (x *Transcript) GetGeneId() string {
	if x != nil {
		return x.GeneId
	}
	return ""
}

func (x *Transcript) GetExons() []*Transcript_Exon {
	if x != nil {
		return x.Exons
	}
	return nil
}

func (x *Transcript) GetCodingSequence() *Transcript_CodingSequence {
	if x != nil {
		return x.CodingSequence
	}
	return nil
}

type ExternalId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the source of this data.
	SourceName string `protobuf:"bytes,1,opt,name=source_name,json=sourceName,proto3" json:"source_name,omitempty"`
	// The id used by the source of this data.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ExternalId) Reset() {
	*x = ExternalId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalId) ProtoMessage() {}

func (x *ExternalId) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalId.ProtoReflect.Descriptor instead.
func (*ExternalId) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{4}
}

func (x *ExternalId) GetSourceName() string {
	if x != nil {
		return x.SourceName
	}
	return ""
}

func (x *ExternalId) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type CreateAnnotationSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotation set to create.
	AnnotationSet *AnnotationSet `protobuf:"bytes,1,opt,name=annotation_set,json=annotationSet,proto3" json:"annotation_set,omitempty"`
}

func (x *CreateAnnotationSetRequest) Reset() {
	*x = CreateAnnotationSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnnotationSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnnotationSetRequest) ProtoMessage() {}

func (x *CreateAnnotationSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnnotationSetRequest.ProtoReflect.Descriptor instead.
func (*CreateAnnotationSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{5}
}

func (x *CreateAnnotationSetRequest) GetAnnotationSet() *AnnotationSet {
	if x != nil {
		return x.AnnotationSet
	}
	return nil
}

type GetAnnotationSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the annotation set to be retrieved.
	AnnotationSetId string `protobuf:"bytes,1,opt,name=annotation_set_id,json=annotationSetId,proto3" json:"annotation_set_id,omitempty"`
}

func (x *GetAnnotationSetRequest) Reset() {
	*x = GetAnnotationSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAnnotationSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnnotationSetRequest) ProtoMessage() {}

func (x *GetAnnotationSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnnotationSetRequest.ProtoReflect.Descriptor instead.
func (*GetAnnotationSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{6}
}

func (x *GetAnnotationSetRequest) GetAnnotationSetId() string {
	if x != nil {
		return x.AnnotationSetId
	}
	return ""
}

type UpdateAnnotationSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the annotation set to be updated.
	AnnotationSetId string `protobuf:"bytes,1,opt,name=annotation_set_id,json=annotationSetId,proto3" json:"annotation_set_id,omitempty"`
	// The new annotation set.
	AnnotationSet *AnnotationSet `protobuf:"bytes,2,opt,name=annotation_set,json=annotationSet,proto3" json:"annotation_set,omitempty"`
	// An optional mask specifying which fields to update. Mutable fields are
	// [name][google.genomics.v1.AnnotationSet.name],
	// [source_uri][google.genomics.v1.AnnotationSet.source_uri], and
	// [info][google.genomics.v1.AnnotationSet.info]. If unspecified, all
	// mutable fields will be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAnnotationSetRequest) Reset() {
	*x = UpdateAnnotationSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAnnotationSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAnnotationSetRequest) ProtoMessage() {}

func (x *UpdateAnnotationSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAnnotationSetRequest.ProtoReflect.Descriptor instead.
func (*UpdateAnnotationSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateAnnotationSetRequest) GetAnnotationSetId() string {
	if x != nil {
		return x.AnnotationSetId
	}
	return ""
}

func (x *UpdateAnnotationSetRequest) GetAnnotationSet() *AnnotationSet {
	if x != nil {
		return x.AnnotationSet
	}
	return nil
}

func (x *UpdateAnnotationSetRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

type DeleteAnnotationSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the annotation set to be deleted.
	AnnotationSetId string `protobuf:"bytes,1,opt,name=annotation_set_id,json=annotationSetId,proto3" json:"annotation_set_id,omitempty"`
}

func (x *DeleteAnnotationSetRequest) Reset() {
	*x = DeleteAnnotationSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAnnotationSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnnotationSetRequest) ProtoMessage() {}

func (x *DeleteAnnotationSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnnotationSetRequest.ProtoReflect.Descriptor instead.
func (*DeleteAnnotationSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteAnnotationSetRequest) GetAnnotationSetId() string {
	if x != nil {
		return x.AnnotationSetId
	}
	return ""
}

type SearchAnnotationSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The dataset IDs to search within. Caller must have `READ` access
	// to these datasets.
	DatasetIds []string `protobuf:"bytes,1,rep,name=dataset_ids,json=datasetIds,proto3" json:"dataset_ids,omitempty"`
	// If specified, only annotation sets associated with the given reference set
	// are returned.
	ReferenceSetId string `protobuf:"bytes,2,opt,name=reference_set_id,json=referenceSetId,proto3" json:"reference_set_id,omitempty"`
	// Only return annotations sets for which a substring of the name matches this
	// string (case insensitive).
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// If specified, only annotation sets that have any of these types are
	// returned.
	Types []AnnotationType `protobuf:"varint,4,rep,packed,name=types,proto3,enum=google.genomics.v1.AnnotationType" json:"types,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 128. The maximum value is 1024.
	PageSize int32 `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *SearchAnnotationSetsRequest) Reset() {
	*x = SearchAnnotationSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAnnotationSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAnnotationSetsRequest) ProtoMessage() {}

func (x *SearchAnnotationSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAnnotationSetsRequest.ProtoReflect.Descriptor instead.
func (*SearchAnnotationSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{9}
}

func (x *SearchAnnotationSetsRequest) GetDatasetIds() []string {
	if x != nil {
		return x.DatasetIds
	}
	return nil
}

func (x *SearchAnnotationSetsRequest) GetReferenceSetId() string {
	if x != nil {
		return x.ReferenceSetId
	}
	return ""
}

func (x *SearchAnnotationSetsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchAnnotationSetsRequest) GetTypes() []AnnotationType {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *SearchAnnotationSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchAnnotationSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

type SearchAnnotationSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The matching annotation sets.
	AnnotationSets []*AnnotationSet `protobuf:"bytes,1,rep,name=annotation_sets,json=annotationSets,proto3" json:"annotation_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAnnotationSetsResponse) Reset() {
	*x = SearchAnnotationSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAnnotationSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAnnotationSetsResponse) ProtoMessage() {}

func (x *SearchAnnotationSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAnnotationSetsResponse.ProtoReflect.Descriptor instead.
func (*SearchAnnotationSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{10}
}

func (x *SearchAnnotationSetsResponse) GetAnnotationSets() []*AnnotationSet {
	if x != nil {
		return x.AnnotationSets
	}
	return nil
}

func (x *SearchAnnotationSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotation to be created.
	Annotation *Annotation `protobuf:"bytes,1,opt,name=annotation,proto3" json:"annotation,omitempty"`
}

func (x *CreateAnnotationRequest) Reset() {
	*x = CreateAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnnotationRequest) ProtoMessage() {}

func (x *CreateAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnnotationRequest.ProtoReflect.Descriptor instead.
func (*CreateAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{11}
}

func (x *CreateAnnotationRequest) GetAnnotation() *Annotation {
	if x != nil {
		return x.Annotation
	}
	return nil
}

type BatchCreateAnnotationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotations to be created. At most 4096 can be specified in a single
	// request.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// A unique request ID which enables the server to detect duplicated requests.
	// If provided, duplicated requests will result in the same response; if not
	// provided, duplicated requests may result in duplicated data. For a given
	// annotation set, callers should not reuse `request_id`s when writing
	// different batches of annotations - behavior in this case is undefined.
	// A common approach is to use a UUID. For batch jobs where worker crashes are
	// a possibility, consider using some unique variant of a worker or run ID.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *BatchCreateAnnotationsRequest) Reset() {
	*x = BatchCreateAnnotationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateAnnotationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateAnnotationsRequest) ProtoMessage() {}

func (x *BatchCreateAnnotationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateAnnotationsRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateAnnotationsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{12}
}

func (x *BatchCreateAnnotationsRequest) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *BatchCreateAnnotationsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

type BatchCreateAnnotationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resulting per-annotation entries, ordered consistently with the
	// original request.
	Entries []*BatchCreateAnnotationsResponse_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *BatchCreateAnnotationsResponse) Reset() {
	*x = BatchCreateAnnotationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateAnnotationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateAnnotationsResponse) ProtoMessage() {}

func (x *BatchCreateAnnotationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateAnnotationsResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateAnnotationsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{13}
}

func (x *BatchCreateAnnotationsResponse) GetEntries() []*BatchCreateAnnotationsResponse_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type GetAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the annotation to be retrieved.
	AnnotationId string `protobuf:"bytes,1,opt,name=annotation_id,json=annotationId,proto3" json:"annotation_id,omitempty"`
}

func (x *GetAnnotationRequest) Reset() {
	*x = GetAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnnotationRequest) ProtoMessage() {}

func (x *GetAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnnotationRequest.ProtoReflect.Descriptor instead.
func (*GetAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{14}
}

func (x *GetAnnotationRequest) GetAnnotationId() string {
	if x != nil {
		return x.AnnotationId
	}
	return ""
}

type UpdateAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the annotation to be updated.
	AnnotationId string `protobuf:"bytes,1,opt,name=annotation_id,json=annotationId,proto3" json:"annotation_id,omitempty"`
	// The new annotation.
	Annotation *Annotation `protobuf:"bytes,2,opt,name=annotation,proto3" json:"annotation,omitempty"`
	// An optional mask specifying which fields to update. Mutable fields are
	// [name][google.genomics.v1.Annotation.name],
	// [variant][google.genomics.v1.Annotation.variant],
	// [transcript][google.genomics.v1.Annotation.transcript], and
	// [info][google.genomics.v1.Annotation.info]. If unspecified, all mutable
	// fields will be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAnnotationRequest) Reset() {
	*x = UpdateAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAnnotationRequest) ProtoMessage() {}

func (x *UpdateAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAnnotationRequest.ProtoReflect.Descriptor instead.
func (*UpdateAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateAnnotationRequest) GetAnnotationId() string {
	if x != nil {
		return x.AnnotationId
	}
	return ""
}

func (x *UpdateAnnotationRequest) GetAnnotation() *Annotation {
	if x != nil {
		return x.Annotation
	}
	return nil
}

func (x *UpdateAnnotationRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

type DeleteAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the annotation to be deleted.
	AnnotationId string `protobuf:"bytes,1,opt,name=annotation_id,json=annotationId,proto3" json:"annotation_id,omitempty"`
}

func (x *DeleteAnnotationRequest) Reset() {
	*x = DeleteAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnnotationRequest) ProtoMessage() {}

func (x *DeleteAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnnotationRequest.ProtoReflect.Descriptor instead.
func (*DeleteAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteAnnotationRequest) GetAnnotationId() string {
	if x != nil {
		return x.AnnotationId
	}
	return ""
}

type SearchAnnotationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The annotation sets to search within. The caller must have
	// `READ` access to these annotation sets.
	// All queried annotation sets must have the same type.
	AnnotationSetIds []string `protobuf:"bytes,1,rep,name=annotation_set_ids,json=annotationSetIds,proto3" json:"annotation_set_ids,omitempty"`
	// Required. `reference_id` or `reference_name` must be set.
	//
	// Types that are assignable to Reference:
	//	*SearchAnnotationsRequest_ReferenceId
	//	*SearchAnnotationsRequest_ReferenceName
	Reference isSearchAnnotationsRequest_Reference `protobuf_oneof:"reference"`
	// The start position of the range on the reference, 0-based inclusive. If
	// specified,
	// [referenceId][google.genomics.v1.SearchAnnotationsRequest.reference_id] or
	// [referenceName][google.genomics.v1.SearchAnnotationsRequest.reference_name]
	// must be specified. Defaults to 0.
	Start int64 `protobuf:"varint,4,opt,name=start,proto3" json:"start,omitempty"`
	// The end position of the range on the reference, 0-based exclusive. If
	// [referenceId][google.genomics.v1.SearchAnnotationsRequest.reference_id] or
	// [referenceName][google.genomics.v1.SearchAnnotationsRequest.reference_name]
	// must be specified, Defaults to the length of the reference.
	End int64 `protobuf:"varint,5,opt,name=end,proto3" json:"end,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 256. The maximum value is 2048.
	PageSize int32 `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *SearchAnnotationsRequest) Reset() {
	*x = SearchAnnotationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAnnotationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAnnotationsRequest) ProtoMessage() {}

func (x *SearchAnnotationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAnnotationsRequest.ProtoReflect.Descriptor instead.
func (*SearchAnnotationsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{17}
}

func (x *SearchAnnotationsRequest) GetAnnotationSetIds() []string {
	if x != nil {
		return x.AnnotationSetIds
	}
	return nil
}

func (m *SearchAnnotationsRequest) GetReference() isSearchAnnotationsRequest_Reference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (x *SearchAnnotationsRequest) GetReferenceId() string {
	if x, ok := x.GetReference().(*SearchAnnotationsRequest_ReferenceId); ok {
		return x.ReferenceId
	}
	return ""
}

func (x *SearchAnnotationsRequest) GetReferenceName() string {
	if x, ok := x.GetReference().(*SearchAnnotationsRequest_ReferenceName); ok {
		return x.ReferenceName
	}
	return ""
}

func (x *SearchAnnotationsRequest) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *SearchAnnotationsRequest) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *SearchAnnotationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchAnnotationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

type isSearchAnnotationsRequest_Reference interface {
	isSearchAnnotationsRequest_Reference()
}

type SearchAnnotationsRequest_ReferenceId struct {
	// The ID of the reference to query.
	ReferenceId string `protobuf:"bytes,2,opt,name=reference_id,json=referenceId,proto3,oneof"`
}

type SearchAnnotationsRequest_ReferenceName struct {
	// The name of the reference to query, within the reference set associated
	// with this query.
	ReferenceName string `protobuf:"bytes,3,opt,name=reference_name,json=referenceName,proto3,oneof"`
}

func (*SearchAnnotationsRequest_ReferenceId) isSearchAnnotationsRequest_Reference() {}

func (*SearchAnnotationsRequest_ReferenceName) isSearchAnnotationsRequest_Reference() {}

type SearchAnnotationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The matching annotations.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAnnotationsResponse) Reset() {
	*x = SearchAnnotationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAnnotationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAnnotationsResponse) ProtoMessage() {}

func (x *SearchAnnotationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAnnotationsResponse.ProtoReflect.Descriptor instead.
func (*SearchAnnotationsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{18}
}

func (x *SearchAnnotationsResponse) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *SearchAnnotationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type VariantAnnotation_ClinicalCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A set of names for the condition.
	Names []string `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
	// The set of external IDs for this condition.
	ExternalIds []*ExternalId `protobuf:"bytes,2,rep,name=external_ids,json=externalIds,proto3" json:"external_ids,omitempty"`
	// The MedGen concept id associated with this gene.
	// Search for these IDs at http://www.ncbi.nlm.nih.gov/medgen/
	ConceptId string `protobuf:"bytes,3,opt,name=concept_id,json=conceptId,proto3" json:"concept_id,omitempty"`
	// The OMIM id for this condition.
	// Search for these IDs at http://omim.org/
	OmimId string `protobuf:"bytes,4,opt,name=omim_id,json=omimId,proto3" json:"omim_id,omitempty"`
}

func (x *VariantAnnotation_ClinicalCondition) Reset() {
	*x = VariantAnnotation_ClinicalCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VariantAnnotation_ClinicalCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VariantAnnotation_ClinicalCondition) ProtoMessage() {}

func (x *VariantAnnotation_ClinicalCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VariantAnnotation_ClinicalCondition.ProtoReflect.Descriptor instead.
func (*VariantAnnotation_ClinicalCondition) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{2, 0}
}

func (x *VariantAnnotation_ClinicalCondition) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

func (x *VariantAnnotation_ClinicalCondition) GetExternalIds() []*ExternalId {
	if x != nil {
		return x.ExternalIds
	}
	return nil
}

func (x *VariantAnnotation_ClinicalCondition) GetConceptId() string {
	if x != nil {
		return x.ConceptId
	}
	return ""
}

func (x *VariantAnnotation_ClinicalCondition) GetOmimId() string {
	if x != nil {
		return x.OmimId
	}
	return ""
}

type Transcript_Exon struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start position of the exon on this annotation's reference sequence,
	// 0-based inclusive. Note that this is relative to the reference start, and
	// **not** the containing annotation start.
	Start int64 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// The end position of the exon on this annotation's reference sequence,
	// 0-based exclusive. Note that this is relative to the reference start, and
	// *not* the containing annotation start.
	End int64 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	// The frame of this exon. Contains a value of 0, 1, or 2, which indicates
	// the offset of the first coding base of the exon within the reading frame
	// of the coding DNA sequence, if any. This field is dependent on the
	// strandedness of this annotation (see
	// [Annotation.reverse_strand][google.genomics.v1.Annotation.reverse_strand]).
	// For forward stranded annotations, this offset is relative to the
	// [exon.start][google.genomics.v1.Transcript.Exon.start]. For reverse
	// strand annotations, this offset is relative to the
	// [exon.end][google.genomics.v1.Transcript.Exon.end] `- 1`.
	//
	// Unset if this exon does not intersect the coding sequence. Upon creation
	// of a transcript, the frame must be populated for all or none of the
	// coding exons.
	Frame *wrappers.Int32Value `protobuf:"bytes,3,opt,name=frame,proto3" json:"frame,omitempty"`
}

func (x *Transcript_Exon) Reset() {
	*x = Transcript_Exon{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Transcript_Exon) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Transcript_Exon) ProtoMessage() {}

func (x *Transcript_Exon) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Transcript_Exon.ProtoReflect.Descriptor instead.
func (*Transcript_Exon) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Transcript_Exon) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Transcript_Exon) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *Transcript_Exon) GetFrame() *wrappers.Int32Value {
	if x != nil {
		return x.Frame
	}
	return nil
}

type Transcript_CodingSequence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start of the coding sequence on this annotation's reference sequence,
	// 0-based inclusive. Note that this position is relative to the reference
	// start, and *not* the containing annotation start.
	Start int64 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// The end of the coding sequence on this annotation's reference sequence,
	// 0-based exclusive. Note that this position is relative to the reference
	// start, and *not* the containing annotation start.
	End int64 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *Transcript_CodingSequence) Reset() {
	*x = Transcript_CodingSequence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Transcript_CodingSequence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Transcript_CodingSequence) ProtoMessage() {}

func (x *Transcript_CodingSequence) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Transcript_CodingSequence.ProtoReflect.Descriptor instead.
func (*Transcript_CodingSequence) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{3, 1}
}

func (x *Transcript_CodingSequence) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Transcript_CodingSequence) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

type BatchCreateAnnotationsResponse_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The creation status.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// The created annotation, if creation was successful.
	Annotation *Annotation `protobuf:"bytes,2,opt,name=annotation,proto3" json:"annotation,omitempty"`
}

func (x *BatchCreateAnnotationsResponse_Entry) Reset() {
	*x = BatchCreateAnnotationsResponse_Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_annotations_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateAnnotationsResponse_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateAnnotationsResponse_Entry) ProtoMessage() {}

func (x *BatchCreateAnnotationsResponse_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_annotations_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateAnnotationsResponse_Entry.ProtoReflect.Descriptor instead.
func (*BatchCreateAnnotationsResponse_Entry) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_annotations_proto_rawDescGZIP(), []int{13, 0}
}

func (x *BatchCreateAnnotationsResponse_Entry) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *BatchCreateAnnotationsResponse_Entry) GetAnnotation() *Annotation {
	if x != nil {
		return x.Annotation
	}
	return nil
}

var File_google_genomics_v1_annotations_proto protoreflect.FileDescriptor

var file_google_genomics_v1_annotations_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70,
	0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe9,
	0x02, 0x0a, 0x0d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x28, 0x0a, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x36, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x3f, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x11, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x53, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xce, 0x04, 0x0a, 0x0a, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x72,
	0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0d, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x53, 0x74, 0x72, 0x61,
	0x6e, 0x64, 0x12, 0x36, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x41, 0x0a, 0x07, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x40, 0x0a,
	0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12,
	0x3c, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e,
	0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x53, 0x0a,
	0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x30, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xfb, 0x09, 0x0a, 0x11,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x44, 0x0a, 0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x52,
	0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x6c, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x42, 0x61, 0x73, 0x65, 0x73,
	0x12, 0x17, 0x0a, 0x07, 0x67, 0x65, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x67, 0x65, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x49, 0x64, 0x73,
	0x12, 0x57, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6c, 0x69, 0x6e,
	0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6f, 0x0a, 0x15, 0x63, 0x6c, 0x69,
	0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x43, 0x6c, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x14, 0x63, 0x6c, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x69,
	0x67, 0x6e, 0x69, 0x66, 0x69, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0xa4, 0x01, 0x0a, 0x11, 0x43,
	0x6c, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x14, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x0c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x52, 0x0b, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x63, 0x65, 0x70, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x6f, 0x6d, 0x69, 0x6d,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x6d, 0x69, 0x6d, 0x49,
	0x64, 0x22, 0x7d, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0e, 0x0a, 0x0a, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x53, 0x45, 0x52, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c,
	0x53, 0x55, 0x42, 0x53, 0x54, 0x49, 0x54, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x07,
	0x0a, 0x03, 0x53, 0x4e, 0x50, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x54, 0x52, 0x55, 0x43,
	0x54, 0x55, 0x52, 0x41, 0x4c, 0x10, 0x06, 0x12, 0x07, 0x0a, 0x03, 0x43, 0x4e, 0x56, 0x10, 0x07,
	0x22, 0xc3, 0x01, 0x0a, 0x06, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x45,
	0x46, 0x46, 0x45, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x5f, 0x4f, 0x54,
	0x48, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x53, 0x48,
	0x49, 0x46, 0x54, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x5f, 0x50,
	0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x44, 0x45, 0x4c, 0x10,
	0x03, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x59, 0x4e, 0x4f, 0x4e, 0x59, 0x4d, 0x4f, 0x55, 0x53, 0x5f,
	0x53, 0x4e, 0x50, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x4f, 0x4e, 0x53, 0x59, 0x4e, 0x4f,
	0x4e, 0x59, 0x4d, 0x4f, 0x55, 0x53, 0x5f, 0x53, 0x4e, 0x50, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x54, 0x4f, 0x50, 0x5f, 0x47, 0x41, 0x49, 0x4e, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x53,
	0x54, 0x4f, 0x50, 0x5f, 0x4c, 0x4f, 0x53, 0x53, 0x10, 0x07, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x50,
	0x4c, 0x49, 0x43, 0x45, 0x5f, 0x53, 0x49, 0x54, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x52, 0x55, 0x50,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x22, 0xc0, 0x02, 0x0a, 0x14, 0x43, 0x6c, 0x69, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x25, 0x0a, 0x21, 0x43, 0x4c, 0x49, 0x4e, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x53, 0x49, 0x47, 0x4e,
	0x49, 0x46, 0x49, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4c, 0x49, 0x4e, 0x49, 0x43,
	0x41, 0x4c, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x49, 0x46, 0x49, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x5f,
	0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x43, 0x45, 0x52,
	0x54, 0x41, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x45, 0x4e, 0x49, 0x47, 0x4e,
	0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x5f, 0x42, 0x45, 0x4e,
	0x49, 0x47, 0x4e, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x5f,
	0x50, 0x41, 0x54, 0x48, 0x4f, 0x47, 0x45, 0x4e, 0x49, 0x43, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a,
	0x50, 0x41, 0x54, 0x48, 0x4f, 0x47, 0x45, 0x4e, 0x49, 0x43, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d,
	0x44, 0x52, 0x55, 0x47, 0x5f, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x07, 0x12,
	0x16, 0x0a, 0x12, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42,
	0x49, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x4f, 0x4e, 0x46, 0x45,
	0x52, 0x53, 0x5f, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x10, 0x09,
	0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x49, 0x53, 0x4b, 0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x10,
	0x0a, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x53, 0x53, 0x4f, 0x43, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x0b, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x54, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x0c, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x50, 0x4c, 0x45, 0x5f, 0x52,
	0x45, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x0d, 0x22, 0xd5, 0x02, 0x0a, 0x0a, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x65, 0x6e, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x67, 0x65, 0x6e, 0x65, 0x49,
	0x64, 0x12, 0x39, 0x0a, 0x05, 0x65, 0x78, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x2e, 0x45, 0x78, 0x6f, 0x6e, 0x52, 0x05, 0x65, 0x78, 0x6f, 0x6e, 0x73, 0x12, 0x56, 0x0a, 0x0f,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x2e, 0x43, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x1a, 0x61, 0x0a, 0x04, 0x45, 0x78, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x03, 0x65, 0x6e, 0x64, 0x12, 0x31, 0x0a, 0x05, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x1a, 0x38, 0x0a, 0x0e, 0x43, 0x6f, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12,
	0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e,
	0x64, 0x22, 0x3d, 0x0a, 0x0a, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64,
	0x22, 0x66, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48,
	0x0a, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x0d, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x22, 0x45, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x49, 0x64, 0x22,
	0xcf, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a,
	0x0a, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x48, 0x0a, 0x0e, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x0d, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x48, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x2a, 0x0a, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x49, 0x64, 0x22, 0xf2, 0x01, 0x0a, 0x1b,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x28, 0x0a, 0x10,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x05, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x22, 0x92, 0x01, 0x0a, 0x1c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4a, 0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x0e, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x59, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x80, 0x01, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xe9, 0x01, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x73, 0x0a, 0x05, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x3e, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x3b, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xbb, 0x01, 0x0a,
	0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3e, 0x0a,
	0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x3e, 0x0a, 0x17, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x87, 0x02, 0x0a, 0x18, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0e, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2a, 0x65, 0x0a, 0x0e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f,
	0x0a, 0x1b, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x56, 0x41, 0x52, 0x49, 0x41, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x45, 0x4e,
	0x45, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x43, 0x52, 0x49, 0x50,
	0x54, 0x10, 0x04, 0x32, 0x84, 0x0d, 0x0a, 0x13, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x56, 0x31, 0x12, 0x94, 0x01, 0x0a, 0x13,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x22, 0x12,
	0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65,
	0x74, 0x73, 0x3a, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x65, 0x74, 0x12, 0x92, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x22, 0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x12,
	0x26, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0xa8, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x12,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x1a, 0x26, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x3a, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x65, 0x74, 0x12, 0x8d, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x2a, 0x26, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x12, 0x9f, 0x01, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x24,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x22, 0x19, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x3a, 0x01, 0x2a, 0x12, 0x84, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x22, 0x0f,
	0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a,
	0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xa7, 0x01, 0x0a, 0x16,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x20, 0x22, 0x1b, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0x82, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x27, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x21, 0x12, 0x1f, 0x2f, 0x76, 0x31, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x94, 0x01, 0x0a, 0x10, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x33, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2d, 0x1a, 0x1f, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x80, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x27, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x21, 0x2a, 0x1f, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x7d, 0x12, 0x93, 0x01, 0x0a, 0x11, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x22,
	0x16, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0x42, 0x6b, 0x0a, 0x16, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_genomics_v1_annotations_proto_rawDescOnce sync.Once
	file_google_genomics_v1_annotations_proto_rawDescData = file_google_genomics_v1_annotations_proto_rawDesc
)

func file_google_genomics_v1_annotations_proto_rawDescGZIP() []byte {
	file_google_genomics_v1_annotations_proto_rawDescOnce.Do(func() {
		file_google_genomics_v1_annotations_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_genomics_v1_annotations_proto_rawDescData)
	})
	return file_google_genomics_v1_annotations_proto_rawDescData
}

var file_google_genomics_v1_annotations_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_genomics_v1_annotations_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_google_genomics_v1_annotations_proto_goTypes = []interface{}{
	(AnnotationType)(0),                          // 0: google.genomics.v1.AnnotationType
	(VariantAnnotation_Type)(0),                  // 1: google.genomics.v1.VariantAnnotation.Type
	(VariantAnnotation_Effect)(0),                // 2: google.genomics.v1.VariantAnnotation.Effect
	(VariantAnnotation_ClinicalSignificance)(0),  // 3: google.genomics.v1.VariantAnnotation.ClinicalSignificance
	(*AnnotationSet)(nil),                        // 4: google.genomics.v1.AnnotationSet
	(*Annotation)(nil),                           // 5: google.genomics.v1.Annotation
	(*VariantAnnotation)(nil),                    // 6: google.genomics.v1.VariantAnnotation
	(*Transcript)(nil),                           // 7: google.genomics.v1.Transcript
	(*ExternalId)(nil),                           // 8: google.genomics.v1.ExternalId
	(*CreateAnnotationSetRequest)(nil),           // 9: google.genomics.v1.CreateAnnotationSetRequest
	(*GetAnnotationSetRequest)(nil),              // 10: google.genomics.v1.GetAnnotationSetRequest
	(*UpdateAnnotationSetRequest)(nil),           // 11: google.genomics.v1.UpdateAnnotationSetRequest
	(*DeleteAnnotationSetRequest)(nil),           // 12: google.genomics.v1.DeleteAnnotationSetRequest
	(*SearchAnnotationSetsRequest)(nil),          // 13: google.genomics.v1.SearchAnnotationSetsRequest
	(*SearchAnnotationSetsResponse)(nil),         // 14: google.genomics.v1.SearchAnnotationSetsResponse
	(*CreateAnnotationRequest)(nil),              // 15: google.genomics.v1.CreateAnnotationRequest
	(*BatchCreateAnnotationsRequest)(nil),        // 16: google.genomics.v1.BatchCreateAnnotationsRequest
	(*BatchCreateAnnotationsResponse)(nil),       // 17: google.genomics.v1.BatchCreateAnnotationsResponse
	(*GetAnnotationRequest)(nil),                 // 18: google.genomics.v1.GetAnnotationRequest
	(*UpdateAnnotationRequest)(nil),              // 19: google.genomics.v1.UpdateAnnotationRequest
	(*DeleteAnnotationRequest)(nil),              // 20: google.genomics.v1.DeleteAnnotationRequest
	(*SearchAnnotationsRequest)(nil),             // 21: google.genomics.v1.SearchAnnotationsRequest
	(*SearchAnnotationsResponse)(nil),            // 22: google.genomics.v1.SearchAnnotationsResponse
	nil,                                          // 23: google.genomics.v1.AnnotationSet.InfoEntry
	nil,                                          // 24: google.genomics.v1.Annotation.InfoEntry
	(*VariantAnnotation_ClinicalCondition)(nil),  // 25: google.genomics.v1.VariantAnnotation.ClinicalCondition
	(*Transcript_Exon)(nil),                      // 26: google.genomics.v1.Transcript.Exon
	(*Transcript_CodingSequence)(nil),            // 27: google.genomics.v1.Transcript.CodingSequence
	(*BatchCreateAnnotationsResponse_Entry)(nil), // 28: google.genomics.v1.BatchCreateAnnotationsResponse.Entry
	(*field_mask.FieldMask)(nil),                 // 29: google.protobuf.FieldMask
	(*_struct.ListValue)(nil),                    // 30: google.protobuf.ListValue
	(*wrappers.Int32Value)(nil),                  // 31: google.protobuf.Int32Value
	(*status.Status)(nil),                        // 32: google.rpc.Status
	(*empty.Empty)(nil),                          // 33: google.protobuf.Empty
}
var file_google_genomics_v1_annotations_proto_depIdxs = []int32{
	0,  // 0: google.genomics.v1.AnnotationSet.type:type_name -> google.genomics.v1.AnnotationType
	23, // 1: google.genomics.v1.AnnotationSet.info:type_name -> google.genomics.v1.AnnotationSet.InfoEntry
	0,  // 2: google.genomics.v1.Annotation.type:type_name -> google.genomics.v1.AnnotationType
	6,  // 3: google.genomics.v1.Annotation.variant:type_name -> google.genomics.v1.VariantAnnotation
	7,  // 4: google.genomics.v1.Annotation.transcript:type_name -> google.genomics.v1.Transcript
	24, // 5: google.genomics.v1.Annotation.info:type_name -> google.genomics.v1.Annotation.InfoEntry
	1,  // 6: google.genomics.v1.VariantAnnotation.type:type_name -> google.genomics.v1.VariantAnnotation.Type
	2,  // 7: google.genomics.v1.VariantAnnotation.effect:type_name -> google.genomics.v1.VariantAnnotation.Effect
	25, // 8: google.genomics.v1.VariantAnnotation.conditions:type_name -> google.genomics.v1.VariantAnnotation.ClinicalCondition
	3,  // 9: google.genomics.v1.VariantAnnotation.clinical_significance:type_name -> google.genomics.v1.VariantAnnotation.ClinicalSignificance
	26, // 10: google.genomics.v1.Transcript.exons:type_name -> google.genomics.v1.Transcript.Exon
	27, // 11: google.genomics.v1.Transcript.coding_sequence:type_name -> google.genomics.v1.Transcript.CodingSequence
	4,  // 12: google.genomics.v1.CreateAnnotationSetRequest.annotation_set:type_name -> google.genomics.v1.AnnotationSet
	4,  // 13: google.genomics.v1.UpdateAnnotationSetRequest.annotation_set:type_name -> google.genomics.v1.AnnotationSet
	29, // 14: google.genomics.v1.UpdateAnnotationSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 15: google.genomics.v1.SearchAnnotationSetsRequest.types:type_name -> google.genomics.v1.AnnotationType
	4,  // 16: google.genomics.v1.SearchAnnotationSetsResponse.annotation_sets:type_name -> google.genomics.v1.AnnotationSet
	5,  // 17: google.genomics.v1.CreateAnnotationRequest.annotation:type_name -> google.genomics.v1.Annotation
	5,  // 18: google.genomics.v1.BatchCreateAnnotationsRequest.annotations:type_name -> google.genomics.v1.Annotation
	28, // 19: google.genomics.v1.BatchCreateAnnotationsResponse.entries:type_name -> google.genomics.v1.BatchCreateAnnotationsResponse.Entry
	5,  // 20: google.genomics.v1.UpdateAnnotationRequest.annotation:type_name -> google.genomics.v1.Annotation
	29, // 21: google.genomics.v1.UpdateAnnotationRequest.update_mask:type_name -> google.protobuf.FieldMask
	5,  // 22: google.genomics.v1.SearchAnnotationsResponse.annotations:type_name -> google.genomics.v1.Annotation
	30, // 23: google.genomics.v1.AnnotationSet.InfoEntry.value:type_name -> google.protobuf.ListValue
	30, // 24: google.genomics.v1.Annotation.InfoEntry.value:type_name -> google.protobuf.ListValue
	8,  // 25: google.genomics.v1.VariantAnnotation.ClinicalCondition.external_ids:type_name -> google.genomics.v1.ExternalId
	31, // 26: google.genomics.v1.Transcript.Exon.frame:type_name -> google.protobuf.Int32Value
	32, // 27: google.genomics.v1.BatchCreateAnnotationsResponse.Entry.status:type_name -> google.rpc.Status
	5,  // 28: google.genomics.v1.BatchCreateAnnotationsResponse.Entry.annotation:type_name -> google.genomics.v1.Annotation
	9,  // 29: google.genomics.v1.AnnotationServiceV1.CreateAnnotationSet:input_type -> google.genomics.v1.CreateAnnotationSetRequest
	10, // 30: google.genomics.v1.AnnotationServiceV1.GetAnnotationSet:input_type -> google.genomics.v1.GetAnnotationSetRequest
	11, // 31: google.genomics.v1.AnnotationServiceV1.UpdateAnnotationSet:input_type -> google.genomics.v1.UpdateAnnotationSetRequest
	12, // 32: google.genomics.v1.AnnotationServiceV1.DeleteAnnotationSet:input_type -> google.genomics.v1.DeleteAnnotationSetRequest
	13, // 33: google.genomics.v1.AnnotationServiceV1.SearchAnnotationSets:input_type -> google.genomics.v1.SearchAnnotationSetsRequest
	15, // 34: google.genomics.v1.AnnotationServiceV1.CreateAnnotation:input_type -> google.genomics.v1.CreateAnnotationRequest
	16, // 35: google.genomics.v1.AnnotationServiceV1.BatchCreateAnnotations:input_type -> google.genomics.v1.BatchCreateAnnotationsRequest
	18, // 36: google.genomics.v1.AnnotationServiceV1.GetAnnotation:input_type -> google.genomics.v1.GetAnnotationRequest
	19, // 37: google.genomics.v1.AnnotationServiceV1.UpdateAnnotation:input_type -> google.genomics.v1.UpdateAnnotationRequest
	20, // 38: google.genomics.v1.AnnotationServiceV1.DeleteAnnotation:input_type -> google.genomics.v1.DeleteAnnotationRequest
	21, // 39: google.genomics.v1.AnnotationServiceV1.SearchAnnotations:input_type -> google.genomics.v1.SearchAnnotationsRequest
	4,  // 40: google.genomics.v1.AnnotationServiceV1.CreateAnnotationSet:output_type -> google.genomics.v1.AnnotationSet
	4,  // 41: google.genomics.v1.AnnotationServiceV1.GetAnnotationSet:output_type -> google.genomics.v1.AnnotationSet
	4,  // 42: google.genomics.v1.AnnotationServiceV1.UpdateAnnotationSet:output_type -> google.genomics.v1.AnnotationSet
	33, // 43: google.genomics.v1.AnnotationServiceV1.DeleteAnnotationSet:output_type -> google.protobuf.Empty
	14, // 44: google.genomics.v1.AnnotationServiceV1.SearchAnnotationSets:output_type -> google.genomics.v1.SearchAnnotationSetsResponse
	5,  // 45: google.genomics.v1.AnnotationServiceV1.CreateAnnotation:output_type -> google.genomics.v1.Annotation
	17, // 46: google.genomics.v1.AnnotationServiceV1.BatchCreateAnnotations:output_type -> google.genomics.v1.BatchCreateAnnotationsResponse
	5,  // 47: google.genomics.v1.AnnotationServiceV1.GetAnnotation:output_type -> google.genomics.v1.Annotation
	5,  // 48: google.genomics.v1.AnnotationServiceV1.UpdateAnnotation:output_type -> google.genomics.v1.Annotation
	33, // 49: google.genomics.v1.AnnotationServiceV1.DeleteAnnotation:output_type -> google.protobuf.Empty
	22, // 50: google.genomics.v1.AnnotationServiceV1.SearchAnnotations:output_type -> google.genomics.v1.SearchAnnotationsResponse
	40, // [40:51] is the sub-list for method output_type
	29, // [29:40] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_genomics_v1_annotations_proto_init() }
func file_google_genomics_v1_annotations_proto_init() {
	if File_google_genomics_v1_annotations_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_genomics_v1_annotations_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Annotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VariantAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Transcript); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExternalId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnnotationSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAnnotationSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAnnotationSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAnnotationSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAnnotationSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAnnotationSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateAnnotationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateAnnotationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAnnotationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAnnotationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VariantAnnotation_ClinicalCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Transcript_Exon); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Transcript_CodingSequence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_annotations_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateAnnotationsResponse_Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_genomics_v1_annotations_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Annotation_Variant)(nil),
		(*Annotation_Transcript)(nil),
	}
	file_google_genomics_v1_annotations_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*SearchAnnotationsRequest_ReferenceId)(nil),
		(*SearchAnnotationsRequest_ReferenceName)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_genomics_v1_annotations_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_genomics_v1_annotations_proto_goTypes,
		DependencyIndexes: file_google_genomics_v1_annotations_proto_depIdxs,
		EnumInfos:         file_google_genomics_v1_annotations_proto_enumTypes,
		MessageInfos:      file_google_genomics_v1_annotations_proto_msgTypes,
	}.Build()
	File_google_genomics_v1_annotations_proto = out.File
	file_google_genomics_v1_annotations_proto_rawDesc = nil
	file_google_genomics_v1_annotations_proto_goTypes = nil
	file_google_genomics_v1_annotations_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AnnotationServiceV1Client is the client API for AnnotationServiceV1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AnnotationServiceV1Client interface {
	// Creates a new annotation set. Caller must have WRITE permission for the
	// associated dataset.
	//
	// The following fields are required:
	//
	//   * [datasetId][google.genomics.v1.AnnotationSet.dataset_id]
	//   * [referenceSetId][google.genomics.v1.AnnotationSet.reference_set_id]
	//
	// All other fields may be optionally specified, unless documented as being
	// server-generated (for example, the `id` field).
	CreateAnnotationSet(ctx context.Context, in *CreateAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error)
	// Gets an annotation set. Caller must have READ permission for
	// the associated dataset.
	GetAnnotationSet(ctx context.Context, in *GetAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error)
	// Updates an annotation set. The update must respect all mutability
	// restrictions and other invariants described on the annotation set resource.
	// Caller must have WRITE permission for the associated dataset.
	UpdateAnnotationSet(ctx context.Context, in *UpdateAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error)
	// Deletes an annotation set. Caller must have WRITE permission
	// for the associated annotation set.
	DeleteAnnotationSet(ctx context.Context, in *DeleteAnnotationSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Searches for annotation sets that match the given criteria. Annotation sets
	// are returned in an unspecified order. This order is consistent, such that
	// two queries for the same content (regardless of page size) yield annotation
	// sets in the same order across their respective streams of paginated
	// responses. Caller must have READ permission for the queried datasets.
	SearchAnnotationSets(ctx context.Context, in *SearchAnnotationSetsRequest, opts ...grpc.CallOption) (*SearchAnnotationSetsResponse, error)
	// Creates a new annotation. Caller must have WRITE permission
	// for the associated annotation set.
	//
	// The following fields are required:
	//
	// * [annotationSetId][google.genomics.v1.Annotation.annotation_set_id]
	// * [referenceName][google.genomics.v1.Annotation.reference_name] or
	//   [referenceId][google.genomics.v1.Annotation.reference_id]
	//
	// ### Transcripts
	//
	// For annotations of type TRANSCRIPT, the following fields of
	// [transcript][google.genomics.v1.Annotation.transcript] must be provided:
	//
	// * [exons.start][google.genomics.v1.Transcript.Exon.start]
	// * [exons.end][google.genomics.v1.Transcript.Exon.end]
	//
	// All other fields may be optionally specified, unless documented as being
	// server-generated (for example, the `id` field). The annotated
	// range must be no longer than 100Mbp (mega base pairs). See the
	// [Annotation resource][google.genomics.v1.Annotation]
	// for additional restrictions on each field.
	CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Creates one or more new annotations atomically. All annotations must
	// belong to the same annotation set. Caller must have WRITE
	// permission for this annotation set. For optimal performance, batch
	// positionally adjacent annotations together.
	//
	// If the request has a systemic issue, such as an attempt to write to
	// an inaccessible annotation set, the entire RPC will fail accordingly. For
	// lesser data issues, when possible an error will be isolated to the
	// corresponding batch entry in the response; the remaining well formed
	// annotations will be created normally.
	//
	// For details on the requirements for each individual annotation resource,
	// see
	// [CreateAnnotation][google.genomics.v1.AnnotationServiceV1.CreateAnnotation].
	BatchCreateAnnotations(ctx context.Context, in *BatchCreateAnnotationsRequest, opts ...grpc.CallOption) (*BatchCreateAnnotationsResponse, error)
	// Gets an annotation. Caller must have READ permission
	// for the associated annotation set.
	GetAnnotation(ctx context.Context, in *GetAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Updates an annotation. Caller must have
	// WRITE permission for the associated dataset.
	UpdateAnnotation(ctx context.Context, in *UpdateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Deletes an annotation. Caller must have WRITE permission for
	// the associated annotation set.
	DeleteAnnotation(ctx context.Context, in *DeleteAnnotationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Searches for annotations that match the given criteria. Results are
	// ordered by genomic coordinate (by reference sequence, then position).
	// Annotations with equivalent genomic coordinates are returned in an
	// unspecified order. This order is consistent, such that two queries for the
	// same content (regardless of page size) yield annotations in the same order
	// across their respective streams of paginated responses. Caller must have
	// READ permission for the queried annotation sets.
	SearchAnnotations(ctx context.Context, in *SearchAnnotationsRequest, opts ...grpc.CallOption) (*SearchAnnotationsResponse, error)
}

type annotationServiceV1Client struct {
	cc grpc.ClientConnInterface
}

func NewAnnotationServiceV1Client(cc grpc.ClientConnInterface) AnnotationServiceV1Client {
	return &annotationServiceV1Client{cc}
}

func (c *annotationServiceV1Client) CreateAnnotationSet(ctx context.Context, in *CreateAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error) {
	out := new(AnnotationSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/CreateAnnotationSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) GetAnnotationSet(ctx context.Context, in *GetAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error) {
	out := new(AnnotationSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/GetAnnotationSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) UpdateAnnotationSet(ctx context.Context, in *UpdateAnnotationSetRequest, opts ...grpc.CallOption) (*AnnotationSet, error) {
	out := new(AnnotationSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/UpdateAnnotationSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) DeleteAnnotationSet(ctx context.Context, in *DeleteAnnotationSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/DeleteAnnotationSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) SearchAnnotationSets(ctx context.Context, in *SearchAnnotationSetsRequest, opts ...grpc.CallOption) (*SearchAnnotationSetsResponse, error) {
	out := new(SearchAnnotationSetsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/SearchAnnotationSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/CreateAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) BatchCreateAnnotations(ctx context.Context, in *BatchCreateAnnotationsRequest, opts ...grpc.CallOption) (*BatchCreateAnnotationsResponse, error) {
	out := new(BatchCreateAnnotationsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/BatchCreateAnnotations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) GetAnnotation(ctx context.Context, in *GetAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/GetAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) UpdateAnnotation(ctx context.Context, in *UpdateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/UpdateAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) DeleteAnnotation(ctx context.Context, in *DeleteAnnotationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/DeleteAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *annotationServiceV1Client) SearchAnnotations(ctx context.Context, in *SearchAnnotationsRequest, opts ...grpc.CallOption) (*SearchAnnotationsResponse, error) {
	out := new(SearchAnnotationsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.AnnotationServiceV1/SearchAnnotations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnnotationServiceV1Server is the server API for AnnotationServiceV1 service.
type AnnotationServiceV1Server interface {
	// Creates a new annotation set. Caller must have WRITE permission for the
	// associated dataset.
	//
	// The following fields are required:
	//
	//   * [datasetId][google.genomics.v1.AnnotationSet.dataset_id]
	//   * [referenceSetId][google.genomics.v1.AnnotationSet.reference_set_id]
	//
	// All other fields may be optionally specified, unless documented as being
	// server-generated (for example, the `id` field).
	CreateAnnotationSet(context.Context, *CreateAnnotationSetRequest) (*AnnotationSet, error)
	// Gets an annotation set. Caller must have READ permission for
	// the associated dataset.
	GetAnnotationSet(context.Context, *GetAnnotationSetRequest) (*AnnotationSet, error)
	// Updates an annotation set. The update must respect all mutability
	// restrictions and other invariants described on the annotation set resource.
	// Caller must have WRITE permission for the associated dataset.
	UpdateAnnotationSet(context.Context, *UpdateAnnotationSetRequest) (*AnnotationSet, error)
	// Deletes an annotation set. Caller must have WRITE permission
	// for the associated annotation set.
	DeleteAnnotationSet(context.Context, *DeleteAnnotationSetRequest) (*empty.Empty, error)
	// Searches for annotation sets that match the given criteria. Annotation sets
	// are returned in an unspecified order. This order is consistent, such that
	// two queries for the same content (regardless of page size) yield annotation
	// sets in the same order across their respective streams of paginated
	// responses. Caller must have READ permission for the queried datasets.
	SearchAnnotationSets(context.Context, *SearchAnnotationSetsRequest) (*SearchAnnotationSetsResponse, error)
	// Creates a new annotation. Caller must have WRITE permission
	// for the associated annotation set.
	//
	// The following fields are required:
	//
	// * [annotationSetId][google.genomics.v1.Annotation.annotation_set_id]
	// * [referenceName][google.genomics.v1.Annotation.reference_name] or
	//   [referenceId][google.genomics.v1.Annotation.reference_id]
	//
	// ### Transcripts
	//
	// For annotations of type TRANSCRIPT, the following fields of
	// [transcript][google.genomics.v1.Annotation.transcript] must be provided:
	//
	// * [exons.start][google.genomics.v1.Transcript.Exon.start]
	// * [exons.end][google.genomics.v1.Transcript.Exon.end]
	//
	// All other fields may be optionally specified, unless documented as being
	// server-generated (for example, the `id` field). The annotated
	// range must be no longer than 100Mbp (mega base pairs). See the
	// [Annotation resource][google.genomics.v1.Annotation]
	// for additional restrictions on each field.
	CreateAnnotation(context.Context, *CreateAnnotationRequest) (*Annotation, error)
	// Creates one or more new annotations atomically. All annotations must
	// belong to the same annotation set. Caller must have WRITE
	// permission for this annotation set. For optimal performance, batch
	// positionally adjacent annotations together.
	//
	// If the request has a systemic issue, such as an attempt to write to
	// an inaccessible annotation set, the entire RPC will fail accordingly. For
	// lesser data issues, when possible an error will be isolated to the
	// corresponding batch entry in the response; the remaining well formed
	// annotations will be created normally.
	//
	// For details on the requirements for each individual annotation resource,
	// see
	// [CreateAnnotation][google.genomics.v1.AnnotationServiceV1.CreateAnnotation].
	BatchCreateAnnotations(context.Context, *BatchCreateAnnotationsRequest) (*BatchCreateAnnotationsResponse, error)
	// Gets an annotation. Caller must have READ permission
	// for the associated annotation set.
	GetAnnotation(context.Context, *GetAnnotationRequest) (*Annotation, error)
	// Updates an annotation. Caller must have
	// WRITE permission for the associated dataset.
	UpdateAnnotation(context.Context, *UpdateAnnotationRequest) (*Annotation, error)
	// Deletes an annotation. Caller must have WRITE permission for
	// the associated annotation set.
	DeleteAnnotation(context.Context, *DeleteAnnotationRequest) (*empty.Empty, error)
	// Searches for annotations that match the given criteria. Results are
	// ordered by genomic coordinate (by reference sequence, then position).
	// Annotations with equivalent genomic coordinates are returned in an
	// unspecified order. This order is consistent, such that two queries for the
	// same content (regardless of page size) yield annotations in the same order
	// across their respective streams of paginated responses. Caller must have
	// READ permission for the queried annotation sets.
	SearchAnnotations(context.Context, *SearchAnnotationsRequest) (*SearchAnnotationsResponse, error)
}

// UnimplementedAnnotationServiceV1Server can be embedded to have forward compatible implementations.
type UnimplementedAnnotationServiceV1Server struct {
}

func (*UnimplementedAnnotationServiceV1Server) CreateAnnotationSet(context.Context, *CreateAnnotationSetRequest) (*AnnotationSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAnnotationSet not implemented")
}
func (*UnimplementedAnnotationServiceV1Server) GetAnnotationSet(context.Context, *GetAnnotationSetRequest) (*AnnotationSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAnnotationSet not implemented")
}
func (*UnimplementedAnnotationServiceV1Server) UpdateAnnotationSet(context.Context, *UpdateAnnotationSetRequest) (*AnnotationSet, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateAnnotationSet not implemented")
}
func (*UnimplementedAnnotationServiceV1Server) DeleteAnnotationSet(context.Context, *DeleteAnnotationSetRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAnnotationSet not implemented")
}
func (*UnimplementedAnnotationServiceV1Server) SearchAnnotationSets(context.Context, *SearchAnnotationSetsRequest) (*SearchAnnotationSetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAnnotationSets not implemented")
}
func (*UnimplementedAnnotationServiceV1Server) CreateAnnotation(context.Context, *CreateAnnotationRequest) (*Annotation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAnnotation not implemented")
}
func (*UnimplementedAnnotationServiceV1Server) BatchCreateAnnotations(context.Context, *BatchCreateAnnotationsRequest) (*BatchCreateAnnotationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchCreateAnnotations not implemented")
}
func (*UnimplementedAnnotationServiceV1Server) GetAnnotation(context.Context, *GetAnnotationRequest) (*Annotation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAnnotation not implemented")
}
func (*UnimplementedAnnotationServiceV1Server) UpdateAnnotation(context.Context, *UpdateAnnotationRequest) (*Annotation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateAnnotation not implemented")
}
func (*UnimplementedAnnotationServiceV1Server) DeleteAnnotation(context.Context, *DeleteAnnotationRequest) (*empty.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAnnotation not implemented")
}
func (*UnimplementedAnnotationServiceV1Server) SearchAnnotations(context.Context, *SearchAnnotationsRequest) (*SearchAnnotationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAnnotations not implemented")
}

func RegisterAnnotationServiceV1Server(s *grpc.Server, srv AnnotationServiceV1Server) {
	s.RegisterService(&_AnnotationServiceV1_serviceDesc, srv)
}

func _AnnotationServiceV1_CreateAnnotationSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).CreateAnnotationSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/CreateAnnotationSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).CreateAnnotationSet(ctx, req.(*CreateAnnotationSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_GetAnnotationSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).GetAnnotationSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/GetAnnotationSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).GetAnnotationSet(ctx, req.(*GetAnnotationSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_UpdateAnnotationSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnnotationSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).UpdateAnnotationSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/UpdateAnnotationSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).UpdateAnnotationSet(ctx, req.(*UpdateAnnotationSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_DeleteAnnotationSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotationSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).DeleteAnnotationSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/DeleteAnnotationSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).DeleteAnnotationSet(ctx, req.(*DeleteAnnotationSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_SearchAnnotationSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAnnotationSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).SearchAnnotationSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/SearchAnnotationSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).SearchAnnotationSets(ctx, req.(*SearchAnnotationSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_CreateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).CreateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/CreateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).CreateAnnotation(ctx, req.(*CreateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_BatchCreateAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).BatchCreateAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/BatchCreateAnnotations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).BatchCreateAnnotations(ctx, req.(*BatchCreateAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_GetAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).GetAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/GetAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).GetAnnotation(ctx, req.(*GetAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_UpdateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).UpdateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/UpdateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).UpdateAnnotation(ctx, req.(*UpdateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_DeleteAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).DeleteAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/DeleteAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).DeleteAnnotation(ctx, req.(*DeleteAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnnotationServiceV1_SearchAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnnotationServiceV1Server).SearchAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.AnnotationServiceV1/SearchAnnotations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnnotationServiceV1Server).SearchAnnotations(ctx, req.(*SearchAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AnnotationServiceV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.AnnotationServiceV1",
	HandlerType: (*AnnotationServiceV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAnnotationSet",
			Handler:    _AnnotationServiceV1_CreateAnnotationSet_Handler,
		},
		{
			MethodName: "GetAnnotationSet",
			Handler:    _AnnotationServiceV1_GetAnnotationSet_Handler,
		},
		{
			MethodName: "UpdateAnnotationSet",
			Handler:    _AnnotationServiceV1_UpdateAnnotationSet_Handler,
		},
		{
			MethodName: "DeleteAnnotationSet",
			Handler:    _AnnotationServiceV1_DeleteAnnotationSet_Handler,
		},
		{
			MethodName: "SearchAnnotationSets",
			Handler:    _AnnotationServiceV1_SearchAnnotationSets_Handler,
		},
		{
			MethodName: "CreateAnnotation",
			Handler:    _AnnotationServiceV1_CreateAnnotation_Handler,
		},
		{
			MethodName: "BatchCreateAnnotations",
			Handler:    _AnnotationServiceV1_BatchCreateAnnotations_Handler,
		},
		{
			MethodName: "GetAnnotation",
			Handler:    _AnnotationServiceV1_GetAnnotation_Handler,
		},
		{
			MethodName: "UpdateAnnotation",
			Handler:    _AnnotationServiceV1_UpdateAnnotation_Handler,
		},
		{
			MethodName: "DeleteAnnotation",
			Handler:    _AnnotationServiceV1_DeleteAnnotation_Handler,
		},
		{
			MethodName: "SearchAnnotations",
			Handler:    _AnnotationServiceV1_SearchAnnotations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/genomics/v1/annotations.proto",
}
