// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.2
// source: google/cloud/language/v1beta2/language_service.proto

package language

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Represents the text encoding that the caller uses to process the output.
// Providing an `EncodingType` is recommended because the API provides the
// beginning offsets for various outputs, such as tokens and mentions, and
// languages that natively use different text encodings may access offsets
// differently.
type EncodingType int32

const (
	// If `EncodingType` is not specified, encoding-dependent information (such as
	// `begin_offset`) will be set at `-1`.
	EncodingType_NONE EncodingType = 0
	// Encoding-dependent information (such as `begin_offset`) is calculated based
	// on the UTF-8 encoding of the input. C++ and Go are examples of languages
	// that use this encoding natively.
	EncodingType_UTF8 EncodingType = 1
	// Encoding-dependent information (such as `begin_offset`) is calculated based
	// on the UTF-16 encoding of the input. Java and JavaScript are examples of
	// languages that use this encoding natively.
	EncodingType_UTF16 EncodingType = 2
	// Encoding-dependent information (such as `begin_offset`) is calculated based
	// on the UTF-32 encoding of the input. Python is an example of a language
	// that uses this encoding natively.
	EncodingType_UTF32 EncodingType = 3
)

// Enum value maps for EncodingType.
var (
	EncodingType_name = map[int32]string{
		0: "NONE",
		1: "UTF8",
		2: "UTF16",
		3: "UTF32",
	}
	EncodingType_value = map[string]int32{
		"NONE":  0,
		"UTF8":  1,
		"UTF16": 2,
		"UTF32": 3,
	}
)

func (x EncodingType) Enum() *EncodingType {
	p := new(EncodingType)
	*p = x
	return p
}

func (x EncodingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncodingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[0].Descriptor()
}

func (EncodingType) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[0]
}

func (x EncodingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncodingType.Descriptor instead.
func (EncodingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{0}
}

// The document types enum.
type Document_Type int32

const (
	// The content type is not specified.
	Document_TYPE_UNSPECIFIED Document_Type = 0
	// Plain text
	Document_PLAIN_TEXT Document_Type = 1
	// HTML
	Document_HTML Document_Type = 2
)

// Enum value maps for Document_Type.
var (
	Document_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "PLAIN_TEXT",
		2: "HTML",
	}
	Document_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"PLAIN_TEXT":       1,
		"HTML":             2,
	}
)

func (x Document_Type) Enum() *Document_Type {
	p := new(Document_Type)
	*p = x
	return p
}

func (x Document_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Document_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[1].Descriptor()
}

func (Document_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[1]
}

func (x Document_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Document_Type.Descriptor instead.
func (Document_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{0, 0}
}

// The type of the entity. For most entity types, the associated metadata is a
// Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID (`mid`). The table
// below lists the associated fields for entities that have different
// metadata.
type Entity_Type int32

const (
	// Unknown
	Entity_UNKNOWN Entity_Type = 0
	// Person
	Entity_PERSON Entity_Type = 1
	// Location
	Entity_LOCATION Entity_Type = 2
	// Organization
	Entity_ORGANIZATION Entity_Type = 3
	// Event
	Entity_EVENT Entity_Type = 4
	// Artwork
	Entity_WORK_OF_ART Entity_Type = 5
	// Consumer product
	Entity_CONSUMER_GOOD Entity_Type = 6
	// Other types of entities
	Entity_OTHER Entity_Type = 7
	// Phone number
	//
	// The metadata lists the phone number, formatted according to local
	// convention, plus whichever additional elements appear in the text:
	//
	// * `number` - the actual number, broken down into sections as per local
	// convention
	// * `national_prefix` - country code, if detected
	// * `area_code` - region or area code, if detected
	// * `extension` - phone extension (to be dialed after connection), if
	// detected
	Entity_PHONE_NUMBER Entity_Type = 9
	// Address
	//
	// The metadata identifies the street number and locality plus whichever
	// additional elements appear in the text:
	//
	// * `street_number` - street number
	// * `locality` - city or town
	// * `street_name` - street/route name, if detected
	// * `postal_code` - postal code, if detected
	// * `country` - country, if detected<
	// * `broad_region` - administrative area, such as the state, if detected
	// * `narrow_region` - smaller administrative area, such as county, if
	// detected
	// * `sublocality` - used in Asian addresses to demark a district within a
	// city, if detected
	Entity_ADDRESS Entity_Type = 10
	// Date
	//
	// The metadata identifies the components of the date:
	//
	// * `year` - four digit year, if detected
	// * `month` - two digit month number, if detected
	// * `day` - two digit day number, if detected
	Entity_DATE Entity_Type = 11
	// Number
	//
	// The metadata is the number itself.
	Entity_NUMBER Entity_Type = 12
	// Price
	//
	// The metadata identifies the `value` and `currency`.
	Entity_PRICE Entity_Type = 13
)

// Enum value maps for Entity_Type.
var (
	Entity_Type_name = map[int32]string{
		0:  "UNKNOWN",
		1:  "PERSON",
		2:  "LOCATION",
		3:  "ORGANIZATION",
		4:  "EVENT",
		5:  "WORK_OF_ART",
		6:  "CONSUMER_GOOD",
		7:  "OTHER",
		9:  "PHONE_NUMBER",
		10: "ADDRESS",
		11: "DATE",
		12: "NUMBER",
		13: "PRICE",
	}
	Entity_Type_value = map[string]int32{
		"UNKNOWN":       0,
		"PERSON":        1,
		"LOCATION":      2,
		"ORGANIZATION":  3,
		"EVENT":         4,
		"WORK_OF_ART":   5,
		"CONSUMER_GOOD": 6,
		"OTHER":         7,
		"PHONE_NUMBER":  9,
		"ADDRESS":       10,
		"DATE":          11,
		"NUMBER":        12,
		"PRICE":         13,
	}
)

func (x Entity_Type) Enum() *Entity_Type {
	p := new(Entity_Type)
	*p = x
	return p
}

func (x Entity_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Entity_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[2].Descriptor()
}

func (Entity_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[2]
}

func (x Entity_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Entity_Type.Descriptor instead.
func (Entity_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{2, 0}
}

// The part of speech tags enum.
type PartOfSpeech_Tag int32

const (
	// Unknown
	PartOfSpeech_UNKNOWN PartOfSpeech_Tag = 0
	// Adjective
	PartOfSpeech_ADJ PartOfSpeech_Tag = 1
	// Adposition (preposition and postposition)
	PartOfSpeech_ADP PartOfSpeech_Tag = 2
	// Adverb
	PartOfSpeech_ADV PartOfSpeech_Tag = 3
	// Conjunction
	PartOfSpeech_CONJ PartOfSpeech_Tag = 4
	// Determiner
	PartOfSpeech_DET PartOfSpeech_Tag = 5
	// Noun (common and proper)
	PartOfSpeech_NOUN PartOfSpeech_Tag = 6
	// Cardinal number
	PartOfSpeech_NUM PartOfSpeech_Tag = 7
	// Pronoun
	PartOfSpeech_PRON PartOfSpeech_Tag = 8
	// Particle or other function word
	PartOfSpeech_PRT PartOfSpeech_Tag = 9
	// Punctuation
	PartOfSpeech_PUNCT PartOfSpeech_Tag = 10
	// Verb (all tenses and modes)
	PartOfSpeech_VERB PartOfSpeech_Tag = 11
	// Other: foreign words, typos, abbreviations
	PartOfSpeech_X PartOfSpeech_Tag = 12
	// Affix
	PartOfSpeech_AFFIX PartOfSpeech_Tag = 13
)

// Enum value maps for PartOfSpeech_Tag.
var (
	PartOfSpeech_Tag_name = map[int32]string{
		0:  "UNKNOWN",
		1:  "ADJ",
		2:  "ADP",
		3:  "ADV",
		4:  "CONJ",
		5:  "DET",
		6:  "NOUN",
		7:  "NUM",
		8:  "PRON",
		9:  "PRT",
		10: "PUNCT",
		11: "VERB",
		12: "X",
		13: "AFFIX",
	}
	PartOfSpeech_Tag_value = map[string]int32{
		"UNKNOWN": 0,
		"ADJ":     1,
		"ADP":     2,
		"ADV":     3,
		"CONJ":    4,
		"DET":     5,
		"NOUN":    6,
		"NUM":     7,
		"PRON":    8,
		"PRT":     9,
		"PUNCT":   10,
		"VERB":    11,
		"X":       12,
		"AFFIX":   13,
	}
)

func (x PartOfSpeech_Tag) Enum() *PartOfSpeech_Tag {
	p := new(PartOfSpeech_Tag)
	*p = x
	return p
}

func (x PartOfSpeech_Tag) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Tag) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[3].Descriptor()
}

func (PartOfSpeech_Tag) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[3]
}

func (x PartOfSpeech_Tag) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Tag.Descriptor instead.
func (PartOfSpeech_Tag) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 0}
}

// The characteristic of a verb that expresses time flow during an event.
type PartOfSpeech_Aspect int32

const (
	// Aspect is not applicable in the analyzed language or is not predicted.
	PartOfSpeech_ASPECT_UNKNOWN PartOfSpeech_Aspect = 0
	// Perfective
	PartOfSpeech_PERFECTIVE PartOfSpeech_Aspect = 1
	// Imperfective
	PartOfSpeech_IMPERFECTIVE PartOfSpeech_Aspect = 2
	// Progressive
	PartOfSpeech_PROGRESSIVE PartOfSpeech_Aspect = 3
)

// Enum value maps for PartOfSpeech_Aspect.
var (
	PartOfSpeech_Aspect_name = map[int32]string{
		0: "ASPECT_UNKNOWN",
		1: "PERFECTIVE",
		2: "IMPERFECTIVE",
		3: "PROGRESSIVE",
	}
	PartOfSpeech_Aspect_value = map[string]int32{
		"ASPECT_UNKNOWN": 0,
		"PERFECTIVE":     1,
		"IMPERFECTIVE":   2,
		"PROGRESSIVE":    3,
	}
)

func (x PartOfSpeech_Aspect) Enum() *PartOfSpeech_Aspect {
	p := new(PartOfSpeech_Aspect)
	*p = x
	return p
}

func (x PartOfSpeech_Aspect) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Aspect) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[4].Descriptor()
}

func (PartOfSpeech_Aspect) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[4]
}

func (x PartOfSpeech_Aspect) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Aspect.Descriptor instead.
func (PartOfSpeech_Aspect) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 1}
}

// The grammatical function performed by a noun or pronoun in a phrase,
// clause, or sentence. In some languages, other parts of speech, such as
// adjective and determiner, take case inflection in agreement with the noun.
type PartOfSpeech_Case int32

const (
	// Case is not applicable in the analyzed language or is not predicted.
	PartOfSpeech_CASE_UNKNOWN PartOfSpeech_Case = 0
	// Accusative
	PartOfSpeech_ACCUSATIVE PartOfSpeech_Case = 1
	// Adverbial
	PartOfSpeech_ADVERBIAL PartOfSpeech_Case = 2
	// Complementive
	PartOfSpeech_COMPLEMENTIVE PartOfSpeech_Case = 3
	// Dative
	PartOfSpeech_DATIVE PartOfSpeech_Case = 4
	// Genitive
	PartOfSpeech_GENITIVE PartOfSpeech_Case = 5
	// Instrumental
	PartOfSpeech_INSTRUMENTAL PartOfSpeech_Case = 6
	// Locative
	PartOfSpeech_LOCATIVE PartOfSpeech_Case = 7
	// Nominative
	PartOfSpeech_NOMINATIVE PartOfSpeech_Case = 8
	// Oblique
	PartOfSpeech_OBLIQUE PartOfSpeech_Case = 9
	// Partitive
	PartOfSpeech_PARTITIVE PartOfSpeech_Case = 10
	// Prepositional
	PartOfSpeech_PREPOSITIONAL PartOfSpeech_Case = 11
	// Reflexive
	PartOfSpeech_REFLEXIVE_CASE PartOfSpeech_Case = 12
	// Relative
	PartOfSpeech_RELATIVE_CASE PartOfSpeech_Case = 13
	// Vocative
	PartOfSpeech_VOCATIVE PartOfSpeech_Case = 14
)

// Enum value maps for PartOfSpeech_Case.
var (
	PartOfSpeech_Case_name = map[int32]string{
		0:  "CASE_UNKNOWN",
		1:  "ACCUSATIVE",
		2:  "ADVERBIAL",
		3:  "COMPLEMENTIVE",
		4:  "DATIVE",
		5:  "GENITIVE",
		6:  "INSTRUMENTAL",
		7:  "LOCATIVE",
		8:  "NOMINATIVE",
		9:  "OBLIQUE",
		10: "PARTITIVE",
		11: "PREPOSITIONAL",
		12: "REFLEXIVE_CASE",
		13: "RELATIVE_CASE",
		14: "VOCATIVE",
	}
	PartOfSpeech_Case_value = map[string]int32{
		"CASE_UNKNOWN":   0,
		"ACCUSATIVE":     1,
		"ADVERBIAL":      2,
		"COMPLEMENTIVE":  3,
		"DATIVE":         4,
		"GENITIVE":       5,
		"INSTRUMENTAL":   6,
		"LOCATIVE":       7,
		"NOMINATIVE":     8,
		"OBLIQUE":        9,
		"PARTITIVE":      10,
		"PREPOSITIONAL":  11,
		"REFLEXIVE_CASE": 12,
		"RELATIVE_CASE":  13,
		"VOCATIVE":       14,
	}
)

func (x PartOfSpeech_Case) Enum() *PartOfSpeech_Case {
	p := new(PartOfSpeech_Case)
	*p = x
	return p
}

func (x PartOfSpeech_Case) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Case) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[5].Descriptor()
}

func (PartOfSpeech_Case) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[5]
}

func (x PartOfSpeech_Case) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Case.Descriptor instead.
func (PartOfSpeech_Case) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 2}
}

// Depending on the language, Form can be categorizing different forms of
// verbs, adjectives, adverbs, etc. For example, categorizing inflected
// endings of verbs and adjectives or distinguishing between short and long
// forms of adjectives and participles
type PartOfSpeech_Form int32

const (
	// Form is not applicable in the analyzed language or is not predicted.
	PartOfSpeech_FORM_UNKNOWN PartOfSpeech_Form = 0
	// Adnomial
	PartOfSpeech_ADNOMIAL PartOfSpeech_Form = 1
	// Auxiliary
	PartOfSpeech_AUXILIARY PartOfSpeech_Form = 2
	// Complementizer
	PartOfSpeech_COMPLEMENTIZER PartOfSpeech_Form = 3
	// Final ending
	PartOfSpeech_FINAL_ENDING PartOfSpeech_Form = 4
	// Gerund
	PartOfSpeech_GERUND PartOfSpeech_Form = 5
	// Realis
	PartOfSpeech_REALIS PartOfSpeech_Form = 6
	// Irrealis
	PartOfSpeech_IRREALIS PartOfSpeech_Form = 7
	// Short form
	PartOfSpeech_SHORT PartOfSpeech_Form = 8
	// Long form
	PartOfSpeech_LONG PartOfSpeech_Form = 9
	// Order form
	PartOfSpeech_ORDER PartOfSpeech_Form = 10
	// Specific form
	PartOfSpeech_SPECIFIC PartOfSpeech_Form = 11
)

// Enum value maps for PartOfSpeech_Form.
var (
	PartOfSpeech_Form_name = map[int32]string{
		0:  "FORM_UNKNOWN",
		1:  "ADNOMIAL",
		2:  "AUXILIARY",
		3:  "COMPLEMENTIZER",
		4:  "FINAL_ENDING",
		5:  "GERUND",
		6:  "REALIS",
		7:  "IRREALIS",
		8:  "SHORT",
		9:  "LONG",
		10: "ORDER",
		11: "SPECIFIC",
	}
	PartOfSpeech_Form_value = map[string]int32{
		"FORM_UNKNOWN":   0,
		"ADNOMIAL":       1,
		"AUXILIARY":      2,
		"COMPLEMENTIZER": 3,
		"FINAL_ENDING":   4,
		"GERUND":         5,
		"REALIS":         6,
		"IRREALIS":       7,
		"SHORT":          8,
		"LONG":           9,
		"ORDER":          10,
		"SPECIFIC":       11,
	}
)

func (x PartOfSpeech_Form) Enum() *PartOfSpeech_Form {
	p := new(PartOfSpeech_Form)
	*p = x
	return p
}

func (x PartOfSpeech_Form) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Form) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[6].Descriptor()
}

func (PartOfSpeech_Form) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[6]
}

func (x PartOfSpeech_Form) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Form.Descriptor instead.
func (PartOfSpeech_Form) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 3}
}

// Gender classes of nouns reflected in the behaviour of associated words.
type PartOfSpeech_Gender int32

const (
	// Gender is not applicable in the analyzed language or is not predicted.
	PartOfSpeech_GENDER_UNKNOWN PartOfSpeech_Gender = 0
	// Feminine
	PartOfSpeech_FEMININE PartOfSpeech_Gender = 1
	// Masculine
	PartOfSpeech_MASCULINE PartOfSpeech_Gender = 2
	// Neuter
	PartOfSpeech_NEUTER PartOfSpeech_Gender = 3
)

// Enum value maps for PartOfSpeech_Gender.
var (
	PartOfSpeech_Gender_name = map[int32]string{
		0: "GENDER_UNKNOWN",
		1: "FEMININE",
		2: "MASCULINE",
		3: "NEUTER",
	}
	PartOfSpeech_Gender_value = map[string]int32{
		"GENDER_UNKNOWN": 0,
		"FEMININE":       1,
		"MASCULINE":      2,
		"NEUTER":         3,
	}
)

func (x PartOfSpeech_Gender) Enum() *PartOfSpeech_Gender {
	p := new(PartOfSpeech_Gender)
	*p = x
	return p
}

func (x PartOfSpeech_Gender) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Gender) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[7].Descriptor()
}

func (PartOfSpeech_Gender) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[7]
}

func (x PartOfSpeech_Gender) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Gender.Descriptor instead.
func (PartOfSpeech_Gender) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 4}
}

// The grammatical feature of verbs, used for showing modality and attitude.
type PartOfSpeech_Mood int32

const (
	// Mood is not applicable in the analyzed language or is not predicted.
	PartOfSpeech_MOOD_UNKNOWN PartOfSpeech_Mood = 0
	// Conditional
	PartOfSpeech_CONDITIONAL_MOOD PartOfSpeech_Mood = 1
	// Imperative
	PartOfSpeech_IMPERATIVE PartOfSpeech_Mood = 2
	// Indicative
	PartOfSpeech_INDICATIVE PartOfSpeech_Mood = 3
	// Interrogative
	PartOfSpeech_INTERROGATIVE PartOfSpeech_Mood = 4
	// Jussive
	PartOfSpeech_JUSSIVE PartOfSpeech_Mood = 5
	// Subjunctive
	PartOfSpeech_SUBJUNCTIVE PartOfSpeech_Mood = 6
)

// Enum value maps for PartOfSpeech_Mood.
var (
	PartOfSpeech_Mood_name = map[int32]string{
		0: "MOOD_UNKNOWN",
		1: "CONDITIONAL_MOOD",
		2: "IMPERATIVE",
		3: "INDICATIVE",
		4: "INTERROGATIVE",
		5: "JUSSIVE",
		6: "SUBJUNCTIVE",
	}
	PartOfSpeech_Mood_value = map[string]int32{
		"MOOD_UNKNOWN":     0,
		"CONDITIONAL_MOOD": 1,
		"IMPERATIVE":       2,
		"INDICATIVE":       3,
		"INTERROGATIVE":    4,
		"JUSSIVE":          5,
		"SUBJUNCTIVE":      6,
	}
)

func (x PartOfSpeech_Mood) Enum() *PartOfSpeech_Mood {
	p := new(PartOfSpeech_Mood)
	*p = x
	return p
}

func (x PartOfSpeech_Mood) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Mood) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[8].Descriptor()
}

func (PartOfSpeech_Mood) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[8]
}

func (x PartOfSpeech_Mood) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Mood.Descriptor instead.
func (PartOfSpeech_Mood) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 5}
}

// Count distinctions.
type PartOfSpeech_Number int32

const (
	// Number is not applicable in the analyzed language or is not predicted.
	PartOfSpeech_NUMBER_UNKNOWN PartOfSpeech_Number = 0
	// Singular
	PartOfSpeech_SINGULAR PartOfSpeech_Number = 1
	// Plural
	PartOfSpeech_PLURAL PartOfSpeech_Number = 2
	// Dual
	PartOfSpeech_DUAL PartOfSpeech_Number = 3
)

// Enum value maps for PartOfSpeech_Number.
var (
	PartOfSpeech_Number_name = map[int32]string{
		0: "NUMBER_UNKNOWN",
		1: "SINGULAR",
		2: "PLURAL",
		3: "DUAL",
	}
	PartOfSpeech_Number_value = map[string]int32{
		"NUMBER_UNKNOWN": 0,
		"SINGULAR":       1,
		"PLURAL":         2,
		"DUAL":           3,
	}
)

func (x PartOfSpeech_Number) Enum() *PartOfSpeech_Number {
	p := new(PartOfSpeech_Number)
	*p = x
	return p
}

func (x PartOfSpeech_Number) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Number) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[9].Descriptor()
}

func (PartOfSpeech_Number) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[9]
}

func (x PartOfSpeech_Number) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Number.Descriptor instead.
func (PartOfSpeech_Number) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 6}
}

// The distinction between the speaker, second person, third person, etc.
type PartOfSpeech_Person int32

const (
	// Person is not applicable in the analyzed language or is not predicted.
	PartOfSpeech_PERSON_UNKNOWN PartOfSpeech_Person = 0
	// First
	PartOfSpeech_FIRST PartOfSpeech_Person = 1
	// Second
	PartOfSpeech_SECOND PartOfSpeech_Person = 2
	// Third
	PartOfSpeech_THIRD PartOfSpeech_Person = 3
	// Reflexive
	PartOfSpeech_REFLEXIVE_PERSON PartOfSpeech_Person = 4
)

// Enum value maps for PartOfSpeech_Person.
var (
	PartOfSpeech_Person_name = map[int32]string{
		0: "PERSON_UNKNOWN",
		1: "FIRST",
		2: "SECOND",
		3: "THIRD",
		4: "REFLEXIVE_PERSON",
	}
	PartOfSpeech_Person_value = map[string]int32{
		"PERSON_UNKNOWN":   0,
		"FIRST":            1,
		"SECOND":           2,
		"THIRD":            3,
		"REFLEXIVE_PERSON": 4,
	}
)

func (x PartOfSpeech_Person) Enum() *PartOfSpeech_Person {
	p := new(PartOfSpeech_Person)
	*p = x
	return p
}

func (x PartOfSpeech_Person) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Person) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[10].Descriptor()
}

func (PartOfSpeech_Person) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[10]
}

func (x PartOfSpeech_Person) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Person.Descriptor instead.
func (PartOfSpeech_Person) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 7}
}

// This category shows if the token is part of a proper name.
type PartOfSpeech_Proper int32

const (
	// Proper is not applicable in the analyzed language or is not predicted.
	PartOfSpeech_PROPER_UNKNOWN PartOfSpeech_Proper = 0
	// Proper
	PartOfSpeech_PROPER PartOfSpeech_Proper = 1
	// Not proper
	PartOfSpeech_NOT_PROPER PartOfSpeech_Proper = 2
)

// Enum value maps for PartOfSpeech_Proper.
var (
	PartOfSpeech_Proper_name = map[int32]string{
		0: "PROPER_UNKNOWN",
		1: "PROPER",
		2: "NOT_PROPER",
	}
	PartOfSpeech_Proper_value = map[string]int32{
		"PROPER_UNKNOWN": 0,
		"PROPER":         1,
		"NOT_PROPER":     2,
	}
)

func (x PartOfSpeech_Proper) Enum() *PartOfSpeech_Proper {
	p := new(PartOfSpeech_Proper)
	*p = x
	return p
}

func (x PartOfSpeech_Proper) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Proper) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[11].Descriptor()
}

func (PartOfSpeech_Proper) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[11]
}

func (x PartOfSpeech_Proper) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Proper.Descriptor instead.
func (PartOfSpeech_Proper) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 8}
}

// Reciprocal features of a pronoun.
type PartOfSpeech_Reciprocity int32

const (
	// Reciprocity is not applicable in the analyzed language or is not
	// predicted.
	PartOfSpeech_RECIPROCITY_UNKNOWN PartOfSpeech_Reciprocity = 0
	// Reciprocal
	PartOfSpeech_RECIPROCAL PartOfSpeech_Reciprocity = 1
	// Non-reciprocal
	PartOfSpeech_NON_RECIPROCAL PartOfSpeech_Reciprocity = 2
)

// Enum value maps for PartOfSpeech_Reciprocity.
var (
	PartOfSpeech_Reciprocity_name = map[int32]string{
		0: "RECIPROCITY_UNKNOWN",
		1: "RECIPROCAL",
		2: "NON_RECIPROCAL",
	}
	PartOfSpeech_Reciprocity_value = map[string]int32{
		"RECIPROCITY_UNKNOWN": 0,
		"RECIPROCAL":          1,
		"NON_RECIPROCAL":      2,
	}
)

func (x PartOfSpeech_Reciprocity) Enum() *PartOfSpeech_Reciprocity {
	p := new(PartOfSpeech_Reciprocity)
	*p = x
	return p
}

func (x PartOfSpeech_Reciprocity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Reciprocity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[12].Descriptor()
}

func (PartOfSpeech_Reciprocity) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[12]
}

func (x PartOfSpeech_Reciprocity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Reciprocity.Descriptor instead.
func (PartOfSpeech_Reciprocity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 9}
}

// Time reference.
type PartOfSpeech_Tense int32

const (
	// Tense is not applicable in the analyzed language or is not predicted.
	PartOfSpeech_TENSE_UNKNOWN PartOfSpeech_Tense = 0
	// Conditional
	PartOfSpeech_CONDITIONAL_TENSE PartOfSpeech_Tense = 1
	// Future
	PartOfSpeech_FUTURE PartOfSpeech_Tense = 2
	// Past
	PartOfSpeech_PAST PartOfSpeech_Tense = 3
	// Present
	PartOfSpeech_PRESENT PartOfSpeech_Tense = 4
	// Imperfect
	PartOfSpeech_IMPERFECT PartOfSpeech_Tense = 5
	// Pluperfect
	PartOfSpeech_PLUPERFECT PartOfSpeech_Tense = 6
)

// Enum value maps for PartOfSpeech_Tense.
var (
	PartOfSpeech_Tense_name = map[int32]string{
		0: "TENSE_UNKNOWN",
		1: "CONDITIONAL_TENSE",
		2: "FUTURE",
		3: "PAST",
		4: "PRESENT",
		5: "IMPERFECT",
		6: "PLUPERFECT",
	}
	PartOfSpeech_Tense_value = map[string]int32{
		"TENSE_UNKNOWN":     0,
		"CONDITIONAL_TENSE": 1,
		"FUTURE":            2,
		"PAST":              3,
		"PRESENT":           4,
		"IMPERFECT":         5,
		"PLUPERFECT":        6,
	}
)

func (x PartOfSpeech_Tense) Enum() *PartOfSpeech_Tense {
	p := new(PartOfSpeech_Tense)
	*p = x
	return p
}

func (x PartOfSpeech_Tense) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Tense) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[13].Descriptor()
}

func (PartOfSpeech_Tense) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[13]
}

func (x PartOfSpeech_Tense) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Tense.Descriptor instead.
func (PartOfSpeech_Tense) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 10}
}

// The relationship between the action that a verb expresses and the
// participants identified by its arguments.
type PartOfSpeech_Voice int32

const (
	// Voice is not applicable in the analyzed language or is not predicted.
	PartOfSpeech_VOICE_UNKNOWN PartOfSpeech_Voice = 0
	// Active
	PartOfSpeech_ACTIVE PartOfSpeech_Voice = 1
	// Causative
	PartOfSpeech_CAUSATIVE PartOfSpeech_Voice = 2
	// Passive
	PartOfSpeech_PASSIVE PartOfSpeech_Voice = 3
)

// Enum value maps for PartOfSpeech_Voice.
var (
	PartOfSpeech_Voice_name = map[int32]string{
		0: "VOICE_UNKNOWN",
		1: "ACTIVE",
		2: "CAUSATIVE",
		3: "PASSIVE",
	}
	PartOfSpeech_Voice_value = map[string]int32{
		"VOICE_UNKNOWN": 0,
		"ACTIVE":        1,
		"CAUSATIVE":     2,
		"PASSIVE":       3,
	}
)

func (x PartOfSpeech_Voice) Enum() *PartOfSpeech_Voice {
	p := new(PartOfSpeech_Voice)
	*p = x
	return p
}

func (x PartOfSpeech_Voice) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartOfSpeech_Voice) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[14].Descriptor()
}

func (PartOfSpeech_Voice) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[14]
}

func (x PartOfSpeech_Voice) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartOfSpeech_Voice.Descriptor instead.
func (PartOfSpeech_Voice) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5, 11}
}

// The parse label enum for the token.
type DependencyEdge_Label int32

const (
	// Unknown
	DependencyEdge_UNKNOWN DependencyEdge_Label = 0
	// Abbreviation modifier
	DependencyEdge_ABBREV DependencyEdge_Label = 1
	// Adjectival complement
	DependencyEdge_ACOMP DependencyEdge_Label = 2
	// Adverbial clause modifier
	DependencyEdge_ADVCL DependencyEdge_Label = 3
	// Adverbial modifier
	DependencyEdge_ADVMOD DependencyEdge_Label = 4
	// Adjectival modifier of an NP
	DependencyEdge_AMOD DependencyEdge_Label = 5
	// Appositional modifier of an NP
	DependencyEdge_APPOS DependencyEdge_Label = 6
	// Attribute dependent of a copular verb
	DependencyEdge_ATTR DependencyEdge_Label = 7
	// Auxiliary (non-main) verb
	DependencyEdge_AUX DependencyEdge_Label = 8
	// Passive auxiliary
	DependencyEdge_AUXPASS DependencyEdge_Label = 9
	// Coordinating conjunction
	DependencyEdge_CC DependencyEdge_Label = 10
	// Clausal complement of a verb or adjective
	DependencyEdge_CCOMP DependencyEdge_Label = 11
	// Conjunct
	DependencyEdge_CONJ DependencyEdge_Label = 12
	// Clausal subject
	DependencyEdge_CSUBJ DependencyEdge_Label = 13
	// Clausal passive subject
	DependencyEdge_CSUBJPASS DependencyEdge_Label = 14
	// Dependency (unable to determine)
	DependencyEdge_DEP DependencyEdge_Label = 15
	// Determiner
	DependencyEdge_DET DependencyEdge_Label = 16
	// Discourse
	DependencyEdge_DISCOURSE DependencyEdge_Label = 17
	// Direct object
	DependencyEdge_DOBJ DependencyEdge_Label = 18
	// Expletive
	DependencyEdge_EXPL DependencyEdge_Label = 19
	// Goes with (part of a word in a text not well edited)
	DependencyEdge_GOESWITH DependencyEdge_Label = 20
	// Indirect object
	DependencyEdge_IOBJ DependencyEdge_Label = 21
	// Marker (word introducing a subordinate clause)
	DependencyEdge_MARK DependencyEdge_Label = 22
	// Multi-word expression
	DependencyEdge_MWE DependencyEdge_Label = 23
	// Multi-word verbal expression
	DependencyEdge_MWV DependencyEdge_Label = 24
	// Negation modifier
	DependencyEdge_NEG DependencyEdge_Label = 25
	// Noun compound modifier
	DependencyEdge_NN DependencyEdge_Label = 26
	// Noun phrase used as an adverbial modifier
	DependencyEdge_NPADVMOD DependencyEdge_Label = 27
	// Nominal subject
	DependencyEdge_NSUBJ DependencyEdge_Label = 28
	// Passive nominal subject
	DependencyEdge_NSUBJPASS DependencyEdge_Label = 29
	// Numeric modifier of a noun
	DependencyEdge_NUM DependencyEdge_Label = 30
	// Element of compound number
	DependencyEdge_NUMBER DependencyEdge_Label = 31
	// Punctuation mark
	DependencyEdge_P DependencyEdge_Label = 32
	// Parataxis relation
	DependencyEdge_PARATAXIS DependencyEdge_Label = 33
	// Participial modifier
	DependencyEdge_PARTMOD DependencyEdge_Label = 34
	// The complement of a preposition is a clause
	DependencyEdge_PCOMP DependencyEdge_Label = 35
	// Object of a preposition
	DependencyEdge_POBJ DependencyEdge_Label = 36
	// Possession modifier
	DependencyEdge_POSS DependencyEdge_Label = 37
	// Postverbal negative particle
	DependencyEdge_POSTNEG DependencyEdge_Label = 38
	// Predicate complement
	DependencyEdge_PRECOMP DependencyEdge_Label = 39
	// Preconjunt
	DependencyEdge_PRECONJ DependencyEdge_Label = 40
	// Predeterminer
	DependencyEdge_PREDET DependencyEdge_Label = 41
	// Prefix
	DependencyEdge_PREF DependencyEdge_Label = 42
	// Prepositional modifier
	DependencyEdge_PREP DependencyEdge_Label = 43
	// The relationship between a verb and verbal morpheme
	DependencyEdge_PRONL DependencyEdge_Label = 44
	// Particle
	DependencyEdge_PRT DependencyEdge_Label = 45
	// Associative or possessive marker
	DependencyEdge_PS DependencyEdge_Label = 46
	// Quantifier phrase modifier
	DependencyEdge_QUANTMOD DependencyEdge_Label = 47
	// Relative clause modifier
	DependencyEdge_RCMOD DependencyEdge_Label = 48
	// Complementizer in relative clause
	DependencyEdge_RCMODREL DependencyEdge_Label = 49
	// Ellipsis without a preceding predicate
	DependencyEdge_RDROP DependencyEdge_Label = 50
	// Referent
	DependencyEdge_REF DependencyEdge_Label = 51
	// Remnant
	DependencyEdge_REMNANT DependencyEdge_Label = 52
	// Reparandum
	DependencyEdge_REPARANDUM DependencyEdge_Label = 53
	// Root
	DependencyEdge_ROOT DependencyEdge_Label = 54
	// Suffix specifying a unit of number
	DependencyEdge_SNUM DependencyEdge_Label = 55
	// Suffix
	DependencyEdge_SUFF DependencyEdge_Label = 56
	// Temporal modifier
	DependencyEdge_TMOD DependencyEdge_Label = 57
	// Topic marker
	DependencyEdge_TOPIC DependencyEdge_Label = 58
	// Clause headed by an infinite form of the verb that modifies a noun
	DependencyEdge_VMOD DependencyEdge_Label = 59
	// Vocative
	DependencyEdge_VOCATIVE DependencyEdge_Label = 60
	// Open clausal complement
	DependencyEdge_XCOMP DependencyEdge_Label = 61
	// Name suffix
	DependencyEdge_SUFFIX DependencyEdge_Label = 62
	// Name title
	DependencyEdge_TITLE DependencyEdge_Label = 63
	// Adverbial phrase modifier
	DependencyEdge_ADVPHMOD DependencyEdge_Label = 64
	// Causative auxiliary
	DependencyEdge_AUXCAUS DependencyEdge_Label = 65
	// Helper auxiliary
	DependencyEdge_AUXVV DependencyEdge_Label = 66
	// Rentaishi (Prenominal modifier)
	DependencyEdge_DTMOD DependencyEdge_Label = 67
	// Foreign words
	DependencyEdge_FOREIGN DependencyEdge_Label = 68
	// Keyword
	DependencyEdge_KW DependencyEdge_Label = 69
	// List for chains of comparable items
	DependencyEdge_LIST DependencyEdge_Label = 70
	// Nominalized clause
	DependencyEdge_NOMC DependencyEdge_Label = 71
	// Nominalized clausal subject
	DependencyEdge_NOMCSUBJ DependencyEdge_Label = 72
	// Nominalized clausal passive
	DependencyEdge_NOMCSUBJPASS DependencyEdge_Label = 73
	// Compound of numeric modifier
	DependencyEdge_NUMC DependencyEdge_Label = 74
	// Copula
	DependencyEdge_COP DependencyEdge_Label = 75
	// Dislocated relation (for fronted/topicalized elements)
	DependencyEdge_DISLOCATED DependencyEdge_Label = 76
	// Aspect marker
	DependencyEdge_ASP DependencyEdge_Label = 77
	// Genitive modifier
	DependencyEdge_GMOD DependencyEdge_Label = 78
	// Genitive object
	DependencyEdge_GOBJ DependencyEdge_Label = 79
	// Infinitival modifier
	DependencyEdge_INFMOD DependencyEdge_Label = 80
	// Measure
	DependencyEdge_MES DependencyEdge_Label = 81
	// Nominal complement of a noun
	DependencyEdge_NCOMP DependencyEdge_Label = 82
)

// Enum value maps for DependencyEdge_Label.
var (
	DependencyEdge_Label_name = map[int32]string{
		0:  "UNKNOWN",
		1:  "ABBREV",
		2:  "ACOMP",
		3:  "ADVCL",
		4:  "ADVMOD",
		5:  "AMOD",
		6:  "APPOS",
		7:  "ATTR",
		8:  "AUX",
		9:  "AUXPASS",
		10: "CC",
		11: "CCOMP",
		12: "CONJ",
		13: "CSUBJ",
		14: "CSUBJPASS",
		15: "DEP",
		16: "DET",
		17: "DISCOURSE",
		18: "DOBJ",
		19: "EXPL",
		20: "GOESWITH",
		21: "IOBJ",
		22: "MARK",
		23: "MWE",
		24: "MWV",
		25: "NEG",
		26: "NN",
		27: "NPADVMOD",
		28: "NSUBJ",
		29: "NSUBJPASS",
		30: "NUM",
		31: "NUMBER",
		32: "P",
		33: "PARATAXIS",
		34: "PARTMOD",
		35: "PCOMP",
		36: "POBJ",
		37: "POSS",
		38: "POSTNEG",
		39: "PRECOMP",
		40: "PRECONJ",
		41: "PREDET",
		42: "PREF",
		43: "PREP",
		44: "PRONL",
		45: "PRT",
		46: "PS",
		47: "QUANTMOD",
		48: "RCMOD",
		49: "RCMODREL",
		50: "RDROP",
		51: "REF",
		52: "REMNANT",
		53: "REPARANDUM",
		54: "ROOT",
		55: "SNUM",
		56: "SUFF",
		57: "TMOD",
		58: "TOPIC",
		59: "VMOD",
		60: "VOCATIVE",
		61: "XCOMP",
		62: "SUFFIX",
		63: "TITLE",
		64: "ADVPHMOD",
		65: "AUXCAUS",
		66: "AUXVV",
		67: "DTMOD",
		68: "FOREIGN",
		69: "KW",
		70: "LIST",
		71: "NOMC",
		72: "NOMCSUBJ",
		73: "NOMCSUBJPASS",
		74: "NUMC",
		75: "COP",
		76: "DISLOCATED",
		77: "ASP",
		78: "GMOD",
		79: "GOBJ",
		80: "INFMOD",
		81: "MES",
		82: "NCOMP",
	}
	DependencyEdge_Label_value = map[string]int32{
		"UNKNOWN":      0,
		"ABBREV":       1,
		"ACOMP":        2,
		"ADVCL":        3,
		"ADVMOD":       4,
		"AMOD":         5,
		"APPOS":        6,
		"ATTR":         7,
		"AUX":          8,
		"AUXPASS":      9,
		"CC":           10,
		"CCOMP":        11,
		"CONJ":         12,
		"CSUBJ":        13,
		"CSUBJPASS":    14,
		"DEP":          15,
		"DET":          16,
		"DISCOURSE":    17,
		"DOBJ":         18,
		"EXPL":         19,
		"GOESWITH":     20,
		"IOBJ":         21,
		"MARK":         22,
		"MWE":          23,
		"MWV":          24,
		"NEG":          25,
		"NN":           26,
		"NPADVMOD":     27,
		"NSUBJ":        28,
		"NSUBJPASS":    29,
		"NUM":          30,
		"NUMBER":       31,
		"P":            32,
		"PARATAXIS":    33,
		"PARTMOD":      34,
		"PCOMP":        35,
		"POBJ":         36,
		"POSS":         37,
		"POSTNEG":      38,
		"PRECOMP":      39,
		"PRECONJ":      40,
		"PREDET":       41,
		"PREF":         42,
		"PREP":         43,
		"PRONL":        44,
		"PRT":          45,
		"PS":           46,
		"QUANTMOD":     47,
		"RCMOD":        48,
		"RCMODREL":     49,
		"RDROP":        50,
		"REF":          51,
		"REMNANT":      52,
		"REPARANDUM":   53,
		"ROOT":         54,
		"SNUM":         55,
		"SUFF":         56,
		"TMOD":         57,
		"TOPIC":        58,
		"VMOD":         59,
		"VOCATIVE":     60,
		"XCOMP":        61,
		"SUFFIX":       62,
		"TITLE":        63,
		"ADVPHMOD":     64,
		"AUXCAUS":      65,
		"AUXVV":        66,
		"DTMOD":        67,
		"FOREIGN":      68,
		"KW":           69,
		"LIST":         70,
		"NOMC":         71,
		"NOMCSUBJ":     72,
		"NOMCSUBJPASS": 73,
		"NUMC":         74,
		"COP":          75,
		"DISLOCATED":   76,
		"ASP":          77,
		"GMOD":         78,
		"GOBJ":         79,
		"INFMOD":       80,
		"MES":          81,
		"NCOMP":        82,
	}
)

func (x DependencyEdge_Label) Enum() *DependencyEdge_Label {
	p := new(DependencyEdge_Label)
	*p = x
	return p
}

func (x DependencyEdge_Label) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DependencyEdge_Label) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[15].Descriptor()
}

func (DependencyEdge_Label) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[15]
}

func (x DependencyEdge_Label) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DependencyEdge_Label.Descriptor instead.
func (DependencyEdge_Label) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{6, 0}
}

// The supported types of mentions.
type EntityMention_Type int32

const (
	// Unknown
	EntityMention_TYPE_UNKNOWN EntityMention_Type = 0
	// Proper name
	EntityMention_PROPER EntityMention_Type = 1
	// Common noun (or noun compound)
	EntityMention_COMMON EntityMention_Type = 2
)

// Enum value maps for EntityMention_Type.
var (
	EntityMention_Type_name = map[int32]string{
		0: "TYPE_UNKNOWN",
		1: "PROPER",
		2: "COMMON",
	}
	EntityMention_Type_value = map[string]int32{
		"TYPE_UNKNOWN": 0,
		"PROPER":       1,
		"COMMON":       2,
	}
)

func (x EntityMention_Type) Enum() *EntityMention_Type {
	p := new(EntityMention_Type)
	*p = x
	return p
}

func (x EntityMention_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntityMention_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_language_v1beta2_language_service_proto_enumTypes[16].Descriptor()
}

func (EntityMention_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_language_v1beta2_language_service_proto_enumTypes[16]
}

func (x EntityMention_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntityMention_Type.Descriptor instead.
func (EntityMention_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{7, 0}
}

// ################################################################ #
//
// Represents the input to API methods.
type Document struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. If the type is not set or is `TYPE_UNSPECIFIED`,
	// returns an `INVALID_ARGUMENT` error.
	Type Document_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.language.v1beta2.Document_Type" json:"type,omitempty"`
	// The source of the document: a string containing the content or a
	// Google Cloud Storage URI.
	//
	// Types that are assignable to Source:
	//	*Document_Content
	//	*Document_GcsContentUri
	Source isDocument_Source `protobuf_oneof:"source"`
	// The language of the document (if not specified, the language is
	// automatically detected). Both ISO and BCP-47 language codes are
	// accepted.<br>
	// [Language
	// Support](https://cloud.google.com/natural-language/docs/languages) lists
	// currently supported languages for each API method. If the language (either
	// specified by the caller or automatically detected) is not supported by the
	// called API method, an `INVALID_ARGUMENT` error is returned.
	Language string `protobuf:"bytes,4,opt,name=language,proto3" json:"language,omitempty"`
}

func (x *Document) Reset() {
	*x = Document{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document) ProtoMessage() {}

func (x *Document) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document.ProtoReflect.Descriptor instead.
func (*Document) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{0}
}

func (x *Document) GetType() Document_Type {
	if x != nil {
		return x.Type
	}
	return Document_TYPE_UNSPECIFIED
}

func (m *Document) GetSource() isDocument_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Document) GetContent() string {
	if x, ok := x.GetSource().(*Document_Content); ok {
		return x.Content
	}
	return ""
}

func (x *Document) GetGcsContentUri() string {
	if x, ok := x.GetSource().(*Document_GcsContentUri); ok {
		return x.GcsContentUri
	}
	return ""
}

func (x *Document) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

type isDocument_Source interface {
	isDocument_Source()
}

type Document_Content struct {
	// The content of the input in string format.
	// Cloud audit logging exempt since it is based on user data.
	Content string `protobuf:"bytes,2,opt,name=content,proto3,oneof"`
}

type Document_GcsContentUri struct {
	// The Google Cloud Storage URI where the file content is located.
	// This URI must be of the form: gs://bucket_name/object_name. For more
	// details, see https://cloud.google.com/storage/docs/reference-uris.
	// NOTE: Cloud Storage object versioning is not supported.
	GcsContentUri string `protobuf:"bytes,3,opt,name=gcs_content_uri,json=gcsContentUri,proto3,oneof"`
}

func (*Document_Content) isDocument_Source() {}

func (*Document_GcsContentUri) isDocument_Source() {}

// Represents a sentence in the input document.
type Sentence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The sentence text.
	Text *TextSpan `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// For calls to [AnalyzeSentiment][] or if
	// [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_document_sentiment] is set to
	// true, this field will contain the sentiment for the sentence.
	Sentiment *Sentiment `protobuf:"bytes,2,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
}

func (x *Sentence) Reset() {
	*x = Sentence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Sentence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sentence) ProtoMessage() {}

func (x *Sentence) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Sentence.ProtoReflect.Descriptor instead.
func (*Sentence) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{1}
}

func (x *Sentence) GetText() *TextSpan {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *Sentence) GetSentiment() *Sentiment {
	if x != nil {
		return x.Sentiment
	}
	return nil
}

// Represents a phrase in the text that is a known entity, such as
// a person, an organization, or location. The API associates information, such
// as salience and mentions, with entities.
type Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The representative name for the entity.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The entity type.
	Type Entity_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.language.v1beta2.Entity_Type" json:"type,omitempty"`
	// Metadata associated with the entity.
	//
	// For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
	// and Knowledge Graph MID (`mid`), if they are available. For the metadata
	// associated with other entity types, see the Type table below.
	Metadata map[string]string `protobuf:"bytes,3,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The salience score associated with the entity in the [0, 1.0] range.
	//
	// The salience score for an entity provides information about the
	// importance or centrality of that entity to the entire document text.
	// Scores closer to 0 are less salient, while scores closer to 1.0 are highly
	// salient.
	Salience float32 `protobuf:"fixed32,4,opt,name=salience,proto3" json:"salience,omitempty"`
	// The mentions of this entity in the input document. The API currently
	// supports proper noun mentions.
	Mentions []*EntityMention `protobuf:"bytes,5,rep,name=mentions,proto3" json:"mentions,omitempty"`
	// For calls to [AnalyzeEntitySentiment][] or if
	// [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment] is set to
	// true, this field will contain the aggregate sentiment expressed for this
	// entity in the provided document.
	Sentiment *Sentiment `protobuf:"bytes,6,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
}

func (x *Entity) Reset() {
	*x = Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entity) ProtoMessage() {}

func (x *Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entity.ProtoReflect.Descriptor instead.
func (*Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{2}
}

func (x *Entity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Entity) GetType() Entity_Type {
	if x != nil {
		return x.Type
	}
	return Entity_UNKNOWN
}

func (x *Entity) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Entity) GetSalience() float32 {
	if x != nil {
		return x.Salience
	}
	return 0
}

func (x *Entity) GetMentions() []*EntityMention {
	if x != nil {
		return x.Mentions
	}
	return nil
}

func (x *Entity) GetSentiment() *Sentiment {
	if x != nil {
		return x.Sentiment
	}
	return nil
}

// Represents the smallest syntactic building block of the text.
type Token struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The token text.
	Text *TextSpan `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Parts of speech tag for this token.
	PartOfSpeech *PartOfSpeech `protobuf:"bytes,2,opt,name=part_of_speech,json=partOfSpeech,proto3" json:"part_of_speech,omitempty"`
	// Dependency tree parse for this token.
	DependencyEdge *DependencyEdge `protobuf:"bytes,3,opt,name=dependency_edge,json=dependencyEdge,proto3" json:"dependency_edge,omitempty"`
	// [Lemma](https://en.wikipedia.org/wiki/Lemma_%28morphology%29) of the token.
	Lemma string `protobuf:"bytes,4,opt,name=lemma,proto3" json:"lemma,omitempty"`
}

func (x *Token) Reset() {
	*x = Token{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Token) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Token) ProtoMessage() {}

func (x *Token) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Token.ProtoReflect.Descriptor instead.
func (*Token) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{3}
}

func (x *Token) GetText() *TextSpan {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *Token) GetPartOfSpeech() *PartOfSpeech {
	if x != nil {
		return x.PartOfSpeech
	}
	return nil
}

func (x *Token) GetDependencyEdge() *DependencyEdge {
	if x != nil {
		return x.DependencyEdge
	}
	return nil
}

func (x *Token) GetLemma() string {
	if x != nil {
		return x.Lemma
	}
	return ""
}

// Represents the feeling associated with the entire text or entities in
// the text.
// Next ID: 6
type Sentiment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A non-negative number in the [0, +inf) range, which represents
	// the absolute magnitude of sentiment regardless of score (positive or
	// negative).
	Magnitude float32 `protobuf:"fixed32,2,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
	// Sentiment score between -1.0 (negative sentiment) and 1.0
	// (positive sentiment).
	Score float32 `protobuf:"fixed32,3,opt,name=score,proto3" json:"score,omitempty"`
}

func (x *Sentiment) Reset() {
	*x = Sentiment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Sentiment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sentiment) ProtoMessage() {}

func (x *Sentiment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Sentiment.ProtoReflect.Descriptor instead.
func (*Sentiment) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{4}
}

func (x *Sentiment) GetMagnitude() float32 {
	if x != nil {
		return x.Magnitude
	}
	return 0
}

func (x *Sentiment) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

// Represents part of speech information for a token.
type PartOfSpeech struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The part of speech tag.
	Tag PartOfSpeech_Tag `protobuf:"varint,1,opt,name=tag,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Tag" json:"tag,omitempty"`
	// The grammatical aspect.
	Aspect PartOfSpeech_Aspect `protobuf:"varint,2,opt,name=aspect,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Aspect" json:"aspect,omitempty"`
	// The grammatical case.
	Case PartOfSpeech_Case `protobuf:"varint,3,opt,name=case,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Case" json:"case,omitempty"`
	// The grammatical form.
	Form PartOfSpeech_Form `protobuf:"varint,4,opt,name=form,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Form" json:"form,omitempty"`
	// The grammatical gender.
	Gender PartOfSpeech_Gender `protobuf:"varint,5,opt,name=gender,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Gender" json:"gender,omitempty"`
	// The grammatical mood.
	Mood PartOfSpeech_Mood `protobuf:"varint,6,opt,name=mood,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Mood" json:"mood,omitempty"`
	// The grammatical number.
	Number PartOfSpeech_Number `protobuf:"varint,7,opt,name=number,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Number" json:"number,omitempty"`
	// The grammatical person.
	Person PartOfSpeech_Person `protobuf:"varint,8,opt,name=person,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Person" json:"person,omitempty"`
	// The grammatical properness.
	Proper PartOfSpeech_Proper `protobuf:"varint,9,opt,name=proper,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Proper" json:"proper,omitempty"`
	// The grammatical reciprocity.
	Reciprocity PartOfSpeech_Reciprocity `protobuf:"varint,10,opt,name=reciprocity,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Reciprocity" json:"reciprocity,omitempty"`
	// The grammatical tense.
	Tense PartOfSpeech_Tense `protobuf:"varint,11,opt,name=tense,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Tense" json:"tense,omitempty"`
	// The grammatical voice.
	Voice PartOfSpeech_Voice `protobuf:"varint,12,opt,name=voice,proto3,enum=google.cloud.language.v1beta2.PartOfSpeech_Voice" json:"voice,omitempty"`
}

func (x *PartOfSpeech) Reset() {
	*x = PartOfSpeech{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartOfSpeech) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartOfSpeech) ProtoMessage() {}

func (x *PartOfSpeech) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartOfSpeech.ProtoReflect.Descriptor instead.
func (*PartOfSpeech) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{5}
}

func (x *PartOfSpeech) GetTag() PartOfSpeech_Tag {
	if x != nil {
		return x.Tag
	}
	return PartOfSpeech_UNKNOWN
}

func (x *PartOfSpeech) GetAspect() PartOfSpeech_Aspect {
	if x != nil {
		return x.Aspect
	}
	return PartOfSpeech_ASPECT_UNKNOWN
}

func (x *PartOfSpeech) GetCase() PartOfSpeech_Case {
	if x != nil {
		return x.Case
	}
	return PartOfSpeech_CASE_UNKNOWN
}

func (x *PartOfSpeech) GetForm() PartOfSpeech_Form {
	if x != nil {
		return x.Form
	}
	return PartOfSpeech_FORM_UNKNOWN
}

func (x *PartOfSpeech) GetGender() PartOfSpeech_Gender {
	if x != nil {
		return x.Gender
	}
	return PartOfSpeech_GENDER_UNKNOWN
}

func (x *PartOfSpeech) GetMood() PartOfSpeech_Mood {
	if x != nil {
		return x.Mood
	}
	return PartOfSpeech_MOOD_UNKNOWN
}

func (x *PartOfSpeech) GetNumber() PartOfSpeech_Number {
	if x != nil {
		return x.Number
	}
	return PartOfSpeech_NUMBER_UNKNOWN
}

func (x *PartOfSpeech) GetPerson() PartOfSpeech_Person {
	if x != nil {
		return x.Person
	}
	return PartOfSpeech_PERSON_UNKNOWN
}

func (x *PartOfSpeech) GetProper() PartOfSpeech_Proper {
	if x != nil {
		return x.Proper
	}
	return PartOfSpeech_PROPER_UNKNOWN
}

func (x *PartOfSpeech) GetReciprocity() PartOfSpeech_Reciprocity {
	if x != nil {
		return x.Reciprocity
	}
	return PartOfSpeech_RECIPROCITY_UNKNOWN
}

func (x *PartOfSpeech) GetTense() PartOfSpeech_Tense {
	if x != nil {
		return x.Tense
	}
	return PartOfSpeech_TENSE_UNKNOWN
}

func (x *PartOfSpeech) GetVoice() PartOfSpeech_Voice {
	if x != nil {
		return x.Voice
	}
	return PartOfSpeech_VOICE_UNKNOWN
}

// Represents dependency parse tree information for a token.
type DependencyEdge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the head of this token in the dependency tree.
	// This is the index of the token which has an arc going to this token.
	// The index is the position of the token in the array of tokens returned
	// by the API method. If this token is a root token, then the
	// `head_token_index` is its own index.
	HeadTokenIndex int32 `protobuf:"varint,1,opt,name=head_token_index,json=headTokenIndex,proto3" json:"head_token_index,omitempty"`
	// The parse label for the token.
	Label DependencyEdge_Label `protobuf:"varint,2,opt,name=label,proto3,enum=google.cloud.language.v1beta2.DependencyEdge_Label" json:"label,omitempty"`
}

func (x *DependencyEdge) Reset() {
	*x = DependencyEdge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DependencyEdge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DependencyEdge) ProtoMessage() {}

func (x *DependencyEdge) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DependencyEdge.ProtoReflect.Descriptor instead.
func (*DependencyEdge) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{6}
}

func (x *DependencyEdge) GetHeadTokenIndex() int32 {
	if x != nil {
		return x.HeadTokenIndex
	}
	return 0
}

func (x *DependencyEdge) GetLabel() DependencyEdge_Label {
	if x != nil {
		return x.Label
	}
	return DependencyEdge_UNKNOWN
}

// Represents a mention for an entity in the text. Currently, proper noun
// mentions are supported.
type EntityMention struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mention text.
	Text *TextSpan `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The type of the entity mention.
	Type EntityMention_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.language.v1beta2.EntityMention_Type" json:"type,omitempty"`
	// For calls to [AnalyzeEntitySentiment][] or if
	// [AnnotateTextRequest.Features.extract_entity_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entity_sentiment] is set to
	// true, this field will contain the sentiment expressed for this mention of
	// the entity in the provided document.
	Sentiment *Sentiment `protobuf:"bytes,3,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
}

func (x *EntityMention) Reset() {
	*x = EntityMention{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityMention) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityMention) ProtoMessage() {}

func (x *EntityMention) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityMention.ProtoReflect.Descriptor instead.
func (*EntityMention) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{7}
}

func (x *EntityMention) GetText() *TextSpan {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *EntityMention) GetType() EntityMention_Type {
	if x != nil {
		return x.Type
	}
	return EntityMention_TYPE_UNKNOWN
}

func (x *EntityMention) GetSentiment() *Sentiment {
	if x != nil {
		return x.Sentiment
	}
	return nil
}

// Represents an output piece of text.
type TextSpan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The content of the output text.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The API calculates the beginning offset of the content in the original
	// document according to the [EncodingType][google.cloud.language.v1beta2.EncodingType] specified in the API request.
	BeginOffset int32 `protobuf:"varint,2,opt,name=begin_offset,json=beginOffset,proto3" json:"begin_offset,omitempty"`
}

func (x *TextSpan) Reset() {
	*x = TextSpan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextSpan) ProtoMessage() {}

func (x *TextSpan) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextSpan.ProtoReflect.Descriptor instead.
func (*TextSpan) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{8}
}

func (x *TextSpan) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *TextSpan) GetBeginOffset() int32 {
	if x != nil {
		return x.BeginOffset
	}
	return 0
}

// Represents a category returned from the text classifier.
type ClassificationCategory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the category representing the document, from the [predefined
	// taxonomy](https://cloud.google.com/natural-language/docs/categories).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The classifier's confidence of the category. Number represents how certain
	// the classifier is that this category represents the given text.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *ClassificationCategory) Reset() {
	*x = ClassificationCategory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassificationCategory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassificationCategory) ProtoMessage() {}

func (x *ClassificationCategory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassificationCategory.ProtoReflect.Descriptor instead.
func (*ClassificationCategory) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{9}
}

func (x *ClassificationCategory) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ClassificationCategory) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// The sentiment analysis request message.
type AnalyzeSentimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The encoding type used by the API to calculate sentence offsets for the
	// sentence sentiment.
	EncodingType EncodingType `protobuf:"varint,2,opt,name=encoding_type,json=encodingType,proto3,enum=google.cloud.language.v1beta2.EncodingType" json:"encoding_type,omitempty"`
}

func (x *AnalyzeSentimentRequest) Reset() {
	*x = AnalyzeSentimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeSentimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeSentimentRequest) ProtoMessage() {}

func (x *AnalyzeSentimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeSentimentRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeSentimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{10}
}

func (x *AnalyzeSentimentRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *AnalyzeSentimentRequest) GetEncodingType() EncodingType {
	if x != nil {
		return x.EncodingType
	}
	return EncodingType_NONE
}

// The sentiment analysis response message.
type AnalyzeSentimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overall sentiment of the input document.
	DocumentSentiment *Sentiment `protobuf:"bytes,1,opt,name=document_sentiment,json=documentSentiment,proto3" json:"document_sentiment,omitempty"`
	// The language of the text, which will be the same as the language specified
	// in the request or, if not specified, the automatically-detected language.
	// See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
	Language string `protobuf:"bytes,2,opt,name=language,proto3" json:"language,omitempty"`
	// The sentiment for all the sentences in the document.
	Sentences []*Sentence `protobuf:"bytes,3,rep,name=sentences,proto3" json:"sentences,omitempty"`
}

func (x *AnalyzeSentimentResponse) Reset() {
	*x = AnalyzeSentimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeSentimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeSentimentResponse) ProtoMessage() {}

func (x *AnalyzeSentimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeSentimentResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeSentimentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{11}
}

func (x *AnalyzeSentimentResponse) GetDocumentSentiment() *Sentiment {
	if x != nil {
		return x.DocumentSentiment
	}
	return nil
}

func (x *AnalyzeSentimentResponse) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

func (x *AnalyzeSentimentResponse) GetSentences() []*Sentence {
	if x != nil {
		return x.Sentences
	}
	return nil
}

// The entity-level sentiment analysis request message.
type AnalyzeEntitySentimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The encoding type used by the API to calculate offsets.
	EncodingType EncodingType `protobuf:"varint,2,opt,name=encoding_type,json=encodingType,proto3,enum=google.cloud.language.v1beta2.EncodingType" json:"encoding_type,omitempty"`
}

func (x *AnalyzeEntitySentimentRequest) Reset() {
	*x = AnalyzeEntitySentimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeEntitySentimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeEntitySentimentRequest) ProtoMessage() {}

func (x *AnalyzeEntitySentimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeEntitySentimentRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeEntitySentimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{12}
}

func (x *AnalyzeEntitySentimentRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *AnalyzeEntitySentimentRequest) GetEncodingType() EncodingType {
	if x != nil {
		return x.EncodingType
	}
	return EncodingType_NONE
}

// The entity-level sentiment analysis response message.
type AnalyzeEntitySentimentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The recognized entities in the input document with associated sentiments.
	Entities []*Entity `protobuf:"bytes,1,rep,name=entities,proto3" json:"entities,omitempty"`
	// The language of the text, which will be the same as the language specified
	// in the request or, if not specified, the automatically-detected language.
	// See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
	Language string `protobuf:"bytes,2,opt,name=language,proto3" json:"language,omitempty"`
}

func (x *AnalyzeEntitySentimentResponse) Reset() {
	*x = AnalyzeEntitySentimentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeEntitySentimentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeEntitySentimentResponse) ProtoMessage() {}

func (x *AnalyzeEntitySentimentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeEntitySentimentResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeEntitySentimentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{13}
}

func (x *AnalyzeEntitySentimentResponse) GetEntities() []*Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *AnalyzeEntitySentimentResponse) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

// The entity analysis request message.
type AnalyzeEntitiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The encoding type used by the API to calculate offsets.
	EncodingType EncodingType `protobuf:"varint,2,opt,name=encoding_type,json=encodingType,proto3,enum=google.cloud.language.v1beta2.EncodingType" json:"encoding_type,omitempty"`
}

func (x *AnalyzeEntitiesRequest) Reset() {
	*x = AnalyzeEntitiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeEntitiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeEntitiesRequest) ProtoMessage() {}

func (x *AnalyzeEntitiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeEntitiesRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeEntitiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{14}
}

func (x *AnalyzeEntitiesRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *AnalyzeEntitiesRequest) GetEncodingType() EncodingType {
	if x != nil {
		return x.EncodingType
	}
	return EncodingType_NONE
}

// The entity analysis response message.
type AnalyzeEntitiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The recognized entities in the input document.
	Entities []*Entity `protobuf:"bytes,1,rep,name=entities,proto3" json:"entities,omitempty"`
	// The language of the text, which will be the same as the language specified
	// in the request or, if not specified, the automatically-detected language.
	// See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
	Language string `protobuf:"bytes,2,opt,name=language,proto3" json:"language,omitempty"`
}

func (x *AnalyzeEntitiesResponse) Reset() {
	*x = AnalyzeEntitiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeEntitiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeEntitiesResponse) ProtoMessage() {}

func (x *AnalyzeEntitiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeEntitiesResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeEntitiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{15}
}

func (x *AnalyzeEntitiesResponse) GetEntities() []*Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *AnalyzeEntitiesResponse) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

// The syntax analysis request message.
type AnalyzeSyntaxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// The encoding type used by the API to calculate offsets.
	EncodingType EncodingType `protobuf:"varint,2,opt,name=encoding_type,json=encodingType,proto3,enum=google.cloud.language.v1beta2.EncodingType" json:"encoding_type,omitempty"`
}

func (x *AnalyzeSyntaxRequest) Reset() {
	*x = AnalyzeSyntaxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeSyntaxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeSyntaxRequest) ProtoMessage() {}

func (x *AnalyzeSyntaxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeSyntaxRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeSyntaxRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{16}
}

func (x *AnalyzeSyntaxRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *AnalyzeSyntaxRequest) GetEncodingType() EncodingType {
	if x != nil {
		return x.EncodingType
	}
	return EncodingType_NONE
}

// The syntax analysis response message.
type AnalyzeSyntaxResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sentences in the input document.
	Sentences []*Sentence `protobuf:"bytes,1,rep,name=sentences,proto3" json:"sentences,omitempty"`
	// Tokens, along with their syntactic information, in the input document.
	Tokens []*Token `protobuf:"bytes,2,rep,name=tokens,proto3" json:"tokens,omitempty"`
	// The language of the text, which will be the same as the language specified
	// in the request or, if not specified, the automatically-detected language.
	// See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
	Language string `protobuf:"bytes,3,opt,name=language,proto3" json:"language,omitempty"`
}

func (x *AnalyzeSyntaxResponse) Reset() {
	*x = AnalyzeSyntaxResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeSyntaxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeSyntaxResponse) ProtoMessage() {}

func (x *AnalyzeSyntaxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeSyntaxResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeSyntaxResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{17}
}

func (x *AnalyzeSyntaxResponse) GetSentences() []*Sentence {
	if x != nil {
		return x.Sentences
	}
	return nil
}

func (x *AnalyzeSyntaxResponse) GetTokens() []*Token {
	if x != nil {
		return x.Tokens
	}
	return nil
}

func (x *AnalyzeSyntaxResponse) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

// The document classification request message.
type ClassifyTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
}

func (x *ClassifyTextRequest) Reset() {
	*x = ClassifyTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassifyTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassifyTextRequest) ProtoMessage() {}

func (x *ClassifyTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassifyTextRequest.ProtoReflect.Descriptor instead.
func (*ClassifyTextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{18}
}

func (x *ClassifyTextRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

// The document classification response message.
type ClassifyTextResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Categories representing the input document.
	Categories []*ClassificationCategory `protobuf:"bytes,1,rep,name=categories,proto3" json:"categories,omitempty"`
}

func (x *ClassifyTextResponse) Reset() {
	*x = ClassifyTextResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassifyTextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassifyTextResponse) ProtoMessage() {}

func (x *ClassifyTextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassifyTextResponse.ProtoReflect.Descriptor instead.
func (*ClassifyTextResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{19}
}

func (x *ClassifyTextResponse) GetCategories() []*ClassificationCategory {
	if x != nil {
		return x.Categories
	}
	return nil
}

// The request message for the text annotation API, which can perform multiple
// analysis types (sentiment, entities, and syntax) in one call.
type AnnotateTextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input document.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// Required. The enabled features.
	Features *AnnotateTextRequest_Features `protobuf:"bytes,2,opt,name=features,proto3" json:"features,omitempty"`
	// The encoding type used by the API to calculate offsets.
	EncodingType EncodingType `protobuf:"varint,3,opt,name=encoding_type,json=encodingType,proto3,enum=google.cloud.language.v1beta2.EncodingType" json:"encoding_type,omitempty"`
}

func (x *AnnotateTextRequest) Reset() {
	*x = AnnotateTextRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateTextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateTextRequest) ProtoMessage() {}

func (x *AnnotateTextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateTextRequest.ProtoReflect.Descriptor instead.
func (*AnnotateTextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{20}
}

func (x *AnnotateTextRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *AnnotateTextRequest) GetFeatures() *AnnotateTextRequest_Features {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *AnnotateTextRequest) GetEncodingType() EncodingType {
	if x != nil {
		return x.EncodingType
	}
	return EncodingType_NONE
}

// The text annotations response message.
type AnnotateTextResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sentences in the input document. Populated if the user enables
	// [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_syntax].
	Sentences []*Sentence `protobuf:"bytes,1,rep,name=sentences,proto3" json:"sentences,omitempty"`
	// Tokens, along with their syntactic information, in the input document.
	// Populated if the user enables
	// [AnnotateTextRequest.Features.extract_syntax][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_syntax].
	Tokens []*Token `protobuf:"bytes,2,rep,name=tokens,proto3" json:"tokens,omitempty"`
	// Entities, along with their semantic information, in the input document.
	// Populated if the user enables
	// [AnnotateTextRequest.Features.extract_entities][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_entities].
	Entities []*Entity `protobuf:"bytes,3,rep,name=entities,proto3" json:"entities,omitempty"`
	// The overall sentiment for the document. Populated if the user enables
	// [AnnotateTextRequest.Features.extract_document_sentiment][google.cloud.language.v1beta2.AnnotateTextRequest.Features.extract_document_sentiment].
	DocumentSentiment *Sentiment `protobuf:"bytes,4,opt,name=document_sentiment,json=documentSentiment,proto3" json:"document_sentiment,omitempty"`
	// The language of the text, which will be the same as the language specified
	// in the request or, if not specified, the automatically-detected language.
	// See [Document.language][google.cloud.language.v1beta2.Document.language] field for more details.
	Language string `protobuf:"bytes,5,opt,name=language,proto3" json:"language,omitempty"`
	// Categories identified in the input document.
	Categories []*ClassificationCategory `protobuf:"bytes,6,rep,name=categories,proto3" json:"categories,omitempty"`
}

func (x *AnnotateTextResponse) Reset() {
	*x = AnnotateTextResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateTextResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateTextResponse) ProtoMessage() {}

func (x *AnnotateTextResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateTextResponse.ProtoReflect.Descriptor instead.
func (*AnnotateTextResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{21}
}

func (x *AnnotateTextResponse) GetSentences() []*Sentence {
	if x != nil {
		return x.Sentences
	}
	return nil
}

func (x *AnnotateTextResponse) GetTokens() []*Token {
	if x != nil {
		return x.Tokens
	}
	return nil
}

func (x *AnnotateTextResponse) GetEntities() []*Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *AnnotateTextResponse) GetDocumentSentiment() *Sentiment {
	if x != nil {
		return x.DocumentSentiment
	}
	return nil
}

func (x *AnnotateTextResponse) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

func (x *AnnotateTextResponse) GetCategories() []*ClassificationCategory {
	if x != nil {
		return x.Categories
	}
	return nil
}

// All available features for sentiment, syntax, and semantic analysis.
// Setting each one to true will enable that specific analysis for the input.
// Next ID: 10
type AnnotateTextRequest_Features struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Extract syntax information.
	ExtractSyntax bool `protobuf:"varint,1,opt,name=extract_syntax,json=extractSyntax,proto3" json:"extract_syntax,omitempty"`
	// Extract entities.
	ExtractEntities bool `protobuf:"varint,2,opt,name=extract_entities,json=extractEntities,proto3" json:"extract_entities,omitempty"`
	// Extract document-level sentiment.
	ExtractDocumentSentiment bool `protobuf:"varint,3,opt,name=extract_document_sentiment,json=extractDocumentSentiment,proto3" json:"extract_document_sentiment,omitempty"`
	// Extract entities and their associated sentiment.
	ExtractEntitySentiment bool `protobuf:"varint,4,opt,name=extract_entity_sentiment,json=extractEntitySentiment,proto3" json:"extract_entity_sentiment,omitempty"`
	// Classify the full document into categories. If this is true,
	// the API will use the default model which classifies into a
	// [predefined
	// taxonomy](https://cloud.google.com/natural-language/docs/categories).
	ClassifyText bool `protobuf:"varint,6,opt,name=classify_text,json=classifyText,proto3" json:"classify_text,omitempty"`
}

func (x *AnnotateTextRequest_Features) Reset() {
	*x = AnnotateTextRequest_Features{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateTextRequest_Features) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateTextRequest_Features) ProtoMessage() {}

func (x *AnnotateTextRequest_Features) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_language_v1beta2_language_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateTextRequest_Features.ProtoReflect.Descriptor instead.
func (*AnnotateTextRequest_Features) Descriptor() ([]byte, []int) {
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP(), []int{20, 0}
}

func (x *AnnotateTextRequest_Features) GetExtractSyntax() bool {
	if x != nil {
		return x.ExtractSyntax
	}
	return false
}

func (x *AnnotateTextRequest_Features) GetExtractEntities() bool {
	if x != nil {
		return x.ExtractEntities
	}
	return false
}

func (x *AnnotateTextRequest_Features) GetExtractDocumentSentiment() bool {
	if x != nil {
		return x.ExtractDocumentSentiment
	}
	return false
}

func (x *AnnotateTextRequest_Features) GetExtractEntitySentiment() bool {
	if x != nil {
		return x.ExtractEntitySentiment
	}
	return false
}

func (x *AnnotateTextRequest_Features) GetClassifyText() bool {
	if x != nil {
		return x.ClassifyText
	}
	return false
}

var File_google_cloud_language_v1beta2_language_service_proto protoreflect.FileDescriptor

var file_google_cloud_language_v1beta2_language_service_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf0,
	0x01, 0x0a, 0x08, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0f, 0x67, 0x63, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x63, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x55, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x22,
	0x36, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a,
	0x0a, 0x50, 0x4c, 0x41, 0x49, 0x4e, 0x5f, 0x54, 0x45, 0x58, 0x54, 0x10, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x48, 0x54, 0x4d, 0x4c, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x8f, 0x01, 0x0a, 0x08, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x3b,
	0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x54, 0x65, 0x78,
	0x74, 0x53, 0x70, 0x61, 0x6e, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x46, 0x0a, 0x09, 0x73,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x22, 0xd4, 0x04, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x4f, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x61, 0x6c, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x08, 0x73, 0x61, 0x6c, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x48, 0x0a, 0x08, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x0a, 0x09, 0x73, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xb9,
	0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x10,
	0x0a, 0x0c, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03,
	0x12, 0x09, 0x0a, 0x05, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x57,
	0x4f, 0x52, 0x4b, 0x5f, 0x4f, 0x46, 0x5f, 0x41, 0x52, 0x54, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d,
	0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x47, 0x4f, 0x4f, 0x44, 0x10, 0x06, 0x12,
	0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x07, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x48,
	0x4f, 0x4e, 0x45, 0x5f, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x09, 0x12, 0x0b, 0x0a, 0x07,
	0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0a, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x54,
	0x45, 0x10, 0x0b, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x0c, 0x12,
	0x09, 0x0a, 0x05, 0x50, 0x52, 0x49, 0x43, 0x45, 0x10, 0x0d, 0x22, 0x85, 0x02, 0x0a, 0x05, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x52, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x51, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x4f, 0x66,
	0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x53, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x12, 0x56, 0x0a, 0x0f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x65, 0x64, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x64, 0x67, 0x65, 0x52, 0x0e, 0x64, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x64, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x6c, 0x65, 0x6d, 0x6d, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x65, 0x6d,
	0x6d, 0x61, 0x22, 0x3f, 0x0a, 0x09, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x1c, 0x0a, 0x09, 0x6d, 0x61, 0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x09, 0x6d, 0x61, 0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x22, 0xb9, 0x11, 0x0a, 0x0c, 0x50, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x53, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x12, 0x41, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x54,
	0x61, 0x67, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x4a, 0x0a, 0x06, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x53, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x52, 0x06, 0x61, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x63, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x43,
	0x61, 0x73, 0x65, 0x52, 0x04, 0x63, 0x61, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x04, 0x66, 0x6f, 0x72,
	0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x53, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x52, 0x04, 0x66, 0x6f, 0x72, 0x6d, 0x12,
	0x4a, 0x0a, 0x06, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x47, 0x65, 0x6e,
	0x64, 0x65, 0x72, 0x52, 0x06, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x12, 0x44, 0x0a, 0x04, 0x6d,
	0x6f, 0x6f, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x4f, 0x66,
	0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x4d, 0x6f, 0x6f, 0x64, 0x52, 0x04, 0x6d, 0x6f, 0x6f,
	0x64, 0x12, 0x4a, 0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x4a, 0x0a,
	0x06, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x61,
	0x72, 0x74, 0x4f, 0x66, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x4f, 0x66,
	0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x52, 0x06, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x12, 0x59, 0x0a, 0x0b, 0x72, 0x65, 0x63, 0x69, 0x70, 0x72, 0x6f,
	0x63, 0x69, 0x74, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x4f,
	0x66, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x52, 0x65, 0x63, 0x69, 0x70, 0x72, 0x6f, 0x63,
	0x69, 0x74, 0x79, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x69, 0x70, 0x72, 0x6f, 0x63, 0x69, 0x74, 0x79,
	0x12, 0x47, 0x0a, 0x05, 0x74, 0x65, 0x6e, 0x73, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x54, 0x65, 0x6e,
	0x73, 0x65, 0x52, 0x05, 0x74, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x05, 0x76, 0x6f, 0x69,
	0x63, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x4f, 0x66, 0x53,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x05, 0x76, 0x6f, 0x69,
	0x63, 0x65, 0x22, 0x8d, 0x01, 0x0a, 0x03, 0x54, 0x61, 0x67, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x4a, 0x10, 0x01,
	0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x50, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x56,
	0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4f, 0x4e, 0x4a, 0x10, 0x04, 0x12, 0x07, 0x0a, 0x03,
	0x44, 0x45, 0x54, 0x10, 0x05, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x55, 0x4e, 0x10, 0x06, 0x12,
	0x07, 0x0a, 0x03, 0x4e, 0x55, 0x4d, 0x10, 0x07, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x52, 0x4f, 0x4e,
	0x10, 0x08, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x52, 0x54, 0x10, 0x09, 0x12, 0x09, 0x0a, 0x05, 0x50,
	0x55, 0x4e, 0x43, 0x54, 0x10, 0x0a, 0x12, 0x08, 0x0a, 0x04, 0x56, 0x45, 0x52, 0x42, 0x10, 0x0b,
	0x12, 0x05, 0x0a, 0x01, 0x58, 0x10, 0x0c, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x46, 0x46, 0x49, 0x58,
	0x10, 0x0d, 0x22, 0x4f, 0x0a, 0x06, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x0e,
	0x41, 0x53, 0x50, 0x45, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00,
	0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x45, 0x52, 0x46, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01,
	0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4d, 0x50, 0x45, 0x52, 0x46, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x49, 0x56,
	0x45, 0x10, 0x03, 0x22, 0xf8, 0x01, 0x0a, 0x04, 0x43, 0x61, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x0c,
	0x43, 0x41, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x41, 0x43, 0x43, 0x55, 0x53, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x41, 0x44, 0x56, 0x45, 0x52, 0x42, 0x49, 0x41, 0x4c, 0x10, 0x02, 0x12, 0x11, 0x0a,
	0x0d, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x44, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08,
	0x47, 0x45, 0x4e, 0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e,
	0x53, 0x54, 0x52, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x4c, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08,
	0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x07, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f,
	0x4d, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x42,
	0x4c, 0x49, 0x51, 0x55, 0x45, 0x10, 0x09, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x41, 0x52, 0x54, 0x49,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x0a, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x52, 0x45, 0x50, 0x4f, 0x53,
	0x49, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x0b, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x46,
	0x4c, 0x45, 0x58, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x10, 0x0c, 0x12, 0x11, 0x0a,
	0x0d, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x10, 0x0d,
	0x12, 0x0c, 0x0a, 0x08, 0x56, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x0e, 0x22, 0xaf,
	0x01, 0x0a, 0x04, 0x46, 0x6f, 0x72, 0x6d, 0x12, 0x10, 0x0a, 0x0c, 0x46, 0x4f, 0x52, 0x4d, 0x5f,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x44, 0x4e,
	0x4f, 0x4d, 0x49, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x55, 0x58, 0x49, 0x4c,
	0x49, 0x41, 0x52, 0x59, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45,
	0x4d, 0x45, 0x4e, 0x54, 0x49, 0x5a, 0x45, 0x52, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x46, 0x49,
	0x4e, 0x41, 0x4c, 0x5f, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06,
	0x47, 0x45, 0x52, 0x55, 0x4e, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x41, 0x4c,
	0x49, 0x53, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x52, 0x52, 0x45, 0x41, 0x4c, 0x49, 0x53,
	0x10, 0x07, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x48, 0x4f, 0x52, 0x54, 0x10, 0x08, 0x12, 0x08, 0x0a,
	0x04, 0x4c, 0x4f, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x52, 0x44, 0x45, 0x52,
	0x10, 0x0a, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x43, 0x10, 0x0b,
	0x22, 0x45, 0x0a, 0x06, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x45,
	0x4e, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x46, 0x45, 0x4d, 0x49, 0x4e, 0x49, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x4d, 0x41, 0x53, 0x43, 0x55, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4e,
	0x45, 0x55, 0x54, 0x45, 0x52, 0x10, 0x03, 0x22, 0x7f, 0x0a, 0x04, 0x4d, 0x6f, 0x6f, 0x64, 0x12,
	0x10, 0x0a, 0x0c, 0x4d, 0x4f, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x00, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c,
	0x5f, 0x4d, 0x4f, 0x4f, 0x44, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4d, 0x50, 0x45, 0x52,
	0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4e, 0x44, 0x49, 0x43,
	0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x49, 0x4e, 0x54, 0x45, 0x52,
	0x52, 0x4f, 0x47, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x4a, 0x55,
	0x53, 0x53, 0x49, 0x56, 0x45, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x55, 0x42, 0x4a, 0x55,
	0x4e, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x06, 0x22, 0x40, 0x0a, 0x06, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x49, 0x4e, 0x47, 0x55, 0x4c,
	0x41, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x4c, 0x55, 0x52, 0x41, 0x4c, 0x10, 0x02,
	0x12, 0x08, 0x0a, 0x04, 0x44, 0x55, 0x41, 0x4c, 0x10, 0x03, 0x22, 0x54, 0x0a, 0x06, 0x50, 0x65,
	0x72, 0x73, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x49, 0x52, 0x53,
	0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x10, 0x02, 0x12,
	0x09, 0x0a, 0x05, 0x54, 0x48, 0x49, 0x52, 0x44, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45,
	0x46, 0x4c, 0x45, 0x58, 0x49, 0x56, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x10, 0x04,
	0x22, 0x38, 0x0a, 0x06, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x52,
	0x4f, 0x50, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f,
	0x54, 0x5f, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x10, 0x02, 0x22, 0x4a, 0x0a, 0x0b, 0x52, 0x65,
	0x63, 0x69, 0x70, 0x72, 0x6f, 0x63, 0x69, 0x74, 0x79, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x43,
	0x49, 0x50, 0x52, 0x4f, 0x43, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x43, 0x49, 0x50, 0x52, 0x4f, 0x43, 0x41, 0x4c,
	0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x43, 0x49, 0x50, 0x52,
	0x4f, 0x43, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x73, 0x0a, 0x05, 0x54, 0x65, 0x6e, 0x73, 0x65, 0x12,
	0x11, 0x0a, 0x0d, 0x54, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x41,
	0x4c, 0x5f, 0x54, 0x45, 0x4e, 0x53, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x55, 0x54,
	0x55, 0x52, 0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x41, 0x53, 0x54, 0x10, 0x03, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09,
	0x49, 0x4d, 0x50, 0x45, 0x52, 0x46, 0x45, 0x43, 0x54, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x50,
	0x4c, 0x55, 0x50, 0x45, 0x52, 0x46, 0x45, 0x43, 0x54, 0x10, 0x06, 0x22, 0x42, 0x0a, 0x05, 0x56,
	0x6f, 0x69, 0x63, 0x65, 0x12, 0x11, 0x0a, 0x0d, 0x56, 0x4f, 0x49, 0x43, 0x45, 0x5f, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x55, 0x53, 0x41, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x41, 0x53, 0x53, 0x49, 0x56, 0x45, 0x10, 0x03, 0x22,
	0xb1, 0x08, 0x0a, 0x0e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x64,
	0x67, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x68, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x68, 0x65,
	0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x49, 0x0a, 0x05,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x64, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0xa9, 0x07, 0x0a, 0x05, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x41, 0x42, 0x42, 0x52, 0x45, 0x56, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x43,
	0x4f, 0x4d, 0x50, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x44, 0x56, 0x43, 0x4c, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x44, 0x56, 0x4d, 0x4f, 0x44, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04,
	0x41, 0x4d, 0x4f, 0x44, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x50, 0x50, 0x4f, 0x53, 0x10,
	0x06, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x54, 0x54, 0x52, 0x10, 0x07, 0x12, 0x07, 0x0a, 0x03, 0x41,
	0x55, 0x58, 0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x55, 0x58, 0x50, 0x41, 0x53, 0x53, 0x10,
	0x09, 0x12, 0x06, 0x0a, 0x02, 0x43, 0x43, 0x10, 0x0a, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x43, 0x4f,
	0x4d, 0x50, 0x10, 0x0b, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4f, 0x4e, 0x4a, 0x10, 0x0c, 0x12, 0x09,
	0x0a, 0x05, 0x43, 0x53, 0x55, 0x42, 0x4a, 0x10, 0x0d, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x53, 0x55,
	0x42, 0x4a, 0x50, 0x41, 0x53, 0x53, 0x10, 0x0e, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x45, 0x50, 0x10,
	0x0f, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x45, 0x54, 0x10, 0x10, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49,
	0x53, 0x43, 0x4f, 0x55, 0x52, 0x53, 0x45, 0x10, 0x11, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f, 0x42,
	0x4a, 0x10, 0x12, 0x12, 0x08, 0x0a, 0x04, 0x45, 0x58, 0x50, 0x4c, 0x10, 0x13, 0x12, 0x0c, 0x0a,
	0x08, 0x47, 0x4f, 0x45, 0x53, 0x57, 0x49, 0x54, 0x48, 0x10, 0x14, 0x12, 0x08, 0x0a, 0x04, 0x49,
	0x4f, 0x42, 0x4a, 0x10, 0x15, 0x12, 0x08, 0x0a, 0x04, 0x4d, 0x41, 0x52, 0x4b, 0x10, 0x16, 0x12,
	0x07, 0x0a, 0x03, 0x4d, 0x57, 0x45, 0x10, 0x17, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x57, 0x56, 0x10,
	0x18, 0x12, 0x07, 0x0a, 0x03, 0x4e, 0x45, 0x47, 0x10, 0x19, 0x12, 0x06, 0x0a, 0x02, 0x4e, 0x4e,
	0x10, 0x1a, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x50, 0x41, 0x44, 0x56, 0x4d, 0x4f, 0x44, 0x10, 0x1b,
	0x12, 0x09, 0x0a, 0x05, 0x4e, 0x53, 0x55, 0x42, 0x4a, 0x10, 0x1c, 0x12, 0x0d, 0x0a, 0x09, 0x4e,
	0x53, 0x55, 0x42, 0x4a, 0x50, 0x41, 0x53, 0x53, 0x10, 0x1d, 0x12, 0x07, 0x0a, 0x03, 0x4e, 0x55,
	0x4d, 0x10, 0x1e, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x1f, 0x12,
	0x05, 0x0a, 0x01, 0x50, 0x10, 0x20, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x41, 0x52, 0x41, 0x54, 0x41,
	0x58, 0x49, 0x53, 0x10, 0x21, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x41, 0x52, 0x54, 0x4d, 0x4f, 0x44,
	0x10, 0x22, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x43, 0x4f, 0x4d, 0x50, 0x10, 0x23, 0x12, 0x08, 0x0a,
	0x04, 0x50, 0x4f, 0x42, 0x4a, 0x10, 0x24, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x4f, 0x53, 0x53, 0x10,
	0x25, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x4f, 0x53, 0x54, 0x4e, 0x45, 0x47, 0x10, 0x26, 0x12, 0x0b,
	0x0a, 0x07, 0x50, 0x52, 0x45, 0x43, 0x4f, 0x4d, 0x50, 0x10, 0x27, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x52, 0x45, 0x43, 0x4f, 0x4e, 0x4a, 0x10, 0x28, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x52, 0x45, 0x44,
	0x45, 0x54, 0x10, 0x29, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x52, 0x45, 0x46, 0x10, 0x2a, 0x12, 0x08,
	0x0a, 0x04, 0x50, 0x52, 0x45, 0x50, 0x10, 0x2b, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x52, 0x4f, 0x4e,
	0x4c, 0x10, 0x2c, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x52, 0x54, 0x10, 0x2d, 0x12, 0x06, 0x0a, 0x02,
	0x50, 0x53, 0x10, 0x2e, 0x12, 0x0c, 0x0a, 0x08, 0x51, 0x55, 0x41, 0x4e, 0x54, 0x4d, 0x4f, 0x44,
	0x10, 0x2f, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x43, 0x4d, 0x4f, 0x44, 0x10, 0x30, 0x12, 0x0c, 0x0a,
	0x08, 0x52, 0x43, 0x4d, 0x4f, 0x44, 0x52, 0x45, 0x4c, 0x10, 0x31, 0x12, 0x09, 0x0a, 0x05, 0x52,
	0x44, 0x52, 0x4f, 0x50, 0x10, 0x32, 0x12, 0x07, 0x0a, 0x03, 0x52, 0x45, 0x46, 0x10, 0x33, 0x12,
	0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4d, 0x4e, 0x41, 0x4e, 0x54, 0x10, 0x34, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x45, 0x50, 0x41, 0x52, 0x41, 0x4e, 0x44, 0x55, 0x4d, 0x10, 0x35, 0x12, 0x08, 0x0a, 0x04,
	0x52, 0x4f, 0x4f, 0x54, 0x10, 0x36, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x4e, 0x55, 0x4d, 0x10, 0x37,
	0x12, 0x08, 0x0a, 0x04, 0x53, 0x55, 0x46, 0x46, 0x10, 0x38, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x4d,
	0x4f, 0x44, 0x10, 0x39, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x10, 0x3a, 0x12,
	0x08, 0x0a, 0x04, 0x56, 0x4d, 0x4f, 0x44, 0x10, 0x3b, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x4f, 0x43,
	0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x3c, 0x12, 0x09, 0x0a, 0x05, 0x58, 0x43, 0x4f, 0x4d, 0x50,
	0x10, 0x3d, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x55, 0x46, 0x46, 0x49, 0x58, 0x10, 0x3e, 0x12, 0x09,
	0x0a, 0x05, 0x54, 0x49, 0x54, 0x4c, 0x45, 0x10, 0x3f, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x44, 0x56,
	0x50, 0x48, 0x4d, 0x4f, 0x44, 0x10, 0x40, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x55, 0x58, 0x43, 0x41,
	0x55, 0x53, 0x10, 0x41, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x55, 0x58, 0x56, 0x56, 0x10, 0x42, 0x12,
	0x09, 0x0a, 0x05, 0x44, 0x54, 0x4d, 0x4f, 0x44, 0x10, 0x43, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4f,
	0x52, 0x45, 0x49, 0x47, 0x4e, 0x10, 0x44, 0x12, 0x06, 0x0a, 0x02, 0x4b, 0x57, 0x10, 0x45, 0x12,
	0x08, 0x0a, 0x04, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x46, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4d,
	0x43, 0x10, 0x47, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x4d, 0x43, 0x53, 0x55, 0x42, 0x4a, 0x10,
	0x48, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x4d, 0x43, 0x53, 0x55, 0x42, 0x4a, 0x50, 0x41, 0x53,
	0x53, 0x10, 0x49, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x55, 0x4d, 0x43, 0x10, 0x4a, 0x12, 0x07, 0x0a,
	0x03, 0x43, 0x4f, 0x50, 0x10, 0x4b, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x49, 0x53, 0x4c, 0x4f, 0x43,
	0x41, 0x54, 0x45, 0x44, 0x10, 0x4c, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x53, 0x50, 0x10, 0x4d, 0x12,
	0x08, 0x0a, 0x04, 0x47, 0x4d, 0x4f, 0x44, 0x10, 0x4e, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x4f, 0x42,
	0x4a, 0x10, 0x4f, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x46, 0x4d, 0x4f, 0x44, 0x10, 0x50, 0x12,
	0x07, 0x0a, 0x03, 0x4d, 0x45, 0x53, 0x10, 0x51, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x43, 0x4f, 0x4d,
	0x50, 0x10, 0x52, 0x22, 0x8d, 0x02, 0x0a, 0x0d, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x52, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x09, 0x73, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x30, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50,
	0x52, 0x4f, 0x50, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x4d, 0x4d, 0x4f,
	0x4e, 0x10, 0x02, 0x22, 0x47, 0x0a, 0x08, 0x54, 0x65, 0x78, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x12,
	0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x62, 0x65, 0x67,
	0x69, 0x6e, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0b, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x4c, 0x0a, 0x16,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xb5, 0x01, 0x0a, 0x17, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x50, 0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79,
	0x70, 0x65, 0x22, 0xd6, 0x01, 0x0a, 0x18, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x65,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x57, 0x0a, 0x12, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0xbb, 0x01, 0x0a, 0x1d,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x6f, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x45,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x22, 0x7f, 0x0a, 0x1e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x08, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1a,
	0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x16, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x50, 0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x78, 0x0a, 0x17, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x08,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12,
	0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x22, 0xb2, 0x01, 0x0a, 0x14,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x50,
	0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65,
	0x22, 0xb8, 0x01, 0x0a, 0x15, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x79, 0x6e, 0x74,
	0x61, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x73, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x3c, 0x0a, 0x06, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x06, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12,
	0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x22, 0x5f, 0x0a, 0x13, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x6d, 0x0a, 0x14,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52,
	0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x22, 0x8b, 0x04, 0x0a, 0x13,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5c, 0x0a,
	0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x50, 0x0a, 0x0d, 0x65,
	0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0c, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xf9, 0x01,
	0x0a, 0x08, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x53, 0x79, 0x6e, 0x74, 0x61,
	0x78, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x5f, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x65, 0x78, 0x74,
	0x72, 0x61, 0x63, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x1a,
	0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x18, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x18, 0x65, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x65, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x79,
	0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x63, 0x6c, 0x61,
	0x73, 0x73, 0x69, 0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x22, 0xaa, 0x03, 0x0a, 0x14, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x09,
	0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x06, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52,
	0x06, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x12, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12,
	0x55, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2a, 0x38, 0x0a, 0x0c, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00,
	0x12, 0x08, 0x0a, 0x04, 0x55, 0x54, 0x46, 0x38, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x55, 0x54,
	0x46, 0x31, 0x36, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x55, 0x54, 0x46, 0x33, 0x32, 0x10, 0x03,
	0x32, 0x8a, 0x0b, 0x0a, 0x0f, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xd7, 0x01, 0x0a, 0x10, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x28, 0x22, 0x23, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x65,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x16, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0xda, 0x41, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xd3,
	0x01, 0x0a, 0x0f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x22, 0x22, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x16, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0xda, 0x41, 0x08, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0xef, 0x01, 0x0a, 0x16, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2e, 0x22, 0x29, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x16, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0xda, 0x41, 0x08, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xcb, 0x01, 0x0a, 0x0d, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x22, 0x20, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x16, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0xda, 0x41, 0x08, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0xae, 0x01, 0x0a, 0x0c, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x79, 0x54, 0x65, 0x78, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x79, 0x54, 0x65,
	0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69,
	0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x22, 0x1f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x79, 0x54, 0x65, 0x78, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x08, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xd9, 0x01, 0x0a, 0x0c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x54,
	0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x22, 0x1f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x65, 0x54, 0x65, 0x78, 0x74, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2c,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0xda, 0x41, 0x11,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x1a, 0x7a, 0xca, 0x41, 0x17, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5d,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2c, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x82, 0x01,
	0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x42, 0x14, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x45, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x3b, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_language_v1beta2_language_service_proto_rawDescOnce sync.Once
	file_google_cloud_language_v1beta2_language_service_proto_rawDescData = file_google_cloud_language_v1beta2_language_service_proto_rawDesc
)

func file_google_cloud_language_v1beta2_language_service_proto_rawDescGZIP() []byte {
	file_google_cloud_language_v1beta2_language_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_language_v1beta2_language_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_language_v1beta2_language_service_proto_rawDescData)
	})
	return file_google_cloud_language_v1beta2_language_service_proto_rawDescData
}

var file_google_cloud_language_v1beta2_language_service_proto_enumTypes = make([]protoimpl.EnumInfo, 17)
var file_google_cloud_language_v1beta2_language_service_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_google_cloud_language_v1beta2_language_service_proto_goTypes = []interface{}{
	(EncodingType)(0),                      // 0: google.cloud.language.v1beta2.EncodingType
	(Document_Type)(0),                     // 1: google.cloud.language.v1beta2.Document.Type
	(Entity_Type)(0),                       // 2: google.cloud.language.v1beta2.Entity.Type
	(PartOfSpeech_Tag)(0),                  // 3: google.cloud.language.v1beta2.PartOfSpeech.Tag
	(PartOfSpeech_Aspect)(0),               // 4: google.cloud.language.v1beta2.PartOfSpeech.Aspect
	(PartOfSpeech_Case)(0),                 // 5: google.cloud.language.v1beta2.PartOfSpeech.Case
	(PartOfSpeech_Form)(0),                 // 6: google.cloud.language.v1beta2.PartOfSpeech.Form
	(PartOfSpeech_Gender)(0),               // 7: google.cloud.language.v1beta2.PartOfSpeech.Gender
	(PartOfSpeech_Mood)(0),                 // 8: google.cloud.language.v1beta2.PartOfSpeech.Mood
	(PartOfSpeech_Number)(0),               // 9: google.cloud.language.v1beta2.PartOfSpeech.Number
	(PartOfSpeech_Person)(0),               // 10: google.cloud.language.v1beta2.PartOfSpeech.Person
	(PartOfSpeech_Proper)(0),               // 11: google.cloud.language.v1beta2.PartOfSpeech.Proper
	(PartOfSpeech_Reciprocity)(0),          // 12: google.cloud.language.v1beta2.PartOfSpeech.Reciprocity
	(PartOfSpeech_Tense)(0),                // 13: google.cloud.language.v1beta2.PartOfSpeech.Tense
	(PartOfSpeech_Voice)(0),                // 14: google.cloud.language.v1beta2.PartOfSpeech.Voice
	(DependencyEdge_Label)(0),              // 15: google.cloud.language.v1beta2.DependencyEdge.Label
	(EntityMention_Type)(0),                // 16: google.cloud.language.v1beta2.EntityMention.Type
	(*Document)(nil),                       // 17: google.cloud.language.v1beta2.Document
	(*Sentence)(nil),                       // 18: google.cloud.language.v1beta2.Sentence
	(*Entity)(nil),                         // 19: google.cloud.language.v1beta2.Entity
	(*Token)(nil),                          // 20: google.cloud.language.v1beta2.Token
	(*Sentiment)(nil),                      // 21: google.cloud.language.v1beta2.Sentiment
	(*PartOfSpeech)(nil),                   // 22: google.cloud.language.v1beta2.PartOfSpeech
	(*DependencyEdge)(nil),                 // 23: google.cloud.language.v1beta2.DependencyEdge
	(*EntityMention)(nil),                  // 24: google.cloud.language.v1beta2.EntityMention
	(*TextSpan)(nil),                       // 25: google.cloud.language.v1beta2.TextSpan
	(*ClassificationCategory)(nil),         // 26: google.cloud.language.v1beta2.ClassificationCategory
	(*AnalyzeSentimentRequest)(nil),        // 27: google.cloud.language.v1beta2.AnalyzeSentimentRequest
	(*AnalyzeSentimentResponse)(nil),       // 28: google.cloud.language.v1beta2.AnalyzeSentimentResponse
	(*AnalyzeEntitySentimentRequest)(nil),  // 29: google.cloud.language.v1beta2.AnalyzeEntitySentimentRequest
	(*AnalyzeEntitySentimentResponse)(nil), // 30: google.cloud.language.v1beta2.AnalyzeEntitySentimentResponse
	(*AnalyzeEntitiesRequest)(nil),         // 31: google.cloud.language.v1beta2.AnalyzeEntitiesRequest
	(*AnalyzeEntitiesResponse)(nil),        // 32: google.cloud.language.v1beta2.AnalyzeEntitiesResponse
	(*AnalyzeSyntaxRequest)(nil),           // 33: google.cloud.language.v1beta2.AnalyzeSyntaxRequest
	(*AnalyzeSyntaxResponse)(nil),          // 34: google.cloud.language.v1beta2.AnalyzeSyntaxResponse
	(*ClassifyTextRequest)(nil),            // 35: google.cloud.language.v1beta2.ClassifyTextRequest
	(*ClassifyTextResponse)(nil),           // 36: google.cloud.language.v1beta2.ClassifyTextResponse
	(*AnnotateTextRequest)(nil),            // 37: google.cloud.language.v1beta2.AnnotateTextRequest
	(*AnnotateTextResponse)(nil),           // 38: google.cloud.language.v1beta2.AnnotateTextResponse
	nil,                                    // 39: google.cloud.language.v1beta2.Entity.MetadataEntry
	(*AnnotateTextRequest_Features)(nil),   // 40: google.cloud.language.v1beta2.AnnotateTextRequest.Features
}
var file_google_cloud_language_v1beta2_language_service_proto_depIdxs = []int32{
	1,  // 0: google.cloud.language.v1beta2.Document.type:type_name -> google.cloud.language.v1beta2.Document.Type
	25, // 1: google.cloud.language.v1beta2.Sentence.text:type_name -> google.cloud.language.v1beta2.TextSpan
	21, // 2: google.cloud.language.v1beta2.Sentence.sentiment:type_name -> google.cloud.language.v1beta2.Sentiment
	2,  // 3: google.cloud.language.v1beta2.Entity.type:type_name -> google.cloud.language.v1beta2.Entity.Type
	39, // 4: google.cloud.language.v1beta2.Entity.metadata:type_name -> google.cloud.language.v1beta2.Entity.MetadataEntry
	24, // 5: google.cloud.language.v1beta2.Entity.mentions:type_name -> google.cloud.language.v1beta2.EntityMention
	21, // 6: google.cloud.language.v1beta2.Entity.sentiment:type_name -> google.cloud.language.v1beta2.Sentiment
	25, // 7: google.cloud.language.v1beta2.Token.text:type_name -> google.cloud.language.v1beta2.TextSpan
	22, // 8: google.cloud.language.v1beta2.Token.part_of_speech:type_name -> google.cloud.language.v1beta2.PartOfSpeech
	23, // 9: google.cloud.language.v1beta2.Token.dependency_edge:type_name -> google.cloud.language.v1beta2.DependencyEdge
	3,  // 10: google.cloud.language.v1beta2.PartOfSpeech.tag:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Tag
	4,  // 11: google.cloud.language.v1beta2.PartOfSpeech.aspect:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Aspect
	5,  // 12: google.cloud.language.v1beta2.PartOfSpeech.case:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Case
	6,  // 13: google.cloud.language.v1beta2.PartOfSpeech.form:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Form
	7,  // 14: google.cloud.language.v1beta2.PartOfSpeech.gender:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Gender
	8,  // 15: google.cloud.language.v1beta2.PartOfSpeech.mood:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Mood
	9,  // 16: google.cloud.language.v1beta2.PartOfSpeech.number:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Number
	10, // 17: google.cloud.language.v1beta2.PartOfSpeech.person:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Person
	11, // 18: google.cloud.language.v1beta2.PartOfSpeech.proper:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Proper
	12, // 19: google.cloud.language.v1beta2.PartOfSpeech.reciprocity:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Reciprocity
	13, // 20: google.cloud.language.v1beta2.PartOfSpeech.tense:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Tense
	14, // 21: google.cloud.language.v1beta2.PartOfSpeech.voice:type_name -> google.cloud.language.v1beta2.PartOfSpeech.Voice
	15, // 22: google.cloud.language.v1beta2.DependencyEdge.label:type_name -> google.cloud.language.v1beta2.DependencyEdge.Label
	25, // 23: google.cloud.language.v1beta2.EntityMention.text:type_name -> google.cloud.language.v1beta2.TextSpan
	16, // 24: google.cloud.language.v1beta2.EntityMention.type:type_name -> google.cloud.language.v1beta2.EntityMention.Type
	21, // 25: google.cloud.language.v1beta2.EntityMention.sentiment:type_name -> google.cloud.language.v1beta2.Sentiment
	17, // 26: google.cloud.language.v1beta2.AnalyzeSentimentRequest.document:type_name -> google.cloud.language.v1beta2.Document
	0,  // 27: google.cloud.language.v1beta2.AnalyzeSentimentRequest.encoding_type:type_name -> google.cloud.language.v1beta2.EncodingType
	21, // 28: google.cloud.language.v1beta2.AnalyzeSentimentResponse.document_sentiment:type_name -> google.cloud.language.v1beta2.Sentiment
	18, // 29: google.cloud.language.v1beta2.AnalyzeSentimentResponse.sentences:type_name -> google.cloud.language.v1beta2.Sentence
	17, // 30: google.cloud.language.v1beta2.AnalyzeEntitySentimentRequest.document:type_name -> google.cloud.language.v1beta2.Document
	0,  // 31: google.cloud.language.v1beta2.AnalyzeEntitySentimentRequest.encoding_type:type_name -> google.cloud.language.v1beta2.EncodingType
	19, // 32: google.cloud.language.v1beta2.AnalyzeEntitySentimentResponse.entities:type_name -> google.cloud.language.v1beta2.Entity
	17, // 33: google.cloud.language.v1beta2.AnalyzeEntitiesRequest.document:type_name -> google.cloud.language.v1beta2.Document
	0,  // 34: google.cloud.language.v1beta2.AnalyzeEntitiesRequest.encoding_type:type_name -> google.cloud.language.v1beta2.EncodingType
	19, // 35: google.cloud.language.v1beta2.AnalyzeEntitiesResponse.entities:type_name -> google.cloud.language.v1beta2.Entity
	17, // 36: google.cloud.language.v1beta2.AnalyzeSyntaxRequest.document:type_name -> google.cloud.language.v1beta2.Document
	0,  // 37: google.cloud.language.v1beta2.AnalyzeSyntaxRequest.encoding_type:type_name -> google.cloud.language.v1beta2.EncodingType
	18, // 38: google.cloud.language.v1beta2.AnalyzeSyntaxResponse.sentences:type_name -> google.cloud.language.v1beta2.Sentence
	20, // 39: google.cloud.language.v1beta2.AnalyzeSyntaxResponse.tokens:type_name -> google.cloud.language.v1beta2.Token
	17, // 40: google.cloud.language.v1beta2.ClassifyTextRequest.document:type_name -> google.cloud.language.v1beta2.Document
	26, // 41: google.cloud.language.v1beta2.ClassifyTextResponse.categories:type_name -> google.cloud.language.v1beta2.ClassificationCategory
	17, // 42: google.cloud.language.v1beta2.AnnotateTextRequest.document:type_name -> google.cloud.language.v1beta2.Document
	40, // 43: google.cloud.language.v1beta2.AnnotateTextRequest.features:type_name -> google.cloud.language.v1beta2.AnnotateTextRequest.Features
	0,  // 44: google.cloud.language.v1beta2.AnnotateTextRequest.encoding_type:type_name -> google.cloud.language.v1beta2.EncodingType
	18, // 45: google.cloud.language.v1beta2.AnnotateTextResponse.sentences:type_name -> google.cloud.language.v1beta2.Sentence
	20, // 46: google.cloud.language.v1beta2.AnnotateTextResponse.tokens:type_name -> google.cloud.language.v1beta2.Token
	19, // 47: google.cloud.language.v1beta2.AnnotateTextResponse.entities:type_name -> google.cloud.language.v1beta2.Entity
	21, // 48: google.cloud.language.v1beta2.AnnotateTextResponse.document_sentiment:type_name -> google.cloud.language.v1beta2.Sentiment
	26, // 49: google.cloud.language.v1beta2.AnnotateTextResponse.categories:type_name -> google.cloud.language.v1beta2.ClassificationCategory
	27, // 50: google.cloud.language.v1beta2.LanguageService.AnalyzeSentiment:input_type -> google.cloud.language.v1beta2.AnalyzeSentimentRequest
	31, // 51: google.cloud.language.v1beta2.LanguageService.AnalyzeEntities:input_type -> google.cloud.language.v1beta2.AnalyzeEntitiesRequest
	29, // 52: google.cloud.language.v1beta2.LanguageService.AnalyzeEntitySentiment:input_type -> google.cloud.language.v1beta2.AnalyzeEntitySentimentRequest
	33, // 53: google.cloud.language.v1beta2.LanguageService.AnalyzeSyntax:input_type -> google.cloud.language.v1beta2.AnalyzeSyntaxRequest
	35, // 54: google.cloud.language.v1beta2.LanguageService.ClassifyText:input_type -> google.cloud.language.v1beta2.ClassifyTextRequest
	37, // 55: google.cloud.language.v1beta2.LanguageService.AnnotateText:input_type -> google.cloud.language.v1beta2.AnnotateTextRequest
	28, // 56: google.cloud.language.v1beta2.LanguageService.AnalyzeSentiment:output_type -> google.cloud.language.v1beta2.AnalyzeSentimentResponse
	32, // 57: google.cloud.language.v1beta2.LanguageService.AnalyzeEntities:output_type -> google.cloud.language.v1beta2.AnalyzeEntitiesResponse
	30, // 58: google.cloud.language.v1beta2.LanguageService.AnalyzeEntitySentiment:output_type -> google.cloud.language.v1beta2.AnalyzeEntitySentimentResponse
	34, // 59: google.cloud.language.v1beta2.LanguageService.AnalyzeSyntax:output_type -> google.cloud.language.v1beta2.AnalyzeSyntaxResponse
	36, // 60: google.cloud.language.v1beta2.LanguageService.ClassifyText:output_type -> google.cloud.language.v1beta2.ClassifyTextResponse
	38, // 61: google.cloud.language.v1beta2.LanguageService.AnnotateText:output_type -> google.cloud.language.v1beta2.AnnotateTextResponse
	56, // [56:62] is the sub-list for method output_type
	50, // [50:56] is the sub-list for method input_type
	50, // [50:50] is the sub-list for extension type_name
	50, // [50:50] is the sub-list for extension extendee
	0,  // [0:50] is the sub-list for field type_name
}

func init() { file_google_cloud_language_v1beta2_language_service_proto_init() }
func file_google_cloud_language_v1beta2_language_service_proto_init() {
	if File_google_cloud_language_v1beta2_language_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Sentence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Token); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Sentiment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartOfSpeech); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DependencyEdge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityMention); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextSpan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClassificationCategory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeSentimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeSentimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeEntitySentimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeEntitySentimentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeEntitiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeEntitiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeSyntaxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeSyntaxResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClassifyTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClassifyTextResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateTextRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateTextResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_language_v1beta2_language_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateTextRequest_Features); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_language_v1beta2_language_service_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Document_Content)(nil),
		(*Document_GcsContentUri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_language_v1beta2_language_service_proto_rawDesc,
			NumEnums:      17,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_language_v1beta2_language_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_language_v1beta2_language_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_language_v1beta2_language_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_language_v1beta2_language_service_proto_msgTypes,
	}.Build()
	File_google_cloud_language_v1beta2_language_service_proto = out.File
	file_google_cloud_language_v1beta2_language_service_proto_rawDesc = nil
	file_google_cloud_language_v1beta2_language_service_proto_goTypes = nil
	file_google_cloud_language_v1beta2_language_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LanguageServiceClient is the client API for LanguageService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LanguageServiceClient interface {
	// Analyzes the sentiment of the provided text.
	AnalyzeSentiment(ctx context.Context, in *AnalyzeSentimentRequest, opts ...grpc.CallOption) (*AnalyzeSentimentResponse, error)
	// Finds named entities (currently proper names and common nouns) in the text
	// along with entity types, salience, mentions for each entity, and
	// other properties.
	AnalyzeEntities(ctx context.Context, in *AnalyzeEntitiesRequest, opts ...grpc.CallOption) (*AnalyzeEntitiesResponse, error)
	// Finds entities, similar to [AnalyzeEntities][google.cloud.language.v1beta2.LanguageService.AnalyzeEntities] in the text and analyzes
	// sentiment associated with each entity and its mentions.
	AnalyzeEntitySentiment(ctx context.Context, in *AnalyzeEntitySentimentRequest, opts ...grpc.CallOption) (*AnalyzeEntitySentimentResponse, error)
	// Analyzes the syntax of the text and provides sentence boundaries and
	// tokenization along with part-of-speech tags, dependency trees, and other
	// properties.
	AnalyzeSyntax(ctx context.Context, in *AnalyzeSyntaxRequest, opts ...grpc.CallOption) (*AnalyzeSyntaxResponse, error)
	// Classifies a document into categories.
	ClassifyText(ctx context.Context, in *ClassifyTextRequest, opts ...grpc.CallOption) (*ClassifyTextResponse, error)
	// A convenience method that provides all syntax, sentiment, entity, and
	// classification features in one call.
	AnnotateText(ctx context.Context, in *AnnotateTextRequest, opts ...grpc.CallOption) (*AnnotateTextResponse, error)
}

type languageServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLanguageServiceClient(cc grpc.ClientConnInterface) LanguageServiceClient {
	return &languageServiceClient{cc}
}

func (c *languageServiceClient) AnalyzeSentiment(ctx context.Context, in *AnalyzeSentimentRequest, opts ...grpc.CallOption) (*AnalyzeSentimentResponse, error) {
	out := new(AnalyzeSentimentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v1beta2.LanguageService/AnalyzeSentiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) AnalyzeEntities(ctx context.Context, in *AnalyzeEntitiesRequest, opts ...grpc.CallOption) (*AnalyzeEntitiesResponse, error) {
	out := new(AnalyzeEntitiesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v1beta2.LanguageService/AnalyzeEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) AnalyzeEntitySentiment(ctx context.Context, in *AnalyzeEntitySentimentRequest, opts ...grpc.CallOption) (*AnalyzeEntitySentimentResponse, error) {
	out := new(AnalyzeEntitySentimentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v1beta2.LanguageService/AnalyzeEntitySentiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) AnalyzeSyntax(ctx context.Context, in *AnalyzeSyntaxRequest, opts ...grpc.CallOption) (*AnalyzeSyntaxResponse, error) {
	out := new(AnalyzeSyntaxResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v1beta2.LanguageService/AnalyzeSyntax", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) ClassifyText(ctx context.Context, in *ClassifyTextRequest, opts ...grpc.CallOption) (*ClassifyTextResponse, error) {
	out := new(ClassifyTextResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v1beta2.LanguageService/ClassifyText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageServiceClient) AnnotateText(ctx context.Context, in *AnnotateTextRequest, opts ...grpc.CallOption) (*AnnotateTextResponse, error) {
	out := new(AnnotateTextResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.language.v1beta2.LanguageService/AnnotateText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LanguageServiceServer is the server API for LanguageService service.
type LanguageServiceServer interface {
	// Analyzes the sentiment of the provided text.
	AnalyzeSentiment(context.Context, *AnalyzeSentimentRequest) (*AnalyzeSentimentResponse, error)
	// Finds named entities (currently proper names and common nouns) in the text
	// along with entity types, salience, mentions for each entity, and
	// other properties.
	AnalyzeEntities(context.Context, *AnalyzeEntitiesRequest) (*AnalyzeEntitiesResponse, error)
	// Finds entities, similar to [AnalyzeEntities][google.cloud.language.v1beta2.LanguageService.AnalyzeEntities] in the text and analyzes
	// sentiment associated with each entity and its mentions.
	AnalyzeEntitySentiment(context.Context, *AnalyzeEntitySentimentRequest) (*AnalyzeEntitySentimentResponse, error)
	// Analyzes the syntax of the text and provides sentence boundaries and
	// tokenization along with part-of-speech tags, dependency trees, and other
	// properties.
	AnalyzeSyntax(context.Context, *AnalyzeSyntaxRequest) (*AnalyzeSyntaxResponse, error)
	// Classifies a document into categories.
	ClassifyText(context.Context, *ClassifyTextRequest) (*ClassifyTextResponse, error)
	// A convenience method that provides all syntax, sentiment, entity, and
	// classification features in one call.
	AnnotateText(context.Context, *AnnotateTextRequest) (*AnnotateTextResponse, error)
}

// UnimplementedLanguageServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLanguageServiceServer struct {
}

func (*UnimplementedLanguageServiceServer) AnalyzeSentiment(context.Context, *AnalyzeSentimentRequest) (*AnalyzeSentimentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeSentiment not implemented")
}
func (*UnimplementedLanguageServiceServer) AnalyzeEntities(context.Context, *AnalyzeEntitiesRequest) (*AnalyzeEntitiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeEntities not implemented")
}
func (*UnimplementedLanguageServiceServer) AnalyzeEntitySentiment(context.Context, *AnalyzeEntitySentimentRequest) (*AnalyzeEntitySentimentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeEntitySentiment not implemented")
}
func (*UnimplementedLanguageServiceServer) AnalyzeSyntax(context.Context, *AnalyzeSyntaxRequest) (*AnalyzeSyntaxResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeSyntax not implemented")
}
func (*UnimplementedLanguageServiceServer) ClassifyText(context.Context, *ClassifyTextRequest) (*ClassifyTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClassifyText not implemented")
}
func (*UnimplementedLanguageServiceServer) AnnotateText(context.Context, *AnnotateTextRequest) (*AnnotateTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnnotateText not implemented")
}

func RegisterLanguageServiceServer(s *grpc.Server, srv LanguageServiceServer) {
	s.RegisterService(&_LanguageService_serviceDesc, srv)
}

func _LanguageService_AnalyzeSentiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeSentimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnalyzeSentiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v1beta2.LanguageService/AnalyzeSentiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnalyzeSentiment(ctx, req.(*AnalyzeSentimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_AnalyzeEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnalyzeEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v1beta2.LanguageService/AnalyzeEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnalyzeEntities(ctx, req.(*AnalyzeEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_AnalyzeEntitySentiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeEntitySentimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnalyzeEntitySentiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v1beta2.LanguageService/AnalyzeEntitySentiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnalyzeEntitySentiment(ctx, req.(*AnalyzeEntitySentimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_AnalyzeSyntax_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeSyntaxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnalyzeSyntax(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v1beta2.LanguageService/AnalyzeSyntax",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnalyzeSyntax(ctx, req.(*AnalyzeSyntaxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_ClassifyText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClassifyTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).ClassifyText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v1beta2.LanguageService/ClassifyText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).ClassifyText(ctx, req.(*ClassifyTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageService_AnnotateText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageServiceServer).AnnotateText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.language.v1beta2.LanguageService/AnnotateText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageServiceServer).AnnotateText(ctx, req.(*AnnotateTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LanguageService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.language.v1beta2.LanguageService",
	HandlerType: (*LanguageServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnalyzeSentiment",
			Handler:    _LanguageService_AnalyzeSentiment_Handler,
		},
		{
			MethodName: "AnalyzeEntities",
			Handler:    _LanguageService_AnalyzeEntities_Handler,
		},
		{
			MethodName: "AnalyzeEntitySentiment",
			Handler:    _LanguageService_AnalyzeEntitySentiment_Handler,
		},
		{
			MethodName: "AnalyzeSyntax",
			Handler:    _LanguageService_AnalyzeSyntax_Handler,
		},
		{
			MethodName: "ClassifyText",
			Handler:    _LanguageService_ClassifyText_Handler,
		},
		{
			MethodName: "AnnotateText",
			Handler:    _LanguageService_AnnotateText_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/language/v1beta2/language_service.proto",
}
