// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.2
// source: google/devtools/resultstore/v2/file_set.proto

package resultstore

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// This resource represents a set of Files and other (nested) FileSets.
// A FileSet is a node in the graph, and the file_sets field represents the
// outgoing edges. A resource may reference various nodes in the graph to
// represent the transitive closure of all files from those nodes.
// The FileSets must form a directed acyclic graph. The Upload API is unable to
// enforce that the graph is acyclic at write time, and if cycles are written,
// it may cause issues at read time.
//
// A FileSet may be referenced by other resources in conjunction with Files. A
// File is preferred for something that can only be ever referenced by one
// resource, and a FileSet is preferred if it can be reference by multiple
// resources.
type FileSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The format of this FileSet resource name must be:
	// invocations/${INVOCATION_ID}/fileSets/${url_encode(FILE_SET_ID)}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the file set. They must match the
	// resource name after proper encoding.
	Id *FileSet_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// List of names of other file sets that are referenced from this one.
	// Each name must point to a file set under the same invocation. The name
	// format must be: invocations/${INVOCATION_ID}/fileSets/${FILE_SET_ID}
	FileSets []string `protobuf:"bytes,3,rep,name=file_sets,json=fileSets,proto3" json:"file_sets,omitempty"`
	// Files that are contained within this file set.
	// The uid field in the file should be unique for the Invocation.
	Files []*File `protobuf:"bytes,4,rep,name=files,proto3" json:"files,omitempty"`
}

func (x *FileSet) Reset() {
	*x = FileSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_file_set_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileSet) ProtoMessage() {}

func (x *FileSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_file_set_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileSet.ProtoReflect.Descriptor instead.
func (*FileSet) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_file_set_proto_rawDescGZIP(), []int{0}
}

func (x *FileSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FileSet) GetId() *FileSet_Id {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *FileSet) GetFileSets() []string {
	if x != nil {
		return x.FileSets
	}
	return nil
}

func (x *FileSet) GetFiles() []*File {
	if x != nil {
		return x.Files
	}
	return nil
}

// The resource ID components that identify the FileSet.
type FileSet_Id struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Invocation ID.
	InvocationId string `protobuf:"bytes,1,opt,name=invocation_id,json=invocationId,proto3" json:"invocation_id,omitempty"`
	// The FileSet ID.
	FileSetId string `protobuf:"bytes,2,opt,name=file_set_id,json=fileSetId,proto3" json:"file_set_id,omitempty"`
}

func (x *FileSet_Id) Reset() {
	*x = FileSet_Id{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_file_set_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileSet_Id) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileSet_Id) ProtoMessage() {}

func (x *FileSet_Id) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_file_set_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileSet_Id.ProtoReflect.Descriptor instead.
func (*FileSet_Id) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_file_set_proto_rawDescGZIP(), []int{0, 0}
}

func (x *FileSet_Id) GetInvocationId() string {
	if x != nil {
		return x.InvocationId
	}
	return ""
}

func (x *FileSet_Id) GetFileSetId() string {
	if x != nil {
		return x.FileSetId
	}
	return ""
}

var File_google_devtools_resultstore_v2_file_set_proto protoreflect.FileDescriptor

var file_google_devtools_resultstore_v2_file_set_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32,
	0x2f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x1a,
	0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f,
	0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfd, 0x01, 0x0a, 0x07, 0x46,
	0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x2e,
	0x49, 0x64, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73,
	0x65, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x53,
	0x65, 0x74, 0x73, 0x12, 0x3a, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x1a,
	0x49, 0x0a, 0x02, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0b, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x49, 0x64, 0x42, 0x71, 0x0a, 0x22, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32,
	0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76,
	0x32, 0x3b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_resultstore_v2_file_set_proto_rawDescOnce sync.Once
	file_google_devtools_resultstore_v2_file_set_proto_rawDescData = file_google_devtools_resultstore_v2_file_set_proto_rawDesc
)

func file_google_devtools_resultstore_v2_file_set_proto_rawDescGZIP() []byte {
	file_google_devtools_resultstore_v2_file_set_proto_rawDescOnce.Do(func() {
		file_google_devtools_resultstore_v2_file_set_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_resultstore_v2_file_set_proto_rawDescData)
	})
	return file_google_devtools_resultstore_v2_file_set_proto_rawDescData
}

var file_google_devtools_resultstore_v2_file_set_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_devtools_resultstore_v2_file_set_proto_goTypes = []interface{}{
	(*FileSet)(nil),    // 0: google.devtools.resultstore.v2.FileSet
	(*FileSet_Id)(nil), // 1: google.devtools.resultstore.v2.FileSet.Id
	(*File)(nil),       // 2: google.devtools.resultstore.v2.File
}
var file_google_devtools_resultstore_v2_file_set_proto_depIdxs = []int32{
	1, // 0: google.devtools.resultstore.v2.FileSet.id:type_name -> google.devtools.resultstore.v2.FileSet.Id
	2, // 1: google.devtools.resultstore.v2.FileSet.files:type_name -> google.devtools.resultstore.v2.File
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_devtools_resultstore_v2_file_set_proto_init() }
func file_google_devtools_resultstore_v2_file_set_proto_init() {
	if File_google_devtools_resultstore_v2_file_set_proto != nil {
		return
	}
	file_google_devtools_resultstore_v2_file_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_resultstore_v2_file_set_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_file_set_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileSet_Id); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_resultstore_v2_file_set_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_devtools_resultstore_v2_file_set_proto_goTypes,
		DependencyIndexes: file_google_devtools_resultstore_v2_file_set_proto_depIdxs,
		MessageInfos:      file_google_devtools_resultstore_v2_file_set_proto_msgTypes,
	}.Build()
	File_google_devtools_resultstore_v2_file_set_proto = out.File
	file_google_devtools_resultstore_v2_file_set_proto_rawDesc = nil
	file_google_devtools_resultstore_v2_file_set_proto_goTypes = nil
	file_google_devtools_resultstore_v2_file_set_proto_depIdxs = nil
}
