// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.2
// source: google/maps/unity/clientinfo.proto

package unity

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Platform enum.
type ClientInfo_Platform int32

const (
	// Unspecified or unknown OS.
	ClientInfo_PLATFORM_UNSPECIFIED ClientInfo_Platform = 0
	// Development environment.
	ClientInfo_EDITOR ClientInfo_Platform = 1
	// macOS.
	ClientInfo_MAC_OS ClientInfo_Platform = 2
	// Windows.
	ClientInfo_WINDOWS ClientInfo_Platform = 3
	// Linux
	ClientInfo_LINUX ClientInfo_Platform = 4
	// Android
	ClientInfo_ANDROID ClientInfo_Platform = 5
	// iOS
	ClientInfo_IOS ClientInfo_Platform = 6
	// WebGL.
	ClientInfo_WEB_GL ClientInfo_Platform = 7
)

// Enum value maps for ClientInfo_Platform.
var (
	ClientInfo_Platform_name = map[int32]string{
		0: "PLATFORM_UNSPECIFIED",
		1: "EDITOR",
		2: "MAC_OS",
		3: "WINDOWS",
		4: "LINUX",
		5: "ANDROID",
		6: "IOS",
		7: "WEB_GL",
	}
	ClientInfo_Platform_value = map[string]int32{
		"PLATFORM_UNSPECIFIED": 0,
		"EDITOR":               1,
		"MAC_OS":               2,
		"WINDOWS":              3,
		"LINUX":                4,
		"ANDROID":              5,
		"IOS":                  6,
		"WEB_GL":               7,
	}
)

func (x ClientInfo_Platform) Enum() *ClientInfo_Platform {
	p := new(ClientInfo_Platform)
	*p = x
	return p
}

func (x ClientInfo_Platform) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClientInfo_Platform) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_unity_clientinfo_proto_enumTypes[0].Descriptor()
}

func (ClientInfo_Platform) Type() protoreflect.EnumType {
	return &file_google_maps_unity_clientinfo_proto_enumTypes[0]
}

func (x ClientInfo_Platform) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClientInfo_Platform.Descriptor instead.
func (ClientInfo_Platform) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_unity_clientinfo_proto_rawDescGZIP(), []int{0, 0}
}

// Client information.
type ClientInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Application ID, such as the package name on Android and the bundle
	// identifier on iOS platforms.
	ApplicationId string `protobuf:"bytes,1,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// Application version number, such as "1.2.3". The exact format is
	// application-dependent.
	ApplicationVersion string `protobuf:"bytes,2,opt,name=application_version,json=applicationVersion,proto3" json:"application_version,omitempty"`
	// Platform where the application is running.
	Platform ClientInfo_Platform `protobuf:"varint,3,opt,name=platform,proto3,enum=google.maps.unity.ClientInfo_Platform" json:"platform,omitempty"`
	// Operating system name and version as reported by the OS. For example,
	// "Mac OS X 10.10.4". The exact format is platform-dependent.
	OperatingSystem string `protobuf:"bytes,4,opt,name=operating_system,json=operatingSystem,proto3" json:"operating_system,omitempty"`
	// API client name and version. For example, the SDK calling the API. The
	// exact format is up to the client.
	ApiClient string `protobuf:"bytes,5,opt,name=api_client,json=apiClient,proto3" json:"api_client,omitempty"`
	// Device model as reported by the device. The exact format is
	// platform-dependent.
	DeviceModel string `protobuf:"bytes,6,opt,name=device_model,json=deviceModel,proto3" json:"device_model,omitempty"`
	// Language code (in BCP-47 format) indicating the UI language of the client.
	// Examples are "en", "en-US" or "ja-Latn". For more information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `protobuf:"bytes,7,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Build number/version of the operating system. e.g., the contents of
	// android.os.Build.ID in Android, or the contents of sysctl "kern.osversion"
	// in iOS.
	OperatingSystemBuild string `protobuf:"bytes,8,opt,name=operating_system_build,json=operatingSystemBuild,proto3" json:"operating_system_build,omitempty"`
}

func (x *ClientInfo) Reset() {
	*x = ClientInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_unity_clientinfo_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientInfo) ProtoMessage() {}

func (x *ClientInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_unity_clientinfo_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientInfo.ProtoReflect.Descriptor instead.
func (*ClientInfo) Descriptor() ([]byte, []int) {
	return file_google_maps_unity_clientinfo_proto_rawDescGZIP(), []int{0}
}

func (x *ClientInfo) GetApplicationId() string {
	if x != nil {
		return x.ApplicationId
	}
	return ""
}

func (x *ClientInfo) GetApplicationVersion() string {
	if x != nil {
		return x.ApplicationVersion
	}
	return ""
}

func (x *ClientInfo) GetPlatform() ClientInfo_Platform {
	if x != nil {
		return x.Platform
	}
	return ClientInfo_PLATFORM_UNSPECIFIED
}

func (x *ClientInfo) GetOperatingSystem() string {
	if x != nil {
		return x.OperatingSystem
	}
	return ""
}

func (x *ClientInfo) GetApiClient() string {
	if x != nil {
		return x.ApiClient
	}
	return ""
}

func (x *ClientInfo) GetDeviceModel() string {
	if x != nil {
		return x.DeviceModel
	}
	return ""
}

func (x *ClientInfo) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ClientInfo) GetOperatingSystemBuild() string {
	if x != nil {
		return x.OperatingSystemBuild
	}
	return ""
}

var File_google_maps_unity_clientinfo_proto protoreflect.FileDescriptor

var file_google_maps_unity_clientinfo_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x75, 0x6e,
	0x69, 0x74, 0x79, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x75, 0x6e, 0x69, 0x74, 0x79, 0x22, 0xe8, 0x03, 0x0a, 0x0a, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2f, 0x0a,
	0x13, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42,
	0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x75,
	0x6e, 0x69, 0x74, 0x79, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x1d, 0x0a,
	0x0a, 0x61, 0x70, 0x69, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x61, 0x70, 0x69, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x53,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x22, 0x76, 0x0a, 0x08, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f,
	0x52, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x45, 0x44, 0x49, 0x54, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x4d, 0x41, 0x43, 0x5f, 0x4f, 0x53, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x49, 0x4e, 0x44,
	0x4f, 0x57, 0x53, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x4c, 0x49, 0x4e, 0x55, 0x58, 0x10, 0x04,
	0x12, 0x0b, 0x0a, 0x07, 0x41, 0x4e, 0x44, 0x52, 0x4f, 0x49, 0x44, 0x10, 0x05, 0x12, 0x07, 0x0a,
	0x03, 0x49, 0x4f, 0x53, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x45, 0x42, 0x5f, 0x47, 0x4c,
	0x10, 0x07, 0x42, 0x7c, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x75, 0x6e, 0x69, 0x74, 0x79, 0x42, 0x0f, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x75, 0x6e, 0x69, 0x74, 0x79,
	0x3b, 0x75, 0x6e, 0x69, 0x74, 0x79, 0xa2, 0x02, 0x03, 0x47, 0x4d, 0x55, 0xaa, 0x02, 0x11, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x79,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_unity_clientinfo_proto_rawDescOnce sync.Once
	file_google_maps_unity_clientinfo_proto_rawDescData = file_google_maps_unity_clientinfo_proto_rawDesc
)

func file_google_maps_unity_clientinfo_proto_rawDescGZIP() []byte {
	file_google_maps_unity_clientinfo_proto_rawDescOnce.Do(func() {
		file_google_maps_unity_clientinfo_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_unity_clientinfo_proto_rawDescData)
	})
	return file_google_maps_unity_clientinfo_proto_rawDescData
}

var file_google_maps_unity_clientinfo_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_maps_unity_clientinfo_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_maps_unity_clientinfo_proto_goTypes = []interface{}{
	(ClientInfo_Platform)(0), // 0: google.maps.unity.ClientInfo.Platform
	(*ClientInfo)(nil),       // 1: google.maps.unity.ClientInfo
}
var file_google_maps_unity_clientinfo_proto_depIdxs = []int32{
	0, // 0: google.maps.unity.ClientInfo.platform:type_name -> google.maps.unity.ClientInfo.Platform
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_maps_unity_clientinfo_proto_init() }
func file_google_maps_unity_clientinfo_proto_init() {
	if File_google_maps_unity_clientinfo_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_maps_unity_clientinfo_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_unity_clientinfo_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_unity_clientinfo_proto_goTypes,
		DependencyIndexes: file_google_maps_unity_clientinfo_proto_depIdxs,
		EnumInfos:         file_google_maps_unity_clientinfo_proto_enumTypes,
		MessageInfos:      file_google_maps_unity_clientinfo_proto_msgTypes,
	}.Build()
	File_google_maps_unity_clientinfo_proto = out.File
	file_google_maps_unity_clientinfo_proto_rawDesc = nil
	file_google_maps_unity_clientinfo_proto_goTypes = nil
	file_google_maps_unity_clientinfo_proto_depIdxs = nil
}
