// Code generated by "go generate gonum.org/v1/gonum/unit”; DO NOT EDIT.

// Copyright ©2014 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package unit

import (
	"errors"
	"fmt"
	"math"
	"unicode/utf8"
)

// Torque represents a torque in Newton metres.
type Torque float64

const Newtonmetre Torque = 1

// Unit converts the Torque to a *Unit
func (t Torque) Unit() *Unit {
	return New(float64(t), Dimensions{
		LengthDim: 2,
		MassDim:   1,
		TimeDim:   -2,
	})
}

// Torque allows Torque to implement a Torquer interface
func (t Torque) Torque() Torque {
	return t
}

// From converts the unit into the receiver. From returns an
// error if there is a mismatch in dimension
func (t *Torque) From(u Uniter) error {
	if !DimensionsMatch(u, Newtonmetre) {
		*t = Torque(math.NaN())
		return errors.New("Dimension mismatch")
	}
	*t = Torque(u.Unit().Value())
	return nil
}

func (t Torque) Format(fs fmt.State, c rune) {
	switch c {
	case 'v':
		if fs.Flag('#') {
			fmt.Fprintf(fs, "%T(%v)", t, float64(t))
			return
		}
		fallthrough
	case 'e', 'E', 'f', 'F', 'g', 'G':
		p, pOk := fs.Precision()
		w, wOk := fs.Width()
		const unit = " N m"
		switch {
		case pOk && wOk:
			fmt.Fprintf(fs, "%*.*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), p, float64(t))
		case pOk:
			fmt.Fprintf(fs, "%.*"+string(c), p, float64(t))
		case wOk:
			fmt.Fprintf(fs, "%*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), float64(t))
		default:
			fmt.Fprintf(fs, "%"+string(c), float64(t))
		}
		fmt.Fprint(fs, unit)
	default:
		fmt.Fprintf(fs, "%%!%c(%T=%g N m)", c, t, float64(t))
	}
}
