// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/argoproj/argo-cd/pkg/apis/application/v1alpha1"
	scheme "github.com/argoproj/argo-cd/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AppProjectsGetter has a method to return a AppProjectInterface.
// A group's client should implement this interface.
type AppProjectsGetter interface {
	AppProjects(namespace string) AppProjectInterface
}

// AppProjectInterface has methods to work with AppProject resources.
type AppProjectInterface interface {
	Create(ctx context.Context, appProject *v1alpha1.AppProject, opts v1.CreateOptions) (*v1alpha1.AppProject, error)
	Update(ctx context.Context, appProject *v1alpha1.AppProject, opts v1.UpdateOptions) (*v1alpha1.AppProject, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.AppProject, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.AppProjectList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AppProject, err error)
	AppProjectExpansion
}

// appProjects implements AppProjectInterface
type appProjects struct {
	client rest.Interface
	ns     string
}

// newAppProjects returns a AppProjects
func newAppProjects(c *ArgoprojV1alpha1Client, namespace string) *appProjects {
	return &appProjects{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the appProject, and returns the corresponding appProject object, and an error if there is any.
func (c *appProjects) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.AppProject, err error) {
	result = &v1alpha1.AppProject{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("appprojects").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AppProjects that match those selectors.
func (c *appProjects) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.AppProjectList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.AppProjectList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("appprojects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested appProjects.
func (c *appProjects) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("appprojects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a appProject and creates it.  Returns the server's representation of the appProject, and an error, if there is any.
func (c *appProjects) Create(ctx context.Context, appProject *v1alpha1.AppProject, opts v1.CreateOptions) (result *v1alpha1.AppProject, err error) {
	result = &v1alpha1.AppProject{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("appprojects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(appProject).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a appProject and updates it. Returns the server's representation of the appProject, and an error, if there is any.
func (c *appProjects) Update(ctx context.Context, appProject *v1alpha1.AppProject, opts v1.UpdateOptions) (result *v1alpha1.AppProject, err error) {
	result = &v1alpha1.AppProject{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("appprojects").
		Name(appProject.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(appProject).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the appProject and deletes it. Returns an error if one occurs.
func (c *appProjects) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("appprojects").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *appProjects) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("appprojects").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched appProject.
func (c *appProjects) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AppProject, err error) {
	result = &v1alpha1.AppProject{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("appprojects").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
