import * as React from 'react';
import { PickOptional } from '../../helpers';
export interface DualListSelectorProps {
    /** Additional classes applied to the dual list selector. */
    className?: string;
    /** Title applied to the available options pane. */
    availableOptionsTitle?: string;
    /** Options to display in the available options pane. */
    availableOptions?: React.ReactNode[];
    /** Status message to display above the available options pane. */
    availableOptionsStatus?: string;
    /** Actions to be displayed above the available options pane. */
    availableOptionsActions?: React.ReactNode[];
    /** Title applied to the chosen options pane. */
    chosenOptionsTitle?: string;
    /** Options to display in the chosen options pane. */
    chosenOptions?: React.ReactNode[];
    /** Status message to display above the chosen options pane.*/
    chosenOptionsStatus?: string;
    /** Actions to be displayed above the chosen options pane. */
    chosenOptionsActions?: React.ReactNode[];
    /** Accessible label for the controls between the two panes. */
    controlsAriaLabel?: string;
    /** Optional callback for the add selected button */
    addSelected?: (newAvailableOptions: React.ReactNode[], newChosenOptions: React.ReactNode[]) => void;
    /** Accessible label for the add selected button */
    addSelectedAriaLabel?: string;
    /** Callback fired every time options are chosen or removed */
    onListChange?: (newAvailableOptions: React.ReactNode[], newChosenOptions: React.ReactNode[]) => void;
    /** Optional callback for the add all button */
    addAll?: (newAvailableOptions: React.ReactNode[], newChosenOptions: React.ReactNode[]) => void;
    /** Accessible label for the add all button */
    addAllAriaLabel?: string;
    /** Optional callback for the remove selected button */
    removeSelected?: (newAvailableOptions: React.ReactNode[], newChosenOptions: React.ReactNode[]) => void;
    /** Accessible label for the remove selected button */
    removeSelectedAriaLabel?: string;
    /** Optional callback for the remove all button */
    removeAll?: (newAvailableOptions: React.ReactNode[], newChosenOptions: React.ReactNode[]) => void;
    /** Accessible label for the remove all button */
    removeAllAriaLabel?: string;
    /** Optional callback fired when an option is selected */
    onOptionSelect?: (e: React.MouseEvent | React.ChangeEvent) => void;
    /** Flag indicating a search bar should be included above both the available and chosen panes. */
    isSearchable?: boolean;
    /** Accessible label for the search input on the available options pane. */
    availableOptionsSearchAriaLabel?: string;
    /** Accessible label for the search input on the chosen options pane. */
    chosenOptionsSearchAriaLabel?: string;
    /** Optional filter function for custom filtering based on search string. */
    filterOption?: (option: React.ReactNode, input: string) => boolean;
    /** Id of the dual list selector. */
    id?: string;
}
interface DualListSelectorState {
    availableOptions: React.ReactNode[];
    availableOptionsSelected: number[];
    chosenOptions: React.ReactNode[];
    chosenOptionsSelected: number[];
}
export declare class DualListSelector extends React.Component<DualListSelectorProps, DualListSelectorState> {
    static displayName: string;
    private controlsEl;
    static defaultProps: PickOptional<DualListSelectorProps>;
    constructor(props: DualListSelectorProps);
    componentDidUpdate(): void;
    addAll: () => void;
    removeAll: () => void;
    addSelected: () => void;
    removeSelected: () => void;
    onOptionSelect: (e: React.MouseEvent | React.ChangeEvent, index: number, isChosen: boolean) => void;
    handleKeys: (event: KeyboardEvent) => void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    render(): JSX.Element;
}
export {};
//# sourceMappingURL=DualListSelector.d.ts.map