import { ClusterClient } from './client';
import { DiscoveryClient } from './discoveryClient';
import { ResponseType } from 'axios';
import { TokenExpiryHandler } from './resources/common';
export declare class ClientFactoryUnknownClusterError extends Error {
    constructor(clusterName: string);
}
export declare class ClientFactoryMissingUserError extends Error {
    constructor();
}
export declare class ClientFactoryMissingApiRoot extends Error {
    constructor();
}
export declare class ClientFactoryMissingDiscoveryApi extends Error {
    constructor();
}
interface IUser {
    access_token: string;
    expiry_time: number;
}
export declare const ClientFactory: {
    cluster: (user: IUser, clusterApi: string, customResponseType?: ResponseType) => ClusterClient;
    discovery: (user: IUser, namespace: string, discoveryApi: string, clusterName?: string | undefined, tokenSecret?: string | undefined, customResponseType?: ResponseType) => DiscoveryClient | null;
};
export declare const setTokenExpiryHandler: (newExpiryHandler: TokenExpiryHandler) => void;
export {};
