import { MutationConfig, QueryConfig, QueryKey, QueryKeySerializerFunction, ReactQueryConfig, ResolvedQueryConfig } from './types';
import { QueryCache } from './queryCache';
export interface ReactQueryConfigRef {
    current: ReactQueryConfig;
}
export declare const defaultQueryKeySerializerFn: QueryKeySerializerFunction;
/**
 * Config merging strategy
 *
 * When using hooks the config will be merged in the following order:
 *
 * 1. These defaults.
 * 2. Defaults from the hook query cache.
 * 3. Combined defaults from any config providers in the tree.
 * 4. Query/mutation config provided to the hook.
 *
 * When using a query cache directly the config will be merged in the following order:
 *
 * 1. These defaults.
 * 2. Defaults from the query cache.
 * 3. Query/mutation config provided to the query cache method.
 */
export declare const DEFAULT_CONFIG: ReactQueryConfig;
export declare function getDefaultReactQueryConfig(): {
    queries: {};
    mutations: {};
};
export declare function mergeReactQueryConfigs(a: ReactQueryConfig, b: ReactQueryConfig): ReactQueryConfig;
export declare function getResolvedQueryConfig<TResult, TError>(queryCache: QueryCache, queryKey: QueryKey, contextConfig?: ReactQueryConfig, config?: QueryConfig<TResult, TError>): ResolvedQueryConfig<TResult, TError>;
export declare function isResolvedQueryConfig<TResult, TError>(config: any): config is ResolvedQueryConfig<TResult, TError>;
export declare function getResolvedMutationConfig<TResult, TError, TVariables, TSnapshot>(queryCache: QueryCache, contextConfig?: ReactQueryConfig, config?: MutationConfig<TResult, TError, TVariables, TSnapshot>): MutationConfig<TResult, TError, TVariables, TSnapshot>;
