import { Updater } from './utils';
import { ArrayQueryKey, IsFetchingMoreValue, QueryStatus, ResolvedQueryConfig } from './types';
import { QueryObserver, UpdateListener } from './queryObserver';
export interface QueryState<TResult, TError> {
    canFetchMore?: boolean;
    data?: TResult;
    error: TError | null;
    failureCount: number;
    isFetching: boolean;
    isFetchingMore: IsFetchingMoreValue;
    isInitialData: boolean;
    isInvalidated: boolean;
    status: QueryStatus;
    throwInErrorBoundary?: boolean;
    updateCount: number;
    updatedAt: number;
}
interface FetchOptions {
    fetchMore?: FetchMoreOptions;
}
export interface FetchMoreOptions {
    fetchMoreVariable?: unknown;
    previous: boolean;
}
export interface RefetchOptions {
    throwOnError?: boolean;
}
declare const enum ActionType {
    Failed = 0,
    Fetch = 1,
    Success = 2,
    Error = 3,
    Invalidate = 4
}
interface SetDataOptions {
    updatedAt?: number;
}
interface FailedAction {
    type: ActionType.Failed;
}
interface FetchAction {
    type: ActionType.Fetch;
    isFetchingMore?: IsFetchingMoreValue;
}
interface SuccessAction<TResult> {
    type: ActionType.Success;
    data: TResult | undefined;
    canFetchMore?: boolean;
    updatedAt?: number;
}
interface ErrorAction<TError> {
    type: ActionType.Error;
    error: TError;
}
interface InvalidateAction {
    type: ActionType.Invalidate;
}
export declare type Action<TResult, TError> = ErrorAction<TError> | FailedAction | FetchAction | InvalidateAction | SuccessAction<TResult>;
export declare class Query<TResult, TError> {
    queryKey: ArrayQueryKey;
    queryHash: string;
    config: ResolvedQueryConfig<TResult, TError>;
    observers: QueryObserver<TResult, TError>[];
    state: QueryState<TResult, TError>;
    cacheTime: number;
    private queryCache;
    private promise?;
    private gcTimeout?;
    private cancelFetch?;
    private continueFetch?;
    private isTransportCancelable?;
    constructor(config: ResolvedQueryConfig<TResult, TError>);
    private updateConfig;
    private dispatch;
    private scheduleGc;
    cancel(silent?: boolean): Promise<undefined>;
    private continue;
    private clearTimersObservers;
    private clearGcTimeout;
    setData(updater: Updater<TResult | undefined, TResult>, options?: SetDataOptions): void;
    /**
     * @deprecated
     */
    clear(): void;
    remove(): void;
    destroy(): void;
    isActive(): boolean;
    isStale(): boolean;
    isStaleByTime(staleTime?: number): boolean;
    onInteraction(type: 'focus' | 'online'): void;
    /**
     * @deprectated
     */
    subscribe(listener?: UpdateListener<TResult, TError>): QueryObserver<TResult, TError>;
    subscribeObserver(observer: QueryObserver<TResult, TError>): void;
    unsubscribeObserver(observer: QueryObserver<TResult, TError>): void;
    invalidate(): void;
    /**
     * @deprectated
     */
    refetch(options?: RefetchOptions, config?: ResolvedQueryConfig<TResult, TError>): Promise<TResult | undefined>;
    /**
     * @deprectated
     */
    fetchMore(fetchMoreVariable?: unknown, options?: FetchMoreOptions, config?: ResolvedQueryConfig<TResult, TError>): Promise<TResult | undefined>;
    fetch(options?: FetchOptions, config?: ResolvedQueryConfig<TResult, TError>): Promise<TResult>;
    private startFetch;
    private startInfiniteFetch;
    private tryFetchData;
}
export declare function queryReducer<TResult, TError>(state: QueryState<TResult, TError>, action: Action<TResult, TError>): QueryState<TResult, TError>;
export {};
