import { InfiniteQueryConfig, InfiniteQueryResult, QueryFunction, QueryKey, TypedQueryFunction, TypedQueryFunctionArgs } from '../core/types';
export interface UseInfiniteQueryObjectConfig<TResult, TError> {
    queryKey: QueryKey;
    queryFn?: QueryFunction<TResult>;
    config?: InfiniteQueryConfig<TResult, TError>;
}
export declare function useInfiniteQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryConfig?: InfiniteQueryConfig<TResult, TError>): InfiniteQueryResult<TResult, TError>;
export declare function useInfiniteQuery<TResult, TError, TArgs extends TypedQueryFunctionArgs>(queryKey: QueryKey, queryFn: TypedQueryFunction<TResult, TArgs>, queryConfig?: InfiniteQueryConfig<TResult, TError>): InfiniteQueryResult<TResult, TError>;
export declare function useInfiniteQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryFn: QueryFunction<TResult>, queryConfig?: InfiniteQueryConfig<TResult, TError>): InfiniteQueryResult<TResult, TError>;
export declare function useInfiniteQuery<TResult = unknown, TError = unknown>(config: UseInfiniteQueryObjectConfig<TResult, TError>): InfiniteQueryResult<TResult, TError>;
