'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var cardinals = {
  rules: [
  function () {
    return 0;
  },
  function (n) {
    return n === 1 ? 0 : 1;
  },
  function (n) {
    return n <= 1 ? 0 : 1;
  },
  function (n) {
    return n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 !== 0 ? 1 : 2;
  },
  function (n) {
    return n === 1 || n === 11 ? 0 : n === 2 || n === 12 ? 1 : n > 2 && n < 20 ? 2 : 3;
  },
  function (n) {
    return n === 1 ? 0 : n === 0 || n % 100 > 0 && n % 100 < 20 ? 1 : 2;
  },
  function (n) {
    return n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2;
  },
  function (n) {
    return n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2;
  },
  function (n) {
    return n === 1 ? 0 : n >= 2 && n <= 4 ? 1 : 2;
  },
  function (n) {
    return n === 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2;
  },
  function (n) {
    return n % 100 === 1 ? 0 : n % 100 === 2 ? 1 : n % 100 === 3 || n % 100 === 4 ? 2 : 3;
  },
  function (n) {
    return n === 1 ? 0 : n === 2 ? 1 : n > 2 && n < 7 ? 2 : n > 6 && n < 11 ? 3 : 4;
  },
  function (n) {
    return n === 1 ? 0 : n === 2 ? 1 : n % 100 >= 3 && n % 100 <= 10 ? 2 : n % 100 >= 11 ? 3 : n !== 0 ? 4 : 5;
  },
  function (n) {
    return n === 1 ? 0 : n === 0 || n % 100 > 1 && n % 100 < 11 ? 1 : n % 100 > 10 && n % 100 < 20 ? 2 : 3;
  },
  function (n) {
    return n % 10 === 1 ? 0 : n % 10 === 2 ? 1 : 2;
  },
  function (n) {
    return n % 10 === 1 && n % 100 !== 11 ? 0 : 1;
  },
  function (n) {
    return n % 10 === 1 && n % 100 !== 11 && n % 100 !== 71 && n % 100 !== 91 ? 0 : n % 10 === 2 && n % 100 !== 12 && n % 100 !== 72 && n % 100 !== 92 ? 2 : n % 10 === 3 && n % 100 !== 13 && n % 100 !== 73 && n % 100 !== 93 ? 3 : n % 10 === 4 && n % 100 !== 14 && n % 100 !== 74 && n % 100 !== 94 ? 3 : n % 10 === 9 && n % 100 !== 19 && n % 100 !== 79 && n % 100 !== 99 ? 3 : 4;
  },
  function (n) {
    return n !== 0 ? 0 : 1;
  },
  function (n) {
    return n === 1 ? 0 : n === 2 ? 1 : n === 3 ? 2 : n === 6 ? 3 : n !== 0 ? 4 : 5;
  },
  function (n) {
    return n === 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2;
  },
  function (n) {
    return n === 1 ? 0 : n === 2 ? 1 : n === 3 ? 2 : 3;
  },
  function (n) {
    return n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2;
  },
  function (n) {
    return n === 0 ? 0 : n === 1 ? 1 : 2;
  }],
  rulesByLocale: {
    ach: 2,
    af: 1,
    ak: 2,
    am: 2,
    an: 1,
    anp: 1,
    ar: 12,
    arn: 2,
    as: 1,
    ast: 1,
    ay: 0,
    az: 1,
    be: 7,
    bg: 1,
    bn: 1,
    bo: 0,
    br: 2,
    brx: 1,
    bs: 7,
    ca: 1,
    cgg: 0,
    cs: 8,
    csb: 19,
    cy: 18,
    da: 1,
    de: 1,
    doi: 1,
    dz: 0,
    el: 1,
    en: 1,
    eo: 1,
    es: 1,
    'es-ar': 1,
    et: 1,
    eu: 1,
    fa: 2,
    ff: 1,
    fi: 1,
    fil: 2,
    fo: 1,
    fr: 2,
    fur: 1,
    fy: 1,
    ga: 11,
    gd: 4,
    gl: 1,
    gu: 1,
    gun: 2,
    ha: 1,
    he: 1,
    hi: 1,
    hne: 1,
    hr: 7,
    hu: 1,
    hy: 1,
    ia: 1,
    id: 0,
    is: 15,
    it: 1,
    ja: 0,
    jbo: 0,
    jv: 17,
    ka: 0,
    kk: 1,
    kl: 1,
    km: 0,
    kn: 1,
    ko: 0,
    ku: 1,
    kw: 20,
    ky: 1,
    lb: 1,
    ln: 2,
    lo: 0,
    lt: 6,
    lv: 3,
    mai: 1,
    me: 21,
    mfe: 2,
    mg: 2,
    mi: 2,
    mk: 15,
    ml: 1,
    mn: 1,
    mni: 1,
    mnk: 22,
    mr: 1,
    ms: 0,
    mt: 13,
    my: 0,
    nah: 1,
    nap: 1,
    nb: 1,
    ne: 1,
    nl: 1,
    nn: 1,
    no: 1,
    nso: 1,
    oc: 2,
    or: 1,
    pa: 1,
    pap: 1,
    pl: 9,
    pms: 1,
    ps: 1,
    pt: 1,
    'pt-br': 2,
    rm: 1,
    ro: 5,
    ru: 7,
    rw: 1,
    sah: 0,
    sat: 1,
    sco: 1,
    sd: 1,
    se: 1,
    si: 1,
    sk: 8,
    sl: 10,
    so: 1,
    son: 1,
    sq: 1,
    sr: 7,
    su: 0,
    sv: 1,
    sw: 1,
    ta: 1,
    te: 1,
    tg: 2,
    th: 0,
    ti: 2,
    tk: 1,
    tr: 2,
    tt: 0,
    ug: 0,
    uk: 7,
    ur: 1,
    uz: 2,
    vi: 0,
    wa: 2,
    wo: 0,
    yo: 1,
    'zh-cn': 0,
    'zh-tw': 2
  }
};

var rules = cardinals.rules,
    rulesByLocale = cardinals.rulesByLocale;
function normalizeLocale(locale) {
  return locale.toLowerCase().replace('_', '-');
}
function getLanguage(locale) {
  var separator = locale.indexOf('-');
  return separator > 0 ? locale.substr(0, separator) : locale;
}
function getPluralRuleForCardinalsByLocale(locale) {
  locale = normalizeLocale(locale);
  var index = rulesByLocale[locale];
  if (index === undefined) {
    var language = getLanguage(locale);
    index = rulesByLocale[language];
  }
  if (index === undefined) {
    throw new Error("Unrecognized locale: \"" + locale + "\".");
  }
  return rules[index];
}
function getPluralRuleForCardinalsByIndex(index) {
  var rule = rules[index];
  if (rule === undefined) {
    throw new Error("Invalid index: \"" + index + "\".");
  }
  return rule;
}
function getPluralFormForCardinalByLocale(locale, count) {
  var rule = getPluralRuleForCardinalsByLocale(locale);
  return rule(count);
}
function getPluralFormForCardinalByIndex(index, count) {
  var rule = getPluralRuleForCardinalsByIndex(index);
  return rule(count);
}

exports.getPluralRuleForCardinalsByLocale = getPluralRuleForCardinalsByLocale;
exports.getPluralFormForCardinalByLocale = getPluralFormForCardinalByLocale;
exports.getPluralRuleForCardinalsByIndex = getPluralRuleForCardinalsByIndex;
exports.getPluralFormForCardinalByIndex = getPluralFormForCardinalByIndex;
