export declare type KubeResource = NamespacedResource | ClusterResource;
export interface IKubeResource {
    listPath(): string;
    namedPath(name: string): string;
}
export interface IGroupVersionKindPlural {
    group: string;
    version: string;
    kindPlural: string;
}
export declare type TokenExpiryHandler = (oldToken: object) => void;
export declare abstract class NamespacedResource implements IKubeResource {
    abstract gvk(): IGroupVersionKindPlural;
    namespace: string;
    constructor(namespace: string);
    listPath(): string;
    namedPath(name: string): string;
}
export declare abstract class ClusterResource implements IKubeResource {
    abstract gvk(): IGroupVersionKindPlural;
    listPath(): string;
    namedPath(name: string): string;
}
export declare abstract class OAuthClient {
    private _token;
    private _tokenExpiryTime;
    private _tokenExpiryHandler;
    constructor(token: string);
    getOAuthHeader(): {
        Authorization: string;
    };
    setTokenExpiryHandler(handler: TokenExpiryHandler, tokenExpiryTime: number): void;
    checkExpiry(err: {
        response?: {
            status: number;
        };
    }): void;
    private _oldToken;
}
