// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package baremetalinfrastructure

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/baremetalinfrastructure/mgmt/2020-08-06-preview/baremetalinfrastructure"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AzureBareMetalHardwareTypeNamesEnum = original.AzureBareMetalHardwareTypeNamesEnum

const (
	CiscoUCS AzureBareMetalHardwareTypeNamesEnum = original.CiscoUCS
	HPE      AzureBareMetalHardwareTypeNamesEnum = original.HPE
)

type AzureBareMetalInstancePowerStateEnum = original.AzureBareMetalInstancePowerStateEnum

const (
	Restarting AzureBareMetalInstancePowerStateEnum = original.Restarting
	Started    AzureBareMetalInstancePowerStateEnum = original.Started
	Starting   AzureBareMetalInstancePowerStateEnum = original.Starting
	Stopped    AzureBareMetalInstancePowerStateEnum = original.Stopped
	Stopping   AzureBareMetalInstancePowerStateEnum = original.Stopping
	Unknown    AzureBareMetalInstancePowerStateEnum = original.Unknown
)

type AzureBareMetalInstanceSizeNamesEnum = original.AzureBareMetalInstanceSizeNamesEnum

const (
	S112    AzureBareMetalInstanceSizeNamesEnum = original.S112
	S144    AzureBareMetalInstanceSizeNamesEnum = original.S144
	S144m   AzureBareMetalInstanceSizeNamesEnum = original.S144m
	S192    AzureBareMetalInstanceSizeNamesEnum = original.S192
	S192m   AzureBareMetalInstanceSizeNamesEnum = original.S192m
	S192xm  AzureBareMetalInstanceSizeNamesEnum = original.S192xm
	S224    AzureBareMetalInstanceSizeNamesEnum = original.S224
	S224m   AzureBareMetalInstanceSizeNamesEnum = original.S224m
	S224om  AzureBareMetalInstanceSizeNamesEnum = original.S224om
	S224oo  AzureBareMetalInstanceSizeNamesEnum = original.S224oo
	S224oom AzureBareMetalInstanceSizeNamesEnum = original.S224oom
	S224ooo AzureBareMetalInstanceSizeNamesEnum = original.S224ooo
	S384    AzureBareMetalInstanceSizeNamesEnum = original.S384
	S384m   AzureBareMetalInstanceSizeNamesEnum = original.S384m
	S384xm  AzureBareMetalInstanceSizeNamesEnum = original.S384xm
	S384xxm AzureBareMetalInstanceSizeNamesEnum = original.S384xxm
	S448    AzureBareMetalInstanceSizeNamesEnum = original.S448
	S448m   AzureBareMetalInstanceSizeNamesEnum = original.S448m
	S448om  AzureBareMetalInstanceSizeNamesEnum = original.S448om
	S448oo  AzureBareMetalInstanceSizeNamesEnum = original.S448oo
	S448oom AzureBareMetalInstanceSizeNamesEnum = original.S448oom
	S448ooo AzureBareMetalInstanceSizeNamesEnum = original.S448ooo
	S576m   AzureBareMetalInstanceSizeNamesEnum = original.S576m
	S576xm  AzureBareMetalInstanceSizeNamesEnum = original.S576xm
	S672    AzureBareMetalInstanceSizeNamesEnum = original.S672
	S672m   AzureBareMetalInstanceSizeNamesEnum = original.S672m
	S672om  AzureBareMetalInstanceSizeNamesEnum = original.S672om
	S672oo  AzureBareMetalInstanceSizeNamesEnum = original.S672oo
	S672oom AzureBareMetalInstanceSizeNamesEnum = original.S672oom
	S672ooo AzureBareMetalInstanceSizeNamesEnum = original.S672ooo
	S72     AzureBareMetalInstanceSizeNamesEnum = original.S72
	S72m    AzureBareMetalInstanceSizeNamesEnum = original.S72m
	S768    AzureBareMetalInstanceSizeNamesEnum = original.S768
	S768m   AzureBareMetalInstanceSizeNamesEnum = original.S768m
	S768xm  AzureBareMetalInstanceSizeNamesEnum = original.S768xm
	S896    AzureBareMetalInstanceSizeNamesEnum = original.S896
	S896m   AzureBareMetalInstanceSizeNamesEnum = original.S896m
	S896om  AzureBareMetalInstanceSizeNamesEnum = original.S896om
	S896oo  AzureBareMetalInstanceSizeNamesEnum = original.S896oo
	S896oom AzureBareMetalInstanceSizeNamesEnum = original.S896oom
	S896ooo AzureBareMetalInstanceSizeNamesEnum = original.S896ooo
	S96     AzureBareMetalInstanceSizeNamesEnum = original.S96
	S960m   AzureBareMetalInstanceSizeNamesEnum = original.S960m
)

type AzureBareMetalProvisioningStatesEnum = original.AzureBareMetalProvisioningStatesEnum

const (
	Accepted  AzureBareMetalProvisioningStatesEnum = original.Accepted
	Creating  AzureBareMetalProvisioningStatesEnum = original.Creating
	Deleting  AzureBareMetalProvisioningStatesEnum = original.Deleting
	Failed    AzureBareMetalProvisioningStatesEnum = original.Failed
	Migrating AzureBareMetalProvisioningStatesEnum = original.Migrating
	Succeeded AzureBareMetalProvisioningStatesEnum = original.Succeeded
	Updating  AzureBareMetalProvisioningStatesEnum = original.Updating
)

type AzureBareMetalInstance = original.AzureBareMetalInstance
type AzureBareMetalInstanceProperties = original.AzureBareMetalInstanceProperties
type AzureBareMetalInstancesClient = original.AzureBareMetalInstancesClient
type AzureBareMetalInstancesDeleteFuture = original.AzureBareMetalInstancesDeleteFuture
type AzureBareMetalInstancesListResult = original.AzureBareMetalInstancesListResult
type AzureBareMetalInstancesListResultIterator = original.AzureBareMetalInstancesListResultIterator
type AzureBareMetalInstancesListResultPage = original.AzureBareMetalInstancesListResultPage
type AzureBareMetalInstancesRestartFuture = original.AzureBareMetalInstancesRestartFuture
type AzureBareMetalInstancesShutdownFuture = original.AzureBareMetalInstancesShutdownFuture
type AzureBareMetalInstancesStartFuture = original.AzureBareMetalInstancesStartFuture
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type Disk = original.Disk
type Display = original.Display
type ErrorDefinition = original.ErrorDefinition
type ErrorResponse = original.ErrorResponse
type HardwareProfile = original.HardwareProfile
type IPAddress = original.IPAddress
type NetworkProfile = original.NetworkProfile
type OSProfile = original.OSProfile
type Operation = original.Operation
type OperationList = original.OperationList
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type Result = original.Result
type StorageProfile = original.StorageProfile
type Tags = original.Tags
type TrackedResource = original.TrackedResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAzureBareMetalInstancesClient(subscriptionID string) AzureBareMetalInstancesClient {
	return original.NewAzureBareMetalInstancesClient(subscriptionID)
}
func NewAzureBareMetalInstancesClientWithBaseURI(baseURI string, subscriptionID string) AzureBareMetalInstancesClient {
	return original.NewAzureBareMetalInstancesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAzureBareMetalInstancesListResultIterator(page AzureBareMetalInstancesListResultPage) AzureBareMetalInstancesListResultIterator {
	return original.NewAzureBareMetalInstancesListResultIterator(page)
}
func NewAzureBareMetalInstancesListResultPage(cur AzureBareMetalInstancesListResult, getNextPage func(context.Context, AzureBareMetalInstancesListResult) (AzureBareMetalInstancesListResult, error)) AzureBareMetalInstancesListResultPage {
	return original.NewAzureBareMetalInstancesListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAzureBareMetalHardwareTypeNamesEnumValues() []AzureBareMetalHardwareTypeNamesEnum {
	return original.PossibleAzureBareMetalHardwareTypeNamesEnumValues()
}
func PossibleAzureBareMetalInstancePowerStateEnumValues() []AzureBareMetalInstancePowerStateEnum {
	return original.PossibleAzureBareMetalInstancePowerStateEnumValues()
}
func PossibleAzureBareMetalInstanceSizeNamesEnumValues() []AzureBareMetalInstanceSizeNamesEnum {
	return original.PossibleAzureBareMetalInstanceSizeNamesEnumValues()
}
func PossibleAzureBareMetalProvisioningStatesEnumValues() []AzureBareMetalProvisioningStatesEnum {
	return original.PossibleAzureBareMetalProvisioningStatesEnumValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
