// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package chromemanagement provides access to the Chrome Management API.
//
// For product documentation, see: http://developers.google.com/chrome/management/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/chromemanagement/v1"
//   ...
//   ctx := context.Background()
//   chromemanagementService, err := chromemanagement.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   chromemanagementService, err := chromemanagement.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   chromemanagementService, err := chromemanagement.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package chromemanagement // import "google.golang.org/api/chromemanagement/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "chromemanagement:v1"
const apiName = "chromemanagement"
const apiVersion = "v1"
const basePath = "https://chromemanagement.googleapis.com/"
const mtlsBasePath = "https://chromemanagement.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See reports about devices and Chrome browsers managed within your
	// organization
	ChromeManagementReportsReadonlyScope = "https://www.googleapis.com/auth/chrome.management.reports.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/chrome.management.reports.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Customers = NewCustomersService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Customers *CustomersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCustomersService(s *Service) *CustomersService {
	rs := &CustomersService{s: s}
	rs.Reports = NewCustomersReportsService(s)
	return rs
}

type CustomersService struct {
	s *Service

	Reports *CustomersReportsService
}

func NewCustomersReportsService(s *Service) *CustomersReportsService {
	rs := &CustomersReportsService{s: s}
	return rs
}

type CustomersReportsService struct {
	s *Service
}

// GoogleChromeManagementV1BrowserVersion: Describes a browser version
// and its install count.
type GoogleChromeManagementV1BrowserVersion struct {
	// Channel: Output only. The release channel of the installed browser.
	//
	// Possible values:
	//   "RELEASE_CHANNEL_UNSPECIFIED" - No release channel specified.
	//   "CANARY" - Canary release channel.
	//   "DEV" - Dev release channel.
	//   "BETA" - Beta release channel.
	//   "STABLE" - Stable release channel.
	Channel string `json:"channel,omitempty"`

	// Count: Output only. Count grouped by device_system and major version
	Count int64 `json:"count,omitempty,string"`

	// DeviceOsVersion: Output only. Version of the system-specified
	// operating system.
	DeviceOsVersion string `json:"deviceOsVersion,omitempty"`

	// System: Output only. The device operating system.
	//
	// Possible values:
	//   "DEVICE_SYSTEM_UNSPECIFIED" - No operating system specified.
	//   "SYSTEM_OTHER" - Other operating system.
	//   "SYSTEM_ANDROID" - Android operating system.
	//   "SYSTEM_IOS" - Apple iOS operating system.
	//   "SYSTEM_CROS" - Chrome OS operating system.
	//   "SYSTEM_WINDOWS" - Microsoft Windows operating system.
	//   "SYSTEM_MAC" - Apple macOS operating system.
	//   "SYSTEM_LINUX" - Linux operating system.
	System string `json:"system,omitempty"`

	// Version: Output only. The full version of the installed browser.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Channel") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Channel") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1BrowserVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1BrowserVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountChromeVersionsResponse: Response
// containing requested browser versions details and counts.
type GoogleChromeManagementV1CountChromeVersionsResponse struct {
	// BrowserVersions: List of all browser versions and their install
	// counts.
	BrowserVersions []*GoogleChromeManagementV1BrowserVersion `json:"browserVersions,omitempty"`

	// NextPageToken: Token to specify the next page of the request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TotalSize: Total number browser versions matching request.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BrowserVersions") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BrowserVersions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1CountChromeVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountChromeVersionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1CountInstalledAppsResponse: Response
// containing details of queried installed apps.
type GoogleChromeManagementV1CountInstalledAppsResponse struct {
	// InstalledApps: List of installed apps matching request.
	InstalledApps []*GoogleChromeManagementV1InstalledApp `json:"installedApps,omitempty"`

	// NextPageToken: Token to specify the next page of the request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TotalSize: Total number of installed apps matching request.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "InstalledApps") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InstalledApps") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1CountInstalledAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1CountInstalledAppsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1Device: Describes a device reporting Chrome
// browser information.
type GoogleChromeManagementV1Device struct {
	// DeviceId: Output only. The ID of the device that reported this Chrome
	// browser information.
	DeviceId string `json:"deviceId,omitempty"`

	// Machine: Output only. The name of the machine within its local
	// network.
	Machine string `json:"machine,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1Device) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1Device
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1FindInstalledAppDevicesResponse: Response
// containing a list of devices with queried app installed.
type GoogleChromeManagementV1FindInstalledAppDevicesResponse struct {
	// Devices: A list of devices which have the app installed. Sorted in
	// ascending alphabetical order on the Device.machine field.
	Devices []*GoogleChromeManagementV1Device `json:"devices,omitempty"`

	// NextPageToken: Token to specify the next page of the request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TotalSize: Total number of devices matching request.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Devices") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Devices") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1FindInstalledAppDevicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1FindInstalledAppDevicesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleChromeManagementV1InstalledApp: Describes an installed app.
type GoogleChromeManagementV1InstalledApp struct {
	// AppId: Output only. Unique identifier of the app. For Chrome apps and
	// extensions, the 32-character id (e.g.
	// ehoadneljpdggcbbknedodolkkjodefl). For Android apps, the package name
	// (e.g. com.evernote).
	AppId string `json:"appId,omitempty"`

	// AppInstallType: Output only. How the app was installed.
	//
	// Possible values:
	//   "APP_INSTALL_TYPE_UNSPECIFIED" - Application install type not
	// specified.
	//   "MULTIPLE" - Multiple app install types.
	//   "NORMAL" - Normal app install type.
	//   "ADMIN" - Administrator app install type.
	//   "DEVELOPMENT" - Development app install type.
	//   "SIDELOAD" - Sideloaded app install type.
	//   "OTHER" - Other app install type.
	AppInstallType string `json:"appInstallType,omitempty"`

	// AppSource: Output only. Source of the installed app.
	//
	// Possible values:
	//   "APP_SOURCE_UNSPECIFIED" - Application source not specified.
	//   "CHROME_WEBSTORE" - Generally for extensions and Chrome apps.
	//   "PLAY_STORE" - Play Store app.
	AppSource string `json:"appSource,omitempty"`

	// AppType: Output only. Type of the app.
	//
	// Possible values:
	//   "APP_TYPE_UNSPECIFIED" - App type not specified.
	//   "EXTENSION" - Chrome extension.
	//   "APP" - Chrome app.
	//   "THEME" - Chrome theme.
	//   "HOSTED_APP" - Chrome hosted app.
	//   "ANDROID_APP" - ARC++ app.
	AppType string `json:"appType,omitempty"`

	// BrowserDeviceCount: Output only. Count of browser devices with this
	// app installed.
	BrowserDeviceCount int64 `json:"browserDeviceCount,omitempty,string"`

	// Description: Output only. Description of the installed app.
	Description string `json:"description,omitempty"`

	// Disabled: Output only. Whether the app is disabled.
	Disabled bool `json:"disabled,omitempty"`

	// DisplayName: Output only. Name of the installed app.
	DisplayName string `json:"displayName,omitempty"`

	// HomepageUri: Output only. Homepage uri of the installed app.
	HomepageUri string `json:"homepageUri,omitempty"`

	// OsUserCount: Output only. Count of ChromeOS users with this app
	// installed.
	OsUserCount int64 `json:"osUserCount,omitempty,string"`

	// Permissions: Output only. Permissions of the installed app.
	Permissions []string `json:"permissions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppId") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppId") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleChromeManagementV1InstalledApp) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleChromeManagementV1InstalledApp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "chromemanagement.customers.reports.countChromeVersions":

type CustomersReportsCountChromeVersionsCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountChromeVersions: Generate report of installed Chrome versions.
//
// - customer: Customer id or "my_customer" to use the customer
//   associated to the account making the request.
func (r *CustomersReportsService) CountChromeVersions(customer string) *CustomersReportsCountChromeVersionsCall {
	c := &CustomersReportsCountChromeVersionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Filter sets the optional parameter "filter": Query string to filter
// results, AND-separated fields in EBNF syntax. Note: OR operations are
// not supported in this filter. Supported filter fields: *
// last_active_date
func (c *CustomersReportsCountChromeVersionsCall) Filter(filter string) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit.
func (c *CustomersReportsCountChromeVersionsCall) OrgUnitId(orgUnitId string) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// results to return. Maximum and default are 100.
func (c *CustomersReportsCountChromeVersionsCall) PageSize(pageSize int64) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify
// the page of the request to be returned.
func (c *CustomersReportsCountChromeVersionsCall) PageToken(pageToken string) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersReportsCountChromeVersionsCall) Fields(s ...googleapi.Field) *CustomersReportsCountChromeVersionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersReportsCountChromeVersionsCall) IfNoneMatch(entityTag string) *CustomersReportsCountChromeVersionsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersReportsCountChromeVersionsCall) Context(ctx context.Context) *CustomersReportsCountChromeVersionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersReportsCountChromeVersionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountChromeVersionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210629")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countChromeVersions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countChromeVersions" call.
// Exactly one of *GoogleChromeManagementV1CountChromeVersionsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleChromeManagementV1CountChromeVersionsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersReportsCountChromeVersionsCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountChromeVersionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromeManagementV1CountChromeVersionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generate report of installed Chrome versions.",
	//   "flatPath": "v1/customers/{customersId}/reports:countChromeVersions",
	//   "httpMethod": "GET",
	//   "id": "chromemanagement.customers.reports.countChromeVersions",
	//   "parameterOrder": [
	//     "customer"
	//   ],
	//   "parameters": {
	//     "customer": {
	//       "description": "Required. Customer id or \"my_customer\" to use the customer associated to the account making the request.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Query string to filter results, AND-separated fields in EBNF syntax. Note: OR operations are not supported in this filter. Supported filter fields: * last_active_date",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orgUnitId": {
	//       "description": "The ID of the organizational unit.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of results to return. Maximum and default are 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token to specify the page of the request to be returned.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+customer}/reports:countChromeVersions",
	//   "response": {
	//     "$ref": "GoogleChromeManagementV1CountChromeVersionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.reports.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsCountChromeVersionsCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1CountChromeVersionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "chromemanagement.customers.reports.countInstalledApps":

type CustomersReportsCountInstalledAppsCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CountInstalledApps: Generate report of app installations.
//
// - customer: Customer id or "my_customer" to use the customer
//   associated to the account making the request.
func (r *CustomersReportsService) CountInstalledApps(customer string) *CustomersReportsCountInstalledAppsCall {
	c := &CustomersReportsCountInstalledAppsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// Filter sets the optional parameter "filter": Query string to filter
// results, AND-separated fields in EBNF syntax. Note: OR operations are
// not supported in this filter. Supported filter fields: * app_name *
// app_type * install_type * number_of_permissions * total_install_count
// * latest_profile_active_date * permission_name
func (c *CustomersReportsCountInstalledAppsCall) Filter(filter string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order
// results. Supported order by fields: * app_name * app_type *
// install_type * number_of_permissions * total_install_count
func (c *CustomersReportsCountInstalledAppsCall) OrderBy(orderBy string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit.
func (c *CustomersReportsCountInstalledAppsCall) OrgUnitId(orgUnitId string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// results to return. Maximum and default are 100.
func (c *CustomersReportsCountInstalledAppsCall) PageSize(pageSize int64) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify
// the page of the request to be returned.
func (c *CustomersReportsCountInstalledAppsCall) PageToken(pageToken string) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersReportsCountInstalledAppsCall) Fields(s ...googleapi.Field) *CustomersReportsCountInstalledAppsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersReportsCountInstalledAppsCall) IfNoneMatch(entityTag string) *CustomersReportsCountInstalledAppsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersReportsCountInstalledAppsCall) Context(ctx context.Context) *CustomersReportsCountInstalledAppsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersReportsCountInstalledAppsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsCountInstalledAppsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210629")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:countInstalledApps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.countInstalledApps" call.
// Exactly one of *GoogleChromeManagementV1CountInstalledAppsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleChromeManagementV1CountInstalledAppsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersReportsCountInstalledAppsCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1CountInstalledAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromeManagementV1CountInstalledAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generate report of app installations.",
	//   "flatPath": "v1/customers/{customersId}/reports:countInstalledApps",
	//   "httpMethod": "GET",
	//   "id": "chromemanagement.customers.reports.countInstalledApps",
	//   "parameterOrder": [
	//     "customer"
	//   ],
	//   "parameters": {
	//     "customer": {
	//       "description": "Required. Customer id or \"my_customer\" to use the customer associated to the account making the request.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Query string to filter results, AND-separated fields in EBNF syntax. Note: OR operations are not supported in this filter. Supported filter fields: * app_name * app_type * install_type * number_of_permissions * total_install_count * latest_profile_active_date * permission_name",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Field used to order results. Supported order by fields: * app_name * app_type * install_type * number_of_permissions * total_install_count",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orgUnitId": {
	//       "description": "The ID of the organizational unit.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of results to return. Maximum and default are 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token to specify the page of the request to be returned.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+customer}/reports:countInstalledApps",
	//   "response": {
	//     "$ref": "GoogleChromeManagementV1CountInstalledAppsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.reports.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsCountInstalledAppsCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1CountInstalledAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "chromemanagement.customers.reports.findInstalledAppDevices":

type CustomersReportsFindInstalledAppDevicesCall struct {
	s            *Service
	customer     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FindInstalledAppDevices: Generate report of devices that have a
// specified app installed.
//
// - customer: Customer id or "my_customer" to use the customer
//   associated to the account making the request.
func (r *CustomersReportsService) FindInstalledAppDevices(customer string) *CustomersReportsFindInstalledAppDevicesCall {
	c := &CustomersReportsFindInstalledAppDevicesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.customer = customer
	return c
}

// AppId sets the optional parameter "appId": Unique identifier of the
// app. For Chrome apps and extensions, the 32-character id (e.g.
// ehoadneljpdggcbbknedodolkkjodefl). For Android apps, the package name
// (e.g. com.evernote).
func (c *CustomersReportsFindInstalledAppDevicesCall) AppId(appId string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("appId", appId)
	return c
}

// AppType sets the optional parameter "appType": Type of the app.
//
// Possible values:
//   "APP_TYPE_UNSPECIFIED" - App type not specified.
//   "EXTENSION" - Chrome extension.
//   "APP" - Chrome app.
//   "THEME" - Chrome theme.
//   "HOSTED_APP" - Chrome hosted app.
//   "ANDROID_APP" - ARC++ app.
func (c *CustomersReportsFindInstalledAppDevicesCall) AppType(appType string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("appType", appType)
	return c
}

// Filter sets the optional parameter "filter": Query string to filter
// results, AND-separated fields in EBNF syntax. Note: OR operations are
// not supported in this filter. Supported filter fields: *
// last_active_date
func (c *CustomersReportsFindInstalledAppDevicesCall) Filter(filter string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field used to order
// results. Supported order by fields: * machine * device_id
func (c *CustomersReportsFindInstalledAppDevicesCall) OrderBy(orderBy string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// OrgUnitId sets the optional parameter "orgUnitId": The ID of the
// organizational unit.
func (c *CustomersReportsFindInstalledAppDevicesCall) OrgUnitId(orgUnitId string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("orgUnitId", orgUnitId)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// results to return. Maximum and default are 100.
func (c *CustomersReportsFindInstalledAppDevicesCall) PageSize(pageSize int64) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token to specify
// the page of the request to be returned.
func (c *CustomersReportsFindInstalledAppDevicesCall) PageToken(pageToken string) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersReportsFindInstalledAppDevicesCall) Fields(s ...googleapi.Field) *CustomersReportsFindInstalledAppDevicesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersReportsFindInstalledAppDevicesCall) IfNoneMatch(entityTag string) *CustomersReportsFindInstalledAppDevicesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersReportsFindInstalledAppDevicesCall) Context(ctx context.Context) *CustomersReportsFindInstalledAppDevicesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersReportsFindInstalledAppDevicesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersReportsFindInstalledAppDevicesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210629")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+customer}/reports:findInstalledAppDevices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"customer": c.customer,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "chromemanagement.customers.reports.findInstalledAppDevices" call.
// Exactly one of
// *GoogleChromeManagementV1FindInstalledAppDevicesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleChromeManagementV1FindInstalledAppDevicesResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CustomersReportsFindInstalledAppDevicesCall) Do(opts ...googleapi.CallOption) (*GoogleChromeManagementV1FindInstalledAppDevicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleChromeManagementV1FindInstalledAppDevicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generate report of devices that have a specified app installed.",
	//   "flatPath": "v1/customers/{customersId}/reports:findInstalledAppDevices",
	//   "httpMethod": "GET",
	//   "id": "chromemanagement.customers.reports.findInstalledAppDevices",
	//   "parameterOrder": [
	//     "customer"
	//   ],
	//   "parameters": {
	//     "appId": {
	//       "description": "Unique identifier of the app. For Chrome apps and extensions, the 32-character id (e.g. ehoadneljpdggcbbknedodolkkjodefl). For Android apps, the package name (e.g. com.evernote).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "appType": {
	//       "description": "Type of the app.",
	//       "enum": [
	//         "APP_TYPE_UNSPECIFIED",
	//         "EXTENSION",
	//         "APP",
	//         "THEME",
	//         "HOSTED_APP",
	//         "ANDROID_APP"
	//       ],
	//       "enumDescriptions": [
	//         "App type not specified.",
	//         "Chrome extension.",
	//         "Chrome app.",
	//         "Chrome theme.",
	//         "Chrome hosted app.",
	//         "ARC++ app."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "customer": {
	//       "description": "Required. Customer id or \"my_customer\" to use the customer associated to the account making the request.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "filter": {
	//       "description": "Query string to filter results, AND-separated fields in EBNF syntax. Note: OR operations are not supported in this filter. Supported filter fields: * last_active_date",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Field used to order results. Supported order by fields: * machine * device_id",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orgUnitId": {
	//       "description": "The ID of the organizational unit.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Maximum number of results to return. Maximum and default are 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Token to specify the page of the request to be returned.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+customer}/reports:findInstalledAppDevices",
	//   "response": {
	//     "$ref": "GoogleChromeManagementV1FindInstalledAppDevicesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/chrome.management.reports.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersReportsFindInstalledAppDevicesCall) Pages(ctx context.Context, f func(*GoogleChromeManagementV1FindInstalledAppDevicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
